/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.cache.config;

import com.efuture.ocp.common.cache.config.RedisProperty;
import com.jarvis.cache.ICacheManager;
import com.jarvis.cache.autoconfigure.AutoloadCacheProperties;
import com.jarvis.cache.redis.LettuceRedisClusterCacheManager;
import com.jarvis.cache.redis.SpringRedisCacheManager;
import com.jarvis.cache.serializer.ISerializer;
import io.lettuce.core.cluster.RedisClusterClient;
import java.lang.reflect.Field;
import java.time.Duration;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClusterConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;
import org.springframework.data.redis.core.RedisConnectionUtils;

@Order(value=1)
@Configuration
@EnableConfigurationProperties(value={RedisProperty.class})
@ConditionalOnClass(value={LettuceConnectionFactory.class})
public class LettuceCacheCacheManagerConfiguration {
    Logger log = LoggerFactory.getLogger(LettuceCacheCacheManagerConfiguration.class);

    @Bean
    public RedisConnectionFactory getConnectionFactory(RedisProperty redisProperty) {
        RedisStandaloneConfiguration configuration = new RedisStandaloneConfiguration();
        configuration.setHostName(redisProperty.getHost());
        configuration.setPort(redisProperty.getPort().intValue());
        configuration.setDatabase(redisProperty.getDatabase().intValue());
        configuration.setPassword(RedisPassword.of((String)redisProperty.getPassword()));
        LettuceConnectionFactory factory = new LettuceConnectionFactory(configuration, (LettuceClientConfiguration)this.getPoolConfig(redisProperty));
        return factory;
    }

    @Bean
    public LettucePoolingClientConfiguration getPoolConfig(RedisProperty redisProperty) {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(redisProperty.getMaxTotal().intValue());
        config.setMaxWaitMillis((long)redisProperty.getMaxWait().intValue());
        config.setMaxIdle(redisProperty.getMaxIdle().intValue());
        config.setMinIdle(redisProperty.getMinIdle().intValue());
        LettucePoolingClientConfiguration pool = LettucePoolingClientConfiguration.builder().poolConfig(config).commandTimeout(Duration.ofMillis(redisProperty.getTimeout().intValue())).shutdownTimeout(Duration.ofMillis(redisProperty.getShutdown().intValue())).build();
        return pool;
    }

    @Bean
    @ConditionalOnMissingBean(value={ICacheManager.class})
    @ConditionalOnBean(value={RedisConnectionFactory.class})
    public ICacheManager LettuceCacheCacheManager(AutoloadCacheProperties config, ISerializer<Object> serializer, RedisConnectionFactory connectionFactory) {
        return this.createRedisCacheManager(config, serializer, (LettuceConnectionFactory)connectionFactory);
    }

    private ICacheManager createRedisCacheManager(AutoloadCacheProperties config, ISerializer<Object> serializer, LettuceConnectionFactory connectionFactory) {
        RedisConnection redisConnection = null;
        try {
            redisConnection = connectionFactory.getConnection();
            SpringRedisCacheManager cacheManager = null;
            if (redisConnection instanceof LettuceClusterConnection) {
                LettuceClusterConnection lettuceClusterConnection = (LettuceClusterConnection)redisConnection;
                try {
                    Field clusterClientField = LettuceClusterConnection.class.getDeclaredField("clusterClient");
                    clusterClientField.setAccessible(true);
                    RedisClusterClient redisClusterClient = (RedisClusterClient)clusterClientField.get(lettuceClusterConnection);
                    cacheManager = new LettuceRedisClusterCacheManager(redisClusterClient, serializer);
                }
                catch (Exception e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                }
            } else {
                cacheManager = new SpringRedisCacheManager((RedisConnectionFactory)connectionFactory, serializer);
            }
            SpringRedisCacheManager springRedisCacheManager = cacheManager;
            return springRedisCacheManager;
        }
        catch (Throwable e) {
            this.log.error(e.getMessage(), e);
            throw e;
        }
        finally {
            RedisConnectionUtils.releaseConnection((RedisConnection)redisConnection, (RedisConnectionFactory)connectionFactory, (boolean)false);
        }
    }
}

