/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.cache.template;

import com.jarvis.cache.ICacheManager;
import com.jarvis.cache.MSetParam;
import com.jarvis.cache.exception.CacheCenterConnectionException;
import com.jarvis.cache.to.AutoLoadConfig;
import com.jarvis.cache.to.CacheConfigTO;
import com.jarvis.cache.to.CacheKeyTO;
import com.jarvis.cache.to.CacheWrapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CacheTemplate {
    private ICacheManager cacheManager;
    private AutoLoadConfig config;
    private CacheConfigTO emptyConfig = new CacheConfigTO();

    public CacheTemplate(ICacheManager cacheManager, AutoLoadConfig config) {
        this.cacheManager = cacheManager;
        this.config = config;
    }

    public CacheKeyTO getCacheKeyTO(String key) {
        return new CacheKeyTO(this.config.getNamespace(), key, null);
    }

    public CacheKeyTO getCacheKeyTO(String namespace, String key, String hfield) {
        return new CacheKeyTO(namespace, key, hfield);
    }

    public CacheWrapper<Object> getCacheWrapper(int expire, Object data) {
        return new CacheWrapper(data, expire);
    }

    public CacheConfigTO getCacheConfig(int localType, int localExpire) {
        CacheConfigTO config = null;
        if (localType == 1) {
            config = new CacheConfigTO();
            config.setLocalCacheConfig(localExpire, true);
        } else if (localType == 2) {
            config = new CacheConfigTO();
            config.setLocalCacheConfig(localExpire, false);
        } else {
            config = this.emptyConfig;
        }
        return config;
    }

    public void set(String key, int expire, Object data) throws CacheCenterConnectionException {
        this.set(this.getCacheKeyTO(key), this.getCacheWrapper(expire, data), this.emptyConfig);
    }

    public void set(String key, int expire, Object data, int localType, int localExpire) throws CacheCenterConnectionException {
        this.set(this.getCacheKeyTO(key), this.getCacheWrapper(expire, data), this.getCacheConfig(localType, localExpire));
    }

    public void set(String namespace, String key, String hfield, int expire, Object data) throws CacheCenterConnectionException {
        this.set(this.getCacheKeyTO(namespace, key, hfield), this.getCacheWrapper(expire, data), this.emptyConfig);
    }

    public void set(String namespace, String key, String hfield, int expire, Object data, int localType, int localExpire) throws CacheCenterConnectionException {
        this.set(this.getCacheKeyTO(namespace, key, hfield), this.getCacheWrapper(expire, data), this.getCacheConfig(localType, localExpire));
    }

    public void set(CacheKeyTO cacheKey, CacheWrapper<Object> data, CacheConfigTO config) throws CacheCenterConnectionException {
        this.cacheManager.setCache(cacheKey, data, config);
    }

    public void mSet(CacheConfigTO config, Collection<MSetParam> params) throws CacheCenterConnectionException {
        this.cacheManager.mset(config, params);
    }

    public CacheWrapper<Object> getCacheWrapperData(String namespace, String key, String hfield) throws CacheCenterConnectionException {
        return this.cacheManager.get(this.getCacheKeyTO(namespace, key, hfield), this.emptyConfig);
    }

    public Map<String, Object> mGet(Set<String> keys) throws CacheCenterConnectionException {
        HashSet<CacheKeyTO> ckey = new HashSet<CacheKeyTO>();
        for (String key : keys) {
            ckey.add(this.getCacheKeyTO(key));
        }
        Map rtnCache = this.cacheManager.mget(this.emptyConfig, Object.class, ckey);
        HashMap<String, Object> rtn = new HashMap<String, Object>();
        for (Map.Entry entry : rtnCache.entrySet()) {
            rtn.put(((CacheKeyTO)entry.getKey()).getKey(), ((CacheWrapper)entry.getValue()).getCacheObject());
        }
        return rtn;
    }

    public Object get(String key) throws CacheCenterConnectionException {
        CacheWrapper<Object> data = this.getCacheWrapperData(this.config.getNamespace(), key, null);
        if (data == null) {
            return null;
        }
        return data.getCacheObject();
    }

    public void del(String key) throws CacheCenterConnectionException {
        this.del(this.config.getNamespace(), key, null);
    }

    public void del(String namespace, String key, String hfield) throws CacheCenterConnectionException {
        HashSet<CacheKeyTO> keys = new HashSet<CacheKeyTO>();
        CacheKeyTO cacheKey = this.getCacheKeyTO(namespace, key, hfield);
        keys.add(cacheKey);
        this.cacheManager.delete(keys);
    }

    public static interface LOCAL_TYPE {
        public static final int ONLY_REMOTE = 0;
        public static final int ONLY_LOCAL = 1;
        public static final int ALL = 2;
    }
}

