/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.callnumber;

import cn.hutool.core.thread.ExecutorBuilder;
import com.efuture.common.utils.ServiceLogs;
import com.efuture.common.utils.StringUtils;
import com.efuture.ocp.common.callnumber.CallNumberHandle;
import com.efuture.ocp.common.callnumber.NumberInfo;
import com.efuture.ocp.common.exception.ServiceException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;

public class CallNumberExecutor {
    CallNumberHandle handle;
    ConcurrentMap<String, ExecutorService> executors = new ConcurrentHashMap<String, ExecutorService>();
    ConcurrentMap<String, List<CallNumberRuner>> workers = new ConcurrentHashMap<String, List<CallNumberRuner>>();

    public CallNumberExecutor(CallNumberHandle handle) {
        this.handle = handle;
    }

    public void submit(String bizName, int maxNum, int maxWorker, Consumer<NumberInfo> worker) {
        ExecutorService executorService = this.executors.computeIfAbsent(bizName, key -> ExecutorBuilder.create().setMaxPoolSize(maxWorker).setCorePoolSize(0).build());
        List workList = this.workers.computeIfAbsent(bizName, key -> {
            ArrayList<CallNumberRuner> runers = new ArrayList<CallNumberRuner>();
            for (int i = 0; i < maxWorker; ++i) {
                CallNumberRuner run = new CallNumberRuner((String)key, maxNum, i, worker);
                runers.add(run);
            }
            return runers;
        });
        if (workList.size() < maxWorker) {
            for (int i = workList.size() - 1; i < maxWorker; ++i) {
                CallNumberRuner run = new CallNumberRuner(bizName, maxNum, i, worker);
                workList.add(run);
            }
        }
        for (CallNumberRuner runer : workList) {
            if (runer.isRunning()) continue;
            runer.nextRound();
            executorService.submit(runer);
        }
    }

    public boolean watchPrint(String bizName) {
        List workList = (List)this.workers.get(bizName);
        boolean ibRun = false;
        for (CallNumberRuner runer : workList) {
            ibRun = runer.isRunning();
            ServiceLogs.debug((String)"watchPrint", (String)runer.watch(), (long)0L, (Object[])new Object[0]);
        }
        return ibRun;
    }

    public List<String> status(String bizName) {
        if (StringUtils.isEmpty((CharSequence)bizName)) {
            throw ServiceException.newGroupServiceException((String)"unknown", (String)"50002", (String)"\u4efb\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        ArrayList<String> rtn = new ArrayList<String>();
        List workList = (List)this.workers.get(bizName);
        if (workList == null) {
            return null;
        }
        for (CallNumberRuner runer : workList) {
            rtn.add(runer.watch());
        }
        return rtn;
    }

    public void clear(String bizName) {
        this.executors.remove(bizName);
        List workList = (List)this.workers.get(bizName);
        workList.clear();
        this.workers.remove(bizName);
    }

    public String stop(String bizName) {
        ExecutorService executorService;
        if (StringUtils.isEmpty((CharSequence)bizName)) {
            throw ServiceException.newGroupServiceException((String)"unknown", (String)"50002", (String)"\u4efb\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        String msg = "\u4efb\u52a1[" + bizName + "]";
        List workList = (List)this.workers.get(bizName);
        if (workList != null) {
            for (CallNumberRuner runer : workList) {
                runer.stop();
            }
        }
        if ((executorService = (ExecutorService)this.executors.get(bizName)) == null) {
            return msg + "\u672a\u63d0\u4ea4";
        }
        if (executorService.isShutdown()) {
            return msg + "\u5df2\u7ecf\u505c\u6b62\u6216\u672a\u5f00\u59cb";
        }
        List<Runnable> runnableList = executorService.shutdownNow();
        msg = msg + "\u505c\u6b62\u6210\u529f";
        this.clear(bizName);
        if (runnableList != null && runnableList.size() > 0) {
            return msg + ",\u8fd8\u6709[" + runnableList.size() + "]\u6761\u4efb\u52a1\u672a\u5b8c\u6210";
        }
        return msg;
    }

    public CallNumberRuner call(String bizName, int maxNumer, Consumer<NumberInfo> worker) {
        CallNumberRuner run = new CallNumberRuner(bizName, maxNumer, 0, worker);
        run.run();
        return run;
    }

    public NumberInfo getNumber(String bizName, int maxNum, int waitSecond) {
        NumberInfo num = new NumberInfo(bizName, maxNum, -99);
        int rtn = this.handle.next(num, waitSecond);
        if (rtn < 0) {
            return null;
        }
        return num;
    }

    public int getNextNumber(NumberInfo num, int waitSecond) {
        if (num.isRunning()) {
            this.handle.complete(num);
        }
        return this.handle.next(num, waitSecond);
    }

    public void destroy() {
        for (String bizName : this.executors.keySet()) {
            this.stop(bizName);
        }
    }

    private class CallNumberRuner
    implements Runnable {
        public String curJobKey = "";
        private NumberInfo number;
        private Consumer<NumberInfo> worker;
        private String lineSeparator = System.lineSeparator();
        private int flag = 0;
        private int round = 0;
        private long startTime = 0L;
        private int times = 0;

        public CallNumberRuner(NumberInfo number, Consumer<NumberInfo> worker) {
            this.number = number;
            this.worker = worker;
        }

        public CallNumberRuner(String bizName, int maxNum, int start, Consumer<NumberInfo> worker) {
            this.number = new NumberInfo(bizName, maxNum, start);
            this.worker = worker;
        }

        public NumberInfo getNumber() {
            return this.number;
        }

        public Consumer<NumberInfo> getWorker() {
            return this.worker;
        }

        public void nextRound() {
            this.startTime = System.currentTimeMillis();
        }

        public String watch() {
            long curtime = System.currentTimeMillis();
            long elapsed = (curtime - this.startTime) / 1000L;
            StringBuilder sb = new StringBuilder();
            sb.append(" number:" + this.number.toString());
            sb.append(" status:" + this.flag);
            sb.append(" round:" + this.round);
            sb.append(" times:" + this.times);
            sb.append(" elapsed:" + elapsed + "s");
            return sb.toString();
        }

        public boolean isRunning() {
            return this.number.isRunning();
        }

        public int getFlag() {
            return this.flag;
        }

        public void stop() {
            this.flag = RUNER_FLAG.ABORT.flag;
        }

        public void start() {
            this.flag = RUNER_FLAG.RUNNING.getFlag();
            ++this.round;
            this.times = 0;
            ServiceLogs.info((String)"CallNumberRuner", (String)"\u5f00\u59cb\u8fd0\u884c[{0}]", (long)0L, (Object[])new Object[]{this.number.toString()});
        }

        public void error(Throwable th) {
            this.flag = RUNER_FLAG.ERROR.getFlag();
            ServiceLogs.error((String)"CallNumberRuner", (Throwable)th, (String)"\u6267\u884c[{0}]\u53d1\u751f\u5f02\u5e38", (long)0L, (Object[])new Object[]{this.number.toString()});
        }

        public void complete() {
            if (this.flag <= 99) {
                this.flag = RUNER_FLAG.COMPLETE.getFlag();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private void exec() {
            num = -99;
            r = new Random(Math.abs(this.number.start));
            randomAwait = r.nextInt(100) + 1;
            lastRound = this.round;
            do {
                try {
                    Thread.sleep(randomAwait);
                    num = this.times == 0 ? CallNumberExecutor.this.handle.start(this.number) : CallNumberExecutor.this.handle.next(this.number, 10);
                    if (num >= 0) {
                        ++this.times;
                        ServiceLogs.info((String)"CallNumberRuner", (String)"\u5f00\u59cb\u6267\u884c[{0}]", (long)0L, (Object[])new Object[]{this.number.toString()});
                        this.worker.accept(this.number);
                    } else {
                        ServiceLogs.info((String)"CallNumberRuner", (String)"[{0}]\u53eb\u53f7\u8fd4\u56de\u503c[{1}]\u5c0f\u4e8e0,\u51c6\u5907\u9000\u51fa", (long)0L, (Object[])new Object[]{this.number.toString(), num});
                    }
                    CallNumberExecutor.this.handle.complete(this.number);
                    ** if (!Thread.currentThread().isInterrupted()) goto lbl-1000
                }
                catch (InterruptedException e1) {
                    block12: {
                        ServiceLogs.error((String)"CallNumberRuner", null, (String)"\u6267\u884c[{0}]\u88ab\u5f3a\u5236\u7ec8\u6b62", (long)0L, (Object[])new Object[]{this.number.toString()});
                        CallNumberExecutor.this.handle.complete(this.number);
                        if (!Thread.currentThread().isInterrupted()) break block12;
                        ServiceLogs.error((String)"CallNumberRuner", null, (String)"\u6267\u884c[{0}]\u5df2\u88ab\u5f3a\u5236\u7ec8\u6b62", (long)0L, (Object[])new Object[]{this.number.toString()});
                        return;
                    }
                    return;
                }
                catch (Exception e) {
                    ServiceLogs.error((String)"CallNumberRuner", (Throwable)e, (String)"\u6267\u884c[{0}]\u53d1\u751f\u9519\u8bef:[{1}]", (long)0L, (Object[])new Object[]{this.number.toString(), e.getMessage()});
                    CallNumberExecutor.this.handle.complete(this.number);
                    ** if (!Thread.currentThread().isInterrupted()) goto lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        ServiceLogs.error((String)"CallNumberRuner", null, (String)"\u6267\u884c[{0}]\u5df2\u88ab\u5f3a\u5236\u7ec8\u6b62", (long)0L, (Object[])new Object[]{this.number.toString()});
                        return;
                    }
lbl-1000:
                    // 1 sources

                    {
                    }
                    {
                        catch (Throwable var6_7) {
                            CallNumberExecutor.this.handle.complete(this.number);
                            if (Thread.currentThread().isInterrupted()) {
                                ServiceLogs.error((String)"CallNumberRuner", null, (String)"\u6267\u884c[{0}]\u5df2\u88ab\u5f3a\u5236\u7ec8\u6b62", (long)0L, (Object[])new Object[]{this.number.toString()});
                                return;
                            }
                            throw var6_7;
                        }
                    }
                }
lbl-1000:
                // 1 sources

                {
                    ServiceLogs.error((String)"CallNumberRuner", null, (String)"\u6267\u884c[{0}]\u5df2\u88ab\u5f3a\u5236\u7ec8\u6b62", (long)0L, (Object[])new Object[]{this.number.toString()});
                    return;
                }
lbl-1000:
                // 1 sources

                {
                }
                if (this.flag <= 99) continue;
                ServiceLogs.info((String)"CallNumberRuner", (String)"[{0}]:\u6807\u5fd7\u4e0d\u4e3a0,\u51c6\u5907\u7ec8\u6b62", (long)0L, (Object[])new Object[]{this.number.toString()});
                return;
            } while (num >= 0);
        }

        @Override
        public void run() {
            this.curJobKey = Thread.currentThread().getName() + "-" + this.number.getLockKey() + "-" + this.number.getStart();
            ServiceLogs.setCurLogKey((String)this.curJobKey);
            if (this.number.isRunning()) {
                ServiceLogs.info((String)"CallNumberRuner", (String)"\u5f53\u524d\u5e8f\u53f7[{0}]\u6b63\u5728\u6267\u884c,\u4e0d\u7ee7\u7eed\u6267\u884c", (long)0L, (Object[])new Object[]{this.number.toString()});
                return;
            }
            this.start();
            try {
                this.exec();
            }
            catch (Throwable th) {
                this.error(th);
            }
            this.complete();
        }
    }

    public static enum RUNER_FLAG {
        NOT_START(0),
        RUNNING(1),
        COMPLETE(100),
        ERROR(101),
        ABORT(102);

        int flag;

        private RUNER_FLAG(int flag) {
            this.flag = flag;
        }

        public int getFlag() {
            return this.flag;
        }
    }
}

