/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.cache.config;

import com.efuture.ocp.common.cache.config.FutureCacheManagerConfig;
import com.efuture.ocp.common.cache.template.CacheTemplate;
import com.jarvis.cache.CacheHandler;
import com.jarvis.cache.ComboCacheManager;
import com.jarvis.cache.ICacheManager;
import com.jarvis.cache.autoconfigure.AutoloadCacheManageConfiguration;
import com.jarvis.cache.autoconfigure.AutoloadCacheProperties;
import com.jarvis.cache.autoconfigure.DistributedLockConfiguration;
import com.jarvis.cache.clone.ICloner;
import com.jarvis.cache.lock.ILock;
import com.jarvis.cache.map.MapCacheManager;
import com.jarvis.cache.script.AbstractScriptParser;
import com.jarvis.cache.script.SpringELParser;
import com.jarvis.cache.serializer.HessianSerializer;
import com.jarvis.cache.serializer.ISerializer;
import com.jarvis.cache.serializer.JdkSerializer;
import com.jarvis.cache.serializer.KryoSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.util.ClassUtils;

@Order(value=0)
@Configuration
@AutoConfigureAfter(value={FutureCacheManagerConfig.class, AutoloadCacheManageConfiguration.class, DistributedLockConfiguration.class})
@EnableConfigurationProperties(value={AutoloadCacheProperties.class})
public class FutureCacheAutoConfig {
    private static final boolean hessianPresent = ClassUtils.isPresent((String)"com.caucho.hessian.io.AbstractSerializerFactory", (ClassLoader)AutoloadCacheManageConfiguration.class.getClassLoader());
    private static final boolean kryoPresent = ClassUtils.isPresent((String)"com.esotericsoftware.kryo.Kryo", (ClassLoader)AutoloadCacheManageConfiguration.class.getClassLoader());
    private final ILock lock;
    Logger log = LoggerFactory.getLogger(FutureCacheAutoConfig.class);

    public FutureCacheAutoConfig(ObjectProvider<ILock> lockProvider) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("FutureCacheAutoConfig------->>>>\u7f13\u5b58\u81ea\u52a8\u88c5\u914d\u542f\u52a8\u6210\u529f");
        }
        this.lock = null != lockProvider ? (ILock)lockProvider.getIfAvailable() : null;
    }

    @Bean
    @ConditionalOnMissingBean(value={ISerializer.class})
    public ISerializer<Object> getCacheSerializer() {
        HessianSerializer res;
        if (hessianPresent) {
            res = new HessianSerializer();
            this.log.debug("HessianSerializer auto-configured");
        } else if (kryoPresent) {
            res = new KryoSerializer();
            this.log.debug("KryoSerializer auto-configured");
        } else {
            res = new JdkSerializer();
            this.log.debug("JdkSerializer auto-configured");
        }
        return res;
    }

    @Bean
    @ConditionalOnMissingBean(value={AbstractScriptParser.class})
    public AbstractScriptParser autoloadCacheScriptParser() {
        return new SpringELParser();
    }

    @Bean(destroyMethod="destroy")
    @ConditionalOnMissingBean(value={CacheHandler.class})
    public CacheHandler cacheHandler(ICacheManager cacheManager, AutoloadCacheProperties config) {
        AbstractScriptParser scriptParser = this.autoloadCacheScriptParser();
        ISerializer<Object> cloner = this.getCacheSerializer();
        ICacheManager comboCacheManager = this.comboCacheManager(cacheManager, config, (ICloner)cloner, scriptParser);
        CacheHandler cacheHandler = new CacheHandler(comboCacheManager, scriptParser, config.getConfig(), cloner);
        cacheHandler.setLock(this.lock);
        return cacheHandler;
    }

    @Bean
    @ConditionalOnMissingBean(value={CacheTemplate.class})
    public CacheTemplate cacheTemplate(CacheHandler cacheHandler) {
        return new CacheTemplate(cacheHandler.getCacheManager(), cacheHandler.getAutoLoadConfig());
    }

    public ICacheManager comboCacheManager(ICacheManager remoteCache, AutoloadCacheProperties config, ICloner cloner, AbstractScriptParser scriptParser) {
        ICacheManager localCache = this.getLocalCache(config, cloner, scriptParser);
        if (remoteCache == null) {
            return localCache;
        }
        return new ComboCacheManager(localCache, remoteCache, scriptParser);
    }

    private ICacheManager getLocalCache(AutoloadCacheProperties config, ICloner cloner, AbstractScriptParser scriptParser) {
        return new MapCacheManager(config.getConfig(), cloner);
    }
}

