/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.cache.config;

import cn.hutool.extra.spring.SpringUtil;
import com.efuture.ocp.common.distributedLock.DistributedLockHandle;
import com.efuture.ocp.common.distributedLock.DistributedLockKeyBySpringEL;
import com.efuture.ocp.common.distributedLock.DistributedLockKeyHandle;
import com.efuture.ocp.common.distributedLock.LockTemplate;
import com.efuture.ocp.common.distributedLock.LockWatchdog;
import com.efuture.ocp.common.distributedLock.LockWatchdogImpl;
import com.efuture.ocp.common.distributedLock.SpringRedisDistributedLockHandle;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.redis.connection.RedisConnectionFactory;

@Configuration
@ConditionalOnClass(value={RedisConnectionFactory.class})
@Import(value={SpringUtil.class})
public class FutureRedisLockAutoConfig {
    @Bean
    @ConditionalOnMissingBean(value={DistributedLockHandle.class})
    public DistributedLockHandle lockHandle(RedisConnectionFactory redisConnectionFactory) {
        return new SpringRedisDistributedLockHandle(redisConnectionFactory);
    }

    @Bean
    @ConditionalOnMissingBean(value={DistributedLockKeyHandle.class})
    public DistributedLockKeyHandle keyHandle() {
        return new DistributedLockKeyBySpringEL();
    }

    @Bean
    @ConditionalOnMissingBean(value={LockTemplate.class})
    public LockTemplate lockTemplate(DistributedLockHandle lockHandle) {
        return new LockTemplate(lockHandle);
    }

    @Bean
    @ConditionalOnMissingBean(value={LockWatchdog.class})
    public LockWatchdog LockWatchdog(DistributedLockHandle lockHandle) {
        return new LockWatchdogImpl(lockHandle);
    }
}

