/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.cache.config;

import com.efuture.ocp.common.cache.config.RedisProperty;
import com.efuture.ocp.common.cache.message.RedisMessageUtils;
import com.efuture.ocp.common.cache.message.RootMessageListenerAdapter;
import java.util.ArrayList;
import java.util.HashSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.adapter.MessageListenerAdapter;

public class FutureRedisMessageConfig {
    @Autowired
    private StringRedisTemplate redisTemplate;

    @Bean
    RedisMessageListenerContainer container(RedisProperty redisProperty) {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(this.redisTemplate.getConnectionFactory());
        ArrayList<PatternTopic> topicList = new ArrayList<PatternTopic>();
        String topics = redisProperty.getTopics();
        String[] topicArray = topics.split(",");
        HashSet<String> topicSet = new HashSet<String>();
        for (int i = 0; i < topicArray.length; ++i) {
            topicSet.add(topicArray[0]);
        }
        topicSet.add("cache_data_changed");
        topicSet.add("config_data_changed");
        for (String t : topicSet) {
            topicList.add(new PatternTopic(t));
        }
        MessageListenerAdapter listenerAdapter = new MessageListenerAdapter((Object)new RootMessageListenerAdapter());
        container.addMessageListener((MessageListener)listenerAdapter, topicList);
        return container;
    }

    @Bean
    public RedisMessageUtils redisMessageUtils() {
        return new RedisMessageUtils(this.redisTemplate);
    }
}

