/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.cache.message;

import com.alibaba.fastjson.JSONObject;
import com.efuture.common.utils.ServiceLogs;
import com.efuture.ocp.common.cache.message.CacheDataChangeEvent;
import com.efuture.ocp.common.cache.message.ConfigDataChangeEvent;
import org.springframework.data.redis.core.StringRedisTemplate;

public class RedisMessageUtils {
    private StringRedisTemplate stringRedisTemplate;

    public RedisMessageUtils(StringRedisTemplate stringRedisTemplate) {
        this.stringRedisTemplate = stringRedisTemplate;
    }

    public void publish(String channel, String data) {
        this.stringRedisTemplate.convertAndSend(channel, (Object)data);
        ServiceLogs.truedebuglog((String)"RedisMessage:send", (String)"\u53d1\u9001\u5230redis,channel[{0}] data[{1}]", (long)0L, (Object[])new Object[]{channel, data});
    }

    public void publishCacheDataChangeEvent(String cacheKey) {
        CacheDataChangeEvent event = new CacheDataChangeEvent(cacheKey);
        this.publish("cache_data_changed", JSONObject.toJSONString((Object)event));
    }

    public void publishConfigDataChangeEvent(String configKey, String configVal) {
        ConfigDataChangeEvent event = new ConfigDataChangeEvent(configKey, configVal);
        this.publish("config_data_changed", JSONObject.toJSONString((Object)event));
    }
}

