/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.distributedLock;

import com.efuture.common.utils.ServiceLogs;
import com.efuture.ocp.common.distributedLock.DLock;
import com.efuture.ocp.common.distributedLock.DistributedLockKeyHandle;
import java.util.concurrent.ConcurrentHashMap;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class DistributedLockKeyBySpringEL
implements DistributedLockKeyHandle {
    protected static final String TARGET = "target";
    protected static final String ARGS = "args";
    private final ExpressionParser parser = new SpelExpressionParser();
    private final ConcurrentHashMap<String, Expression> expCache = new ConcurrentHashMap();

    public String getExpressionKey(ProceedingJoinPoint point, DLock around) {
        String className = point.getTarget().getClass().getSimpleName();
        String methodName = point.getSignature().getName();
        String expressionStr = around.key();
        return className + "_" + methodName + "_" + expressionStr;
    }

    @Override
    public String getKey(ProceedingJoinPoint point, DLock around) {
        String expressionStr = around.key();
        ServiceLogs.truedebuglog((String)"DistributedLockKey", (String)("\u83b7\u53d6\u9501\u8868\u8fbe\u5f0f[" + expressionStr + "]"), (long)0L, (Object[])new Object[0]);
        String keySpEL = this.getExpressionKey(point, around);
        ServiceLogs.truedebuglog((String)"DistributedLockKey", (String)("\u83b7\u53d6\u9501\u8868\u8fbe\u5f0fKey[" + keySpEL + "]"), (long)0L, (Object[])new Object[0]);
        StandardEvaluationContext context = new StandardEvaluationContext();
        context.setVariable(ARGS, (Object)point.getArgs());
        context.setVariable(TARGET, point.getTarget());
        Expression expression = this.expCache.get(keySpEL);
        if (null == expression) {
            expression = this.parser.parseExpression(expressionStr);
            this.expCache.put(keySpEL, expression);
        }
        return (String)expression.getValue((EvaluationContext)context, String.class);
    }
}

