/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.ocp.common.distributedLock;

import com.efuture.ocp.common.distributedLock.AbstractDistributedLockHandle;
import com.efuture.ocp.common.distributedLock.DLockInfo;
import com.jarvis.cache.serializer.StringSerializer;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.RedisConnectionUtils;
import org.springframework.data.redis.core.types.Expiration;

public class SpringRedisDistributedLockHandle
extends AbstractDistributedLockHandle {
    private static final Logger logger = LoggerFactory.getLogger(SpringRedisDistributedLockHandle.class);
    private static final StringSerializer STRING_SERIALIZER = new StringSerializer();
    private final RedisConnectionFactory redisConnectionFactory;

    public SpringRedisDistributedLockHandle(RedisConnectionFactory redisConnectionFactory) {
        this.redisConnectionFactory = redisConnectionFactory;
    }

    private RedisConnection getConnection() {
        return RedisConnectionUtils.getConnection((RedisConnectionFactory)this.redisConnectionFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doNaiveCachePut(String key, DLockInfo lockInfo, int lockExpire, int waitMillSeconds) {
        if (null == this.redisConnectionFactory || null == key || key.isEmpty()) {
            return false;
        }
        RedisConnection redisConnection = this.getConnection();
        try {
            String val = String.valueOf(lockInfo.getLockKey());
            Expiration expiration = Expiration.from((long)lockExpire, (TimeUnit)TimeUnit.SECONDS);
            Boolean locked = redisConnection.stringCommands().set(STRING_SERIALIZER.serialize(key), STRING_SERIALIZER.serialize(val), expiration, RedisStringCommands.SetOption.SET_IF_ABSENT);
            boolean bl = locked == null ? false : locked;
            return bl;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            RedisConnectionUtils.releaseConnection((RedisConnection)redisConnection, (RedisConnectionFactory)this.redisConnectionFactory, (boolean)false);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doNaiveCacheRenewal(DLockInfo lockInfo) {
        if (null == this.redisConnectionFactory || null == lockInfo) {
            return false;
        }
        RedisConnection redisConnection = this.getConnection();
        try {
            String key = lockInfo.getKey();
            String val = String.valueOf(lockInfo.getLockKey());
            Expiration expiration = Expiration.from((long)lockInfo.getLeaseTime().intValue(), (TimeUnit)TimeUnit.SECONDS);
            Boolean succ = redisConnection.stringCommands().set(STRING_SERIALIZER.serialize(key), STRING_SERIALIZER.serialize(val), expiration, RedisStringCommands.SetOption.SET_IF_PRESENT);
            boolean bl = succ == null ? false : succ;
            return bl;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            RedisConnectionUtils.releaseConnection((RedisConnection)redisConnection, (RedisConnectionFactory)this.redisConnectionFactory, (boolean)false);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doNaiveCacheDelete(String key) {
        if (null == this.redisConnectionFactory || null == key || key.length() == 0) {
            return;
        }
        RedisConnection redisConnection = this.getConnection();
        try {
            redisConnection.keyCommands().del((byte[][])new byte[][]{STRING_SERIALIZER.serialize(key)});
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            RedisConnectionUtils.releaseConnection((RedisConnection)redisConnection, (RedisConnectionFactory)this.redisConnectionFactory, (boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long doNaiveCacheGet(String key) {
        long rtn = 0L;
        if (null == this.redisConnectionFactory || null == key || key.length() == 0) {
            return rtn;
        }
        RedisConnection redisConnection = this.getConnection();
        try {
            String str = STRING_SERIALIZER.deserialize(redisConnection.stringCommands().get(STRING_SERIALIZER.serialize(key)), String.class);
            if (str != null) {
                rtn = Long.valueOf(str);
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            RedisConnectionUtils.releaseConnection((RedisConnection)redisConnection, (RedisConnectionFactory)this.redisConnectionFactory, (boolean)false);
        }
        return rtn;
    }
}

