

/*
 * Copyright [2019] [恒宇少年 - 于起宇]
 *
 *      Licensed under the Apache License, Version 2.0 (the "License");
 *      you may not use this file except in compliance with the License.
 *      You may obtain a copy of the License at
 *
 *          http://www.apache.org/licenses/LICENSE-2.0
 *
 *      Unless required by applicable law or agreed to in writing, software
 *      distributed under the License is distributed on an "AS IS" BASIS,
 *      WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *      See the License for the specific language governing permissions and
 *      limitations under the License.
 *
 */
package com.efuture.common.web;

import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

/**
 * Http Servlet Response Copier
 *
 * @author：恒宇少年 - 于起宇
 * <p>
 * DateTime：2019-07-16 12:56
 * Blog：http://blog.yuqiyu.com
 * WebSite：http://www.jianshu.com/u/092df3f77bca
 * Gitee：https://gitee.com/hengboy
 * GitHub：https://github.com/hengboy
 */
public class ServletOutputStreamCopier extends ServletOutputStream
{
    /**
     * Output Stream
     */
    private OutputStream outputStream;
    /**
     * Copy Byte Array Output Stream
     */
    private ByteArrayOutputStream copy;

    public ServletOutputStreamCopier(OutputStream outputStream)
    {
        this.outputStream = outputStream;
        this.copy = new ByteArrayOutputStream(1024);
    }

    @Override
    public void write(int b) throws IOException
    {
        outputStream.write(b);
        copy.write(b);
    }

    public byte[] getCopy()
    {
        return copy.toByteArray();
    }

    @Override
    public boolean isReady()
    {
        return false;
    }

    @Override
    public void setWriteListener(WriteListener writeListener)
    {
    }
}
