package com.efuture.common.web.filter;


import com.efuture.common.web.RequestWrapper;
import com.efuture.common.web.ResponseWrapper;
import com.efuture.common.web.utils.HttpReqUtils;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

public class LoggingBodyFilter implements Filter
{
    /**
     * the bean name of {@link LoggingBodyFilter}
     */
    public static final String BEAN_NAME = "loggingBodyFilter";

    /**
     * Called by the web container to indicate to a filter that it is being
     * placed into service. The servlet container calls the init method exactly
     * once after instantiating the filter. The init method must complete
     * successfully before the filter is asked to do any filtering work.
     * <p>
     * The web container cannot place the filter into service if the init method
     * either:
     * <ul>
     * <li>Throws a ServletException</li>
     * <li>Does not return within a time period defined by the web
     * container</li>
     * </ul>
     *
     * @param filterConfig The configuration information associated with the
     *                     filter instance being initialised
     * @throws ServletException if the initialisation fails
     */
    @Override
    public void init(FilterConfig filterConfig) throws ServletException
    {
    }

    /**
     * Wrapper Body
     * replace http request body instance
     * replace http response body instance
     *
     * @param request     http request
     * @param response    http response
     * @param filterChain filter chain
     * @throws IOException      ioException
     * @throws ServletException servlet Exception
     */
    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException
    {
        // see https://gitee.com/minbox-projects/minbox-logging/issues/I1JWSK
        if (!HttpReqUtils.isMultipart(request)) {
            RequestWrapper requestWrapper = new RequestWrapper((HttpServletRequest) request);
            ResponseWrapper responseWrapper = new ResponseWrapper((HttpServletResponse) response);
            filterChain.doFilter(requestWrapper, responseWrapper);
            responseWrapper.flushBuffer();
        }
        else {
            filterChain.doFilter(request, response);
        }
    }

    /**
     * Called by the web container to indicate to a filter that it is being
     * taken out of service. This method is only called once all threads within
     * the filter's doFilter method have exited or after a timeout period has
     * passed. After the web container calls this method, it will not call the
     * doFilter method again on this instance of the filter. <br>
     * <br>
     * <p>
     * This method gives the filter an opportunity to clean up any resources
     * that are being held (for example, memory, file handles, threads) and make
     * sure that any persistent state is synchronized with the filter's current
     * state in memory.
     */
    @Override
    public void destroy()
    {
    }
}