package com.efuture.common.web.controller;

import com.efuture.common.web.session.ServiceSession;
import com.efuture.common.web.session.ServiceSessionUtils;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;


@RestControllerAdvice
public class ResponseControllerAdvice implements ResponseBodyAdvice<Object>
{

    /**
     * Whether this component supports the given controllers method return type
     * and the selected {@code HttpMessageConverter} type.
     *
     * @param returnType    the return type
     * @param converterType the selected converter type
     * @return {@code true} if {@link #beforeBodyWrite} should be invoked;
     * {@code false} otherwise
     */
    @Override
    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType)
    {
        return !returnType.getParameterType().equals(ResultVO.class);
    }

    /**
     * Invoked after an {@code HttpMessageConverter} is selected and just before
     * its write method is invoked.
     *
     * @param body                  the body to be written
     * @param returnType            the return type of the controllers method
     * @param selectedContentType   the content type selected through content negotiation
     * @param selectedConverterType the converter type selected to write to the response
     * @param request               the current request
     * @param response              the current response
     * @return the body that was passed in or a modified (possibly new) instance
     */
    @Override
    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType,
                                  Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response)
    {
        ServiceSession session = ServiceSessionUtils.getLocalSession();
        ResultVO rtn = null;

        if (body == null) {
            rtn = ResultVO.success("");
        }
        else {
            rtn = ResultVO.success(body);
        }

        rtn.setLogkey(session.getRootkey());

        if (session.isDebugEnble()) {
            rtn.setMsg(session.getMsgs());
        }

        return rtn;
    }
}
