package com.efuture.common.web.controller;

import cn.hutool.log.StaticLog;
import com.efuture.common.utils.ServiceLogs;
import com.efuture.common.web.session.ServiceSession;
import com.efuture.common.web.session.ServiceSessionUtils;
import com.efuture.common.web.utils.HttpReqUtils;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.AsyncHandlerInterceptor;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SessionAndLogWebInterceptor implements HandlerInterceptor
{
    /**
     * Intercept the execution of a handler. Called after HandlerMapping determined
     * an appropriate handler object, but before HandlerAdapter invokes the handler.
     * <p>DispatcherServlet processes a handler in an execution chain, consisting
     * of any number of interceptors, with the handler itself at the end.
     * With this method, each interceptor can decide to abort the execution chain,
     * typically sending an HTTP error or writing a custom response.
     * <p><strong>Note:</strong> special considerations apply for asynchronous
     * request processing. For more details see
     * {@link AsyncHandlerInterceptor}.
     * <p>The default implementation returns {@code true}.
     *
     * @param request  current HTTP request
     * @param response current HTTP response
     * @param handler  chosen handler to execute, for type and/or instance evaluation
     * @return {@code true} if the execution chain should proceed with the
     * next interceptor or the handler itself. Else, DispatcherServlet assumes
     * that this interceptor has already dealt with the response itself.
     * @throws Exception in case of errors
     */
    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception
    {
        try {
            //创建Session
            ServiceSession session = ServiceSessionUtils.createLocalSessionFromHttpRequest(request);

            //记录日志
            if (checkIgnore(HttpReqUtils.getUri(request)) || checkIgnoreHttpStatus(response.getStatus())) {
                return true;
            }

            ServiceLogs.logRequest(HttpReqUtils.getRequestBody(request));
        }
        finally {
            return true;
        }
    }

    /**
     * TODO：增加参数判断url是否记录日志
     *
     * @param uri
     * @return
     */
    private boolean checkIgnore(String uri)
    {
        return false;
        //return UrlUtils.isIgnore(factoryBean.getIgnorePaths(), uri);
    }

    /**
     * Check whether to filter the request of the specified {@link HttpStatus}
     *
     * @param httpStatusCode {@link HttpServletResponse#getStatus()}
     * @return
     */
    private boolean checkIgnoreHttpStatus(int httpStatusCode)
    {
        return false;
        //        HttpStatus httpStatus = HttpStatus.valueOf(httpStatusCode);
        //        List<HttpStatus> ignoreHttpStatus = factoryBean.getIgnoreHttpStatus();
        //        return ignoreHttpStatus.contains(httpStatus);
    }

    /**
     * Intercept the execution of a handler. Called after HandlerAdapter actually
     * invoked the handler, but before the DispatcherServlet renders the view.
     * Can expose additional model objects to the view via the given ModelAndView.
     * <p>DispatcherServlet processes a handler in an execution chain, consisting
     * of any number of interceptors, with the handler itself at the end.
     * With this method, each interceptor can post-process an execution,
     * getting applied in inverse order of the execution chain.
     * <p><strong>Note:</strong> special considerations apply for asynchronous
     * request processing. For more details see
     * {@link AsyncHandlerInterceptor}.
     * <p>The default implementation is empty.
     *
     * @param request      current HTTP request
     * @param response     current HTTP response
     * @param handler      the handler (or {@link HandlerMethod}) that started asynchronous
     *                     execution, for type and/or instance examination
     * @param modelAndView the {@code ModelAndView} that the handler returned
     *                     (can also be {@code null})
     * @throws Exception in case of errors
     */
    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception
    {
        StaticLog.debug("postHandle-------------------------");
    }

    /**
     * Callback after completion of request processing, that is, after rendering
     * the view. Will be called on any outcome of handler execution, thus allows
     * for proper resource cleanup.
     * <p>Note: Will only be called if this interceptor's {@code preHandle}
     * method has successfully completed and returned {@code true}!
     * <p>As with the {@code postHandle} method, the method will be invoked on each
     * interceptor in the chain in reverse order, so the first interceptor will be
     * the last to be invoked.
     * <p><strong>Note:</strong> special considerations apply for asynchronous
     * request processing. For more details see
     * {@link AsyncHandlerInterceptor}.
     * <p>The default implementation is empty.
     *
     * @param request  current HTTP request
     * @param response current HTTP response
     * @param handler  the handler (or {@link HandlerMethod}) that started asynchronous
     *                 execution, for type and/or instance examination
     * @param ex       any exception thrown on handler execution, if any; this does not
     *                 include exceptions that have been handled through an exception resolver
     * @throws Exception in case of errors
     */
    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception
    {
        StaticLog.debug("afterCompletion-------------------------");

        if (ex == null) {
            ServiceLogs.logResponse(HttpReqUtils.getResponseBody(response), "0");
        }

        ServiceSessionUtils.removeLocalSession();
    }
}
