/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.web.utils;

import com.efuture.common.web.RequestWrapper;
import com.efuture.common.web.ResponseWrapper;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class HttpReqUtils {
    public static boolean isMultipart(ServletRequest request) {
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().startsWith("multipart/");
    }

    public static String getIp(HttpServletRequest request) {
        Assert.notNull((Object)request, (String)"request instance is null.");
        String Xip = request.getHeader("X-Real-IP");
        String XFor = request.getHeader("X-Forwarded-For");
        if (!StringUtils.isEmpty((Object)XFor) && !"unKnown".equalsIgnoreCase(XFor)) {
            int index = XFor.indexOf(",");
            if (index != -1) {
                return XFor.substring(0, index);
            }
            return XFor;
        }
        XFor = Xip;
        if (!StringUtils.isEmpty((Object)XFor) && !"unKnown".equalsIgnoreCase(XFor)) {
            return XFor;
        }
        if (StringUtils.isEmpty((Object)XFor) || "unknown".equalsIgnoreCase(XFor)) {
            XFor = request.getHeader("Proxy-Client-IP");
        }
        if (StringUtils.isEmpty((Object)XFor) || "unknown".equalsIgnoreCase(XFor)) {
            XFor = request.getHeader("WL-Proxy-Client-IP");
        }
        if (StringUtils.isEmpty((Object)XFor) || "unknown".equalsIgnoreCase(XFor)) {
            XFor = request.getHeader("HTTP_CLIENT_IP");
        }
        if (StringUtils.isEmpty((Object)XFor) || "unknown".equalsIgnoreCase(XFor)) {
            XFor = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (StringUtils.isEmpty((Object)XFor) || "unknown".equalsIgnoreCase(XFor)) {
            XFor = request.getRemoteAddr();
        }
        return XFor;
    }

    public static Map<String, String> getRequestHeaders(HttpServletRequest request) {
        Assert.notNull((Object)request, (String)"request instance is null.");
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration enumeration = request.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String headerName = (String)enumeration.nextElement();
            String headerValue = request.getHeader(headerName);
            headers.put(headerName, headerValue);
        }
        return headers;
    }

    public static Map<String, String> getResponseHeaders(HttpServletResponse response) {
        Assert.notNull((Object)response, (String)"response instance is null.");
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String headerName : response.getHeaderNames()) {
            String headerValue = response.getHeader(headerName);
            headers.put(headerName, headerValue);
        }
        return headers;
    }

    public static String getHeader(HttpServletRequest request, String headerName) {
        Assert.notNull((Object)request, (String)"request instance is null.");
        Assert.notNull((Object)headerName, (String)"request header name is null.");
        return request.getHeader(headerName);
    }

    public static String getRequestBody(HttpServletRequest request) {
        Assert.notNull((Object)request, (String)"request instance is null.");
        RequestWrapper requestWrapper = request instanceof RequestWrapper ? (RequestWrapper)request : new RequestWrapper(request);
        return requestWrapper.getBody();
    }

    public static String getResponseBody(HttpServletResponse response) throws IOException {
        if (response instanceof ResponseWrapper) {
            ResponseWrapper responseWrapper = (ResponseWrapper)response;
            byte[] copy = responseWrapper.getCopy();
            return new String(copy, "UTF-8");
        }
        return null;
    }

    public static Map getPathParams(HttpServletRequest request) {
        Assert.notNull((Object)request, (String)"request instance is null.");
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramValue;
            String paramName = (String)paramNames.nextElement();
            String[] paramValues = request.getParameterValues(paramName);
            if (paramValues.length != 1 || (paramValue = paramValues[0]).length() == 0) continue;
            map.put(paramName, paramValue);
        }
        return map;
    }

    public static String getUri(HttpServletRequest request) {
        Assert.notNull((Object)request, (String)"request instance is null.");
        return request.getRequestURI();
    }
}

