/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.web.controller;

import com.efuture.common.web.controller.FieldValidatorExceptionCode;
import com.efuture.common.web.controller.ResultVO;
import com.efuture.common.web.exception.ServiceException;
import java.lang.reflect.Field;
import javax.servlet.http.HttpServletRequest;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class ExceptionControllerAdvice {
    @ExceptionHandler
    public ResultVO<String> exceptionHandler(HttpServletRequest request, Exception e) {
        if (e instanceof ServiceException) {
            return this.serviceExceptionHandler((ServiceException)e);
        }
        if (e instanceof MethodArgumentNotValidException) {
            try {
                return this.methodArgumentNotValidExceptionHandler((MethodArgumentNotValidException)e);
            }
            catch (NoSuchFieldException e1) {
                return this.othersExceptionHandler(e);
            }
        }
        return this.othersExceptionHandler(e);
    }

    public ResultVO<String> othersExceptionHandler(Exception e) {
        return ResultVO.failure(e.getMessage());
    }

    public ResultVO<String> serviceExceptionHandler(ServiceException e) {
        return ResultVO.failure(e.getMessage());
    }

    public ResultVO<String> methodArgumentNotValidExceptionHandler(MethodArgumentNotValidException e) throws NoSuchFieldException {
        String fieldName;
        String defaultMessage = ((ObjectError)e.getBindingResult().getAllErrors().get(0)).getDefaultMessage();
        Class parameterType = e.getParameter().getParameterType();
        Field field = parameterType.getDeclaredField(fieldName = e.getBindingResult().getFieldError().getField());
        FieldValidatorExceptionCode annotation = field.getAnnotation(FieldValidatorExceptionCode.class);
        if (annotation != null) {
            return ResultVO.failure(annotation.value(), annotation.message());
        }
        return ResultVO.failure("60000", defaultMessage);
    }
}

