/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.web.exception;

import java.text.MessageFormat;
import org.springframework.util.StringUtils;

public class ServiceException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private String errGroup;
    private String errCode;
    private Object[] errArgs;

    public ServiceException(String errCode, String errmsg, Object ... args) {
        super(ServiceException.format(errmsg, args));
        this.errCode = errCode;
        this.errArgs = args;
    }

    private static String format(String errMsg, Object ... args) {
        if (args == null || args.length <= 0) {
            return errMsg;
        }
        for (int i = 0; args != null && i < args.length; ++i) {
            if (args[i] instanceof String) continue;
            args[i] = StringUtils.isEmpty((Object)args[i]) ? "" : args[i].toString();
        }
        return MessageFormat.format(errMsg, args);
    }

    public static ServiceException newGroupServiceException(String errGroup, String errcode, String errmsg, Object ... args) {
        ServiceException rtn = new ServiceException(errcode, errmsg, args);
        rtn.errGroup = errGroup;
        return rtn;
    }

    public String getErrGroup() {
        return this.errGroup;
    }

    public String getErrorCode() {
        return this.errCode;
    }

    public Object[] getErrorArgs() {
        return this.errArgs;
    }

    public static interface ERR_GROUP {
        public static final String UNKNOWN = "unknown";
        public static final String DATABASE = "database";
        public static final String NETWORK = "network";
        public static final String DATA = "data";
        public static final String SERVICE = "service";
        public static final String IGNORE = "ignore";
    }
}

