package com.efuture.common.web.controller;

import com.efuture.ocp.common.exception.ResponseCode;

/**
 * 统一响应
 */
public class ResultVO<T>
{
    private String returncode;
    private String msg;
    private T data;
    private String logkey;


    private ResultVO(T data)
    {
        this(ResponseCode.SUCCESS, data);
    }

    private ResultVO(String code, T data)
    {
        this.returncode = code;
        this.data = data;
    }

    private ResultVO(String returncode, String msg, T data, String logkey)
    {
        this.returncode = returncode;
        this.msg = msg;
        this.data = data;
        this.logkey = logkey;
    }

    private ResultVO(String returncode, String msg, T data)
    {
        this.returncode = returncode;
        this.msg = msg;
        this.data = data;
        this.logkey = "";
    }

    public static ResultVO failure(String returncode, String msg)
    {
        return new ResultVO(returncode, msg, null);
    }

    public static ResultVO failure(String msg)
    {
        return new ResultVO(ResponseCode.FAILURE, msg, msg);
    }
    public static ResultVO success(Object data)
    {
        return new ResultVO(ResponseCode.SUCCESS, data);
    }

    public String getReturncode()
    {
        return returncode;
    }

    public void setReturncode(String returncode)
    {
        this.returncode = returncode;
    }

    public String getMsg()
    {
        return msg;
    }

    public void setMsg(String msg)
    {
        this.msg = msg;
    }

    public T getData()
    {
        return data;
    }

    public void setData(T data)
    {
        this.data = data;
    }

    public String getLogkey()
    {
        return logkey;
    }

    public void setLogkey(String logkey)
    {
        this.logkey = logkey;
    }
}
