/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.common.autoconfig;

import com.efuture.common.web.argument.SessionArgumentResolver;
import com.efuture.common.web.controller.ExceptionControllerAdvice;
import com.efuture.common.web.controller.SessionAndLogWebInterceptor;
import com.efuture.common.web.filter.LoggingBodyFilter;
import java.util.List;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class WebAutoConfiguration
implements WebMvcConfigurer {
    SessionAndLogWebInterceptor sessionAndLogWebInterceptor;

    public WebAutoConfiguration(SessionAndLogWebInterceptor sessionAndLogWebInterceptor) {
        this.sessionAndLogWebInterceptor = sessionAndLogWebInterceptor;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.sessionAndLogWebInterceptor);
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers) {
        resolvers.add(new SessionArgumentResolver());
    }

    @Configuration
    protected static class ControllerAdviceAutoConfig {
        protected ControllerAdviceAutoConfig() {
        }

        @Bean
        @ConditionalOnMissingBean
        public ExceptionControllerAdvice exceptionControllerAdvice() {
            return new ExceptionControllerAdvice();
        }
    }

    @Configuration
    protected static class FilterAutoConfig {
        protected FilterAutoConfig() {
        }

        @Bean
        @Order(value=0)
        public FilterRegistrationBean loggingBodyFilter() {
            FilterRegistrationBean filter = new FilterRegistrationBean((Filter)new LoggingBodyFilter(), new ServletRegistrationBean[0]);
            filter.addUrlPatterns(new String[]{"/*"});
            return filter;
        }
    }

    @Configuration
    protected static class SessionWebInterceptorAutoConfig {
        protected SessionWebInterceptorAutoConfig() {
        }

        @Bean
        @ConditionalOnMissingBean
        public SessionAndLogWebInterceptor newSessionWebInterceptor() {
            return new SessionAndLogWebInterceptor();
        }
    }
}

