mini.parse();

var json3 = [ {id : "99", text : "全部" },
              {id : "0", text : "已签约" },
              {id : "1", text : "MD计划" },
              {id : "2", text : "备选" } ];
var fileType = [{ code: "E", name: "邮件往来" },
                { code: "V", name: "视频介绍" },
                { code: "M", name: "会议纪要" }];


//单据列表
var brandlibraryheadList = {
	"type" : "gridbox",
	//"resources" : OmdUrl.mss,
	//"method" : "mss.work.report.query",
	//"response" : "report",
	/* "manualLoad" : false, */
	"bindform" : "layouttabs", // 绑定切换的TabsBox.name
	//"searchParam" : {
	//	"queryid" : "select_brandlibraryheadlist",
	//},
	"bindSearchParam": ["ph_key"], // 明细页面查询条件字段
	"properties" : {
		"onrowclick" : "selectBrand",
		"id" : "brandlibraryheadList",
		"columns" : [ {
			type : "indexcolumn",
			headerAlign : "center",
			header : "行号",
			width:80,
		},{
			field : "ppcode",
			headerAlign : "center",
			header : "品牌编码",
			allowSort : true,
			width:120,
		},{
			field : "ppcname",
			headerAlign : "center",
			header : "品牌名称",
			allowSort : true,
			width:120,
		},{
			field : "company",
			headerAlign : "center",
			header : "经营公司",	
			allowSort : true,
			width:200,
		},{
			field : "linkman",
			headerAlign : "center",
			header : "联系人",
			allowSort : true,
			width:100,
		},{
			field : "lmphone",
			headerAlign : "center",
			header : "联系方式",
			allowSort : true,
			width:100,
		},{
			field : "spid",
			headerAlign : "center",
			header : "对应商铺",
			allowSort : true,
			width:100,
		},{
			field : "symboliprojectcname",
			headerAlign : "center",
			header : "标志性项目名称",
			allowSort : true,
			width:200,
		}]
	},
};
//附件列表
var filelistcolumns = {
	"type" : "gridbox",
	"properties" : {
		"id" : "billattachment",
		"multiSelect" : true,
		"allowCellEdit" : true,
		"allowCellSelect" : true,
		"editNextOnEnterKey" : true,
		"editNextRowCell" : true,
		"allowSortColumn" : false,
		"showColumnsMenu":true,
		"showSummaryRow":true,
		"oncellbeginedit" : "OcmControl.checkboxEditor",
		"columns" : [ {
			type : "indexcolumn",
			headerAlign : "center",
			header : "行号",
			readOnly : true,
			width:30,
		}, {
			field : "billno",
			headerAlign : "center",
			header : "billno",
			readOnly : "true",
			visible : false,
		}, {
			field : "billmoduleid",
			headerAlign : "center",
			header : "billmoduleid",
			readOnly : "true",
			visible : false,
		}, {
			field : "filekey",
			headerAlign : "center",
			header : "文件key值",
			width : 100,
			readOnly : "true",
		}, {
			field : "filetype",
			type : "comboboxcolumn",
			headerAlign : "center",
			header : "文件类型",
			readOnly : "true",
			width : 80,
			readOnly: true,
    	    textField:"name",
    	    valueField:"code", 
			data: fileType,
			renderer: "OcmControl.dictRendererWithCode",
		}, {
			field : "filename",
			headerAlign : "center",
			header : "文件名",
			readOnly : "true",
			width : 200,
		}, {
			field : "download",
			headerAlign : "center",
			header : "下载",
			readOnly : "true",
			width : 50,
		}]
	}
};

function searchBrand() {
	var authgrid = mini.get("brandlibraryheadList");
	authgrid.clearRows();
	var ppcode_name = mini.get("ppcode_name").getValue();
	var status = "";
	var rbl = mini.get("rbl");
	status = rbl.getValue();
	var searchParam = {
		"queryid" : "select_brandlibraryheadlist",
		"ppcode_name" : ppcode_name,
		"brandstatus" : status,
	};
	var method = "mss.work.report.query";
	itemLoader.doRequest(OmdUrl.mss, method, searchParam, null, null,
			function(data) {
				var griddata = data.report;
				if (griddata.length > 0) {
					authgrid.setTotalCount(griddata.length);
					authgrid.setData(griddata);
					authgrid.setSelected(griddata[0]);
					selectBrand();
				}
			}, null, null, false);
}

function clearparam() {
	var form = new mini.Form("#searchform");
	var suplinkman = mini.get("suplinkman");
	var contmain = mini.get("contmain");
	var filelist = mini.get("billattachment");
	fillbrandData({});
	fillmarketanalysisData({});
	suplinkman.setData();
	contmain.setData();
	filelist.setData();
	form.clear();
}

function fillmarketanalysisData(data) {
	// 基本信息
	$("#rxse").text("");
	$("#yxse").text("");
	$("#px").text("");
	$("#yxstb").text("");
	$("#jfxh").text("");
	$("#yqje").text("");
	if (data && data.length > 0) {
		$.each(data[0], function(key, value) {
			if (key == "rxse") {
				$("#rxse").text(value);
			}
			if (key == "yxse") {
				$("#yxse").text(value);
			}
			if (key == "px") {
				$("#px").text(value);
			}
			if (key == "yxstb") {
				$("#yxstb").text(value);
			}
			if (key == "jfxh") {
				$("#jfxh").text(value);
			}
			if (key == "yqje") {
				$("#yqje").text(value);
			}
		});
	}
}

//品牌详细信息
function fillbrandData(data) {
	// 基本信息
	$("#info_ppcode").text("");
	$("#info_ppcname").text("");
	$("#info_mid_name").text("");
	$("#info_jyms").text("");
	$("#info_company").text("");
	$("#info_companynet").text("");
	$("#info_symboliprojectcname").text("");
	$("#info_getchannel").text("");
	$("#info_hpfg").text("");
	$("#info_pptarget").text("");
	$("#info_areamid_name").text("");
	$("#info_symbolicfloor").text("");
	$("#info_jzpp_name").text("");
	$("#info_adjacentbrand").text("");
	$("#info_pricemin").text("");
	$("#info_pricemax").text("");
	$("#info_pricerangegoodsname").text("");
	$("#info_areacovered").text("");
	$("#info_manageanalysis").text("");
	$("#info_nxse").text("");
	$("#info_salesrate").text("");
	$("#info_opennumber").text("");
	$("#info_latelyopennumber").text("");
	$("#info_openrate").text("");
	$("#info_openarea").text("");
	$("#info_px").text("");
	$("#info_putcondition").text("");
	$("#info_cooperationmode").text("");
	$("#info_cooperationcondition").text("");
	$("#info_majorinfo").text("");
	if (data && data.length > 0) {
		$.each(data[0], function(key, value) {
			if (key == "ppcode"){$("#info_ppcode").text(value);}
			if (key == "ppcname"){$("#info_ppcname").text(value);}
			if (key == "mid_name"){$("#info_mid_name").text(value);}
			if (key == "jyms"){$("#info_jyms").text(value);}
			if (key == "company"){$("#info_company").text(value);}
			if (key == "companynet"){$("#info_companynet").text(value);}
			if (key == "symboliprojectcname"){$("#info_symboliprojectcname").text(value);}
			if (key == "getchannel"){$("#info_getchannel").text(value);}
			if (key == "hpfg"){$("#info_hpfg").text(value);}
			if (key == "pptarget"){$("#info_pptarget").text(value);}
			if (key == "mid_name"){$("#info_mid_name").text(value);}
			if (key == "symbolicfloor"){$("#info_symbolicfloor").text(value);}
			if (key == "jzpp_name"){$("#info_jzpp_name").text(value);}
			if (key == "adjacentbrand"){$("#info_adjacentbrand").text(value);}
			if (key == "pricemin"){$("#info_pricemin").text(value);}
			if (key == "pricemax"){$("#info_pricemax").text(value);}
			if (key == "pricerangegoodsname"){$("#info_pricerangegoodsname").text(value);}
			if (key == "areacovered"){$("#info_areacovered").text(value);}
			if (key == "manageanalysis"){$("#info_manageanalysis").text(value);}
			if (key == "nxse"){$("#info_nxse").text(value);}
			if (key == "salesrate"){$("#info_salesrate").text(value);}
			if (key == "opennumber"){$("#info_opennumber").text(value);}
			if (key == "latelyopennumber"){$("#info_latelyopennumber").text(value);}
			if (key == "openrate"){$("#info_openrate").text(value);}
			if (key == "openarea"){$("#info_openarea").text(value);}
			if (key == "px"){$("#info_px").text(value);}
			if (key == "putcondition"){$("#info_putcondition").text(value);}
			if (key == "cooperationmode"){$("#info_cooperationmode").text(value);}
			if (key == "cooperationcondition"){$("#info_cooperationcondition").text(value);}
			if (key == "majorinfo"){$("#info_majorinfo").text(value);}
			if (key == "areamid_name"){$("#info_areamid_name").text(value);}
		});
	}
}

function selectBrand(){
	var brandlibraryheadList = mini.get("brandlibraryheadList");
	var row = brandlibraryheadList.getSelected();
	if(row == undefined || row == ''){
		return;
	}
	var suplinkman = mini.get("suplinkman");
	var contmain = mini.get("contmain");
	var filelist = mini.get("billattachment");
	
	suplinkman.setData();
	contmain.setData();
	filelist.setData();
	
	var brand_searchparam = {
		"queryid" : "select_brandinfo",
		ppcode : row.ppcode
	};
	var suplinkman_searchparam = {
		"queryid" : "select_suplinkman",
		ppcode : row.ppcode
	};
	var contmain_searchparam = {
		"queryid" : "select_contmain_brand",
		ppcode : row.ppcode
	};
	var marketanalysis_searchparam = {
		"queryid" : "select_marketanalysis",
		ppcode : row.ppcode
	};
	var filelist_searchparam = {
		"queryid" : "select_filelist",
		ppcode : row.ppcode
	};
	
	itemLoader.doRequest(OmdUrl.mss, "mss.work.report.query",brand_searchparam, null, null, function(data) {
		var brandData = data.report;
		if (brandData.length > 0) {
			fillbrandData(brandData);
		}
	}, null, null, false);
	
	itemLoader.doRequest(OmdUrl.mss, "mss.work.report.query",suplinkman_searchparam, null, null, function(data) {
		var suplinkmanData = data.report;
		if (suplinkmanData.length > 0) {
			suplinkman.setData(suplinkmanData);
		}
	}, null, null, false);
	itemLoader.doRequest(OmdUrl.mss, "mss.work.report.query",contmain_searchparam, null, null, function(data) {
		var contmainData = data.report;
		if (contmainData.length > 0) {
			contmain.setData(contmainData);
		}
	}, null, null, false);
	itemLoader.doRequest(OmdUrl.mss, "mss.work.report.query",marketanalysis_searchparam, null, null, function(data) {
		var marketanalysisData = data.report;
		if (marketanalysisData.length > 0) {
			fillmarketanalysisData(marketanalysisData);
		}
	}, null, null, false);
	itemLoader.doRequest(OmdUrl.mss, "mss.work.report.query",filelist_searchparam, null, null, function(data) {
		var filelistData = data.report;
		if (filelistData.length > 0) {
			var temp = [];
			var data = filelistData;
			for ( var i = 0; i < filelistData.length; i++) {
		  		var row = {};
		  		row.filename = data[i].filename;
				row.filetype = data[i].filetype;
				row.ph_timestamp = new Date(data[i].ph_timestamp);
				//row.ph_timestamp = mini.formatDate(row.ph_timestamp,"yyyy-MM-dd HH:mm:ss");
				row.filekey = data[i].filekey;
				row.billno = data[i].billno;
				row.billmoduleid = data[i].billmoduleid;
				var url = '<a href="http://' + window.location.host + '/mall-fileservice/xload/download/mongo/?data=' + row.filekey + '"  target="view_window">下载</a>';
				url = encodeURI(url);
				row.download = url;
				temp.push(row);
		  	} 
			filelist.setData(temp);
		}
	}, null, null, false);
}

// +---------------------------------------------------
// | 字符串转成日期类型
// | 格式 MM/dd/YYYY MM-dd-YYYY YYYY/MM/dd YYYY-MM-dd
// +---------------------------------------------------
function StringToDate(DateStr) {

	var converted = Date.parse(DateStr);
	var myDate = new Date(converted);
	if (isNaN(myDate)) {
		// var delimCahar = DateStr.indexOf('/')!=-1?'/':'-';
		var arys = DateStr.split('-');
		myDate = new Date(arys[0], --arys[1], arys[2]);
	}
	return myDate;
}

