/**
 * 页面定义
 */
(function () {
	// 要引用的包
	var utils = Future.ns('Future.utils');
	var validate = Future.ns('Future.validate');
	var col = Future.ns('default.col');
	// 活动命名空间
	var ns = Future.ns('changemoney.view');

	// 定义一个对象用来配置界面
	var bill = {};
	//var billtype = getBilltype(app.modulecode);
	// 把定义对象放到命名空间下
	ns.bill = bill;
	//utils.billtype = billtype;
	
//	var money = [{ code: '0.1', name: '1角' }, { code: '0.5', name: '5角'},
//	             { code: '1', name: '1元' }, { code: '5', name: '5元'},
//                 { code: '10', name: '10元' }, { code: '20', name: '20元'},
//                 { code: '50', name: '50元' }, { code: '100', name: '100元'}];
	// 字典数据初始化
	var dicData = OcmControl.getDict("BILLMODULEID,BILLSTATUS,BILLSOURCE","code,name,pro1,ddvalue") || {};

	// 查询列表
	bill.changemoneylist = {
		"type": "gridbox",
		"resources": OmdUrl.mss,
		"method": "mss.work.changemoneyhd.search",
		"response": "changemoneyhd",
		"bindform": "layouttabs",
		"bindSearchParam": ["ph_key"], // 明细页面查询条件字段
		"searchParam": {
			"billmoduleid" : app.modulecode,
			"order_field": "billno",
			"order_direction": "desc",
		},
		"properties": {
			"id": utils.createid('changemoneylist'),
			"columns": [{
				type: "indexcolumn",
				headerAlign: "center",
				header: "行号",
				width: 60,
			}, {
				field: "billno",
				type: "TextBox",
				headerAlign: "center",
				header: "单据编号",
				width: 150,
			}, {
				field: "billstatus",
				type: "TextBox",
				headerAlign: "center",
				header: "单据状态",
				renderer: "OcmControl.dictRendererWithCode",
				dictkey: 'BILLSTATUS',
			}, {
				field : "billsource",
				headerAlign : "center",
				header : "单据来源",
				type : "comboboxcolumn",  
				headerAlign : "center",
	        	textField:"name",
        	    valueField:"code" , 
				data: dicData.BILLSOURCE,
				renderer: "OcmControl.dictRendererWithCode",
				allowSort : true,
			}, {
				field: "muid",
				type: "TextBox",
				headerAlign: "center",
				header: "门店",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "muid_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"muid"},
				visible:false,
				enabledSearch : true,
			}, {
				field: "muid_name",
				type: "TextBox",
				headerAlign: "center",
				header: "门店",
				enabledSearch : false,
				width: 180,
			},{
				field: "spid",
				type: "TextBox",
				headerAlign: "center",
				header: "商铺",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "spid_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"spid"},
				visible:false,
				enabledSearch : true,
			}, {
				field: "spid_name",
				type: "TextBox",
				headerAlign: "center",
				header: "商铺",
				enabledSearch : false,
				width: 180,
			}, {
				field : "money",
				header : "兑换总金额",
				headerAlign : "center",
				align: "right",
				vtype :"float",
				readOnly : true,
			},{
				field : "exchange",
				headerAlign : "center",
				header : "兑换人",
				width:150,
				allowSort : true,
			},{
				field : "exchangedate",
				headerAlign : "center",
				header : "兑换日期",
				dataType : "date",
				dateFormat : "yyyy-MM-dd",
				width:150,
				allowSort : true,
			},{
				field : "inputer_name",
				header : "录入人",
				width : 150,
				allowSort : true,
				headerAlign : "center",	
				enabledSearch : false,
			},{
				field : "inputer",
				header : "录入人",
				width : 100,
				allowSort : true,
				headerAlign : "center",	
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "inputer_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
				visible:false,
				enabledSearch : true,
			}, {
				field : "inputdate",
				type : "date",
				dataType : "date",
				format : "yyyy-MM-dd",
				header : "录入日期",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "auditor",
				header : "审核人",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "auditor_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
				visible:false,
				enabledSearch : true,
			}, {
				field : "auditor_name",
				header : "审核人",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				enabledSearch : false,
			}, {
				field : "auditdate",
				type : "date",
				format : "yyyy-MM-dd",
				header : "审核日期",
				width : 150,
				dataType : "date",
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, /*{
				field : "memo",
				header : "备注",
				width : 120,
				allowSort : true,
				headerAlign : "center",
				visible:false,
			}*/]
		}
	};
	
	// 单据主表
	bill.changemoneyhd = {
		"type": "formgrid",
		"resources": OmdUrl.mss,
		"name": 'changemoneyhd',
		"method": "mss.work.changemoneyhd.get",
		"response": "changemoneyhd",
		"properties": {
			"id": utils.createid('changemoneyhd')
		},
		items: [{
				"label": "ph_key：",
				"name": "ph_key",
				"type": "TextBox",
				"visible": false,
			}, {
				"label": "单据编号：",
				"name": "billno",
				"type": "TextBox",
				"readOnly": true,
				"style" : "width:22.5%"
			}, {
				"label": "单据类型：",
				"name": "billmoduleid",
				"type": "ComboBox",
				"defaultValue": app.modulecode,
				dictkey: 'BILLMODULEID',
				"readOnly": true,
				"style" : "width:22.5%"
			}, {
				"label": "单据状态：",
				"name": "billstatus",
				"type": "ComboBox",
				dictkey: 'BILLSTATUS',
				"readOnly": true,
				"defaultValue": "N",
				"style" : "width:22.5%"
			},  {
				"label" : "单据来源：",
				"type" : "ComboBox",
				"name" : "billsource",
				"readOnly": "true",
				"data" : dicData.BILLSOURCE,
				//"defaultValue" : '02',
				"style" : "width:22.5%"
			}, {
				"label": "门店：",
				"name": "muid",
				"type": "fut_popselect",
				"required": "true",
				selectkey: "muid",
				textName: "muid_name",
				allowInput: true,
				beforefunc : "page.head_beforefunc_muid",
				//itemchangedfunc:"page.head_itemchangedfunc",
				"style" : "width:22.5%"
			}, {
				"label": "门店：",
				"name": "muid_name",
				"type": "TextBox",
				visible: false
			}, {
				"label": "商铺：",
				"name": "spid",
				"type": "fut_popselect",
				"required": "true",
				selectkey: "spid",
				textName: "spid_name",
				allowInput: true,
				beforefunc : "page.head_beforefunc_spid",
				"style" : "width:22.5%"
			}, {
				"label": "商铺：",
				"name": "spid_name",
				"type": "TextBox",
				visible: false
			}, {
				"label" : "兑换人：",
				"name" : "exchange",
				"type" : "TextBox",
				"readOnly" : false,
				"enabled" : false,
				"required": "true",
				"style" : "width:22.5%"
			}, {
				"label" : "兑换日期：",
				"type" : "DatePicker",
				"name" : "exchangedate",
				"enabled" : "true",
				"format" : "yyyy-MM-dd",
				"defaultValue" : new Date(),
				"required": "true",
				"style" : "width:22.5%"
			}, {
				"label" : "兑换总金额：",
				"name" : "money",
				"type" : "TextBox",
				"readOnly" : true,
				"enabled" : true,
				defaultValue : "0.00",
				"style" : "width:22.5%"
			}, {
				"label": "录入人：",
				"name" : "inputer_name",
				"type" : "TextBox",
				"readOnly" : true,
				"visible" : true,
				"defaultValue" : app.username,
				"style" : "width:22.5%"
			}, {
				"label" : "录入日期：",
				"name" : "inputdate",
				"type" : "DatePicker",
				"readOnly" : true,
				"format" : "yyyy-MM-dd HH:mm:ss",
				"visible" : true,
				"defaultValue" : new Date(),
				"style" : "width:22.5%"
			}, {
				"label": "审核人：",
				"type": "TextBox",
				"name": "auditor_name",
				"readOnly": "true",
				"style" : "width:22.5%"
			}, {
				"label": "审核日期：",
				"type": "DatePicker",
				"name": "auditdate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
				"style" : "width:22.5%"
			}
		]
	}
	// 单据明细
	bill.changemoneydet= {
			title: '单据明细',
			"type": "gridbox",
			name: 'changemoneydet',
			"properties": {
				"id": utils.createid('changemoneydet'),
				"multiSelect" : true,
				"allowCellEdit" : true,
				"allowCellSelect" : true,
				"editNextOnEnterKey" : true,
				"editNextRowCell" : true,
				"allowSortColumn" : false,
				"showColumnsMenu":true,
				"showSummaryRow":true,
				"oncellbeginedit": "OcmControl.checkboxEditor",
				"columns": [{
					type: "checkcolumn",
					name: "checkcolumn",
					headerAlign: "center",
					readOnly: true,
					width: "40",
				}, 
				/*{
					field: "rowno",
					header: "导入行号",
					visible: false,
				}, */
				{
					type: "indexcolumn",
					name: "indexcolumn",
					header: "行号",
					headerAlign: "center",
					readOnly: true,
					width: "40",
				}, {
					field : "exchange_name",
					header : "兑换名称",
					allowSort : true,
					type : "comboboxcolumn",
					textField : "name",
				  	valueField : "code",
				  	renderer: "OcmControl.dictRendererWithCode",
					dictkey: 'EXCHANGEXNAME',
					editor:OcmControl.newControl('ComboBox'),
					headerAlign : "center",
					width : 150,
					required : true,
				}, {
					field : "exchangex",
					header : "兑换基数(元)",
					headerAlign : "center",	
					align : "right",
					width : 150,
				    //editor : OcmControl.newControl('NumButtonEdit'),
					//editorSet:{format: "n0",},
					//numberFormat:"n0",
					defaultValue : "0",
					align : "right",
					readOnly: true,
					required : false,
				}, {
					field : "num",
					header : "兑换张数",
					headerAlign : "center",	
					align : "right",
					width : 150,
				    editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "n0",},
					numberFormat:"n0",
					defaultValue : "0",
					align : "right",
					readOnly: false,
					required : true,
				}, {
					field : "money",
					header : "兑换金额",
					headerAlign : "center",	
					align : "right",
					width : 150,
				    editor : OcmControl.newControl('NumButtonEdit'),
				    editorSet:{format: "c2",},
					numberFormat:"c2",
					defaultValue : "0",
					align : "right",
					readOnly: true,
					required : false,
				}]
			},
		};

	var btn = Future.default.btn;
	// 按钮配置 - 固定名称
	bill.toolbarconfig = {
		id: utils.createid('systoolbar'),
		items: [btn.addData, btn.delData, btn.editData, btn.saveData,
			btn.auditData, btn.searchData
		]
	}

	// 单据配置
	bill.billconfig = {
		billhead: bill.changemoneyhd, // 单据主表
		billdetail: [bill.changemoneydet], // 单据明细表
		billquerylist: bill.changemoneylist, // 查询列表
		dettabpages: [bill.changemoneydet], // 要放入明细TAB列表的组件
		defaultmoduleid: app.modulecode, // 默认单据类型
	}
	// 创建标准单据模板
	utils.create_standardbill_config(bill);

})()
