/**
 * 页面定义
 */
(function () {
	// 要引用的包
	var utils = Future.ns('Future.utils');
	var validate = Future.ns('Future.validate');
	var col = Future.ns('default.col');
	// 活动命名空间
	var ns = Future.ns('batchgoods.view');
	// 定义一个对象用来配置界面
	var bill = {};
	
	var billtype=getBilltype(app.modulecode);
	
    var billtypes = {
			ly: '2', //联营
			zy: '158', //自营
		}
	if(billtype==billtypes.ly){
		$("title").html("联营商品批量新增");
	}else if(billtype==billtypes.zy){
		$("title").html("自营商品批量新增");
	}
	
	// 把定义对象放到命名空间下
	ns.bill = bill;

	utils.billtype=billtype;
	
	var zywmid = [{code: '1',name: '经销',ddvalue: '[1]经销'},{code: '2',name: '成本代销',ddvalue: '[2]成本代销'},{code: '3',name: '扣率代销',ddvalue: '[3]扣率代销'}];
	var lywmid = [{code: '4',name: '联营',ddvalue: '[4]联营'}];
	
	var zycmpmmid = [{code: '1',name: '管库存单品',ddvalue: '[1]管库存单品'}];
	var lycmpmmid = [{code: '3',name: '不管库存编码',ddvalue: '[3]不管库存编码'},{code: '4',name: '现金键',ddvalue: '[4]现金键'}];
	
	var zygbjjfs = [{code: '1',name: '顺加',ddvalue: '[1]顺加'},{code: '4',name: '倒扣比率',ddvalue: '[4]倒扣比率'}];
	var lygbjjfs = [{code: '3',name: '倒扣金额',ddvalue: '[3]倒扣金额'},{code: '4',name: '倒扣比率',ddvalue: '[4]倒扣比率'}];
	
	var dictData = OcmControl.getDict("GBJJFS","code,name,pro1,ddvalue");
	 
	//获取模块信息
	function getGlobrule(code) {
		 var temp = "";
		 var rule = "1";
		 var searchParam = {"queryid":"select_rulemode"};
		 if (code != undefined && code != "") {
			 searchParam.ruleid = code; 
		 }
		 var method = "mss.work.report.query";
		 itemLoader.doRequest(OmdUrl.mall, method,searchParam, null, null, function(data) {
			 temp = data.report;
			 if(temp.length > 0){
				 rule = temp[0].rulemode;
			 }
		 },null,null,false);
		 return rule;
	}
	var gbidRulemode = getGlobrule("08");
		
	//获取成本代销合同扣率
	var getselfkl = function() {
		var searchParam = {
			queryid : "select_selfgetkl",
			"wmid" : "3",
		};
		var _dicData = {};
		itemLoader.doRequest(OmdUrl.mall, "mss.work.report.query",
				searchParam, null, null, function(data) {
					_dicData = data.report;
				}, null, null, false);
		return _dicData;
	};
	dictData.CONTKL = getselfkl();
	
	// 查询列表
	bill.batchgoodslist = {
		"type": "gridbox",
		"resources": OmdUrl.mss,
		"method": "mss.commodity.goodsbasehead.search",
		"response": "goodsbasehead",
		"bindform": "layouttabs",
		"bindSearchParam": ["ph_key"], // 明细页面查询条件字段
		"searchParam": {
			"billtype" : billtype,
			"order_field": "inputdate",
			"order_direction": "desc",
		},
		"properties": {
			"id": utils.createid('batchgoodslist'),
			"columns": [{
				type: "indexcolumn",
				headerAlign: "center",
				header: "行号",
				width: 60,
			}, {
				field: "billno",
				type: "TextBox",
				headerAlign: "center",
				header: "单据编号",
				width: 150,
			}, {
				field: "billstatus",
				type: "TextBox",
				headerAlign: "center",
				header: "单据状态",
				renderer: "OcmControl.dictRendererWithCode",
				dictkey: 'BILLSTATUS',
			},{
				field: "billtype",
				type: "TextBox",
				headerAlign: "center",
				header: "单据类型",
				renderer: "OcmControl.dictRendererWithCode",
				dictkey: 'BILLTYPE',
				visible:false,
			}, {
				field: "muid",
				type: "TextBox",
				headerAlign: "center",
				header: "门店",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "muid_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"muid"},
				visible:false,
				enabledSearch : true,
			}, {
				field: "muid_name",
				type: "TextBox",
				headerAlign: "center",
				header: "门店",
				enabledSearch : false,
				width: 200,
			}, {
				field: "goodsbasedet:sbid",
				headerAlign: "center",
				displayField : "sbid_name",
				header: billtype === billtypes.ly ? "商户":"供应商",
				cdEdtCfg:{compnentType:'fut_popselect',
					      selectkey: billtype === billtypes.ly ? "sbid": "selfsbid",
					      beforefunc : "page.list_beforefunc_sbid",
					      textName : "sbid_name",},	
				visible:false,
				enabledSearch : true,
			}, {
				field: "sbid_name",
				type: "TextBox",
				headerAlign: "center",
				header: billtype === billtypes.ly ? "商户":"供应商",
				enabledSearch : false,
				width: 150,
			}, {
				field: "goodsbasedet:spid",
				type: "TextBox",
				headerAlign: "center",
				header: billtype === billtypes.ly ? "商铺":"柜组",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "spid_name",
				cdEdtCfg:{compnentType:'fut_popselect',
					      selectkey: billtype === billtypes.ly ? "spid": "selfspid",
					      beforefunc : "page.list_beforefunc_spid",},
				visible:false,
				enabledSearch : true,
				beforefunc : "page.head_beforefunc",
			}, {
				field: "spid_name",
				type: "TextBox",
				headerAlign: "center",
				header: billtype === billtypes.ly ? "商铺":"柜组",
				enabledSearch : false,
				width: 150,
			}, {
				field : "inputer",
				header : "录入人",
				width : 100,
				allowSort : true,
				headerAlign : "center",	
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "inputer_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
				visible:false,
				enabledSearch : true,
			},{
				field : "inputer_name",
				header : "录入人",
				width : 200,
				allowSort : true,
				headerAlign : "center",	
				enabledSearch : false,
			}, {
				field : "inputdate",
				type : "date",
				dataType : "date",
				format : "yyyy-MM-dd",
				header : "录入日期",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "auditor",
				header : "审核人",
				width : 100,
				allowSort : true,
				headerAlign : "center",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "auditor_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
				visible:false,
				enabledSearch : true,
			}, {
				field : "auditor_name",
				header : "审核人",
				width : 200,
				allowSort : true,
				headerAlign : "center",
				enabledSearch : false,
			}, {
				field : "auditdate",
				type : "date",
				format : "yyyy-MM-dd",
				header : "审核日期",
				width : 150,
				dataType : "date",
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}]
		}
	};
	
	// 单据主表
	bill.goodsbasehead = {
		"type": "formgrid",
		"initHeight" : 0.35,
		"resources": OmdUrl.mss,
		"name": 'goodsbasehead',
		"method": "mss.commodity.goodsbasehead.get",
		"response": "goodsbasehead",
		"properties": {
			"id": utils.createid('goodsbasehead')
		},
		items: [{
				"label": "ph_key：",
				"name": "ph_key",
				"type": "TextBox",
				"visible": false,
			}, {
				"label": "单据编号：",
				"name": "billno",
				"type": "TextBox",
				"readOnly": true,
				"visible": true,
			}, {
				"label": "模块编号：",
				"name": "billmoduleid",
				"type": "TextBox",
				"defaultValue": app.modulecode,
				"visible": false,
			}, {
				"label": "单据类型：",
				"name": "billtype",
				"type": "TextBox",
				"defaultValue": getBilltype(app.modulecode),
				"visible": false
			}, {
				"label" : "手工编号：",
				"name" : "billsgno",
				"type" : "TextBox",
				"readOnly" : false,
			}, {
				"label": "单据状态：",
				"name": "billstatus",
				"type": "ComboBox",
				dictkey: 'BILLSTATUS',
				"readOnly": true,
				"defaultValue": "N",
			}, {
				"label": "门店：",
				"name": "muid",
				"type": "fut_popselect",
				selectkey: "muid",
				textName: "muid_name",
				allowInput: true,
				beforefunc : "page.head_beforefunc",
				itemchangedfunc:"page.head_itemchangedfunc",
				"required": true,
			}, {
				"label": billtype === billtypes.ly ? "商户：":"供应商：",
				"name": "sbid",
				"type": "fut_popselect",
				selectkey: billtype === billtypes.ly ? "sbid": "selfsbid",
				textName: "sbid_name",
				allowInput: true,
				beforefunc : "page.head_beforefunc",
				itemchangedfunc:"page.head_itemchangedfunc",
			}, {
				"label": billtype === billtypes.ly ? "商铺：":"柜组：",
				"name": "spid",
				"type": "fut_popselect",
				selectkey: billtype === billtypes.ly ? "spid": "selfspid",
				textName: "spid_name",
				beforefunc : "page.head_beforefunc",
				allowInput: true,
				"style" : "display:block;float:none",
			},{
				"label": "录入人：",
				"type": "TextBox",
				"name": "inputer_name",
				"readOnly": "true",
			}, {
				"label": "审核人：",
				"type": "TextBox",
				"name": "auditor_name",
				"readOnly": "true",
				"style" : "display:block;float:none",
			}, {
				"label": "录入日期：",
				"type": "DatePicker",
				"name": "inputdate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
			}, {
				"label": "审核日期：",
				"type": "DatePicker",
				"name": "auditdate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
			}, {
				"label": "录入人编码",
				"type": "TextBox",
				"name": "inputer",
				"visible": false,
			}, {
				"label": "最后修改日期：",
				"type": "DatePicker",
				"name": "lastmoddate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"visible": false,
			}
		]
	}
	// 单据明细
	bill.goodsbasedet= {
			title: '单据明细',
			"type": "gridbox",
			name: 'goodsbasedet',
			"properties": {
				"id": utils.createid('goodsbasedet'),
				"multiSelect": "true",
				"allowCellEdit": "true",
				"allowCellSelect": "true",
				"editNextOnEnterKey": "true",
				"editNextRowCell": "true",
				"allowSortColumn": "false",
				"allowCellValid": true,
				"sortMode": "client",
				//"showPager": true,
				"oncellbeginedit": "OcmControl.checkboxEditor",
				"columns": [{
					type: "checkcolumn",
					headerAlign: "center",
					readOnly: true,
				}, {
					type: "indexcolumn",
					header: "行号",
					headerAlign: "center",
					readOnly: true,
					width: "60px",
				}, {
					field: "gbid",
					header: "商品编码",
					headerAlign: "center",
					width: 120,					
					readOnly : gbidRulemode === "1" ? true : false,
					required : gbidRulemode === "1" ? false : true,
					allowSort : true,
				}, {
					field: "gbbarcode",
					header: "商品条码",
					headerAlign: "center",
					//required: true,
					width: 120,
				}, {
					field: "gbcname",
					header: "商品名称",
					headerAlign: "center",
					required: true,
					width: 150,
				}, {
					field: "gbtype",
					header: "商品类型",
					type : "comboboxcolumn",
					editor : OcmControl.newControl('ComboBox'),
					renderer : "OcmControl.dictRendererWithCode",
					dictkey : 'GBTYPE',
					visible: false,
				}, {
					field: "gbcostid",
					header: "成本核算方式",
					type : "comboboxcolumn",
					editor : OcmControl.newControl('ComboBox'),
					renderer : "OcmControl.dictRendererWithCode",
					dictkey : 'CMPHSFF',
					visible : false,
				}, {
					field: "muid",
					name: "muid",
					type: "TextBox",
					headerAlign: "center",
					header: "门店",
					editor:OcmControl.newControl('fut_popselectgrid'),
					displayField : "muid_name",
					editorSet: {
	                    selectkey: 'muid',
	                    multiSelect: false,
	                    beforefunc:"page.det_beforefunc",
	                    itemchangedfunc:"page.det_itemchangedfunc",
	                	},
					allowSort: true,
					visible: false,
					width : 150,
				}, {
					field: "sbid",
					name: "sbid",
					type: "TextBox",
					headerAlign: "center",
					header:  billtype === billtypes.ly ? "商户":"供应商",
					editor:OcmControl.newControl('fut_popselectgrid'),
					displayField : "sbid_name",
					editorSet: {
	                    selectkey: billtype === billtypes.ly ? "sbid": "selfsbid",
	                    multiSelect: false,
	                    beforefunc:"page.det_beforefunc",
	                    itemchangedfunc:"page.det_itemchangedfunc",
	                	},
					allowSort: true,
					required: true,
					width : 220,
				}, {
					field: "spid",
					name: "spid",
					type: "TextBox",
					headerAlign: "center",
					header: billtype === billtypes.ly ? "商铺":"柜组",
					editor:OcmControl.newControl('fut_popselectgrid'),
					displayField : "spid_name",
					editorSet: {
		                    selectkey: billtype === billtypes.ly ? 'spid': 'selfspid',
		                    multiSelect: false,
		                    beforefunc:"page.det_beforefunc",
		                    itemchangedfunc:"page.det_itemchangedfunc",
		                },
					allowSort: true,
					required: true,
					width : 180,
				}, {
					field: "ppcode",
					name: "ppcode",
					header: "品牌",
					headerAlign: "center",
					allowSort: true,
					required: true,
					editor: OcmControl.newControl('fut_popselectgrid'),
	                displayField: "ppcode_name",
	                width: 150,
	                editorSet: {
	                    selectkey: 'ppcode',
	                    multiSelect: false,
	                    beforefunc:"page.det_beforefunc",
	                },
				},  {
					field: "catcode",
					header: "商品类别",
					headerAlign: "center",
					allowSort: true,
					required: true,
					editor: OcmControl.newControl('fut_popselectgrid'),
	                displayField: "catcode_name",
	                width: 150,
	                editorSet: {
	                    selectkey: 'treeGbcatcode',
	                    multiSelect: false,
	                },
				}, {
					field: "gbcdcode",
					name: "gbcdcode",
					header: "产地",
					headerAlign: "center",
					allowSort: true,
					editor: OcmControl.newControl('fut_popselectgrid'),
	                displayField: "gbcdcode_name",
	                width: 130,
	                editorSet: {
	                    selectkey: 'coderegion',
	                    beforefunc:"page.det_beforefunc",
	                },
	                required: billtype === billtypes.ly ? false:true,
				},{
					field: "gbunit",
					header: "计量单位",
					headerAlign: "center",
					/*required: billtype === billtypes.ly ? false:true,*/
					required : false,
					width: 100,
					visible: billtype === billtypes.ly ? false:true,
				}, {
					field: "cshh",
					header: "厂商货号",
					headerAlign: "center",
					width: 90,
					visible: billtype === billtypes.ly ? false:true,	
				},  {
					field: "spec",
					header: "规格",
					headerAlign: "center",
					width: 90,
					visible: billtype === billtypes.ly ? false:true,	
				},{
					field : "gbmanamode",
					headerAlign : "center",
					header : "管理方式",
					type : "comboboxcolumn",
					editor : OcmControl.newControl('ComboBox'),
					renderer : "OcmControl.dictRendererWithCode",
					defaultValue : billtype === billtypes.ly ?"":"1",
					data : billtype === billtypes.ly ?lycmpmmid:zycmpmmid,
					allowSort: true,
					required: true,
					readOnly: billtype === billtypes.ly ? false:true,
					width : 120,
				}, {
					field : "gbwmid",
					headerAlign : "center",
					header : "经营方式",
					type : "comboboxcolumn",
					editor : OcmControl.newControl('ComboBox'),
					renderer : "OcmControl.dictRendererWithCode",
					defaultValue : billtype === billtypes.ly ?"4":"",
				    data : billtype === billtypes.ly ? lywmid:zywmid,
					required: true,
					readOnly: billtype === billtypes.ly ? true:false,
					width : 100, 
				}, {
					field : "gbjjfs",
					headerAlign : "center",
					header : "计价方式",
					type : "comboboxcolumn",
					editor : OcmControl.newControl('ComboBox'),
					renderer : "OcmControl.dictRendererWithCode",
					data : billtype === billtypes.ly ? lygbjjfs: zygbjjfs,
					defaultValue : billtype === billtypes.ly ?"4":"1",
					readOnly: true,
					required: true,
					width : 100,
				}, {
					field : "gbtmjstype",
					headerAlign : "center",
					header : "特卖码结算方式",
					type : "comboboxcolumn",
					editor : OcmControl.newControl('ComboBox'),
					renderer : "OcmControl.dictRendererWithCode",
					dictkey : 'GBTMJSTYPE',
					width : 100,
					visible: false
				}, {
					field : "gbisyj",
					headerAlign : "center",
					header : "是否定价",
					type : "comboboxcolumn",
					editor : OcmControl.newControl('ComboBox'),
					renderer : "OcmControl.dictRendererWithCode",
					defaultValue : billtype === billtypes.ly ?"N":"Y",
					dictkey : 'GBISYJ',
					required: true,
					readOnly:true,
					width : 100,
				},{
					field : "isyj",
					headerAlign : "center",
					header : "是否议价",
					type : "comboboxcolumn",
					editor : OcmControl.newControl('ComboBox'),
					renderer : "OcmControl.dictRendererWithCode",
					defaultValue : billtype === billtypes.ly ?"Y":"N",
					visible : billtype === billtypes.ly ? false : true,
					dictkey : 'GBISYJ',
					required: true,
					width : 100,
				}, {
	                field: "gmphsjj",
	                header: "进价",
	                headerAlign: "center",
					width: 110,
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "c2",},
					numberFormat:"c2",
					defaultValue : "0",
					align : "right",
					readOnly: billtype === billtypes.ly ? true: false,
					required: true,
				}, {
	                field: "gmpsj",
	                header: "售价",
	                headerAlign: "center",
					width: 110,
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "c2",},
					numberFormat:"c2",
					defaultValue : "0",
					align : "right",
					allowSort: true,
					required: true,
				}, {
	                field: "gmpkl",
	                name : "gmpkl",
	                header: "扣率",
	                headerAlign: "center",
					width: 100,
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "p2",},
					numberFormat:"p2",
					value : "0",
					align : "right",
					vtype :"range:0,1",
					allowSort: true,
					required: true,
	            }, {
	                field: "gmpke",
	                header: "扣额",
	                headerAlign: "center",
					width: 110,
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{format: "c2",},
					numberFormat:"c2",
					value : "0",
					align : "right",
					readOnly: true,
					required: true,
				}, {
					field : "priceaccuracy",
					headerAlign : "center",
					header : "售价精度",
					type : "comboboxcolumn",
					editor : OcmControl.newControl('ComboBox'),
					renderer : "OcmControl.dictRendererWithCode",
					dictkey : 'PRICEACCURACY',
					required: true,
					width : 100,
	            }, {
	                field: "gmptaxtype",
	                header: "销售税种",
	                headerAlign: "center",
	                type : "comboboxcolumn",
					editor : OcmControl.newControl('ComboBox'),
					renderer : "OcmControl.dictRendererWithCode",
					dictkey : 'GMFTAXTYPE',
					defaultValue : "1",
					width: 100,
					visible: false
	            }, {
	                field: "gmpjxtax",
	                header: "进项税率",
	                headerAlign: "center",
	                type : "comboboxcolumn",
					editor : OcmControl.newControl('ComboBox'),
					renderer : "OcmControl.dictRendererWithCode",
					dictkey : 'JXTAXRATE',
					allowSort: true,
					required: true,
					width : 100,
	            }, {
	                field: "gmpxstax",
	                header: "销项税率",
	                headerAlign: "center",
	                type : "comboboxcolumn",
					editor : OcmControl.newControl('ComboBox'),
					renderer : "OcmControl.dictRendererWithCode",
					dictkey : 'XXTAXRATE',
					allowSort: true,
					required: true,
					width : 100,
	            }, {
	                field: "gmpxftax",
	                header: "消费税率",
	                headerAlign: "center",
	                type : "comboboxcolumn",
					editor : OcmControl.newControl('ComboBox'),
					renderer : "OcmControl.dictRendererWithCode",
					dictkey : 'XFTAXRATE',
					allowSort: true,
					required: true,
					width : 100,
				} ]
			},
		};

	var btn = Future.default.btn;
	// 按钮配置 - 固定名称
	bill.toolbarconfig = {
		id: utils.createid('systoolbar'),
		items: [btn.addData, btn.delData, btn.editData, btn.saveData,
		        btn.separator,btn.auditData, btn.searchData,
			    btn.separator,/*btn.upTemplate,*/btn.downTemplate,btn.billImport
		  ]
	}
	// 单据配置
	bill.billconfig = {
		billhead: bill.goodsbasehead, // 单据主表
		billdetail: [bill.goodsbasedet], // 单据明细表
		billquerylist: bill.batchgoodslist, // 查询列表
		dettabpages: [bill.goodsbasedet], // 要放入明细TAB列表的组件
		defaultmoduleid: app.modulecode, // 默认单据类型
	}

	// 创建标准单据模板
	utils.create_standardbill_config(bill);

})()
