/**
 * 商品配置单 --- 界面定义
 */
(function() {
	// 要引用的包
	var utils = Future.ns('Future.utils');
	
	var col = Future.ns('default.col');
	// 命名空间
	var ns = Future.ns('gbconfigurationlist.view');

	// 定义一个对象用来配置界面
	var bill = {};

	var moduleid = app.modulecode;
	var billtype=getBilltype(moduleid);
	
	var dictData = OcmControl.getDict("DEPLOYTYPE,CMPMMID,GBSTATUS,PRICEACCURACY,GBJJFS,GBISYJ,GBTYPE,CMPHSFF,GMFSTATUS,GMFTAXTYPE,XXTAXRATE,XFTAXRATE","code,name,pro1,ddvalue")
	

	// 把定义对象放到命名空间下
	ns.bill = bill;
	// 表头 自定义名称
	bill.gbcopyhead = {
		"name" : 'gbcopyhead',
		"initHeight" : 0.3,
		"type" : "formgrid",
		"resources" : OmdUrl.mall,
		"method" : "mss.commodity.gbcopyhead.get",
		"response" : "gbcopyhead",
		"properties" : {
			"id" : utils.createid('gbcopyhead'),
		},
		items : [{
			"label": "ph_key：",
			"name": "ph_key",
			"type": "TextBox",
			"visible": false,
		}, {
			"label": "单据编号：",
			"name": "billno",
			"type": "TextBox",
			"readOnly": true,
			"visible": true,
		},{
			"label": "单据编号：",
			"name": "billsgno",
			"type": "TextBox",
			"readOnly": true,
			"visible": false,
		}, {
			"label": "模块编号：",
			"name": "billmoduleid",
			"type": "TextBox",
			"defaultValue": moduleid,
			"visible": false
		}, {
			"label": "单据类型：",
			"name": "billtype",
			"type": "TextBox",
			"defaultValue": billtype,
			"visible": false
		}, {
			"label": "单据状态：",
			"name": "billstatus",
			"type": "ComboBox",
			dictkey: 'BILLSTATUS',
			"readOnly": true,
			"defaultValue": "N",
		},{
			"label" : "配置模式：",
			"name" : "deploytype",
			"type" : "ComboBox",
			"defaultValue" : "1",
			dictkey : 'DEPLOYTYPE',
			"required" : true,
			onvaluechanged:"page.head_itemchanged_deploytype", 
		},{
			"label" : "源门店：",
			"name" : "smuid",
			"type" : "ButtonEdit",
			"required" : true,
			"defaultValue" : "",
			type : "fut_popselect",
			selectkey:"muid",
			textName :"smuid_name",
			beforefunc:"page.head_beforefunc",
			itemchangedfunc:"page.head_itemchangedfunc_smuid", 
		},{
			"label" : "目标门店：",
			"name" : "muid",
			"type" : "ButtonEdit",
			"required" : true,
			"defaultValue" : "",
			type : "fut_popselect",
			selectkey:"muid",
			textName :"muid_name",
			beforefunc:"page.head_beforefunc",
			itemchangedfunc:"page.head_itemchangedfunc_muid", 
			"style" : "display:block;float:none"
		},{
			"label" : "源商铺/柜组：",
			"name" : "sspid",
			"required" : true,
			"defaultValue" : "",
			type : "fut_popselect",
			selectkey : "spid",
			textName : "sspid_name",
			beforefunc:"page.head_beforefunc",
			itemchangedfunc:"page.head_itemchangedfunc_sspid",
			allowSort : true,
		},{
			"label" : "源商铺名称：",
			"name" : "sspid_name",
			"type" : "TextBox",
			"readOnly" : true,
			"visible":false,
		},{
			"label" : "目标源商铺/柜组：",
			"name" : "spid",
			"required" : true,
			"defaultValue" : "",
			type : "fut_popselect",
			selectkey : "spid",
			textName : "spid_name",
			beforefunc:"page.head_beforefunc",
			itemchangedfunc:"page.head_itemchangedfunc_spid",
			allowSort : true, 
			"style" : "display:block;float:none",
		},{
			"label" : "目标商铺名称：",
			"name" : "spid_name",
			"type" : "TextBox",
			"readOnly" : true,
			"visible":false,
		},{
			"label" : "录入人：",
			"name" : "inputer_name",
			"type" : "TextBox",
			"defaultValue" : app.username,
			"readOnly" : true,
		}, {
			"label" : "录入人",
			"name" : "inputer",
			"type" : "TextBox",
			"readOnly" : true,
			"visible":false,
		},{
			"label" : "审核人：",
			"name" : "auditor_name",
			"type" : "TextBox",
			"readOnly" : true,
			"style" : "display:block;float:none",
		},{
			"label" : "审核人姓名",
			"name" : "auditor",
			"type" : "TextBox",
			"readOnly" : true,
			"visible":false,
		},{
	        "label" : "录入日期：",
	        "type" : "DatePicker",
	        "name" : "inputdate",
	        "format" : "yyyy-MM-dd HH:mm:ss",
	        "defaultValue" : new Date(),
	        "readOnly" : "true",
	    },{
            "label": "审核日期：",
            "type": "DatePicker",
            "name": "auditdate",
            "format": "yyyy-MM-dd HH:mm:ss",
            "readOnly": "true",
            "style" : "display:block;float:none",
	    }
	]
	};

	// 明细 自定义名称
	bill.gbcopydet = {
		title: '单据明细',
		"name" : 'gbcopydet',// 名称 数据绑定根据此数据来匹配
		"type" : "gridbox",
		"properties" : {
			"id" : utils.createid('gbcopydet'),
			"multiSelect" : "true",
			"allowCellEdit" : "true",
			"allowCellSelect" : "true",
			"editNextOnEnterKey" : "true",
			"editNextRowCell" : "true",
			"allowSortColumn" : "false",
			"allowCellValid" : true,
			"showPager" : false,
			"oncellbeginedit" : "OcmControl.checkboxEditor",
			"columns" : [ {
				type : "checkcolumn",
				headerAlign : "center",
				readOnly : true,
				width : 30,
			}, {
				type : "indexcolumn",
				header : "行号",
				headerAlign : "center",
			},{
				field: "gbid",
				name: "gbid",
				header: "商品编码",
				headerAlign: "center",
				allowSort: true,
				required: true,
				editor: OcmControl.newControl('fut_popselectgrid'),
                width: "150px",
                editorSet: {
                selectkey: 'gbids',
                multiSelect: true,
                beforefunc:"page.head_beforefunc",
                itemchangedfunc:"page.head_itemchangedfunc_gbid",
                },
			},{
				field : "gbbarcode",
				name : "gbbarcode",
				header : "商品条码",
				headerAlign : "center",
				allowSort : true,
				readOnly : true,
				visible : false,
				width : "160",
			},{
				field : "gbcname",
				name : "gbcname",
				header : "商品名称",
				headerAlign : "center",
				allowSort : true,
				readOnly : true,
				width : "160",
			},{
				field : "catcode",
				name : "catcode",
				header : "商品类别",
				headerAlign : "center",
				displayField : "mid_name",
				allowSort : true,
				readOnly : true,
				width : "160",
			},{
				field : "mid_name",
				name : "mid_name",
				header : "商品类别名称",
				headerAlign : "center",
				allowSort : true,
				readOnly : true,
				visible : false,
				width : "160",
			},{
				field : "ppcode",
				name : "ppcode",
				header : "品牌",
				headerAlign : "center",
				displayField : "ppcode_name",
				allowSort : true,
				readOnly : true,
				width : "160",
			},{
				field : "ppcode_name",
				name : "ppcode_name",
				header : "品牌名称",
				headerAlign : "center",
				allowSort : true,
				readOnly : true,
				visible : false,
				width : "160",
			},{
				field : "sbid",
				name : "sbid",
				header : "商户名称",
				headerAlign : "center",
				editor : OcmControl.newControl('fut_popselectgrid'),
				displayField : "sbid_name",
				cdEdtCfg : {
					compnentType : 'fut_popselect',
					selectkey : "sbid"
				},
				allowSort : true,
				readOnly : true,
				width : "160",
			},{
				field : "sbid_name",
				name : "sbid_name",
				header : "商户名称",
				headerAlign : "center",
				allowSort : true,
				readOnly : true,
				visible : false,
				width : "160",
			},{
				field : "sspid",
				name : "sspid_det",
				header : "源商铺/柜组",
				headerAlign : "center",
				required: false,
				editor: OcmControl.newControl('fut_popselectgrid'),
				displayField : "sspid_name",
				editorSet: {
	                selectkey: 'spid',
	                multiSelect: true,
	                beforefunc:"page.head_beforefunc",
	                itemchangedfunc:"page.head_itemchangedfunc_sspid_det",
	                },
				allowSort : true,
				visible : false,
				width : "160",
			},{
				field : "sspid_name",
				name : "sspid_name",
				header : "源商铺名称",
				headerAlign : "center",
				allowSort : true,
				readOnly : true,
				visible : false,
				width : "160",
			},{
				field : "spid",
				name : "spid_det",
				header : "目标源商铺/柜组",
				headerAlign : "center",
				required: true,
				editor: OcmControl.newControl('fut_popselectgrid'),
				displayField : "spid_name",
				editorSet: {
	                selectkey: 'spid',
	                multiSelect: true,
	                beforefunc:"page.head_beforefunc",
	                itemchangedfunc:"page.head_itemchangedfunc_spid_det",
	                },
				allowSort : true,
				width : "160",
			},{
				field : "spid_name",
				name : "spid_name",
				header : "商铺名称",
				headerAlign : "center",
				allowSort : true,
				readOnly : true,
				visible : false,
				width : "160",
			},{
				field : "gmphsjj",
				name : "gmphsjj",
				header : "进价",
				headerAlign : "center",
				required: true,
				readOnly : true,
				width : 120,
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet : {
					format : "c2",
				},
				numberFormat : "c2",
				defaultValue : "0.00",
				align : "right",
			},{
				field : "gbmanamode",
				headerAlign : "center",
				header : "管理方式",
				allowSort : true,
				readOnly : true,
				visible : false,
				width : "160",
			},{
				field : "priceaccuracy",
				headerAlign : "center",
				header : "售价精度",
				allowSort : true,
				readOnly : true,
				visible : false,
				width : "160",
			},{
				field : "gmpsj",
				name : "gmpsj",
				header : "售价",
				headerAlign : "center",
				required: true,
				width : 120,
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet : {
					format : "c2",
				},
				numberFormat : "c2",
				defaultValue : "0.00",
				align : "right",
			},{
				field : "gmpkl",
				name : "gmpkl",
				header : "扣率",
				headerAlign : "center",
				required: true,
				editor : OcmControl.newControl('TextBox'),
				width : "120",
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{format: "p2",},
				numberFormat:"p2",
				defaultValue : "0",
				align : "right",
			
			},{
				field : "gmpke",
				name : "gmpke",
				header : "扣额",
				headerAlign : "center",
				required: true,
				readOnly : true,
				editor : OcmControl.newControl('TextBox'),
				width : "120",
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{format: "c2",},
				numberFormat:"c2",
				defaultValue : "0",
				align : "right",
			},{
				field : "gmpjxtax",
				name : "gmpjxtax",
				headerAlign : "center",
				header : "进项税率",
				type : "comboboxcolumn",
			  	textField : "name",
			  	valueField : "code",
			  	editor : OcmControl.newControl('ComboBox'),
			  	renderer: "OcmControl.dictRendererWithCode",
			  	align : "center",
			  	dictkey : 'XXTAXRATE',
			  	required : true,
			  	vtype : "required:true",
				width : 120,
			},{
				field : "gmpxstax",
				name : "gmpxstax",
				headerAlign : "center",
				header : "销售税率",
				type : "comboboxcolumn",
			  	textField : "name",
			  	valueField : "code",
			  	editor : OcmControl.newControl('ComboBox'),
			  	renderer: "OcmControl.dictRendererWithCode",
			  	align : "center",
			  	dictkey : 'XXTAXRATE',
			  	required : true,
			  	vtype : "required:true",
				width : 120,
			},{
				field : "gmpxftax",
				name : "gmpxftax",
				headerAlign : "center",
				header : "消费税率",
				type : "comboboxcolumn",
			  	textField : "name",
			  	valueField : "code",
			  	editor : OcmControl.newControl('ComboBox'),
			  	renderer: "OcmControl.dictRendererWithCode",
			  	align : "center",
			  	dictkey : 'XFTAXRATE',
			  	required : true,
			  	vtype : "required:true",
				width : 120,
			} ]
		}
	};


	// 查询 自定义名称
	bill.gbcopyheadquerylist = {
		"title" : '单据列表',
		"name" : 'gbcopyheadquerylist',
		"type" : "gridbox",
		"resources" : OmdUrl.mall,
		"method" : "mss.commodity.gbcopyhead.search",
		"response" : "gbcopyhead",
		"canquery" : true,
		/* "manualLoad" : true, */
		"bindform" : "layouttabs", // 绑定切换的TabsBox.name
		"bindSearchParam" : [ "ph_key" ], // 明细页面查询条件字段
		"searchParam" : {
			"billtype" : billtype,
			"order_field" : "billno",
			"order_direction" : "desc"
		},
		"properties" : {
			"id" : utils.createid('gbcopyheadquerylist'),
			"columns" : [
					{
						type : "indexcolumn",
						header : "行号",
						headerAlign : "center",
					}, {
						field : "billno",
						header : "单据编号",
						allowSort : true,
						headerAlign : "center",
						width : 140,
						enabledSearch : true,
						visible : true
					}, {
						field : "billstatus",
						header : "单据状态",
						allowSort : true,
						headerAlign : "center",
						renderer : "OcmControl.dictRendererWithCode",
						dictkey : 'BILLFLAG',
						width : 120,
						enabledSearch : true,
						visible : true
					}, {
						field : "smuid",
						type : "TextBox",
						headerAlign : "center",
						header : "源门店",
						editor : OcmControl.newControl('fut_popselectgrid'),
						displayField : "smuid_name",
						cdEdtCfg : {
							compnentType : 'fut_popselect',
							selectkey : "muid"
						},
						visible : true,
						enabledSearch : true,
						width : 200,
					},{
						field : "muid",
						type : "TextBox",
						headerAlign : "center",
						header : "目标门店",
						editor : OcmControl.newControl('fut_popselectgrid'),
						displayField : "muid_name",
						cdEdtCfg : {
							compnentType : 'fut_popselect',
							selectkey : "muid"
						},
						visible : true,
						enabledSearch : true,
						width : 200,
					},{
						field : "sspid",
						type : "TextBox",
						headerAlign : "center",
						header : "源商铺",
						editor : OcmControl.newControl('fut_popselectgrid'),
						displayField : "sspid_name",
						cdEdtCfg : {
							compnentType : 'fut_popselect',
							selectkey : "spid"
						},
						visible : true,
						enabledSearch : true,
						width : 200,
					},{
						field : "spid",
						type : "TextBox",
						headerAlign : "center",
						header : "目标商铺",
						editor : OcmControl.newControl('fut_popselectgrid'),
						displayField : "spid_name",
						cdEdtCfg : {
							compnentType : 'fut_popselect',
							selectkey : "spid"
						},
						visible : true,
						enabledSearch : true,
						width : 200,
					},{
						field : "deploytype",
						header : "配置模式",
						width : 150,
						allowSort : true,
						headerAlign : "center",
						renderer : "OcmControl.dictRendererWithCode",
						dictkey : 'DEPLOYTYPE',
					},{
						field : "inputer",
						header : "录入人",
						width : 160,
						allowSort : true,
						headerAlign : "center",	
						editor:OcmControl.newControl('fut_popselectgrid'),
						displayField : "inputer_name",
						cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
						visible : true,
						enabledSearch : true,
					},{
						field : "inputer_name",
						header : "录入人",
						width : 160,
						allowSort : true,
						headerAlign : "center",	
						visible : false,
						enabledSearch : false,
					}, {
						field : "inputdate",
						type : "date",
						dataType : "date",
						format : "yyyy-MM-dd",
						header : "录入日期",
						width : 160,
						allowSort : true,
						headerAlign : "center",
						align : "center",
						visible : true,
						enabledSearch : true,
					}, {
						field : "auditor",
						header : "审核人",
						width : 160,
						allowSort : true,
						headerAlign : "center",
						editor:OcmControl.newControl('fut_popselectgrid'),
						displayField : "auditor_name",
						cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
						visible : true,
						enabledSearch : true,
					}, {
						field : "auditor_name",
						header : "审核人",
						width : 160,
						allowSort : true,
						headerAlign : "center",
						visible : false,
						enabledSearch : false,
					}, {
						field : "auditdate",
						type : "date",
						format : "yyyy-MM-dd",
						header : "审核日期",
						width : 160,
						dataType : "date",
						allowSort : true,
						headerAlign : "center",
						align : "center",
						visible : true,
						enabledSearch : true,
					} ]
		}
	};

	var btn = Future.default.btn;
	// 按钮配置 - 固定名称
	// 按钮配置 - 固定名称
	bill.toolbarconfig = {
		id: utils.createid('systoolbar'),
		items: [btn.addData,btn.editData, btn.saveData, btn.delData,btn.separator,btn.auditData,btn.searchData]
	}


	// 单据配置
	bill.billconfig = {
		billhead : bill.gbcopyhead, // 单据主表
		billdetail : [bill.gbcopydet], // 单据明细表
		billquerylist : bill.gbcopyheadquerylist,// 查询列表
		dettabpages : [bill.gbcopydet],// 要放入明细TAB列表的组件
		defaultmoduleid : app.modulecode,// 默认单据类型
	}

	// 创建标准单据模板
	utils.create_standardbill_config(bill);

})();
