/**
 * 页面定义
 */
(function () {
	// 要引用的包
	var utils = Future.ns('Future.utils');
	var validate = Future.ns('Future.validate');
	var col = Future.ns('default.col');
	// 活动命名空间
	var ns = Future.ns('gbstatus.view');

	var moduleid = app.modulecode;
	var billtype = getBilltype(moduleid);
	utils.billtype=billtype;

	// 定义一个对象用来配置界面
	var bill = {};
	// 把定义对象放到命名空间下
	ns.bill = bill;

	// 查询列表
	bill.gbstatuslist = {
		"type": "gridbox",
		"resources": OmdUrl.mss,
		"method": "mss.commodity.gbstatushead.search",
		"response": "gbstatushead",
		"bindform": "layouttabs",
		"bindSearchParam": ["ph_key"], // 明细页面查询条件字段
		"searchParam": {
			"order_field": "inputdate",
			"order_direction": "desc",
		},
		"properties": {
			"id": utils.createid('batchgoodslist'),
			"columns": [{
				type: "indexcolumn",
				headerAlign: "center",
				header: "行号",
				width: 60,
			}, {
				field: "billno",
				type: "TextBox",
				headerAlign: "center",
				header: "单据编号",
				width: 150,
			}, {
				field: "billstatus",
				type: "TextBox",
				headerAlign: "center",
				header: "单据状态",
				renderer: "OcmControl.dictRendererWithCode",
				dictkey: 'BILLSTATUS',
			}, {
				field: "muid",
				type: "TextBox",
				headerAlign: "center",
				header: "门店",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "muid_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"muid"},
				visible:false,
				enabledSearch : true,
			}, {
				field: "muid_name",
				type: "TextBox",
				headerAlign: "center",
				header: "门店",
				enabledSearch : false,
				width: 200,
			}, {
				field: "sbid",
				type: "TextBox",
				headerAlign: "center",
				header: "商户/供应商",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "sbid_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"sbid"},
				visible:false,
				enabledSearch : true,
			}, {
				field: "sbid_name",
				type: "TextBox",
				headerAlign: "center",
				header: "商户/供应商",
				enabledSearch : false,
				width: 150,
			}, {
				field: "spid",
				type: "TextBox",
				headerAlign: "center",
				header: "商铺/柜组 ",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "spid_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"spid"},
				visible:false,
				enabledSearch : true,
			}, {
				field: "spid_name",
				type: "TextBox",
				headerAlign: "center",
				header: "商铺/柜组 ",
				enabledSearch : false,
				width: 150,
			}, {
				field : "gbbstatus",
				headerAlign : "center",
				header : "新经营状态",
				type : "comboboxcolumn",
				editor : OcmControl.newControl('ComboBox'),
				renderer : "OcmControl.dictRendererWithCode",
				dictkey : 'GMFSTATUS',
				allowSort : true,
				width : 80,
			}, {
				field : "gbstartdate",
				header : "生效日期",
				type: "DatePicker",
				headerAlign: "center",
				dataType: "date",
				dateFormat: "yyyy-MM-dd",
				width: 150,
			}, {
				field: "catcode",
				type: "TextBox",
				headerAlign: "center",
				header: "商品分类",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "catcode_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"treeGbcatcode"},
				width: 150,
			}, {
				field : "inputer",
				header : "录入人",
				width : 100,
				allowSort : true,
				headerAlign : "center",	
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "inputer_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
				visible:false,
				enabledSearch : true,
			},{
				field : "inputer_name",
				header : "录入人",
				width : 200,
				allowSort : true,
				headerAlign : "center",	
				enabledSearch : false,
			}, {
				field : "inputdate",
				type : "date",
				dataType : "date",
				format : "yyyy-MM-dd",
				header : "录入日期",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "auditor",
				header : "审核人",
				width : 100,
				allowSort : true,
				headerAlign : "center",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "auditor_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
				visible:false,
				enabledSearch : true,
			}, {
				field : "auditor_name",
				header : "审核人",
				width : 200,
				allowSort : true,
				headerAlign : "center",
				enabledSearch : false,
			}, {
				field : "auditdate",
				type : "date",
				format : "yyyy-MM-dd",
				header : "审核日期",
				width : 150,
				dataType : "date",
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "canceler",
				header : "取消人",
				width : 100,
				allowSort : true,
				headerAlign : "center",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "canceler_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
				visible:false,
				enabledSearch : true,
			}, {
				field : "canceler_name",
				header : "取消人",
				width : 200,
				allowSort : true,
				headerAlign : "center",
				enabledSearch : false,
			}, {
				field : "canceldate",
				type : "date",
				format : "yyyy-MM-dd",
				header : "取消日期",
				width : 150,
				dataType : "date",
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}]
		}
	};
	
	// 单据主表
	bill.gbstatushead = {
		"type": "formgrid",
		"initHeight" : 0.35,
		"resources": OmdUrl.mss,
		"name": 'gbstatushead',
		"method": "mss.commodity.gbstatushead.get",
		"response": "gbstatushead",
		"properties": {
			"id": utils.createid('gbstatushead')
		},
		items: [{
				"label": "ph_key：",
				"name": "ph_key",
				"type": "TextBox",
				"visible": false,
			}, {
				"label": "单据编号：",
				"name": "billno",
				"type": "TextBox",
				"readOnly": true,
				"visible": true,
			}, {
				"label": "模块编号：",
				"name": "billmoduleid",
				"type": "TextBox",
				"defaultValue": app.modulecode,
				"visible": false
			}, {
				"label": "单据类型：",
				"name": "billtype",
				"type": "TextBox",
				"defaultValue": getBilltype(app.modulecode),
				"visible": false
			}, {
				"label": "单据状态：",
				"name": "billstatus",
				"type": "ComboBox",
				dictkey: 'BILLSTATUS',
				"readOnly": true,
				"defaultValue": "N",
			}, {
				"label": "商户/供应商 ：",
				"name": "sbid",
				"type": "fut_popselect",
				"required":"true",
				selectkey: "sbid",
				textName: "sbid_name",
				allowInput: true,
				beforefunc : "page.head_beforefunc",
			}, {
				"label" : "新经营状态：",
				"name" : "gbbstatus",
				"type" : "ComboBox",
				dictkey : 'HEADGMFSTATUS',
				"required":"true",
				"onvaluechanged":"page.head_beforefunc"
			},{
				"label": "生效日期：",
				"name": "gbstartdate",
				"type": "DatePicker",
				"format" : "yyyy-MM-dd",
				"required" : "true",
				"enabled" : true,
				"value" : mini.formatDate(new Date(), "yyyy-MM-dd"),
				"defaultValue" : mini.formatDate(new Date(), "yyyy-MM-dd"),
			}, {
				"label": "门店：",
				"name": "muid",
				"type": "fut_popselect",
				selectkey: "muid",
				textName: "muid_name",
				allowInput: true,
				beforefunc : "page.head_beforefunc",
				itemchangedfunc:"page.head_itemchangedfunc",
			}, {
				"label": "商铺/柜组：",
				"name": "spid",
				"type": "fut_popselect",
				selectkey: "spid",
				textName: "spid_name",
				beforefunc : "page.head_beforefunc",
				allowInput: true,
			}, {
				"label" : "商品分类：",
				"name" : "catcode",
				type : "fut_popselect",
				selectkey : "treeGbcatcode",
				textName : "catcode_name",
				beforefunc : "page.head_beforefunc",
				itemchangedfunc : "page.head_itemchangedfunc",
				"allowInput" : true,
				"style": "display:block;float:none",
			},{
				"label": "录入人：",
				"type": "TextBox",
				"name": "inputer_name",
				"readOnly": "true",
			}, {
				"label": "审核人：",
				"type": "TextBox",
				"name": "auditor_name",
				"readOnly": "true",
			}, {
				"label": "取消人：",
				"type": "TextBox",
				"name": "canceler_name",
				"readOnly": "true",
			}, {
				"label": "录入日期：",
				"type": "DatePicker",
				"name": "inputdate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
			}, {
				"label": "审核日期：",
				"type": "DatePicker",
				"name": "auditdate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
			}, {
				"label": "取消日期：",
				"type": "DatePicker",
				"name": "canceldate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
			}, {
				"label": "录入人编码",
				"type": "TextBox",
				"name": "inputer",
				"visible": false,
			}, {
				"label": "最后修改日期：",
				"type": "DatePicker",
				"name": "lastmoddate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"visible": false,
			}
		]
	}
	// 单据明细
	bill.gbstatusdet= {
			title: '单据明细',
			"type": "gridbox",
			name: 'gbstatusdet',
			"properties": {
				"id": utils.createid('gbstatusdet'),
				"multiSelect": "true",
				"allowCellEdit": "true",
				"allowCellSelect": "true",
				"editNextOnEnterKey": "true",
				"editNextRowCell": "true",
				"allowSortColumn": "false",
				"allowCellValid": true,
				"sortMode": "client",
				//"showPager": true,
				"oncellbeginedit": "OcmControl.checkboxEditor",
				"columns": [{
					type: "checkcolumn",
					headerAlign: "center",
					readOnly: true,
				}, {
					type: "indexcolumn",
					header: "行号",
					headerAlign: "center",
					readOnly: true,
					width: 60,
				},{
					field: "gbid",
					name: "gbid",
					header: "商品编码",
					headerAlign: "center",
					required: true,
					editor: OcmControl.newControl('fut_popselectgrid'),
	                width: 150,
	                displayField : "gbid",
	                editorSet: {
			                selectkey: 'selfsupgoodsgbbstatus',
			                multiSelect: true,
			                beforefunc:"page.det_beforefunc_gbid",
			                itemchangedfunc:"page.det_itemchangedfunc_gbid"}
				}, {
					field: "gbname",
					header: "商品名称",
					headerAlign: "center",
					width: 100,
					readOnly:true,
				}, {
					field: "catcode",
					header: "商品分类",
					headerAlign: "center",
					width: 100,
					readOnly:true,
					visible :false
				}, {
					field: "catcode_name",
					header: "商品分类",
					headerAlign: "center",
					width: 100,
					readOnly:true,
				},{
					field: "oldgbbstatus",
					header: "原经营状态",
					type : "comboboxcolumn",
					editor : OcmControl.newControl('ComboBox'),
					renderer : "OcmControl.dictRendererWithCode",
					dictkey : 'GMFSTATUS',
					readOnly: true,
				}, {
					field: "gbbarcode",
					header: "商品条码",
					headerAlign: "center",
					width: 100,
					readOnly:true,
				}, {
					field: "muid",
					name: "muid",
					type: "TextBox",
					headerAlign: "center",
					header: "门店",
					editor:OcmControl.newControl('fut_popselectgrid'),
					displayField : "muid_name",
					editorSet: {selectkey: 'muid',multiSelect: false},
					visible: false,
					width : 150,
				}, {
					field: "sbid",
					name: "sbid",
					type: "TextBox",
					headerAlign: "center",
					header: "商户/供应商",
					editor:OcmControl.newControl('fut_popselectgrid'),
					displayField : "sbid_name",
					editorSet: {selectkey: 'sbid',multiSelect: false},
					readOnly: true,
					width : 220,
				}, {
					field: "spid",
					name: "spid",
					type: "TextBox",
					headerAlign: "center",
					header: "商铺/柜组",
					editor:OcmControl.newControl('fut_popselectgrid'),
					displayField : "spid_name",
					editorSet: { selectkey: 'spid', multiSelect: false },
					readOnly: true,
					width : 160,
				}, {
					field : "isupdate",
					headerAlign : "center",
					header : "执行结果",
					type : "comboboxcolumn",
					editor : OcmControl.newControl('ComboBox'),
					renderer : "OcmControl.dictRendererWithCode",
					dictkey : 'ISUPDATE',
					readOnly: true,
					width : 100,
				}, {
					field : "memo",
					header : "备注/原因",
					width : 250,
					readOnly: true,
					headerAlign : "center",

				}  ]
			},
		};

	var btn = Future.default.btn;
	// 按钮配置 - 固定名称
	bill.toolbarconfig = {
		id: utils.createid('systoolbar'),
		items: [btn.addData, btn.delData, btn.editData, btn.saveData,
		        btn.separator,btn.auditData,$.extend({},btn.cancelData,{billstatus:'Y'}), btn.searchData
		  ]
	}
	// 单据配置
	bill.billconfig = {
		billhead: bill.gbstatushead, // 单据主表
		billdetail: [bill.gbstatusdet], // 单据明细表
		billquerylist: bill.gbstatuslist, // 查询列表
		dettabpages: [bill.gbstatusdet], // 要放入明细TAB列表的组件
		defaultmoduleid: app.modulecode, // 默认单据类型
	}

	// 创建标准单据模板
	utils.create_standardbill_config(bill);

})()
