/**
 * 返租合同 --- 界面定义
 */
(function() {
	// 要引用的包
	var utils = Future.ns('Future.utils');

	// 商铺修改命名空间
	var ns = Future.ns('goodschangedetail.view');

	// 定义一个对象用来配置界面
	var bill = {};

	var moduleid = app.modulecode;
	var billtype = getBilltype(moduleid);
	
	var ISUPDATE = [{code:'Y',name:'是'} , {code:'N',name:'否'}];
    
	utils.billtype=billtype;

//	if (moduleid == billmoduleid.kl) {
//		$("title").html("商品扣率变更单");
//	} else if (moduleid == billmoduleid.sj) {
//		$("title").html("售价扣率调整单");
//	}
	$("title").html("售价扣率调整单");
	utils.billmoduleid = moduleid;
	
	var tztype = [{code: '1',name: '调售价',ddvalue: '[1]调售价'},{code: '2',name: '调扣率',ddvalue: '[2]调扣率'},{code: '3',name: '同时调',ddvalue: '[3]同时调'}];
	var zygbjjfs = [{code: '1',name: '顺加',ddvalue: '[1]顺加'},{code: '4',name: '倒扣比率',ddvalue: '[4]倒扣比率'}];
	// 把定义对象放到命名空间下
	ns.bill = bill;
	// 表头 自定义名称
	bill.gbupdatehead = {
		"title" : '单据详情',
		"name" : 'gbupdatehead',
		"type" : "formgrid",
		"resources" : OmdUrl.mall,
		"method" : "mss.commodity.goodschange.get",
		"response" : "gbupdatehead",
		"properties" : {
			"id" : utils.createid('gbupdatehead'),
		},
		items : [
				{
					"id" : "gb_bill",
					"label" : "单据信息",
					"type" : "fieldset",
					"visible" : true,
					"items" : [ {
								"label" : "ph_key：",
								"type" : "TextBox",
								"name" : "ph_key",
								"readOnly" : "true",
								"visible" : false,
							}, {
								"label" : "单据编号：",
								"name" : "billno",
								"type" : "TextBox",
								"required" : "true",
								"readOnly" : true,
								"visible" : true,
							}, {
								"label": "模块编号：",
								"name": "billmoduleid",
								"type": "TextBox",
								"defaultValue": moduleid,
								"visible": false
							}, {
								"label": "单据类型：",
								"name": "billtype",
								"type": "TextBox",
								"defaultValue": billtype,
								"visible": false
							}, {
								"label" : "单据状态：",
								"name" : "billstatus",
								"type" : "ComboBox",
								dictkey : 'BILLSTATUS',
								"defaultValue" : "N",
								"readOnly" : true,
								"visible" : true,
							}, {
								"label" : "手工编号：",
								"name" : "billsgno",
								"type" : "TextBox",
								"readOnly" : false,
							}, {
								"label" : "录入人：",
								"name" : "inputer_name",
								"type" : "TextBox",
								"readOnly" : true,
								"defaultValue" : app.username,
								"visible" : true,
							}, {
								"label" : "审核人：",
								"name" : "auditor_name",
								"type" : "TextBox",
								"readOnly" : true,
								"visible" : true,
								"style" : "display:block;float:none"
							}, {
								"label" : "录入日期：",
								"name" : "inputdate",
								"type" : "DatePicker",
								"readOnly" : true,
								"format" : "yyyy-MM-dd HH:mm:ss",
								"defaultValue" : new Date(),
								"visible" : true,
							}, {
								"label" : "审核日期：",
								"name" : "auditdate",
								"type" : "DatePicker",
								"readOnly" : true,
								"format" : "yyyy-MM-dd HH:mm:ss",
								"visible" : true,
							} ]
				},
				{
					"id" : "gbupdatehead",
					"label" : "商品信息",
					"type" : "fieldset",
					"items" : [ {
								"label" : "门店：",
								"name" : "muid",
								type : "fut_popselect",
								selectkey : "muid",
								textName : "muid_name",
								"required" : "true",
								beforefunc : "page.head_beforefunc",
								itemchangedfunc : "page.head_itemchangedfunc",
								//"allowInput" : true,
								"readOnly" : false,
							},{
								"label" : "门店名称：",
								"name" : "muid_name",
								"type" : "TextBox",
								"required" : "true",
								"defaultValue" : "",
								visible : false,
							}, {
								"label" : "调整类型：",
								"name" : "tztype",
								"type" : "ComboBox",
								"required" : "true",
								dictkey : 'TZTYPE',
								"defaultValue" : "",
								data:tztype,
								"onvaluechanged":"page.head_valuechanged",
								"showNullItem":false
							},{
								"label": "生效日期：",
								"name": "gbstartdate",
								"type": "DatePicker",
								"format" : "yyyy-MM-dd",
								"required" : "true",
								"enabled" : true,
								"value" : mini.formatDate(new Date(), "yyyy-MM-dd"),
								"defaultValue" : mini.formatDate(new Date(), "yyyy-MM-dd"),
							}, {
								"label" : billtype == "159" ? "供应商：":(billtype == "103" ?"供应商：":"商户："),
								"name" : "sbid",
								type : "fut_popselect",
								selectkey : "sbid",
								textName : "sbid_name",
								//"required" : "true",
								beforefunc : "page.head_beforefunc",
								itemchangedfunc : "page.head_itemchangedfunc",
								"allowInput" : true,
								"readOnly" : false,
							}, {
								"label" : "商户名称：",
								"name" : "sbid_name",
								"type" : "TextBox",
								//"required" : "true",
								"defaultValue" : "",
								visible : false,
							} , {
								"label" : "新扣率：",
								"name" : "gmpkl",
								"type" : "NumButtonEdit",
								"defaultValue" : "0",
								"format":"p2",
								allowSort : true,
								"onvaluechanged" : "page.head_valuechanged",
								"visible" : true,
							}, {
								"label" : "新售价：",
								"name" : "gmpsj",
								"type" : "NumButtonEdit",
								"defaultValue" : "0",
								"format":"c2",
								allowSort : true,
								"onvaluechanged" : "page.head_valuechanged",
								"visible" : true,
							},{
								"text" : "是否调整库存",
								"name" : "istzkc",
								"type" : "CheckBox",
								"trueValue" : "Y",
								"falseValue" : "N",
								"defaultValue" : "Y",
								//"visible" : true,
								"visible": billtype =="159"?true:false,
							},{
								"label" : "库存调整单：",
								"name" : "kcbillno",
								"type" : "TextBox",
								//"visible" : true,
								"readOnly" : true,
								"visible": billtype =="159"?true:false,
							}]
				}

		]
	};

	// 明细 自定义名称
	
	bill.gbupdatedet = {
		"title" : '商品信息',// tab页面标题
		"name" : 'gbupdatedet',// 名称 数据绑定根据此数据来匹配
		"type" : "gridbox",
		"properties" : {
			"id" : utils.createid('gbupdatedet'),
//			"multiSelect" : "true",
//			"allowCellEdit" : "true",
//			"allowCellSelect" : "true",
//			"editNextOnEnterKey" : "true",
//			"editNextRowCell" : "true",
//			"allowSortColumn" : "false",
//			"allowCellValid" : true,
//			"showPager" : false,
//			"oncellbeginedit" : "OcmControl.checkboxEditor",
			
			"multiSelect": "true",
			"allowCellEdit": "true",
			"allowCellSelect": "true",
			"editNextOnEnterKey": "true",
			"editNextRowCell": "true",
			"allowSortColumn": "false",
			"allowCellValid": true,
			"sortMode": "client",
			//"showPager": true,
			"oncellbeginedit": "OcmControl.checkboxEditor",
			"columns" : [ {
				type : "checkcolumn",
				headerAlign : "center",
				readOnly : true,
				width : 30,
			},
			{
				type : "indexcolumn",
				header : "行号",
				headerAlign : "center",
				readOnly : true,
			}, 
			 {
				headerAlign : "center",
				header : "行号",
				displayField:"drowno",
				readOnly : true,
				width:50,
				align: "center",
				visible : false
			}, 
//			{
//				field : "nrowid",
//				header : "行主键",
//				width : 80,
//				allowSort : true,
//				headerAlign : "center",
//				visible : false
//			},
			{
				field: "gbid",
				name: "gbid",
				header: "商品编码",
				headerAlign: "center",
				allowSort: true,
				required: (billtype == "159" || billtype == "175")? false:true,
				readOnly: (billtype == "159" || billtype == "175") ? true:false,
				editor: OcmControl.newControl('fut_popselectgrid'),
                width: 100,
                editorSet: {
                selectkey: billtype == "159" ? "kcgbids":"gbids",
                multiSelect: true,
                beforefunc:"page.det_beforefunc",
                itemchangedfunc:"page.det_itemchangedfunc",
                },
			}, {
				field : "gbbarcode",
				name: "gbbarcode",
				header : "商品条码",
				width : 120,
				allowSort: true,
				required: (billtype == "159" || billtype == "175") ? true:false,
				readOnly: billtype == "175" ? true:false,
				editor: OcmControl.newControl('fut_popselectgrid'),
				editorSet: {
					    selectkey: 'selfgbbarcode',
					    multiSelect: true,
					    beforefunc:"page.det_beforefunc",
					    itemchangedfunc:"page.det_itemchangedfunc",
				    },
				headerAlign : "center",
			}, {
				field : "gbcname",
				name: "gbcname",
				header : "商品名称",
				width : 180,
				allowSort: true,
				required: true,
				readOnly : true,
				headerAlign : "center",
			}, {
				field : "muid",
				name: "muid",
				header : "门店ID",
				width : 200,
				allowSort: true,
				// required: true,
				readOnly : true,
				headerAlign : "center",
				visible : false,
			},{
				field: "sbid",
				name: "sbid",
				header: billtype == "159" ? "供应商": (billtype == "103" ? "供应商":"商户"),
				headerAlign: "center",
				allowSort: true,
				required: true,
				readOnly : true,
				editor: OcmControl.newControl('fut_popselectgrid'),
                width: 260,
                visible: billtype =="159"?false:true,
                displayField: "sbid_name",
                editorSet: {
                selectkey:  billtype == "159" ? 'selfsbid':'sbid',
                multiSelect: true,
                beforefunc:"page.det_beforefunc",
                itemchangedfunc:"page.det_itemchangedfunc",
                
                },
			},{
				field: "spid",
				name: "spid",
				header: billtype == "159" ? "柜组": (billtype == "103" ? "柜组": "商铺"),
				headerAlign: "center",
				allowSort: true,
				required: true,
				readOnly :true,
				editor: OcmControl.newControl('fut_popselectgrid'),
                width: 160,
                displayField: "spid_name",
                editorSet: {
                selectkey: billtype == "159" ? "selfallspid":"spid",
                		textName : "spid_name",
                multiSelect: true,
                defaultValue : billtype == "159" ? "0":"",
                beforefunc:"page.det_beforefunc_mfid",
                itemchangedfunc:"page.det_itemchanged_mfid",
                },
			},{
				field: "catcode",
				name: "catcode",
				header: "商品类别",
				headerAlign: "center",
				allowSort: true,
				required: true,
				readOnly : true,
				editor: OcmControl.newControl('fut_popselectgrid'),
                width: 160,
                displayField: "mid_name",
                editorSet: {
                selectkey: 'treeGbcatcode',
                multiSelect: true,
                beforefunc:"page.det_beforefunc",
                itemchangedfunc:"page.det_itemchangedfunc",
                },
			},{
				field: "ppcode",
				name: "ppcode",
				header: "品牌",
				headerAlign: "center",
				allowSort: true,
				required: true,
				readOnly : true,
				editor: OcmControl.newControl('fut_popselectgrid'),
                width: 160,
                displayField: "ppcode_name",
                editorSet: {
                selectkey: 'ppcode',
                multiSelect: true,
                beforefunc:"page.det_beforefunc",
                itemchangedfunc:"page.det_itemchangedfunc",
                },
			},{
				field: "gbmanamode",
				name: "gbmanamode",
				header: "管理方式",
				headerAlign: "center",
				allowSort: true,
				required: true,
				readOnly : true,
                width: 160,
                renderer: "OcmControl.dictRendererWithCode",
            	type : "comboboxcolumn",
            	editor : OcmControl.newControl('ComboBox'),
            	dictkey : 'CMPMMID',
            },{
                field : "gbjjfs",
				headerAlign : "center",
				header : "计价方式",
				type : "comboboxcolumn",
				editor : OcmControl.newControl('ComboBox'),
				renderer : "OcmControl.dictRendererWithCode",
				data : zygbjjfs,
				readOnly: true,
				visible: billtype =="159"?true:false,
				width : 100,
            },{
				field : "gmphsjj",
				name : "gmphsjj",
				headerAlign : "center",
				header : "进价",
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet : {
					format : "c2",
				},
				numberFormat : "c2",
				defaultValue : "0",
				align : "right",
				vtype : "required:true",
				readOnly : true,
				required : true,
				visible: billtype =="159"?true:false,
				width : 80,
			}, {
				field : "oldgmpsj",
				name : "oldgmpsj",
				headerAlign : "center",
				header : "原售价",
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet : {
					format : "c2",
				},
				numberFormat : "c2",
				defaultValue : "0",
				align : "right",
				required : true,
				readOnly : true,
				required : true,
				visible: true,
				width : 80,
			}, {
				field : "gmpsj",
				name : "gmpsj",
				headerAlign : "center",
				header : "新售价",
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet : {
					format : "c2",
				},
				numberFormat : "c2",
				defaultValue : "0",
				align : "right",
				required : true,
				visible: true,
				width : 80,
			}, {
				field : "oldgmpkl",
				name : "oldgmpkl",
				headerAlign : "center",
				header : "原扣率",
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet : {
					format : "p2",
				},
				numberFormat : "p2",
				defaultValue : "0",
				align : "right",
				readOnly : true,
				vtype : "required:true",
				required: true,
				visible: true,
				width : 80,
			}, {
				field : "gmpkl",
				name : "gmpkl",
				headerAlign : "center",
				header :'新扣率',
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet : {
					format : "p2",
				},
				numberFormat : "p2",
				defaultValue : "0",
				align : "right",
				required : true,
				//vtype : "required:true",
				readOnly : false,
				width : 80,
			}, {
				field : "gmfke",
				headerAlign : "center",
				header : billtype =='175'?"新扣额": "扣额",
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet : {
					format : "n2",
				},
				numberFormat : "n2",
				defaultValue : "0",
				align : "right",
				required : true,
				readOnly : true,
				required: true,
				visible: true,
				width : 80,
			},{field : "kcsl",
				headerAlign : "center",
				header : "库存数量",
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet : {
					format : "n0",
				},
				numberFormat : "n0",
				defaultValue : "0",
				align : "right",
				readOnly : true,
				//visible: true,
				visible: billtype =="159"?true:false,
				width : 80,
				} ,{field : "jchj",
					headerAlign : "center",
					header : "进差合计",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet : {
						format : "n0",
					},
					numberFormat : "n0",
					defaultValue : "0",
					align : "right",
					readOnly : true,
				//	visible: true,
					visible: billtype =="159"?true:false,
					width : 80,
					} ]
		}
	};


	// 查询 自定义名称
	bill.gbchangequerylist = {
		"title" : '单据列表',
		"name" : 'gbchangequerylist',
		"type" : "gridbox",
		"resources" : OmdUrl.mall,
		"method" : "mss.commodity.goodschange.search",
		"response" : "gbupdatehead",
		"canquery" : true,
		/* "manualLoad" : true, */
		"bindform" : "layouttabs", // 绑定切换的TabsBox.name
		"bindSearchParam" : [ "ph_key" ], // 明细页面查询条件字段
		"searchParam" : {
			"billtype" : billtype,
			"order_field" : "billno",
			"order_direction" : "desc"
		},
		"properties" : {
			"id" : utils.createid('gbchangequerylist'),
			"columns" : [
					{
						type : "indexcolumn",
						header : "行号",
						headerAlign : "center",
					}, {
						field : "billno",
						header : "单据编号",
						allowSort : true,
						headerAlign : "center",
						width : 140,
						enabledSearch : true,
						visible : true
					}, {
						field : "billsgno",
						header : "手工编号",
						allowSort : true,
						headerAlign : "center",
						width : 140,
						enabledSearch : true,
						visible : true
					}, {
						field : "billstatus",
						header : "单据状态",
						allowSort : true,
						headerAlign : "center",
						renderer : "OcmControl.dictRendererWithCode",
						dictkey : 'BILLFLAG',
						width : 120,
						enabledSearch : true,
						visible : true
					}, {
						field : "tztype",
						header : "调整类型",
						allowSort : true,
						headerAlign : "center",
						renderer : "OcmControl.dictRendererWithCode",
						dictkey : 'TZTYPE',
						data:tztype,
						width : 120,
						enabledSearch : true,
						visible : true
					},{
						field : "muid",
						type : "TextBox",
						headerAlign : "center",
						header : "门店",
						editor : OcmControl.newControl('fut_popselectgrid'),
						displayField : "muid_name",
						cdEdtCfg : {
							compnentType : 'fut_popselect',
							selectkey : "muid"
						},
						visible : false,
						enabledSearch : true,
						width : 200,
					}, {
						field : "muid_name",
						type : "TextBox",
						headerAlign : "center",
						header : "门店",
						enabledSearch : false,
						width : 260,
					}, {
						field : "gbstartdate",
						header : "生效日期",
						type : "date",
						width : 120,
						allowSort : true,
						headerAlign : "center",
						align : "center",
						dataType : "date",
						dateFormat : "yyyy-MM-dd",
					}, {
						field : "gmpkl",
						headerAlign : "center",
						header : "扣率",
						editor : OcmControl.newControl('NumButtonEdit'),
						editorSet : {
							format : "p2",
						},
						numberFormat : "p2",
						defaultValue : "0",
						align : "right",
						width : 100,
						visible: billtype =="159"?false:true,
					}, {
						field : "gmpsj",
						headerAlign : "center",
						header : "售价",
						editor : OcmControl.newControl('NumButtonEdit'),
						editorSet : {
							format : "c2",
						},
						numberFormat : "c2",
						defaultValue : "0",
						align : "right",
						width : 100,
						visible: billtype =="159"?false:true,
					}, {
						field : "sbid",
						type : "TextBox",
						headerAlign : "center",
					    header: billtype == "159" ? "供应商":"商户",
						editor : OcmControl.newControl('fut_popselectgrid'),
						displayField : "sbid_name",
						cdEdtCfg : {
							compnentType : 'fut_popselect',
						    selectkey:  billtype == "159" ? 'selfsbid':'sbid',
						},
						visible : false,
						enabledSearch : true,
						width : 200,
					}, {
						field : "sbid_name",
						type : "TextBox",
						headerAlign : "center",
						header: billtype == "159" ? "供应商":"商户",
						enabledSearch : false,
						width : 260,
					}, {
						field : "inputer",
						header : "录入人",
						width : 160,
						allowSort : true,
						headerAlign : "center",
						editor:OcmControl.newControl('fut_popselectgrid'),
						displayField : "inputer_name",
						cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
						visible : true,
						enabledSearch : true,
					},{
						field : "inputer_name",
						header : "录入人",
						width : 160,
						allowSort : true,
						headerAlign : "center",	
						visible : false,
						enabledSearch : false,
					}, {
						field : "inputdate",
						type : "date",
						dataType : "date",
						format : "yyyy-MM-dd",
						header : "录入日期",
						width : 160,
						allowSort : true,
						headerAlign : "center",
						align : "center",
						visible : true,
						enabledSearch : true,
					}, {
						field : "auditor",
						header : "审核人",
						width : 160,
						allowSort : true,
						headerAlign : "center",
						editor:OcmControl.newControl('fut_popselectgrid'),
						displayField : "auditor_name",
						cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
						visible : true,
						enabledSearch : true,
					}, {
						field : "auditor_name",
						header : "审核人",
						width : 160,
						allowSort : true,
						headerAlign : "center",
						visible : false,
						enabledSearch : false,
					}, {
						field : "auditdate",
						type : "date",
						format : "yyyy-MM-dd",
						header : "审核日期",
						width : 160,
						dataType : "date",
						allowSort : true,
						headerAlign : "center",
						align : "center",
						visible : true,
						enabledSearch : true,
					} ]
		}
	};

	var btn = Future.default.btn;
	// 按钮配置 - 固定名称
	bill.toolbarconfig = {
		id : utils.createid('systoolbar'),
		// items : Future.pub.Basebill.default_toolsbar
		items : [ btn.addData, btn.editData, btn.delData, btn.saveData,
			btn.separator, btn.auditData, btn.cancelData,btn.separator, btn.searchData,
			btn.separator,{'text': '打印商品条码','iconCls': 'icon-print','name': 'printGoods',billstatus: 'Y,X',ibediting: 'N',tabindex: '1'},
			{'text': '打印物价标签','iconCls': 'icon-print','name': 'printPrice',billstatus: 'Y,X',ibediting: 'N',tabindex: '1'}]
	}

	// 单据配置
	bill.billconfig = {
		billhead : bill.gbupdatehead, // 单据主表
		billdetail : [bill.gbupdatedet], // 单据明细表
		billquerylist : bill.gbchangequerylist,// 查询列表
		dettabpages : [bill.gbupdatedet],// 要放入明细TAB列表的组件
		defaultmoduleid : app.modulecode,// 默认单据类型
	}

	// 创建标准单据模板
	utils.create_standardbill_config(bill);

})();
