/**
 * 返租合同 --- 界面定义
 */
(function() {
	// 要引用的包
	var utils = Future.ns('Future.utils');

	// 商铺修改命名空间
	var ns = Future.ns('goodspricechangedetail.view');

	// 定义一个对象用来配置界面
	var bill = {};

	var moduleid = app.modulecode;
	var billtype = getBilltype(moduleid);
	
	var ISUPDATE = [{code:'Y',name:'是'} , {code:'N',name:'否'}];
    
	utils.billtype=billtype;

	$("title").html("商品售价调整单");
	utils.billmoduleid = moduleid;
	var istzkc = [{code: 'Y',name: '是',ddvalue: '[Y]是'},{code: 'N',name: '否',ddvalue: '[N]否'}];
	var tztype = [{code: '1',name: '调售价',ddvalue: '[1]调售价'},{code: '2',name: '调扣率',ddvalue: '[2]调扣率'},{code: '3',name: '同时调',ddvalue: '[3]同时调'}];
	var zygbjjfs = [{code: '1',name: '顺加',ddvalue: '[1]顺加'},{code: '4',name: '倒扣比率',ddvalue: '[4]倒扣比率'}];
	// 把定义对象放到命名空间下
	ns.bill = bill;
	// 表头 自定义名称
	bill.gbupdatehead = {
		"title" : '单据详情',
		"name" : 'gbupdatehead',
		"type" : "formgrid",
		"resources" : OmdUrl.mall,
		"method" : "mss.commodity.goodschange.get",
		"response" : "gbupdatehead",
		"properties" : {
			"id" : utils.createid('gbupdatehead'),
		},
		items : [
				{
					"id" : "gb_bill",
					"label" : "单据信息",
					"type" : "fieldset",
					"visible" : true,
					"items" : [ {
								"label" : "ph_key：",
								"type" : "TextBox",
								"name" : "ph_key",
								"readOnly" : "true",
								"visible" : false,
							}, {
								"label" : "单据编号：",
								"name" : "billno",
								"type" : "TextBox",
								"required" : "true",
								"readOnly" : true,
								"visible" : true,
							}, {
								"label": "模块编号：",
								"name": "billmoduleid",
								"type": "TextBox",
								"defaultValue": moduleid,
								"visible": false
							}, {
								"label": "单据类型：",
								"name": "billtype",
								"type": "TextBox",
								"defaultValue": billtype,
								"visible": false
							}, {
								"label" : "单据状态：",
								"name" : "billstatus",
								"type" : "ComboBox",
								dictkey : 'BILLFLAG',
								"defaultValue" : "N",
								"readOnly" : true,
								"visible" : true,
							}, {
								"label" : "手工编号：",
								"name" : "billsgno",
								"type" : "TextBox",
								"readOnly" : false,
							}, {
								"label" : "录入人：",
								"name" : "inputer_name",
								"type" : "TextBox",
								"readOnly" : true,
								"defaultValue" : app.username,
								"visible" : true,
							}, {
								"label" : "审核人：",
								"name" : "auditor_name",
								"type" : "TextBox",
								"readOnly" : true,
								"visible" : true,
//								"style" : "display:block;float:none"
							}, {
								"label" : "取消人：",
								"name" : "canceler_name",
								"type" : "TextBox",
								"readOnly" : true,
								"visible" : true,
//								"style" : "display:block;float:none"
							},{
								"label" : "录入日期：",
								"name" : "inputdate",
								"type" : "DatePicker",
								"readOnly" : true,
								"format" : "yyyy-MM-dd HH:mm:ss",
								"defaultValue" : new Date(),
								"visible" : true,
							},{
								"label" : "审核日期：",
								"name" : "auditdate",
								"type" : "DatePicker",
								"readOnly" : true,
								"format" : "yyyy-MM-dd HH:mm:ss",
								"visible" : true,
							},{
								"label" : "取消日期：",
								"name" : "canceldate",
								"type" : "DatePicker",
								"readOnly" : true,
								"format" : "yyyy-MM-dd HH:mm:ss",
								"visible" : true,
							} ]
				},
				{
					"id" : "gbupdatehead",
					"label" : "商品信息",
					"type" : "fieldset",
					"items" : [ {
								"label" : "门店：",
								"name" : "muid",
								type : "fut_popselect",
								selectkey : "muid",
								textName : "muid_name",
								"required" : "true",
								beforefunc : "page.head_beforefunc",
								itemchangedfunc : "page.head_itemchangedfunc",
								//"allowInput" : true,
								"readOnly" : false,
							},{
								"label" : "门店名称：",
								"name" : "muid_name",
								"type" : "TextBox",
								"required" : "true",
								"defaultValue" : "",
								visible : false,
							}, {
								"label" : "调整类型：",
								"name" : "tztype",
								"type" : "TextBox",
								"required" : "true",
								"defaultValue" : "1",
								"Value" : "1",
								 visible : false,
							},{
								"label": "生效日期：",
								"name": "gbstartdate",
								"type": "DatePicker",
								"format" : "yyyy-MM-dd",
								"required" : "true",
								"enabled" : true,
								"value" : mini.formatDate(new Date(), "yyyy-MM-dd"),
								"defaultValue" : mini.formatDate(new Date(), "yyyy-MM-dd"),
							}, {
								"label" :  "供应商：",
								"name" : "sbid",
								type : "fut_popselect",
								selectkey : "sbid",
								textName : "sbid_name",
								//"required" : "true",
								beforefunc : "page.head_beforefunc",
								itemchangedfunc : "page.head_itemchangedfunc",
								"allowInput" : true,
								"readOnly" : false,
								visible : false,
							}, {
								"label" : "商户名称：",
								"name" : "sbid_name",
								"type" : "TextBox",
								//"required" : "true",
								"defaultValue" : "",
								visible : false,
							},{
								"label" : "新售价：",
								"name" : "gmpsj",
								"type" : "NumButtonEdit",
								"defaultValue" : "0",
								"format":"c2",
								allowSort : true,
								"onvaluechanged" : "page.head_valuechanged",
								"visible" : true,
							},{
								"label" : "是否调整库存：",
								"name" : "istzkc",
							    "type" : "ComboBox",
							    "required" : "true",
							    dictkey : 'istzkc',
								"trueValue" : "Y",
								"falseValue" : "N",
								"defaultValue" : "Y",
								data:istzkc,
								"visible": true,
							},{
								"label" : "库存调整单：",
								"name" : "kcbillno",
								"type" : "TextBox",
								//"visible" : true,
								"readOnly" : true,
								"visible": true,
							}]
				}

		]
	};

	// 明细 自定义名称
	
	bill.gbupdatedet = {
		"title" : '商品信息',// tab页面标题
		"name" : 'gbupdatedet',// 名称 数据绑定根据此数据来匹配
		"type" : "gridbox",
		"properties" : {
			"id" : utils.createid('gbupdatedet'),			
			"multiSelect": "true",
			"allowCellEdit": "true",
			"allowCellSelect": "true",
			"editNextOnEnterKey": "true",
			"editNextRowCell": "true",
			"allowSortColumn": "false",
			"allowCellValid": true,
			"sortMode": "client",
			//"showPager": true,
			"oncellbeginedit": "OcmControl.checkboxEditor",
			"columns" : [ {
				type : "checkcolumn",
				headerAlign : "center",
				readOnly : true,
				width : 30,
			},
			{
				type : "indexcolumn",
				header : "行号",
				headerAlign : "center",
				readOnly : true,
			}, 
			 {
				headerAlign : "center",
				header : "行号",
				displayField:"drowno",
				readOnly : true,
				width:50,
				align: "center",
				visible : false
			}, 
//			{
//				field : "nrowid",
//				header : "行主键",
//				width : 80,
//				allowSort : true,
//				headerAlign : "center",
//				visible : false
//			},
			{
				field: "gbid",
				name: "gbid",
				header: "商品编码",
				headerAlign: "center",
				allowSort: true,
				required: false,
				readOnly: true,
				editor: OcmControl.newControl('fut_popselectgrid'),
                width: 100,
                editorSet: {
                selectkey: "kcgbids",
                multiSelect: true,
                beforefunc:"page.det_beforefunc",
                itemchangedfunc:"page.det_itemchangedfunc",
                },
			}, {
				field : "gbbarcode",
				name: "gbbarcode",
				header : "商品条码",
				width : 120,
				allowSort: true,
				required: true,
				editor: OcmControl.newControl('fut_popselectgrid'),
				editorSet: {
					    selectkey: 'selfmfidbarcode',
					    multiSelect: true,
					    beforefunc:"page.det_beforefunc",
					    itemchangedfunc:"page.det_itemchangedfunc",
				    },
				headerAlign : "center",
			}, {
				field : "gbcname",
				name: "gbcname",
				header : "商品名称",
				width : 200,
				allowSort: true,
				required: true,
				readOnly : true,
				headerAlign : "center",
			}, {
				field : "muid",
				name: "muid",
				header : "门店ID",
				width : 200,
				allowSort: true,
				// required: true,
				readOnly : true,
				headerAlign : "center",
				visible : false,
			},{
				field: "sbid",
				name: "sbid",
				header: "供应商",
				headerAlign: "center",
				allowSort: true,
				required: true,
				readOnly : true,
				editor: OcmControl.newControl('fut_popselectgrid'),
                width: 260,
                visible: false,
                displayField: "sbid_name",
                editorSet: {
                selectkey: 'selfsbid',
                multiSelect: true,
                beforefunc:"page.det_beforefunc",
                itemchangedfunc:"page.det_itemchangedfunc",
                
                },
			},{
				field: "spid",
				name: "spid",
				header: "柜组",
				headerAlign: "center",
				allowSort: true,
				required: true,
				readOnly :true,
				editor: OcmControl.newControl('fut_popselectgrid'),
                width: 110,
                displayField: "spid_name",
                editorSet: {
                selectkey: "selfallspid",
                		textName : "spid_name",
                multiSelect: true,
               beforefunc:"page.det_beforefunc_mfid",
                itemchangedfunc:"page.det_itemchanged_mfid",
                },
			},{
				field: "catcode",
				name: "catcode",
				header: "商品类别",
				headerAlign: "center",
				allowSort: true,
				required: true,
				readOnly : true,
				editor: OcmControl.newControl('fut_popselectgrid'),
                width: 160,
                displayField: "mid_name",
                editorSet: {
                selectkey: 'treeGbcatcode',
                multiSelect: true,
                beforefunc:"page.det_beforefunc",
                itemchangedfunc:"page.det_itemchangedfunc",
                },
			},{
				field: "ppcode",
				name: "ppcode",
				header: "品牌",
				headerAlign: "center",
				allowSort: true,
				required: true,
				readOnly : true,
				editor: OcmControl.newControl('fut_popselectgrid'),
                width: 160,
                displayField: "ppcode_name",
                editorSet: {
                selectkey: 'ppcode',
                multiSelect: true,
                beforefunc:"page.det_beforefunc",
                itemchangedfunc:"page.det_itemchangedfunc",
                },
			},{
				field: "gbmanamode",
				name: "gbmanamode",
				header: "管理方式",
				headerAlign: "center",
				allowSort: true,
				required: true,
				readOnly : true,
                width: 120,
                renderer: "OcmControl.dictRendererWithCode",
            	type : "comboboxcolumn",
            	editor : OcmControl.newControl('ComboBox'),
            	dictkey : 'CMPMMID',
            },{
				field : "oldgmpsj",
				name : "oldgmpsj",
				headerAlign : "center",
				header : "原售价",
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet : {
					format : "c2",
				},
				numberFormat : "c2",
				defaultValue : "0",
				align : "right",
				required : true,
				readOnly : true,
				required : true,
				visible: true,
				width : 90,
			}, {
				field : "gmpsj",
				name : "gmpsj",
				headerAlign : "center",
				header : "新售价",
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet : {
					format : "c2",
				},
				numberFormat : "c2",
				defaultValue : "0",
				align : "right",
				required : true,
				visible: true,
				width : 90,
			},{field : "kcsl",
				headerAlign : "center",
				header : "库存数量",
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet : {
					format : "n0",
				},
				numberFormat : "n0",
				defaultValue : "0",
				align : "right",
				readOnly : true,
				//visible: true,
				visible: true,
				width : 85,
			} ,{field : "jchj",
				headerAlign : "center",
				header : "进差合计",
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet : {
					format : "n0",
				},
				numberFormat : "n0",
				defaultValue : "0",
				align : "right",
				readOnly : true,
				visible: true,
				width : 85,
				} ]
		}
	};


	// 查询 自定义名称
	bill.gbchangequerylist = {
		"title" : '单据列表',
		"name" : 'gbchangequerylist',
		"type" : "gridbox",
		"resources" : OmdUrl.mall,
		"method" : "mss.commodity.goodschange.search",
		"response" : "gbupdatehead",
		"canquery" : true,
		/* "manualLoad" : true, */
		"bindform" : "layouttabs", // 绑定切换的TabsBox.name
		"bindSearchParam" : [ "ph_key" ], // 明细页面查询条件字段
		"searchParam" : {
			"billtype" : billtype,
			"tztype" :'1',
			"order_field" : "billno",
			"order_direction" : "desc"
		},
		"properties" : {
			"id" : utils.createid('gbchangequerylist'),
			"columns" : [
					{
						type : "indexcolumn",
						header : "行号",
						headerAlign : "center",
					}, {
						field : "billno",
						header : "单据编号",
						allowSort : true,
						headerAlign : "center",
						width : 140,
						enabledSearch : true,
						visible : true
					}, {
						field : "billsgno",
						header : "手工编号",
						allowSort : true,
						headerAlign : "center",
						width : 140,
						enabledSearch : true,
						visible : true
					}, {
						field : "billstatus",
						header : "单据状态",
						allowSort : true,
						headerAlign : "center",
						renderer : "OcmControl.dictRendererWithCode",
						dictkey : 'BILLFLAG',
						width : 110,
						enabledSearch : true,
						visible : true
					},{
						field : "muid",
						type : "TextBox",
						headerAlign : "center",
						header : "门店",
						editor : OcmControl.newControl('fut_popselectgrid'),
						displayField : "muid_name",
						cdEdtCfg : {
							compnentType : 'fut_popselect',
							selectkey : "muid"
						},
						visible : false,
						enabledSearch : true,
						width : 200,
					}, {
						field : "muid_name",
						type : "TextBox",
						headerAlign : "center",
						header : "门店",
						enabledSearch : false,
						width : 250,
					}, {
						field : "gbstartdate",
						header : "生效日期",
						type : "date",
						width : 120,
						allowSort : true,
						headerAlign : "center",
						align : "center",
						dataType : "date",
						dateFormat : "yyyy-MM-dd",
					}, {
						field : "sbid",
						type : "TextBox",
						headerAlign : "center",
					    header: "供应商",
						editor : OcmControl.newControl('fut_popselectgrid'),
						displayField : "sbid_name",
						cdEdtCfg : {
							compnentType : 'fut_popselect',
						    selectkey:  'selfsbid',
						},
						visible : false,
						enabledSearch : true,
						width : 200,
					}, {
						field : "sbid_name",
						type : "TextBox",
						headerAlign : "center",
						header: "供应商",
						enabledSearch : false,
						width : 260,
						visible : false,
					}, {
						field : "inputer",
						header : "录入人",
						width : 160,
						allowSort : true,
						headerAlign : "center",
						editor:OcmControl.newControl('fut_popselectgrid'),
						displayField : "inputer_name",
						cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
						visible : true,
						enabledSearch : true,
					},{
						field : "inputer_name",
						header : "录入人",
						width : 130,
						allowSort : true,
						headerAlign : "center",	
						visible : false,
						enabledSearch : false,
					}, {
						field : "inputdate",
						type : "date",
						dataType : "date",
						format : "yyyy-MM-dd",
						header : "录入日期",
						width : 140,
						allowSort : true,
						headerAlign : "center",
						align : "center",
						visible : true,
						enabledSearch : true,
					}, {
						field : "auditor",
						header : "审核人",
						width : 160,
						allowSort : true,
						headerAlign : "center",
						editor:OcmControl.newControl('fut_popselectgrid'),
						displayField : "auditor_name",
						cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
						visible : true,
						enabledSearch : true,
					}, {
						field : "auditor_name",
						header : "审核人",
						width : 130,
						allowSort : true,
						headerAlign : "center",
						visible : false,
						enabledSearch : false,
					}, {
						field : "auditdate",
						type : "date",
						format : "yyyy-MM-dd",
						header : "审核日期",
						width : 140,
						dataType : "date",
						allowSort : true,
						headerAlign : "center",
						align : "center",
						visible : true,
						enabledSearch : true,
					}, {
						field : "canceler",
						header : "取消人",
						width : 160,
						allowSort : true,
						headerAlign : "center",
						editor:OcmControl.newControl('fut_popselectgrid'),
						displayField : "canceler_name",
						cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
						visible : true,
						enabledSearch : true,
					}, {
						field : "canceler_name",
						header : "取消人",
						width : 130,
						allowSort : true,
						headerAlign : "center",
						visible : false,
						enabledSearch : false,
					}, {
						field : "canceldate",
						type : "date",
						format : "yyyy-MM-dd",
						header : "取消日期",
						width : 140,
						dataType : "date",
						allowSort : true,
						headerAlign : "center",
						align : "center",
						visible : true,
						enabledSearch : true,
					} ]
		}
	};

	var btn = Future.default.btn;
	// 按钮配置 - 固定名称
	bill.toolbarconfig = {
		id : utils.createid('systoolbar'),
		// items : Future.pub.Basebill.default_toolsbar
		items : [ btn.addData, btn.editData, btn.delData, btn.saveData,
			btn.separator, btn.auditData, btn.cancelData,btn.separator, btn.searchData,
			btn.separator,{'text': '打印商品条码','iconCls': 'icon-print','name': 'printGoods',billstatus: 'Y,X',ibediting: 'N',tabindex: '1'},
			{'text': '打印物价标签','iconCls': 'icon-print','name': 'printPrice',billstatus: 'Y,X',ibediting: 'N',tabindex: '1'}]
	}

	// 单据配置
	bill.billconfig = {
		billhead : bill.gbupdatehead, // 单据主表
		billdetail : [bill.gbupdatedet], // 单据明细表
		billquerylist : bill.gbchangequerylist,// 查询列表
		dettabpages : [bill.gbupdatedet],// 要放入明细TAB列表的组件
		defaultmoduleid : app.modulecode,// 默认单据类型
	}

	// 创建标准单据模板
	utils.create_standardbill_config(bill);

})();
