/**
 * 页面定义
 */
(function () {
    // 要引用的包
    var utils = Future.ns('Future.utils');
    var validate = Future.ns('Future.validate');
    var col = Future.ns('default.col');
    // 活动命名空间
    var ns = Future.ns('batchgoods.view');
    // 定义一个对象用来配置界面
    var bill = {};

    var billtype = getBilltype(app.modulecode);

    var billtypes = {
        ly: '2', //联营
        zy: '158', //自营
        zl: '167',
    }
    if (billtype == billtypes.ly) {
        $("title").html("联营商品批量新增");
    } else if (billtype == billtypes.zy) {
        $("title").html("自营商品批量新增");
    } else if (billtype == billtypes.zl) {
        $("title").html("租赁商品申请单");
    }

    // 把定义对象放到命名空间下
    ns.bill = bill;

    utils.billtype = billtype;

    var zlwmid = [{code: '5', name: '租赁', ddvalue: '[5]租赁'}];

    var zlcmpmmid = [{code: '4', name: '现金键', ddvalue: '[4]现金键'}];

    var zlgbjjfs = [{code: '4', name: '倒扣比率', ddvalue: '[4]倒扣比率'}];


    var globrule = getRulemode("goods");

    utils.globrule = globrule;

    // 查询列表
    bill.batchgoodslist = {
        "type": "gridbox",
        "resources": OmdUrl.mss,
        "method": "mall.work.goodsbasehead.search",
        "response": "goodsbasehead",
        "bindform": "layouttabs",
        "bindSearchParam": ["ph_key"], // 明细页面查询条件字段
        "searchParam": {
            "billtype": billtype,
            "order_field": "inputdate",
            "order_direction": "desc",
        },
        "properties": {
            "id": utils.createid('batchgoodslist'),
            "columns": [{
                type: "indexcolumn",
                headerAlign: "center",
                header: "行号",
                width: 50,
            }, {
                field: "billno",
                type: "TextBox",
                headerAlign: "center",
                header: "单据编号",
                width: 140,
            }, {
                field: "billstatus",
                type: "TextBox",
                headerAlign: "center",
                header: "单据状态",
                renderer: "OcmControl.dictRendererWithCode",
                dictkey: 'SYSTEM_BILLSTATUS',
                width: 90,
            }, {
                field: "billtype",
                type: "TextBox",
                headerAlign: "center",
                header: "单据类型",
                renderer: "OcmControl.dictRendererWithCode",
                dictkey: 'BILLTYPE',
                visible: false,
            }, {
                field: "muid",
                type: "TextBox",
                headerAlign: "center",
                header: "门店",
                editor: OcmControl.newControl('fut_popselectgrid'),
                displayField: "muid_name",
                cdEdtCfg: {compnentType: 'fut_popselect', selectkey: "muid"},
                visible: false,
                enabledSearch: true,
            }, {
                field: "muid_name",
                type: "TextBox",
                headerAlign: "center",
                header: "门店",
                enabledSearch: false,
                width: 160,
            }, {
                field: "goodsbasedet:sbid",
                headerAlign: "center",
                displayField: "sbid",
                header: "商户",
                cdEdtCfg: {
                    compnentType: 'fut_popselect',
                    selectkey: "sbid",
                    beforefunc: "page.list_beforefunc_sbid",
                    textName: "sbid",
                },
                visible: false,
                enabledSearch: true,
            }, {
                field: "sbid_name",
                type: "TextBox",
                headerAlign: "center",
                header: "商户",
                enabledSearch: false,
                width: 230,
                visible: true,
            }, {
                field: "contno",
                type: "TextBox",
                headerAlign: "center",
                header: "合同",
                enabledSearch: false,
                width: 85,
                visible: true,
            }, {
                field: "goodsbasedet:spid",
                type: "TextBox",
                headerAlign: "center",
                header: "商铺",
                editor: OcmControl.newControl('fut_popselectgrid'),
                displayField: "spid_name",
                cdEdtCfg: {
                    compnentType: 'fut_popselect',
                    selectkey: "spid",
                    beforefunc: "page.list_beforefunc_spid",
                },
                visible: false,
                enabledSearch: true,
                beforefunc: "page.head_beforefunc",
            }, {
                field: "spid_name",
                type: "TextBox",
                headerAlign: "center",
                header: "商铺",
                enabledSearch: false,
                visible: true,
                width: 230,
            }, {
                field: "goodsbasedet:contno",
                type: "TextBox",
                headerAlign: "center",
                header: "合同号",
                editor: OcmControl.newControl('fut_popselectgrid'),
                displayField: "contno",
                cdEdtCfg: {
                    compnentType: 'fut_popselect',
                    selectkey: "leasecontno",
                    beforefunc: "page.list_beforefunc_contno",
                },
                visible: false,
                enabledSearch: true,
                beforefunc: "page.head_beforefunc",
            }, {
                field: "goodsbasedet:gbid",
                type: "TextBox",
                headerAlign: "center",
                header: "商品编码",
                enabledSearch: true,
                visible: false,
                width: 150,
            }, {
                field: "memo",
                type: "TextBox",
                headerAlign: "center",
                header: "备注",
                enabledSearch: true,
                width: 260,
                visible: true,
            }, {
                field: "inputer",
                header: "录入人",
                width: 100,
                allowSort: true,
                headerAlign: "center",
                editor: OcmControl.newControl('fut_popselectgrid'),
                displayField: "inputer_name",
                cdEdtCfg: {compnentType: 'fut_popselect', selectkey: "user"},
                visible: false,
                enabledSearch: true,
            }, {
                field: "inputer_name",
                header: "录入人",
                width: 130,
                allowSort: true,
                headerAlign: "center",
                enabledSearch: false,
            }, {
                field: "inputdate",
                type: "date",
                dataType: "date",
                format: "yyyy-MM-dd",
                header: "录入日期",
                width: 140,
                allowSort: true,
                headerAlign: "center",
                align: "center",
            }, {
                field: "auditor",
                header: "审核人",
                width: 130,
                allowSort: true,
                headerAlign: "center",
                editor: OcmControl.newControl('fut_popselectgrid'),
                displayField: "auditor_name",
                cdEdtCfg: {compnentType: 'fut_popselect', selectkey: "user"},
                visible: false,
                enabledSearch: true,
            }, {
                field: "auditor_name",
                header: "审核人",
                width: 130,
                allowSort: true,
                headerAlign: "center",
                enabledSearch: false,
            }, {
                field: "auditdate",
                type: "date",
                format: "yyyy-MM-dd",
                header: "审核日期",
                width: 140,
                dataType: "date",
                allowSort: true,
                headerAlign: "center",
                align: "center",
            }]
        }
    };

    // 单据主表
    bill.goodsbasehead = {
        "type": "formgrid",
        "initHeight": 0.3,
        "resources": OmdUrl.mss,
        "name": 'goodsbasehead',
        "method": "mall.work.goodsbasehead.get",
        "response": "goodsbasehead",
        "properties": {
            "id": utils.createid('goodsbasehead')
        },
        items: [{
            "label": "ph_key：",
            "name": "ph_key",
            "type": "TextBox",
            "visible": false,
        }, {
            "label": "单据编号：",
            "name": "billno",
            "type": "TextBox",
            "readOnly": true,
            "visible": true,
        }, {
            "label": "模块编号：",
            "name": "billmoduleid",
            "type": "TextBox",
            "defaultValue": app.modulecode,
            "visible": false,
        }, {
            "label": "单据类型：",
            "name": "billtype",
            "type": "TextBox",
            "defaultValue": getBilltype(app.modulecode),
            "visible": false
        }, {
            "label": "手工编号：",
            "name": "billsgno",
            "type": "TextBox",
            "readOnly": false,
        }, {
            "label": "单据状态：",
            "name": "billstatus",
            "type": "ComboBox",
            dictkey: 'SYSTEM_BILLSTATUS',
            "readOnly": true,
            "defaultValue": "N",
        }, {
            "label": "门店：",
            "name": "muid",
            "type": "fut_popselect",
            selectkey: "muid",
            textName: "muid_name",
            allowInput: true,
            beforefunc: "page.head_beforefunc",
            itemchangedfunc: "page.head_itemchangedfunc",
            "required": true,
        }, {
            "label": "商户：",
            "name": "sbid",
            "type": "fut_popselect",
            selectkey: "sbid",
            textName: "sbid_name",
            allowInput: true,
            beforefunc: "page.head_beforefunc",
            itemchangedfunc: "page.head_itemchangedfunc",
        }, {
            "label": "合同号：",
            "name": "contno",
            "type": "fut_popselect",
            selectkey: "leasecontno",
            textName: "contno",
            allowInput: true,
            beforefunc: "page.head_beforefunc",
            itemchangedfunc: "page.head_itemchangedfunc",
        }, {
            "label": "商铺：",
            "name": "spid",
            "type": "fut_popselect",
            selectkey: "spid",
            textName: "spid_name",
            beforefunc: "page.head_beforefunc",
            allowInput: true,
        }, {
            "label": "备注：",
            "name": "memo",
            "type": "TextBox",
            "width": "60%",
            "style": "display:block;float:none",
        }, {
            "label": "录入人：",
            "type": "TextBox",
            "name": "inputer_name",
            "readOnly": "true",
        }, {
            "label": "审核人：",
            "type": "TextBox",
            "name": "auditor_name",
            "readOnly": "true",
            "style": "display:block;float:none",
        }, {
            "label": "录入日期：",
            "type": "DatePicker",
            "name": "inputdate",
            "format": "yyyy-MM-dd HH:mm:ss",
            "readOnly": "true",
        }, {
            "label": "审核日期：",
            "type": "DatePicker",
            "name": "auditdate",
            "format": "yyyy-MM-dd HH:mm:ss",
            "readOnly": "true",
        }, {
            "label": "录入人编码",
            "type": "TextBox",
            "name": "inputer",
            "visible": false,
        }, {
            "label": "最后修改日期：",
            "type": "DatePicker",
            "name": "lastmoddate",
            "format": "yyyy-MM-dd HH:mm:ss",
            "visible": false,
        }
        ]
    }
    // 单据明细
    bill.goodsbasedet = {
        title: '单据明细',
        "type": "gridbox",
        name: 'goodsbasedet',
        "properties": {
            "id": utils.createid('goodsbasedet'),
            "multiSelect": "true",
            "allowCellEdit": "true",
            "allowCellSelect": "true",
            "editNextOnEnterKey": "true",
            "editNextRowCell": "true",
            "allowSortColumn": "false",
            "allowCellValid": true,
            "sortMode": "client",
            //"showPager": true,
            "oncellbeginedit": "OcmControl.checkboxEditor",
            "columns": [{
                type: "checkcolumn",
                headerAlign: "center",
                readOnly: true,
            }, {
                type: "indexcolumn",
                header: "行号",
                headerAlign: "center",
                readOnly: true,
                width: "40px",
            }, {
                headerAlign: "center",
                header: "行号",
                displayField: "browno",
                readOnly: true,
                width: 50,
                align: "center",
                visible: false
            }, {
                field: "gbid",
                header: "商品编码",
                headerAlign: "center",
                width: 100,
                /*readOnly:true,*/
                allowSort: true,
                required: globrule === "1" ? false : true,
            }, {
                field: "gbcname",
                header: "商品名称",
                headerAlign: "center",
                required: true,
                width: 230,
            }, /*{
					field: "gbbarcode",
					header: "商品条码",
					headerAlign: "center",
					//required: true,
					width: 100,
				}, */{
                field: "gbtype",
                header: "商品类型",
                type: "comboboxcolumn",
                editor: OcmControl.newControl('ComboBox'),
                renderer: "OcmControl.dictRendererWithCode",
                dictkey: 'GOODS_GBTYPE',
                visible: false,
                defaultValue: "1",
            }, {
                field: "gbcostid",
                header: "成本核算方式",
                type: "comboboxcolumn",
                editor: OcmControl.newControl('ComboBox'),
                renderer: "OcmControl.dictRendererWithCode",
                dictkey: 'CMPHSFF',
                visible: false,
                defaultValue: "2",
            }, {
                field: "muid",
                name: "muid",
                type: "TextBox",
                headerAlign: "center",
                header: "门店",
                editor: OcmControl.newControl('fut_popselectgrid'),
                displayField: "muid_name",
                editorSet: {
                    selectkey: 'muid',
                    multiSelect: false,
                    beforefunc: "page.det_beforefunc",
                    itemchangedfunc: "page.det_itemchangedfunc",
                },
                allowSort: true,
                visible: false,
                width: 120,
            }, {
                field: "sbid",
                name: "sbid",
                type: "TextBox",
                headerAlign: "center",
                header: "商户",
                editor: OcmControl.newControl('fut_popselectgrid'),
                displayField: "sbid_name",
                editorSet: {
                    selectkey: "sbid",
                    multiSelect: false,
                    beforefunc: "page.det_beforefunc",
                    itemchangedfunc: "page.det_itemchangedfunc",
                },
                allowSort: true,
                required: true,
                width: 220,
            }, {
                field: "contno",
                name: "contno",
                type: "TextBox",
                headerAlign: "center",
                header: "合同号",
                editor: OcmControl.newControl('fut_popselectgrid'),
                displayField: "contno",
                editorSet: {
                    selectkey: "leasecontno",
                    multiSelect: false,
                    beforefunc: "page.det_beforefunc",
                    itemchangedfunc: "page.det_itemchangedfunc",
                },
                allowSort: true,
                required: true,
                width: 100,
            }, {
                field: "spid",
                name: "spid",
                type: "TextBox",
                headerAlign: "center",
                header: "商铺",
                editor: OcmControl.newControl('fut_popselectgrid'),
                displayField: "spid_name",
                editorSet: {
                    selectkey: 'spid',
                    multiSelect: false,
                    beforefunc: "page.det_beforefunc",
                    itemchangedfunc: "page.det_itemchangedfunc",
                },
                allowSort: true,
                required: true,
                width: 230,
            }, {
                field: "catcode",
                header: "商品分类",
                headerAlign: "center",
                allowSort: true,
                required: true,
                editor: OcmControl.newControl('fut_popselectgrid'),
                displayField: "catcode_name",
                width: 130,
                editorSet: {
                    selectkey: 'treegbcatcode',
                    multiSelect: false,
                },
            }, {
                field: "ppcode",
                name: "ppcode",
                header: "品牌",
                headerAlign: "center",
                allowSort: true,
                required: true,
                editor: OcmControl.newControl('fut_popselectgrid'),
                displayField: "ppcode_name",
                width: 130,
                editorSet: {
                    selectkey: 'ppcode',
                    multiSelect: false,
                    beforefunc: "page.det_beforefunc",
                },
                required: true,
            }, {
                field: "gbmanamode",
                headerAlign: "center",
                header: "管理方式",
                type: "comboboxcolumn",
                editor: OcmControl.newControl('ComboBox'),
                renderer: "OcmControl.dictRendererWithCode",
                defaultValue: "4",
                data: zlcmpmmid,
                allowSort: true,
                readOnly: true,
                visible: false,
                width: 120,
            }, {
                field: "gbwmid",
                headerAlign: "center",
                header: "经营方式",
                type: "comboboxcolumn",
                editor: OcmControl.newControl('ComboBox'),
                renderer: "OcmControl.dictRendererWithCode",
                defaultValue: "5",
                data: zlwmid,
                readOnly: true,
                visible: false,
                width: 100,
            }, {
                field: "gbjjfs",
                headerAlign: "center",
                header: "计价方式",
                type: "comboboxcolumn",
                editor: OcmControl.newControl('ComboBox'),
                renderer: "OcmControl.dictRendererWithCode",
                data: zlgbjjfs,
                defaultValue: "4",
                readOnly: true,
                visible: false,
                width: 100,
            }, {
                field: "gbisyj",
                headerAlign: "center",
                header: "是否定价",
                type: "comboboxcolumn",
                editor: OcmControl.newControl('ComboBox'),
                renderer: "OcmControl.dictRendererWithCode",
                defaultValue: "N",
                dictkey: 'GBISYJ',
                visible: false,
                readOnly: true,
                width: 100,
            }, {
                field: "gmpxstax",
                header: "销项税率",
                headerAlign: "center",
                type: "comboboxcolumn",
                editor: OcmControl.newControl('ComboBox'),
                renderer: "OcmControl.dictRendererWithCode",
                dictkey: 'GOODS_XFTAXRATE',
                allowSort: true,
                required: true,
                width: 85,
            }, {
                field: "gmpxftax",
                header: "消费税率",
                headerAlign: "center",
                type: "comboboxcolumn",
                editor: OcmControl.newControl('ComboBox'),
                renderer: "OcmControl.dictRendererWithCode",
                dictkey: 'GOODS_XFTAXRATE',
                allowSort: true,
                required: true,
                width: 85,
            }, {
                field: "sdate",
                header: "开始日期",
                width: 85,
                headerAlign: "center",
                align: "center",
                editor: OcmControl.newControl('DatePicker'),
                dataType: "date",
                dateFormat: "yyyy-MM-dd",
                visible: false,
            }, {
                field: "edate",
                header: "结束日期",
                width: 85,
                headerAlign: "center",
                align: "center",
                editor: OcmControl.newControl('DatePicker'),
                dataType: "date",
                dateFormat: "yyyy-MM-dd",
                visible: false,
            }, {
                field: "gmpkl",
                name: "gmpkl",
                header: "扣率",
                headerAlign: "center",
                width: 85,
                editor: OcmControl.newControl('NumButtonEdit'),
                editorSet: {format: "p2",},
                numberFormat: "p2",
                value: "0",
                align: "right",
                vtype: "range:0,1",
                allowSort: true,
                visible: false,
            }]
        },
    };

    var btn = Future.default.btn;
    // 按钮配置 - 固定名称
    bill.toolbarconfig = {
        id: utils.createid('systoolbar'),
        items: [btn.addData, btn.delData, btn.editData, btn.saveData,
            btn.separator, btn.auditData, btn.searchData,
            btn.separator,/*btn.upTemplate,*/btn.downTemplate, btn.billImport
        ]
    }
    // 单据配置
    bill.billconfig = {
        billhead: bill.goodsbasehead, // 单据主表
        billdetail: [bill.goodsbasedet], // 单据明细表
        billquerylist: bill.batchgoodslist, // 查询列表
        dettabpages: [bill.goodsbasedet], // 要放入明细TAB列表的组件
        defaultmoduleid: app.modulecode, // 默认单据类型
    }

    // 创建标准单据模板
    utils.create_standardbill_config(bill);

})()
