/**
 *
 */
(function () {
    // 命名空间
    /** @namespace Future.batchgoods.out */
    var ns = Future.ns('batchgoods.out');
    var utils = Future.ns('utils');
    var validate = Future.ns('validate');
    var billtype = utils.billtype;
	var globrule = utils.globrule;
    var token = getUrlParam("token");// token值

    var Batchgoods = function () {
        Batchgoods.superclass.constructor.call(this);
        this.servicekey = 'mss';
        this.head_beforefunc = this.head_beforefunc.bind(this);
        this.head_itemchangedfunc = this.head_itemchangedfunc.bind(this);
        this.det_beforefunc = this.det_beforefunc.bind(this);
        this.det_itemchangedfunc = this.det_itemchangedfunc.bind(this);
        this.list_beforefunc_sbid = this.list_beforefunc_sbid.bind(this);
        this.list_beforefunc_spid = this.list_beforefunc_spid.bind(this);
        this.list_beforefunc_contno = this.list_beforefunc_contno.bind(this);
    }
    ns.Batchgoods = Batchgoods;

    Future.extend(ns.Batchgoods, Future.pub.Basebill, {

        _initview: function () {
            Batchgoods.superclass._initview.call(this);
        },
        initevent: function () {
            Batchgoods.superclass.initevent.call(this);
            this.goodsbasedet.on('cellcommitedit', this.detcellcommitedit, this);
            this.goodsbasedet.on('cellbeginedit', this.oncellbeginedit, this);
            this.goodsbasedet.addNewRowBefore = this.addNewRowBefore.bind(this);
        },
        addDataAfter: function () {
            this.billhead.setValue('inputer', getUserCode());
            this.billhead.setValue('inputer_name', getUserName());
            this.billhead.setValue('inputdate', new Date());
        },
        head_beforefunc: function (e) {
            var colname = e.sender.name;
            if (!e.searchParam) {
                e.searchParam = {};
            }
            if (colname == 'muid') {
                if (this.goodsbasedet.data.length > 0) {
                    mini.alert("明细已存在数据,请先删除后再修改门店");
                    e.cancel = true;
                    return -1;
                }
            }
            var muid = this.goodsbasehead.form.getField('muid').value;
            var sbid = this.goodsbasehead.form.getField('sbid').value;
            var spid = this.goodsbasehead.form.getField('spid').value;
            var contno = this.goodsbasehead.form.getField('contno').value;
            if (colname == 'contno') {
                if (this.goodsbasedet.data.length > 0) {
                    mini.alert("明细已存在数据,请先删除后再修改合同");
                    e.cancel = true;
                    return -1;
                }
                if (muid == undefined || muid == "") {
                    mini.alert("请先输入门店");
                    return -1;
                } else {
                    e.searchParam.contstatus = {"$in": "Y,S"};
                    e.searchParam.wmid = "5";
                    if (muid) {
                        e.searchParam.muid = muid;
                    }
                    if (sbid) {
                        e.searchParam.sbid = sbid;
                    }
                }
            }
            if (colname == 'sbid') {
                if (this.goodsbasedet.data.length > 0) {
                    mini.alert("明细已存在数据,请先删除后再修改商户");
                    e.cancel = true;
                    return -1;
                }
                if (muid == undefined || muid == "") {
                    mini.alert("请先输入门店");
                    return -1;
                } else {
                    e.searchParam.sbwmid5 = "Y";
                    e.searchParam.sbtype = "1";
                    e.searchParam.sbstatus = {"$in": "Y,2,3,4"};
                    if (contno) {
                        e.searchParam.sbid = {"$in": this.searchContmainField("sbid", contno, muid, "")};
                    } else {
                        e.searchParam.sbid = {"$in": this.searchContmainField("sbid", "", muid, "")};
                    }
                }
            }
            if (colname == 'spid') {
                if (this.goodsbasedet.data.length > 0) {
                    mini.alert("明细已存在数据,请先删除后再修改商铺");
                    e.cancel = true;
                    return -1;
                }
                if (muid == undefined || muid == "") {
                    mini.alert("请先输入门店");
                    return -1;
                } else if (contno == undefined || contno == "") {
                    mini.alert("请先输入合同");
                    return -1;
                } else {
                    e.searchParam.spstatus = "Y";
                    e.searchParam.sylx = {"$in": "02,03"};
                    if (sbid) {
                        e.searchParam.spid = {"$in": this.searchContmainField("contmanaframe:spid", contno, muid, sbid)};
                    } else {
                        e.searchParam.spid = {"$in": this.searchContmainField("contmanaframe:spid", contno, muid, "")};
                    }
                }
            }
            return 1;
        },
        searchContmainField: function (field, contnovalue, muidvalue, sbidvalue) {
            var _data = "";
            var tempfield = field;
            var subflag = false;
            var subarr = [];
            if (tempfield.indexOf(":") != -1) {
                tempfield = "*," + tempfield;
                subarr = field.split(":");
                subflag = true;
            }
            var searchParam = {
                fields: tempfield,
                wmid: "5",
                contstatus: {"$in": "Y,S"}
            };
            if (contnovalue) {
                searchParam.contno = contnovalue;
            }
            if (muidvalue) {
                searchParam.muid = muidvalue;
            }
            if (sbidvalue) {
                searchParam.sbid = sbidvalue;
            }
            itemLoader.doRequest(OmdUrl.mall, "mall.work.cont.search", searchParam, null, null, function (data) {
                if (data) {
                    if (data.contmain.length > 0) {
                        var temparry = [];
                        var contmains = data.contmain;
                        for (var i = 0; i < contmains.length; i++) {
                            if (subflag) {
                                var tempcontfield = contmains[i][subarr[0]];
                                for (var j = 0; j < tempcontfield.length;j++ ) {
                                    temparry.push(tempcontfield[j][subarr[1]]);
                                }
                            }else {
                                temparry.push(contmains[i][field]);
                            }
                        }
                        _data = temparry.join(",");
                    }
                }
            }, null, null, false);
            return _data;
        },
        list_beforefunc_sbid: function (e) {
            if (!e.searchParam) {
                e.searchParam = {};
            }
            e.searchParam.sbtype = "1";
            e.searchParam.sbwmid5 = "Y";
            e.searchParam.sbstatus = "Y";
        },
        list_beforefunc_spid: function (e) {
            if (!e.searchParam) {
                e.searchParam = {};
            }
            e.searchParam.sylx = {"$in": "02,03"};
        },
        list_beforefunc_contno: function (e) {
            if (!e.searchParam) {
                e.searchParam = {};
            }
            e.searchParam.wmid = "5";
        },
        head_itemchangedfunc: function (e, data) {
            var colname = e.sender.name;
            if (colname == 'muid') {
                this.billhead.setValueText('contno', "", "");
                this.billhead.setValueText('sbid', "", "");
                this.billhead.setValueText('spid', "", "");
            }
            if (colname == 'contno') {
                if (data[0] != "" && data[0] != null && data[0] != undefined) {
                    this.billhead.setValue('sbid', data[0].sbid);
                    this.billhead.setText('sbid', data[0].sbid_name);
                } else {
                    this.billhead.setValueText('sbid', "", "");
                }
                this.billhead.setValueText('spid', "", "");
            }
            if (colname == 'sbid') {
                this.billhead.setValueText('spid', "", "");
            }
            return 1;
        },
        det_beforefunc: function (e) {
            var colname = e.sender.name;
            var grid = e.sender.grid;
            var row = grid.getSelected();
            if (!e.searchParam) {
                e.searchParam = {};
            }
            ;
            var muid = this.goodsbasehead.form.getField('muid').value;
            var sbid = this.goodsbasehead.form.getField('sbid').value;
            var spid = this.goodsbasehead.form.getField('spid').value;
            var contno = this.goodsbasehead.form.getField('contno').value;
            var detsbid = row.sbid;
            var detcontno = row.contno;
            if (colname == 'muid') {
                if (muid) {
                    e.searchParam.wherestr = " muid = '" + muid + "'";
                }
            }
            ;
            if (colname == 'sbid') {
                e.searchParam.sbwmid5 = "Y";
                e.searchParam.sbtype = "1";
                e.searchParam.sbstatus = {"$in": "Y,2,3,4"};
                if (sbid) {
                    e.searchParam.sbid = sbid;
                } else if (muid) {
                    e.searchParam.sbid = {"$in": this.searchContmainField("sbid", "", muid, "")};
                }
            }
            ;
            if (colname == 'contno') {
                e.searchParam.wmid = "5";
                e.searchParam.contstatus = {"$in": "Y,S"};
                if (contno) {
                    e.searchParam.contno = contno;
                } else if (muid) {
                    e.searchParam.muid = muid;
                    if (sbid) {
                        e.searchParam.sbid = sbid;
                    } else if (detsbid) {
                        e.searchParam.sbid = detsbid;
                    }
                }
            }
            ;
            if (colname == 'spid') {
                var det = this.goodsbasedet.getSelected();
                var contno = det.contno;
                if (contno == "" || contno == undefined || contno == null) {
                    mini.alert("请先输入合同！");
                    return -1;
                }
                e.searchParam.spstatus = {"$in": "Y,E"};
                e.searchParam.sylx = {"$in": "02,03"};
                if (spid) {
                    e.searchParam.spid = spid;
                } else {
                    e.searchParam.spid = {"$in": this.searchContmainField("contmanaframe:spid", "", muid, "")};
                }
            }
            ;

            return 0;
        },
        det_itemchangedfunc: function (e, data) {
            var colname = e.sender.name;
            var row = this.goodsbasedet.getSelected();
            if (colname == 'muid') {
                var newrow = {
                    gbcname: "",
                    spid: "",
                    spid_name: "",
                    sbid: "",
                    sbid_name: "",
                    contno: "",
                    ppcode: "",
                    ppcode_name: ""
                };
                this.goodsbasedet.updateRow(row, newrow);
            }
            if (colname == 'sbid') {
                var newrow = {
                    gbcname: "",
                    contno: "",
                    spid: "",
                    spid_name: "",
                    ppcode: "",
                    ppcode_name: "",
                };
                this.goodsbasedet.updateRow(row, newrow);
            }
            if (colname == 'contno') {
                var gbname = null;
                var muid = this.goodsbasehead.form.getField('muid').value;
                var method = "mall.work.goodsbasehead.getGbname";
                var searchParam = {
                    "muid": muid,
                    "contno": data[0].contno,
                };
                itemLoader.doRequest(OmdUrl.mall, method, searchParam, null, null, function (data) {
                    gbname = data["gbname"];
                }, null, null, false);

                var newrow = {
                    sbid: data[0].sbid,
                    sbid_name: data[0].sbid_name,
                    gbcname: gbname,
                    spid: "",
                    spid_name: "",
                    ppcode: data[0].ppcode,
                    ppcode_name: data[0].ppcode_name,
                };
                this.goodsbasedet.updateRow(row, newrow);
            }
            return 1;
        },
        detcellcommitedit: function (e) {
            var row = e.row;
            if (e.field == "gbid") {
                var _data;
                var searchParam = {
                    "gbid": e.value
                };
                var method = "mall.work.goods.search";
                itemLoader.doRequest(OmdUrl.mall, method, searchParam, null, null, function (data) {
                    _data = data.goodsbase;
                }, null, null, false);
                if (_data.length > 0) {
                    mini.alert("商品编码已存在!请重新输入");
                    e.cancel = true;
                    return -1;
                }
            }
            ;
            //开始日期
            if (e.field == 'sdate') {
                if (e.value != undefined && e.value != "" && e.value) {
                    var sdate = new Date(e.value);
                    sdate = mini.formatDate(sdate, "yyyy-MM-dd");
                    if (e.row.contno != undefined && e.row.contno != "") {
                        if (!this.saveChecksdate(e.row.contno, sdate)) {
                            var ksrq = this.fgetsdate(e.row.contno, sdate);
                            ksrq = new Date(ksrq);
                            ksrq = mini.formatDate(ksrq, "yyyy-MM-dd");
                            mini.alert("开始日期" + sdate + "不能小于" + e.row.contno + "合同开始日期" + ksrq);
                            var newrow = {
                                sdate: ksrq,
                            }
                            this.goodsbasedet.updateRow(row, newrow);
                            e.cancel = true;
                            return -1;
                        }
                    }
                    if (e.row.edate != undefined && e.row.edate != "") {
                        var edate = new Date(e.row.edate);
                        edate = mini.formatDate(edate, "yyyy-MM-dd");
                        if (sdate > edate) {
                            mini.alert("开始日期" + sdate + "不能大于结束日期" + edate);
                            var newrow = {
                                sdate: edate,
                            }
                            this.goodsbasedet.updateRow(row, newrow);
                            e.cancel = true;
                            return -1;
                        }
                    }
                }
            }
            ;
            //结束日期
            if (e.field == 'edate') {
                if (e.value != undefined && e.value != "" && e.value) {
                    var edate = new Date(e.value);
                    edate = mini.formatDate(edate, "yyyy-MM-dd");
                    if (e.row.contno != undefined && e.row.contno != "") {
                        if (!this.saveCheckedate(e.row.contno, edate)) {
                            var jsrq = this.fgetedate(e.row.contno, edate);
                            jsrq = new Date(jsrq);
                            jsrq = mini.formatDate(jsrq, "yyyy-MM-dd");
                            mini.alert("结束日期" + edate + "不能大于" + e.row.contno + "合同结束日期" + jsrq);
                            var newrow = {
                                edate: jsrq,
                            }
                            this.goodsbasedet.updateRow(row, newrow);
                            e.cancel = true;
                            return -1;
                        }
                    }
                    if (e.row.sdate != undefined && e.row.sdate != "") {
                        var sdate = new Date(e.row.sdate);
                        sdate = mini.formatDate(sdate, "yyyy-MM-dd");
                        if (edate < sdate) {
                            mini.alert("结束日期" + edate + "不能小于开始日期" + sdate);
                            var newrow = {
                                edate: sdate,
                            }
                            this.goodsbasedet.updateRow(row, newrow);
                            e.cancel = true;
                            return -1;
                        }
                    }
                }
            }

            if (e.field == "gmpkl") {
                if (!Number(e.value)) {
                    mini.alert("请输入数字");
                    e.cancel = true;
                    return -1;
                }
                if (0 > e.value || e.value > 1) {
                    mini.alert("请输入0到1之间的扣率");
                    var newrow = {
                        gmpkl: 0,
                    }
                    this.goodsbasedet.updateRow(row, newrow);
                    e.cancel = true;
                    return -1;
                }
            }
        },
        oncellbeginedit: function (e) {
            if (e.field == "gbid") {
                if (globrule == "0") {
                    e.cancel = false;
                } else {
                    e.cancel = true;
                }
            }
            if (e.field == "sdate") {
                if (e.row.contno == undefined || e.row.contno == "" || e.row.contno == null) {
                    mini.alert("请先选择合同");
                    e.cancel = true;
                    return -1;
                }
            }
            if (e.field == "edate") {
                if (e.row.sdate == undefined || e.row.sdate == "" || e.row.sdate == null) {
                    mini.alert("请先选择开始日期");
                    e.cancel = true;
                    return -1;
                }
            }
            /*if(e.field == "gmpkl"){
                if(e.row.sdate == undefined || e.row.sdate == ""||e.row.sdate==null ){
                    mini.alert("请先选择开始");
                    e.cancel = true;
                    return -1;
                }
                if(e.row.edate == undefined || e.row.edate == ""||e.row.edate==null ){
                    mini.alert("请先选择结束日期");
                    e.cancel = true;
                    return -1;
               }
            }*/
        },
        addNewRowBefore: function (data) {
            var form = this.goodsbasehead.form;
            form.validate();
            if (form.isValid() == false) {
                mini.alert("请先选择单头门店!");
                return;
            }
            var muid = form.getField('muid').value;
            var muid_name = form.getField('muid').text;
            var sbid = form.getField('sbid').value;
            var sbid_name = form.getField('sbid').text;
            var spid = form.getField('spid').value;
            var spid_name = form.getField('spid').text;
            var contno = form.getField('contno').value;
            var detpp = null;
            var detppname = null;
            var detgbname = null;
            if (contno[0] != "" && contno[0] != null && contno[0] != undefined) {
                var searchParam = {
                    "contno": contno,
                    "contstatus": {"$in": "Y,S"},
                    "wmid": "5"
                };
                itemLoader.doRequest(OmdUrl.mall, "mall.work.cont.search",
                    searchParam, null, null, function (data) {
                        var data = data.contmain;
                        if (data.length > 0) {
                            detpp = data[0].ppcode;
                            detppname = data[0].ppcode_name;
                        }
                        ;
                    }, null, null, false);

                var method = "mall.work.goodsbasehead.getGbname";
                var searchParam = {
                    "muid": muid,
                    "contno": contno,
                };
                itemLoader.doRequest(OmdUrl.mall, method, searchParam, null, null, function (data) {
                    detgbname = data["gbname"];
                }, null, null, false);
            }

            data = {
                gbcname: detgbname,
                gbbarcode: "",
                gbmanamode: "4",
                gbwmid: "5",
                gbjjfs: "4",
                gbisyj: "N",
                gbtype: "1",
                gbcostid: "2",
                priceaccuracy: "0.01",
                gmptaxtype: "1",
                gmpxstax: "0.16",
                gmpxftax: 0,
                sbid: sbid,
                muid: muid,
                spid: spid,
                sbid_name: sbid_name,
                muid_name: muid_name,
                spid_name: spid_name,
                contno: contno,
                ppcode: detpp,
                ppcode_name: detppname,
                priceaccuracy: 0.01,
                gmpjxtax: 0,
                gmpkl: 0,
                gmphsjj: 0,
                gmpsj: 0,
                gmpke: 0,
                isdzcm: "N",
            };

            return data;
        },
        initcontrol: function () {
            Batchgoods.superclass.initcontrol.call(this);
        },
        GetLength: function (str) {
            return str.replace(/[\u0391-\uFFE5]/g, "aa").length;  //先把中文替换成两个字节的英文，在计算长度
        },
        checkValidate: function () {
            var isValid = Batchgoods.superclass.checkValidate.call(this);
            if (isValid == false) {
                return isValid;
            }
            return true;
        },
        saveCheck: function (sbid, muid, spid, contno) {
            var isCheck = true;
            var searchParam = {
                "muid": muid,
                "sbid": sbid,
                "contmanaframe:spid": spid,
                "contno": contno,
            }
            itemLoader.doRequest(OmdUrl.mall, "mall.work.cont.search",
                searchParam, null, null, function (data) {
                    if (data.contmain.length == 0) {
                        isCheck = false;
                    }
                    ;
                }, null, null, false);
            return isCheck;
        },
        fgetsdate: function (contno, sdate) {
            var htksrq = sdate;
            var searchParam = {
                "contno": contno,
            }
            itemLoader.doRequest(OmdUrl.mall, "mall.work.cont.search",
                searchParam, null, null, function (data) {
                    var data = data.contmain;
                    if (data.length > 0) {
                        htksrq = data[0].cmeffdate;
                    }
                    ;
                }, null, null, false);
            return htksrq;
        },
        fgetedate: function (contno, edate) {
            var htjsrq = edate;
            var searchParam = {
                "contno": contno,
            }
            itemLoader.doRequest(OmdUrl.mall, "mall.work.cont.search",
                searchParam, null, null, function (data) {
                    var data = data.contmain;
                    if (data.length > 0) {
                        htjsrq = data[0].cmlapdate;
                    }
                    ;
                }, null, null, false);
            return htjsrq;
        },
        saveChecksdate: function (contno, sdate) {
            var isCheck = true;
            var searchParam = {
                "contno": contno,
                "cmeffdate": {"<=": sdate},
            }
            itemLoader.doRequest(OmdUrl.mall, "mall.work.cont.search",
                searchParam, null, null, function (data) {
                    if (data.contmain.length == 0) {
                        isCheck = false;
                    }
                    ;
                }, null, null, false);
            return isCheck;
        },
        saveCheckedate: function (contno, edate) {
            var isCheck = true;
            var searchParam = {
                "contno": contno,
                "cmlapdate": {">=": edate},
            }
            itemLoader.doRequest(OmdUrl.mall, "mall.work.cont.search",
                searchParam, null, null, function (data) {
                    if (data.contmain.length == 0) {
                        isCheck = false;
                    }
                    ;
                }, null, null, false);
            return isCheck;
        },
        saveDataBefore: function () {
            var form = this.goodsbasehead.form;
            // 必须入力check;
            form.validate();
            if (form.isValid() == false) {
                mini.alert("请先选择单头门店");
                return;
            }
            /*if (this.goodsbasedet.getData().length == 0) {
                mini.alert("请至少维护一行明细");
                return;
            }*/

            var memo = this.goodsbasehead.form.getField('memo').value;
            if (memo && this.GetLength(memo) > 100) {
                mini.alert("备注太长，请检查！")
                return;
            }

            var muid = this.goodsbasehead.form.getField('muid').value;
            this.billhead.setValue('lastmoddate', new Date());

            var rule = globrule

            var obj = {};
            var detData = this.goodsbasedet.getData();
            for (var i = 0; i < detData.length; i++) {
                var cont = i + 1;
                if (rule == "0") {
                    if (!detData[i].gbid || detData[i].gbid == " ") {
                        mini.alert("商品编码规则是手工录入，第" + cont + "行的商品编码不能为空");
                        return;
                    }
                    ;
                }
                ;
                if (!detData[i].sbid || detData[i].sbid == " ") {
                    mini.alert("第" + cont + "行的商户不能为空");
                    return;
                }
                ;
                if (!detData[i].spid || detData[i].spid == " ") {
                    mini.alert("第" + cont + "行的商铺不能为空");
                    return;
                }
                ;
                if (!detData[i].gbwmid || detData[i].gbwmid == " ") {
                    mini.alert("第" + cont + "行的经营方式不能为空");
                    return;
                }
                ;
                if (!detData[i].ppcode || detData[i].ppcode == " ") {
                    mini.alert("第" + cont + "行的品牌不能为空");
                    return;
                }
                ;
                if (!detData[i].gbcname || detData[i].gbcname == " ") {
                    mini.alert("第" + cont + "行的商品名称不能为空");
                    return;
                } else {
                    if (this.GetLength(detData[i].gbcname) > 40) {
                        mini.alert("第" + cont + "行的商品名称太长，请检查！")
                        return;
                    }
                }
                ;
                if (!detData[i].catcode || detData[i].catcode == " ") {
                    mini.alert("第" + cont + "行的商品分类不能为空");
                    return;
                }
                ;
                if (detData[i].gmpxstax != 0 && (!detData[i].gmpxstax || detData[i].gmpxstax == " ")) {
                    mini.alert("第" + cont + "行的销项税率不能为空");
                    return;
                }
                ;
                if (detData[i].gmpxftax != 0 && (!detData[i].gmpxftax || detData[i].gmpxftax == " ")) {
                    mini.alert("第" + cont + "行的消费税率不能为空");
                    return;
                }
                ;
                if (detData[i].gmpkl != 0 && (!detData[i].gmpkl || detData[i].gmpkl == " ")) {
                    mini.alert("第" + cont + "行的扣率不能为空");
                    return;
                }
                ;

                var muid_name = this.goodsbasehead.form.getField('muid').text;
                var isCheck = this.saveCheck(detData[i].sbid, muid, detData[i].spid, detData[i].contno);
                if (!isCheck) {
                    mini.alert("第" + cont + "行的商户" + detData[i].sbid_name + "在" + muid_name + "门店下" + detData[i].spid_name + "商铺没有" + detData[i].contno + "合同");
                    return;
                }

                var sdate = detData[i].sdate;
                var edate = detData[i].edate;
                var kl = detData[i].gmpkl;
                if (sdate && sdate != " " && sdate != null && sdate != undefined) {
                    if (!edate || edate == " ") {
                        mini.alert("第" + cont + "行已维护开始日期，结束日期不能为空");
                        return;
                    }
                    sdate = new Date(sdate);
                    sdate = mini.formatDate(sdate, "yyyy-MM-dd");
                    var isSdateCheck = this.saveChecksdate(detData[i].contno, sdate);
                    if (!isSdateCheck) {
                        var ksrq = this.fgetsdate(detData[i].contno, sdate);
                        ksrq = new Date(ksrq);
                        ksrq = mini.formatDate(ksrq, "yyyy-MM-dd");
                        mini.alert("第" + cont + "行的开始日期" + sdate + "不能小于" + detData[i].contno + "合同开始日期" + ksrq);
                        return;
                    }
                }
                if (edate && edate != " " && edate != null && edate != undefined) {
                    if (!sdate || sdate == " ") {
                        mini.alert("第" + cont + "行已维护结束日期，开始日期不能为空");
                        return;
                    }
                    edate = new Date(edate);
                    edate = mini.formatDate(edate, "yyyy-MM-dd");
                    var isEdateCheck = this.saveCheckedate(detData[i].contno, edate);
                    if (!isEdateCheck) {
                        var jsrq = this.fgetedate(detData[i].contno, edate);
                        jsrq = new Date(jsrq);
                        jsrq = mini.formatDate(jsrq, "yyyy-MM-dd");
                        mini.alert("第" + cont + "行的结束日期" + sdate + "不能大于" + detData[i].contno + "合同结束日期" + jsrq);
                        return;
                    }
                }
                if ((sdate && sdate != " " && sdate != null && sdate != undefined) && (edate && edate != " " && edate != null && edate != undefined)) {
                    var gmpkl = detData[i].gmpkl;
                    /*if (Number(gmpkl) || Number(gmpkl) == " ") {
                        mini.alert("第" + cont + "行已维护开始日期、结束日期，请维护扣率");
                        return;
                    }*/
                    if (Number(gmpkl) == 0) {
                        // var _result = window.confirm("第" + cont + "行扣率为0，确定保存？");
                        // if (_result) {
                        // } else {
                        // 	return ;
                        // }
                        window.confirm("第" + cont + "行扣率为0，确定保存？", function (_result) {
                            if (_result) {
                            } else {
                                return;
                            }
                        });
                    }
                    sdate = new Date(sdate);
                    edate = new Date(edate);
                    sdate = mini.formatDate(sdate, "yyyy-MM-dd");
                    edate = mini.formatDate(edate, "yyyy-MM-dd");
                    if (sdate > edate) {
                        mini.alert("第" + cont + "开始日期不能大于结束日期");
                        return;
                    }
                }

                var num = i + 1;
                var browno = detData[i].browno;
                if (browno == undefined || browno == "" || browno != i) {
                    var newrow = {
                        browno: num,
                    }
                    this.goodsbasedet.updateRow(detData[i], newrow);
                }

                detData[i].lastmoddate = new Date();
                detData[i].lastmodby = getUserCode();
                detData[i].muid = muid;

                if (detData) {
                    obj.goodsbasedet = detData;
                    setGridData(obj.goodsbasedet);
                }
            }
            return obj;
        }
    });
})()

