/**
 * 商品采购订单 --- 界面定义
 */
(function() {
	// 要引用的包
	var utils = Future.ns('Future.utils');
	
	var col = Future.ns('default.col');
	// 命名空间
	var ns = Future.ns('leasechange.view');
	
	function getBilltype (billmoduleid) {
		 var billtype = "";
		 var searchParam = {"modeid":billmoduleid};
		 var method = "mss.base.billmain.search";
		 itemLoader.doRequest(OmdUrl.mall, method,searchParam, null, null, function(data) {
			 	var data = data.billmain;
				if(data.length >0){
					billtype =data[0].billtype;
				}
		 },null,null,false);
		 return billtype;
	}

	// 定义一个对象用来配置界面
	var bill = {};

	var moduleid = app.modulecode;
	var billtype=getBilltype(moduleid);
	
    var dicData = {};
	var wmid = [{code: '5',name: '租赁',ddvalue: '[5]租赁'}] 
		
	// 把定义对象放到命名空间下
	ns.bill = bill;
	utils.billtype=billtype;
	
	// 查询列表
	bill.leasechangelist = {
				"type": "gridbox",
				"resources": OmdUrl.mss,
				"method": "mss.base.leasechangegbhd.search",
				"response": "leasechangegbhd",
				"bindform": "layouttabs",
				"bindSearchParam": ["ph_key"], // 明细页面查询条件字段
				"searchParam": {
					"billtype" : billtype,
					"order_field": "billno",
					"order_direction": "desc",
				},
				"properties": {
					"id": utils.createid('leasechangelist'),
					"columns": [{
						type: "indexcolumn",
						headerAlign: "center",
						header: "行号",
						width: 60,
					}, {
						field: "billno",
						type: "TextBox",
						headerAlign: "center",
						header: "单据编号",
						width: 150,
					}, {
						field : "billsgno",
						header : "手工单号",
						allowSort : true,
						headerAlign : "center",
						width : 150,
						visible:false,
					}, {
						field: "billstatus",
						type: "TextBox",
						headerAlign: "center",
						header: "单据状态",
						renderer: "OcmControl.dictRendererWithCode",
						dictkey: 'BILLSTATUS',
					}, {
						field: "muid",
						type: "TextBox",
						headerAlign: "center",
						header: "门店",
						editor:OcmControl.newControl('fut_popselectgrid'),
						displayField : "muid_name",
						cdEdtCfg:{compnentType:'fut_popselect',selectkey:"muid"},
						visible:false,
						enabledSearch : true,
					}, {
						field: "muid_name",
						type: "TextBox",
						headerAlign: "center",
						header: "门店",
						enabledSearch : false,
						width: 160,
					},{
						field : "sbid",
						type : "TextBox",
						headerAlign : "center",
						header : "商户",
						editor : OcmControl.newControl('fut_popselectgrid'),
						displayField : "sbid_name",
						cdEdtCfg : {
							compnentType : 'fut_popselect',
							selectkey : "sbid",
							beforefunc : "page.list_beforefunc_sbid",
						},
						visible:false,
						enabledSearch : true,
						width : 180,
					},{
						field: "sbid_name",
						type: "TextBox",
						headerAlign: "center",
						header: "商户",
						enabledSearch : false,
						width: 200,
						visible:true,
					},{
						field : "contno",
						header : "合同编号",
						editor : OcmControl.newControl('fut_popselectgrid'),
						displayField : "contno",
						cdEdtCfg : {
							compnentType : 'fut_popselect',
							selectkey : "leasecontno",
							beforefunc : "page.list_beforefunc_contno",
						},
						allowSort : true,
						headerAlign : "center",
						width : 100,
						enabledSearch : true,
						visible : true,
					},{
						field: "contstatus",
						type: "TextBox",
						headerAlign: "center",
						header: "合同状态",
						renderer: "OcmControl.dictRendererWithCode",
						dictkey: 'CONTSTATUS',
					},{
						field : "cmeffdate",
						header : "开始日期",
						type: "DatePicker",
						headerAlign: "center",
						dataType: "date",
						dateFormat: "yyyy-MM-dd",
						width: 100,
				   },{
						field : "cmlapdate",
						header : "结束日期",
						type: "DatePicker",
						headerAlign: "center",
						dataType: "date",
						dateFormat: "yyyy-MM-dd",
						width: 100,
				   },{
						field: "wmid",
						type:"TextBox",
						headerAlign:"center",
						header:"经营方式",
						allowSort : true,
						renderer: "OcmControl.dictRendererWithCode",
						data: wmid,
						width: 90,
					},{
						field : "memo",
						header : "备注",
						width : 200,
						readOnly: true,
						headerAlign : "center",
					},{
						field : "inputer",
						header : "录入人",
						width : 120,
						allowSort : true,
						headerAlign : "center",	
						editor:OcmControl.newControl('fut_popselectgrid'),
						displayField : "inputer_name",
						cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
						visible : true,
						enabledSearch : true,
					},{
						field : "inputer_name",
						header : "录入人",
						width : 120,
						allowSort : true,
						headerAlign : "center",	
						visible : false,
						enabledSearch : false,
					}, {
						field : "inputdate",
						type : "date",
						dataType : "date",
						format : "yyyy-MM-dd",
						header : "录入日期",
						width : 140,
						allowSort : true,
						headerAlign : "center",
						align : "center",
						visible : true,
						enabledSearch : true,
					}, {
						field : "auditor",
						header : "审核人",
						width : 120,
						allowSort : true,
						headerAlign : "center",
						editor:OcmControl.newControl('fut_popselectgrid'),
						displayField : "auditor_name",
						cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
						visible : true,
						enabledSearch : true,
					}, {
						field : "auditor_name",
						header : "审核人",
						width : 120,
						allowSort : true,
						headerAlign : "center",
						visible : false,
						enabledSearch : false,
					}, {
						field : "auditdate",
						type : "date",
						format : "yyyy-MM-dd",
						header : "审核日期",
						width : 140,
						dataType : "date",
						allowSort : true,
						headerAlign : "center",
						align : "center",
						visible : true,
						enabledSearch : true,
					}]
		}
	};
	
	// 表头 自定义名称
	bill.leasechangegbhd = {
		"name" : 'borderhead',
		"initHeight" : 0.3,
		"type" : "formgrid",
		"resources" : OmdUrl.mall,
		"method" : "mss.base.leasechangegbhd.get",
		"response" : "leasechangegbhd",
		"properties" : {
			"id" : utils.createid('leasechangegbhd'),
		},
		items : [{
			"label": "ph_key：",
			"name": "ph_key",
			"type": "TextBox",
			"visible": false,
		}, {
			"label": "单据编号：",
			"name": "billno",
			"type": "TextBox",
			"readOnly": true,
			"visible": true,
		},{
			"label": "手工单号：",
			"name": "billsgno",
			"type": "TextBox",
			/*"visible": false,*/
		}, {
			"label": "模块编号：",
			"name": "billmoduleid",
			"type": "TextBox",
			"defaultValue": app.modulecode,
			"visible": false
		}, {
			"label": "单据类型：",
			"name": "billtype",
			"type": "TextBox",
			"defaultValue": getBilltype(app.modulecode),
			"visible": false
		}, {
			"label": "单据状态：",
			"name": "billstatus",
			"type": "ComboBox",
			dictkey: 'BILLSTATUS',
			"readOnly": true,
			"defaultValue": "N",
			/*"style" : "display:block;float:none"*/
		},{
			"label": "门店：",
			"name": "muid",
			"type": "fut_popselect",
			selectkey: "muid",
			textName: "muid_name",
			allowInput: true,
			beforefunc : "page.head_beforefunc",
			itemchangedfunc:"page.head_itemchangedfunc",
			"required": true,
		}, {
			"label": "商户：",
			"name": "sbid",
			"type": "fut_popselect",
			selectkey: "sbid",
			textName: "sbid_name",
			allowInput: true,
			beforefunc : "page.head_beforefunc",
			itemchangedfunc:"page.head_itemchangedfunc",
			"required": true,
		}, {
			"label" : "合同编号：",
			"name" : "contno",
			 type : "fut_popselect",
			 selectkey : "leasecontno",
			 textName : "contno",
			 beforefunc : "page.head_beforefunc",
			 itemchangedfunc : "page.head_itemchanged",
			 "allowInput" : true,
			 "required" : "true",
		 },{
			  "label" : "合同状态：",
			  "type" : "ComboBox",
			  "name" : "contstatus",
			  "readOnly" : true,
			  "enabled" : "true",
			   dictkey : 'CONTSTATUS',
		 },{
			 "label": "开始日期：",
			 "name": "cmeffdate",
			 "type": "DatePicker",
			 "format" : "yyyy-MM-dd",
			 "readOnly": true,
		  },{
			  "label": "结束日期：",
			  "name": "cmlapdate",
			  "type": "DatePicker",
			  "format" : "yyyy-MM-dd",
			  "readOnly": true,
		  },{
			"label" : "经营方式：",
			"type" : "ComboBox",
			"name" : "wmid",
			"data" : wmid,
			"valueField" : "code",
			"textField" : "name",
			"readOnly": true,
			"required" : false,
			"defaultValue" : "5",
		},{
			"label" : "备注：",
			"name" : "memo",
			"type" : "TextBox",
			"width" : "60%",
			"style": "display:block;float:none",
		}, {
			"label" : "录入人：",
			"name" : "inputer_name",
			"type" : "TextBox",
			"defaultValue" : app.username,
			"readOnly" : true,
		}, {
			"label" : "录入人",
			"name" : "inputer",
			"type" : "TextBox",
			"readOnly" : true,
			"visible":false,
		},{
			"label" : "审核人：",
			"name" : "auditor_name",
			"type" : "TextBox",
			"readOnly" : true,
			"style" : "display:block;float:none",
		},{
			"label" : "审核人姓名",
			"name" : "auditor",
			"type" : "TextBox",
			"readOnly" : true,
			"visible":false,
		},{
	        "label" : "录入日期：",
	        "type" : "DatePicker",
	        "name" : "inputdate",
	        "format" : "yyyy-MM-dd HH:mm:ss",
	        "defaultValue" : new Date(),
	        "readOnly" : "true",
	    },{
            "label": "审核日期：",
            "type": "DatePicker",
            "name": "auditdate",
            "format": "yyyy-MM-dd HH:mm:ss",
            "readOnly": "true",
	    }]
	};

	// 明细 自定义名称
	bill.leasechangegoods = {
		"title" : '合同商品',// tab页面标题
		"name" : 'leasechangegoods',// 名称 数据绑定根据此数据来匹配
		"type" : "gridbox",
		"properties" : {
			"id" : utils.createid('leasechangegoods'),
			"multiSelect" : "true",
			"allowCellEdit" : "true",
			"allowCellSelect" : "true",
			"editNextOnEnterKey" : "true",
			"editNextRowCell" : "true",
			"allowSortColumn" : "false",
			"allowCellValid" : true,
			"showPager" : false,
			"oncellbeginedit" : "OcmControl.checkboxEditor",
			"columns" : [ {
				type : "checkcolumn",
				headerAlign : "center",
				readOnly : true,
				width : 30,
			}, {
				type : "indexcolumn",
				header : "行号",
				headerAlign : "center",
			},{
			  	field : "gbid",
			  	header : "商品编码",
			  	headerAlign : "center",
			  	readOnly : true,
			  	/*align : "center",*/
			  	width : 110,
			 }, {
			  	field : "gbname",
			  	header : "商品名称",
			  	headerAlign : "center",
			  	required : true,
			  	readOnly : false,
			  	width : 110,
			 }, {
			  	field : "spid",
			  	name: "spid",
				displayField : "spname",
			  	header : "商铺",
			  	headerAlign : "center",
				editor:OcmControl.newControl('fut_popselectgrid'),
				editorSet: {
					selectkey:"zlcmfspid",
					textName :"spname",
					beforefunc:"page.det_beforefunc",
					itemchangedfunc:"page.det_itemchanged"
					}, 
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"zlcmfspid"},
			  	width : 150,
			  	required : false,
			  	readOnly : true,
			  },{
			  	field : "mid",
			  	header : "商品分类",
			  	headerAlign : "center",
			  	displayField : "mname",
				required : true,
				readOnly : false,
				editor:OcmControl.newControl('fut_popselectgrid'),
				editorSet: {
					selectkey:"goodscat",
					textName :"mname",
				}, 
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"goodscat"},
			  	width : 150,
			 }, {
			  	field : "ppcode",
			  	name: "ppcode",
			  	header : "品牌",
			  	headerAlign : "center",
			  	displayField : "ppname",
			  	editor:OcmControl.newControl('fut_popselectgrid'),
				editorSet: {
					selectkey:"ppcode",
					textName :"ppname",
					beforefunc:"page.det_beforefunc",
					itemchangedfunc:"page.det_itemchanged"}, 
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"ppcode"},
			  	width : 150,
			  	required : true,
			  	readOnly : false,
			  }, {
			  	field : "xxtax",
			  	header : "销项税率",
				headerAlign : "center",				    
			    width : 100,
			    align : "right",
			    type : "comboboxcolumn",
				editor : OcmControl.newControl('ComboBox'),
				renderer : "OcmControl.dictRendererWithCode",
				dictkey : 'XXTAXRATE',
				allowSort: true,
			  	required : true,
			  	readOnly : false,
			  	width : 100,
			  }, {
			  	field : "xftax",
			  	header : "消费税率",
			  	headerAlign : "center",				    
			    width : 100,
			    align : "right",
			    type : "comboboxcolumn",
				editor : OcmControl.newControl('ComboBox'),
				renderer : "OcmControl.dictRendererWithCode",
				dictkey : 'XFTAXRATE',
				allowSort: true,
			  	required : true,
			  	readOnly : false,
			  	width : 100,
			  },{
			  	field : "contno",
			  	header : "合同编码",
			  	visible : false,
			  	headerAlign : "center",
			 },{
			  	field : "muid",
			  	header : "门店编码",
			  	visible : false,
			  	headerAlign : "center",
			}]
		}
	};

	// 明细 自定义名称
	bill.leasechangegoodskl = {
		"title" : '商品扣率',// tab页面标题
		"name" : 'leasechangegoodskl',// 名称 数据绑定根据此数据来匹配
		"type" : "gridbox",
		"properties" : {
			"id" : utils.createid('leasechangegoodskl'),
			"multiSelect" : "true",
			"allowCellEdit" : "true",
			"allowCellSelect" : "true",
			"editNextOnEnterKey" : "true",
			"editNextRowCell" : "true",
			"allowSortColumn" : "false",
			"allowCellValid" : true,
			"showPager" : false,
			"oncellbeginedit" : "OcmControl.checkboxEditor",
			"columns" : [ {
				type : "checkcolumn",
				headerAlign : "center",
				readOnly : true,
				width : 30,
			}, {
				type : "indexcolumn",
				header : "行号",
				headerAlign : "center",
			}, {
			  	field : "gbid",
			  	header : "商品编码",
			  	headerAlign : "center",
			  	readOnly : true,
			  	/*align : "center",*/
			  	width : 110,
			}, {
				field : "sdate",
			  	header : "开始日期",
			  	width : 100,
			  	headerAlign : "center",
			  	required : true,
			  	align : "center",
			  	editor : OcmControl.newControl('DatePicker'),
			  	dataType : "date",
			  	dateFormat : "yyyy-MM-dd",
			},  {
				field : "edate",
			  	header : "结束日期",
			  	width : 100,
			  	headerAlign : "center",
			  	align : "center",
			  	required : true,
			  	editor : OcmControl.newControl('DatePicker'),
			  	dataType : "date",
			  	dateFormat : "yyyy-MM-dd",
			}, {
				field : "kl",
			  	header : "扣率",
			  	headerAlign : "center",
				editor : OcmControl.newControl('NumButtonEdit'),
			  	numberFormat : "p2",
			  	align: "right",
			  	required : true,
			  	editorSet: {format: "p2",prange:true},
			},{
				field : "memo",
			  	header : "备注",
			  	width : 300,
			  	headerAlign : "center",
			  	align : "center",
			}, {
				field : "contno",
			  	header : "合同编码",
			  	visible : false,
			  	headerAlign : "center",
			}, {
				field : "muid",
			  	header : "门店编码",
			  	visible : false,
			  	headerAlign : "center",
			}]
		}
	};

		
	var btn = Future.default.btn;
	// 按钮配置 - 固定名称
	// 按钮配置 - 固定名称
	bill.toolbarconfig = {
		id: utils.createid('systoolbar'),
		items: [btn.addData,btn.editData, btn.saveData, btn.delData,btn.separator,btn.auditData,btn.searchData]
	}

	var leasechangedet = [bill.leasechangegoods,bill.leasechangegoodskl];
	
	// 单据配置
	bill.billconfig = {
		billhead : bill.leasechangegbhd, // 单据主表
		billdetail : leasechangedet, // 单据明细表
		billquerylist : bill.leasechangelist,// 查询列表
		dettabpages : leasechangedet,// 要放入明细TAB列表的组件
		defaultmoduleid : app.modulecode,// 默认单据类型
	}

	// 创建标准单据模板
	utils.create_standardbill_config(bill);

})();
