
(function() {
	// 要引用的包
	var utils = Future.ns('Future.utils');

	// 商品信息修改
	var ns = Future.ns('goodschange.view');

	// 定义一个对象用来配置界面
	var bill = {};

	var moduleid = app.modulecode;
	var billtype=getBilltype(moduleid);
	
	var ISUPDATE = [{code:'Y',name:'是'} , {code:'N',name:'否'}];

	// 单据类型206，商品批量调整单
	/*
	var billtype_batch='102';

	if (billtype == billtype_batch) {
		$("title").html("商品信息批量调整单");
	}*/

	utils.billmoduleid = moduleid;
	
	// 把定义对象放到命名空间下
	ns.bill = bill;
	// 表头 自定义名称
	bill.gbupdatehead = {
		"title" : '单据详情',
		"name" : 'gbupdatehead',
		"type" : "formgrid",
		"resources" : OmdUrl.mall,
		"method" : "mss.commodity.goodschange.get",
		"response" : "gbupdatehead",
		"properties" : {
			"id" : utils.createid('gbupdatehead'),
		},
		items : [
				{
					"id" : "gb_bill",
					"label" : "单据信息",
					"type" : "fieldset",
					"visible" : true,
					"items" : [ {
								"label" : "ph_key：",
								"type" : "TextBox",
								"name" : "ph_key",
								"readOnly" : "true",
								"visible" : false,
							}, {
								"label" : "单据编号：",
								"name" : "billno",
								"type" : "TextBox",
								"required" : "true",
								"readOnly" : true,
								"visible" : true,
							}, {
								"label": "模块编号：",
								"name": "billmoduleid",
								"type": "TextBox",
								"defaultValue": moduleid,
								"visible": false
							}, {
								"label": "单据类型：",
								"name": "billtype",
								"type": "TextBox",
								"defaultValue": billtype,
								"visible": false
							}, {
								"label" : "单据状态：",
								"name" : "billstatus",
								"type" : "ComboBox",
								dictkey : 'BILLSTATUS',
								"defaultValue" : "N",
								"readOnly" : true,
								"visible" : true,
							}, {
								"label" : "录入人：",
								"name" : "inputer_name",
								"type" : "TextBox",
								"readOnly" : true,
								"defaultValue" : app.username,
								"visible" : true,
							}, {
								"label" : "审核人：",
								"name" : "auditor_name",
								"type" : "TextBox",
								"readOnly" : true,
								"visible" : true,
							}, {
								"label" : "手工编号：",
								"name" : "billsgno",
								"type" : "TextBox",
								"readOnly" : false,
							}, {
								"label" : "录入日期：",
								"name" : "inputdate",
								"type" : "DatePicker",
								"readOnly" : true,
								"format" : "yyyy-MM-dd HH:mm:ss",
								"defaultValue" : new Date(),
								"visible" : true,
							}, {
								"label" : "审核日期：",
								"name" : "auditdate",
								"type" : "DatePicker",
								"readOnly" : true,
								"format" : "yyyy-MM-dd HH:mm:ss",
								"visible" : true,
							} ]
				},
				{
					"id" : "gbupdatehead",
					"label" : "商品信息",
					"type" : "fieldset",
					"items" : [ {
								"label" : "门店：",
								"name" : "muid",
								"type" : "ButtonEdit",
								"required" : true,
								"defaultValue" : "",
								type : "fut_popselect",
								selectkey:"muid",
								textName :"muid_name",
							},{
								"label" : "供应商：",
								"name" : "sbid",
								"defaultValue" : "",
								displayField : "sbid_name",
								type : "fut_popselect",
								selectkey : "selfsbid",
								textName : "sbid_name",
								beforefunc : "head_beforefunc",
							}, {
								"label" : "商户名称：",
								"name" : "sbid_name",
								"type" : "TextBox",
								"required" : "true",
								"defaultValue" : "",
								visible : false,
							},{
								"label" : "柜组：",
								"name" : "spid",
								"required" : "true",
								"defaultValue" : "",
								type : "fut_popselect",
								selectkey : "selfspid",
								beforefunc : "page.head_beforefunc",
								itemchangedfunc : "page.head_itemchangedfunc",
								textName : "spid_name",
								allowSort : true,
							} ,{
								"label" : "商品类别：",
								"name" : "catcode",
								type : "fut_popselect",
								selectkey : "treeGbcatcode",
								textName : "mid_name",
								beforefunc : "page.head_beforefunc",
								itemchangedfunc : "page.head_itemchangedfunc",
								"allowInput" : true,
								"readOnly" : false,
							}, {
								"label" : "商品类别名称：",
								"name" : "mid_name",
								"type" : "TextBox",
								"required" : "true",
								"defaultValue" : "",
								visible : false,
							}, {
								"label" : "品牌：",
								"name" : "ppcode",
								type : "fut_popselect",
								selectkey : "ppcode",
								textName : "ppcode_name",
								beforefunc : "page.head_beforefunc",
								itemchangedfunc : "page.head_itemchangedfunc",
								allowInput : true,
								"readOnly" : false,
								// "style" : "display:block;float:none",
							}, {
								"label" : "品牌名称：",
								"name" : "ppcode_name",
								"type" : "TextBox",
								"required" : "true",
								"defaultValue" : "",
								visible : false,
							}, {
								"label" : "修改历史数据：",
								"name" : "isupdate",
								"type" : "ComboBox",
								// dictkey : 'ISUPDATE',
								data : ISUPDATE,
								"defaultValue" : "",
								"required" : false,
								"visible" : false,
							} ]
				}

		]
	};

	// 明细 自定义名称
	bill.gbupdatedet = {
		"title" : '商品信息',// tab页面标题
		"name" : 'gbupdatedet',// 名称 数据绑定根据此数据来匹配
		"type" : "gridbox",
		"properties" : {
			"id" : utils.createid('gbupdatedet'),
			"multiSelect" : "true",
			"allowCellEdit" : "true",
			"allowCellSelect" : "true",
			"editNextOnEnterKey" : "true",
			"editNextRowCell" : "true",
			"allowSortColumn" : "false",
			"allowCellValid" : true,
			"showPager" : false,
			"oncellbeginedit" : "OcmControl.checkboxEditor",
			"columns" : [ {
				type : "checkcolumn",
				headerAlign : "center",
				readOnly : true,
				width : 30,
			}, {
				type : "indexcolumn",
				header : "行号",
				headerAlign : "center",
			}, {
				field : "nrowid",
				header : "行主键",
				width : 80,
				allowSort : true,
				headerAlign : "center",
				visible : false
			},{
				field : "gbid",
				name : "gbid",
				header : "商品编码",
				width : 130,
				headerAlign : "center",
				required : true,
				readOnly : true,
			},{
				field: "gbbarcode",
				name: "gbbarcode",
				header: "商品条码",
				headerAlign: "center",
				allowSort: true,
				required: true,
				editor: OcmControl.newControl('fut_popselectgrid'),
                width: 120,
                editorSet: {
                selectkey: 'selfgbase',
                multiSelect: true,
                beforefunc:"page.det_beforefunc",
                itemchangedfunc:"page.det_itemchangedfunc",
                },
			},{
				field: "muid",
				name: "muid",
				header: "门店",
				headerAlign: "center",
				allowSort: true,
				//required: true,
				readOnly : true,
				visible : false,
				editor: OcmControl.newControl('fut_popselectgrid'),
                width: 160,
                displayField: "muid_name",
                editorSet: {
                selectkey: 'muid',
                multiSelect: true,
                beforefunc:"page.det_beforefunc",
                itemchangedfunc:"page.det_itemchangedfunc",
                },
			}, {
				field : "sbid",
				name: "sbid",
				header : "商户ID",
				width : 200,
				allowSort: true,
				// required: true,
				readOnly : true,
				headerAlign : "center",
				visible : false,
			},{
				field: "spid",
				name: "spid",
				header: "商铺",
				headerAlign: "center",
				allowSort: true,
				//required: true,
				readOnly : true,
				visible : false,
				editor: OcmControl.newControl('fut_popselectgrid'),
                width: 160,
                displayField: "spid_name",
                editorSet: {
                selectkey: 'spid',
                multiSelect: true,
                beforefunc:"page.det_beforefunc",
                itemchangedfunc:"page.det_itemchangedfunc",
                },
			}, {
				field : "oldgbcname",
				name: "oldgbcname",
				header : "旧商品名称",
				width : 200,
				allowSort: true,
				readOnly : true,
				headerAlign : "center",
			}, {
				field : "gbcname",
				name: "gbcname",
				header : "新商品名称",
				width : 200,
				allowSort: true,
				required: true,
				headerAlign : "center",
			},{
				field: "oldcatcode",
				name: "oldcatcode",
				header: "旧商品类别",
				headerAlign: "center",
				allowSort: true,
				// required: true,
				readOnly : true,
				editor: OcmControl.newControl('fut_popselectgrid'),
                width: 160,
                displayField: "oldmid_name",
                editorSet: {
                selectkey: 'treeGbcatcode',
                multiSelect: true,
                beforefunc:"page.det_beforefunc",
                itemchangedfunc:"page.det_itemchangedfunc",
                },
			},{
				field: "catcode",
				name: "catcode",
				header: "新商品类别",
				headerAlign: "center",
				allowSort: true,
				required: true,
				editor: OcmControl.newControl('fut_popselectgrid'),
                width: 160,
                displayField: "mid_name",
                editorSet: {
                selectkey: 'treeGbcatcode',
                multiSelect: true,
                beforefunc:"page.det_beforefunc",
                itemchangedfunc:"page.det_itemchangedfunc",
                },
			},{
				field: "oldppcode",
				name: "oldppcode",
				header: "旧品牌",
				headerAlign: "center",
				allowSort: true,
				// required: true,
				readOnly : true,
				editor: OcmControl.newControl('fut_popselectgrid'),
                width: 160,
                displayField: "oldppcode_name",
                editorSet: {
                selectkey: 'ppcode',
                multiSelect: true,
                beforefunc:"page.det_beforefunc",
                itemchangedfunc:"page.det_itemchangedfunc",
                },
			},{
				field: "ppcode",
				name: "ppcode",
				header: "新品牌",
				headerAlign: "center",
				allowSort: true,
				required: true,
				editor: OcmControl.newControl('fut_popselectgrid'),
                width: 160,
                displayField: "ppcode_name",
                editorSet: {
                selectkey: 'ppcode',
                multiSelect: true,
                beforefunc:"page.det_beforefunc",
                itemchangedfunc:"page.det_itemchangedfunc",
                },
			}, {
				field : "oldpriceaccuracy",
				name : "oldpriceaccuracy",
				headerAlign : "center",
				header : "旧售价精度",
				//vtype : "required:true",
				type : "comboboxcolumn",
				editor : OcmControl.newControl('ComboBox'),
				dictkey : 'PRICEACCURACY',
				allowSort : false,
				// required : true,
				readOnly : true,
				width : 160,
				renderer : "OcmControl.dictRendererWithCode",
			// editorSet:{onValuechanged : "page.onsptypechange"}
			}, {
				field : "priceaccuracy",
				name : "priceaccuracy",
				headerAlign : "center",
				header : "新售价精度",
				//vtype : "required:true",
				type : "comboboxcolumn",
				editor : OcmControl.newControl('ComboBox'),
				dictkey : 'PRICEACCURACY',
				allowSort : false,
				required : true,
				width : 160,
				renderer : "OcmControl.dictRendererWithCode",
			// editorSet:{onValuechanged : "page.onsptypechange"}
			},{
				field: "oldgbcdcode",
				name: "oldgbcdcode",
				header: "旧产地",
				headerAlign: "center",
				allowSort: true,
				// required: true,
				readOnly : true,
				editor: OcmControl.newControl('fut_popselectgrid'),
                width: 160,
                displayField: "oldgbcdcode_name",
                editorSet: {
                selectkey: 'coderegion',
                multiSelect: true,
                beforefunc:"page.det_beforefunc",
                itemchangedfunc:"page.det_itemchangedfunc",
                },
			},{
				field: "gbcdcode",
				name: "gbcdcode",
				header: "新产地",
				headerAlign: "center",
				allowSort: true,
				required: true,
				editor: OcmControl.newControl('fut_popselectgrid'),
                width: 160,
                displayField: "gbcdcode_name",
                editorSet: {
                selectkey: 'coderegion',
                multiSelect: true,
                beforefunc:"page.det_beforefunc",
                itemchangedfunc:"page.det_itemchangedfunc",
                },
			},{
				field : "oldspec",
				name: "oldspec",
				header : "旧规格",
				width : 200,
				allowSort: true,
				readOnly : true,
				headerAlign : "center",
			},{
				field : "newspec",
				name: "newspec",
				header : "新规格",
				width : 200,
				allowSort: true,
				headerAlign : "center",
				required: true,
			} ,{
				field : "oldcshh",
				name: "oldcshh",
				header: "旧货号",
				width : 200,
				allowSort: true,
				headerAlign : "center",
				required: true,
                readOnly : true,
			},{		
				field: "newcshh",
				name: "newcshh",
				header: "新货号",
				width : 200,
				allowSort: true,
				headerAlign : "center",
				required: true,
			}]
		}
	};


	// 查询 自定义名称
	bill.gbchangequerylist = {
		"title" : '单据列表',
		"name" : 'gbchangequerylist',
		"type" : "gridbox",
		"resources" : OmdUrl.mall,
		"method" : "mss.commodity.goodschange.search",
		"response" : "gbupdatehead",
		"canquery" : true,
		/* "manualLoad" : true, */
		"bindform" : "layouttabs", // 绑定切换的TabsBox.name
		"bindSearchParam" : [ "ph_key" ], // 明细页面查询条件字段
		"searchParam" : {
			"billtype" : billtype,
			"order_field" : "billno",
			"order_direction" : "desc"
		},
		"properties" : {
			"id" : utils.createid('gbchangequerylist'),
			"columns" : [
					{
						type : "indexcolumn",
						header : "行号",
						headerAlign : "center",
					}, {
						field : "billno",
						header : "单据编号",
						allowSort : true,
						headerAlign : "center",
						width : 140,
						enabledSearch : true,
						visible : true
					}, {
						field : "billsgno",        
						header : "手工单号",
						headerAlign : "center",
						width : 140,
						visible : true
					}, {
						field : "billstatus",
						header : "单据状态",
						allowSort : true,
						headerAlign : "center",
						renderer : "OcmControl.dictRendererWithCode",
						dictkey : 'BILLFLAG',
						width : 120,
						enabledSearch : true,
						visible : true
					},{
						field : "muid",
   						displayField : "muid_name",
   						header : "门店",
   						required : true,
   						headerAlign : "center",
   					 	editor:OcmControl.newControl('fut_popselectgrid'),
   						editorSet: {
   							selectkey:"muid",
   							textName :"muid_name",
   							}, 
   						cdEdtCfg:{compnentType:'fut_popselect',selectkey:"muid"},
   						width : 150,
					}, {
						field : "sbid",
						type : "TextBox",
						headerAlign : "center",
						header : "供应商",
						editor : OcmControl.newControl('fut_popselectgrid'),
						displayField : "sbid_name",
						cdEdtCfg : {
							compnentType : 'fut_popselect',
							selectkey : "selfsbid",
							beforefunc : "page.head_beforefunc_sbid",
						},
						visible : false,
						enabledSearch : true,
						width : 150,
					},{
						field : "sbid_name",
						type : "TextBox",
						headerAlign : "center",
						header : "供应商",
						enabledSearch : false,
						width : 150,
					},{
						field : "gbupdatedet:spid",
						headerAlign : "center",
						header : "柜组",
						width:180,
						visible:false,
					    enabledSearch : true,
						cdEdtCfg : {
							compnentType : 'fut_popselect',
							selectkey : "selfspid",
							textName : "spid_name",
							beforefunc:"page.head_beforefunc_sbids",
					}},{
						field : "spid_name",
						header : "柜组",
						headerAlign : "center",
						 enabledSearch : false,
						readOnly: true,
						width : 150,
					},{
						field : "catcode",
						type : "TextBox",
						headerAlign : "center",
						header : "商品类别",
						editor : OcmControl.newControl('fut_popselectgrid'),
						displayField : "mid_name",
						cdEdtCfg : {
							compnentType : 'fut_popselect',
							selectkey : "treeGbcatcode"
						},
						visible : false,
						enabledSearch : true,
						width : 200,
					}, {
						field : "mid_name",
						type : "TextBox",
						headerAlign : "center",
						header : "商品类别",
						enabledSearch : false,
						width : 200,
					}, {
						field : "ppcode",
						type : "TextBox",
						headerAlign : "center",
						header : "品牌",
						editor : OcmControl.newControl('fut_popselectgrid'),
						displayField : "ppcode_name",
						cdEdtCfg : {
							compnentType : 'fut_popselect',
							selectkey : "ppcode"
						},
						visible : false,
						enabledSearch : true,
						width : 200,
					}, {
						field : "ppcode_name",
						type : "TextBox",
						headerAlign : "center",
						header : "品牌",
						enabledSearch : false,
						width : 200,
					}, {
						field : "isupdate",
						header : "修改历史数据",
						width : 120,
						allowSort : true,
						headerAlign : "center",
						renderer : "OcmControl.dictRendererWithCode",
						data : ISUPDATE,
						visible : false,
						enabledSearch : false,
					},{
						field : "gbupdatedet:gbid",
						headerAlign : "center",
						header : "商品",
						width:180,
						visible:false,
					    enabledSearch : true,
						cdEdtCfg : {
							compnentType : 'fut_popselect',
							selectkey : "selfgbase",
							textName : "gbid_name",
							beforefunc : "page.head_beforefunc_gbid",
						},
					},{
						field : "inputer",
						header : "录入人",
						width : 160,
						allowSort : true,
						headerAlign : "center",	
						editor:OcmControl.newControl('fut_popselectgrid'),
						displayField : "inputer_name",
						cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"}
					},{
						field : "inputer_name",
						header : "录入人",
						width : 160,
						allowSort : true,
						headerAlign : "center",	
						visible : false,
						enabledSearch : false,
					}, {
						field : "inputdate",
						type : "date",
						dataType : "date",
						format : "yyyy-MM-dd",
						header : "录入日期",
						width : 160,
						allowSort : true,
						headerAlign : "center",
						align : "center"
					}, {
						field : "auditor",
						header : "审核人",
						width : 160,
						allowSort : true,
						headerAlign : "center",
						editor:OcmControl.newControl('fut_popselectgrid'),
						displayField : "auditor_name",
						cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"}
					}, {
						field : "auditor_name",
						header : "审核人",
						width : 160,
						allowSort : true,
						headerAlign : "center",
						visible : false,
						enabledSearch : false,
					}, {
						field : "auditdate",
						type : "date",
						format : "yyyy-MM-dd",
						header : "审核日期",
						width : 160,
						dataType : "date",
						allowSort : true,
						headerAlign : "center",
						align : "center"
					} ]
		}
	};

	var btn = Future.default.btn;
	// 按钮配置 - 固定名称
	bill.toolbarconfig = {
		id : utils.createid('systoolbar'),
		// items : Future.pub.Basebill.default_toolsbar
		items : [ btn.addData, btn.editData, btn.delData, btn.saveData,
			btn.separator, btn.auditData, btn.separator, btn.searchData ]
	}

	// 单据配置
	bill.billconfig = {
		billhead : bill.gbupdatehead, // 单据主表
		billdetail : [bill.gbupdatedet], // 单据明细表
		billquerylist : bill.gbchangequerylist,// 查询列表
		dettabpages : [bill.gbupdatedet],// 要放入明细TAB列表的组件
		defaultmoduleid : app.modulecode,// 默认单据类型
	}

	// 创建标准单据模板
	utils.create_standardbill_config(bill);

})();
