(function() {
	// 要引用的包
	var utils = Future.ns('Future.utils');	
	// 商品信息修改
	var ns = Future.ns('selfsupadjust.view');
	// 定义一个对象用来配置界面
	var bill = {};

	var moduleid = app.modulecode;
	var billtype=getBilltype(moduleid);
	
	var wmid = [{code: '1',name: '经销',ddvalue: '[1]经销'},{code: '2',name: '成本代销',ddvalue: '[2]成本代销'},{code: '3',name: '扣率代销',ddvalue: '[3]扣率代销'}];

	utils.billmoduleid = moduleid;	
	// 把定义对象放到命名空间下
	ns.bill = bill;
	
	// 单据列表
	bill.badjustsuplist = {
		"title" : '单据列表',
		"name" : 'badjustsuplist',
		"type" : "gridbox",
		"resources" : OmdUrl.mall,
		"method" : "mss.commodity.badjustsup.search",
		"response" : "badjustsuphead",
		"canquery" : true,
		"bindform" : "layouttabs", // 绑定切换的TabsBox.name
		"bindSearchParam" : [ "ph_key" ], // 明细页面查询条件字段
		"searchParam" : {
			"billtype" : billtype,
			"order_field" : "billno",
			"order_direction" : "desc"
		},
		"properties" : {
			"id" : utils.createid('badjustsuplist'),
			"columns" : [
					{
						type : "indexcolumn",
						header : "行号",
						headerAlign : "center",
					}, {
						field : "billno",
						header : "单据编号",
						allowSort : true,
						headerAlign : "center",
						width : 145,
						enabledSearch : true,
						visible : true
					}, {
						field : "billsgno",        
						header : "手工单号",
						headerAlign : "center",
						width : 140,
						visible : false
					}, {
						field : "billstatus",
						header : "单据状态",
						allowSort : true,
						headerAlign : "center",
						renderer : "OcmControl.dictRendererWithCode",
						dictkey : 'BILLFLAG',
						width : 90,
						enabledSearch : true,
						visible : true
					}, {
						field: "muid",
						type: "TextBox",
						headerAlign: "center",
						header: "门店",
						editor:OcmControl.newControl('fut_popselectgrid'),
						displayField : "muid_name",
						cdEdtCfg:{compnentType:'fut_popselect',selectkey:"muid"},
						visible:false,
						enabledSearch : false,
					}, {
						field: "muid_name",
						type: "TextBox",
						headerAlign: "center",
						header: "门店",
						visible:false,
						enabledSearch : false,
						width: 160,
					}, {
						field : "effdate",
						header : "生效日期",
						type: "DatePicker",
						headerAlign: "center",
						dataType: "date",
						dateFormat: "yyyy-MM-dd",
						width: 100,
				   }, {
						field : "newcontno",
						header : "新合同号",
						headerAlign : "center",
						readOnly: true,
						allowSort : true,
						width: 90,
				  }, {
					   field : "newsupid",
					   displayField : "newsbid_name",
					   header : "新供应商",
					   headerAlign : "center",
					   cdEdtCfg : {
							compnentType : 'fut_popselect',
							beforefunc : "head_beforefunc",
							selectkey : "supcode",
							textName : "newsbid_name",
							responseName : "sbid_name"
						},
						readOnly : true,
						width : 160,
				  }, {
					   field : "newwmid",
					   header : "新经营方式",
					   width : 90,
					   allowSort : true,
					   headerAlign : "center",
					   renderer : "OcmControl.dictRendererWithCode",
					   dictkey : 'WMID',
				  }, {
					   field : "contno",
					   header : "原合同号",
					   headerAlign : "center",
					   readOnly: true,
					   allowSort : true,
					   width: 90,
				  }, {
					   field : "supid",
					   displayField : "sbid_name",
					   header : "原供应商",
					   headerAlign : "center",
					   cdEdtCfg : {
							compnentType : 'fut_popselect',
							beforefunc : "head_beforefunc",
							selectkey : "supcode",
							textName : "sbid_name",
							responseName : "sbid_name"
						},
						readOnly : true,
						width : 160,
				 }, {
					   field : "wmid",
					   header : "原经营方式",
					   width : 100,
					   allowSort : true,
					   headerAlign : "center",
					   renderer : "OcmControl.dictRendererWithCode",
					   dictkey : 'WMID',
					   width : 90,
					   /*enabledSearch : false*/ 
				 }, {
					   field : "mfid",
					   displayField : "spid_name",
					   headerAlign : "center",
					   header : "柜组",
					   width:160,
					   enabledSearch : true,
					   cdEdtCfg : {
							compnentType : 'fut_popselect',
							selectkey : "spcode",
							textName : "spid_name",
					  },
					  width: 200,
				}, {
					 header : "是否转换库存",
					 type : "checkboxcolumn",
					 field : "iszkc",
					 trueValue : "Y",
					 falseValue : "N",
					 readOnly : false,
					 enabled: true,
					 width: 95,
			  }, {
					 field : "badjustsupdet:gbid",
					 headerAlign : "center",
					 header : "商品",
					 width:100,
					 visible:false,
					 enabledSearch : true,
					 cdEdtCfg : {
						compnentType : 'fut_popselect',
						selectkey : "gbid",
						textName : "gbid_name",
					 },
			     }, {
						field : "inputer",
						header : "录入人",
						width : 130,
						allowSort : true,
						headerAlign : "center",	
						editor:OcmControl.newControl('fut_popselectgrid'),
						displayField : "inputer_name",
						cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"}
				 }, {
						field : "inputer_name",
						header : "录入人",
						width : 130,
						allowSort : true,
						headerAlign : "center",	
						visible : false,
						enabledSearch : false,
				 }, {
						field : "inputdate",
						type : "date",
						dataType : "date",
						format : "yyyy-MM-dd",
						header : "录入日期",
						width : 130,
						allowSort : true,
						headerAlign : "center",
						align : "center"
				 }, {
						field : "auditor",
						header : "审核人",
						width : 130,
						allowSort : true,
						headerAlign : "center",
						editor:OcmControl.newControl('fut_popselectgrid'),
						displayField : "auditor_name",
						cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"}
				 }, {
						field : "auditor_name",
						header : "审核人",
						width : 130,
						allowSort : true,
						headerAlign : "center",
						visible : false,
						enabledSearch : false,
				 }, {
						field : "auditdate",
						type : "date",
						format : "yyyy-MM-dd",
						header : "审核日期",
						width : 130,
						dataType : "date",
						allowSort : true,
						headerAlign : "center",
						align : "center"
				} ]
		}
	};
	
	// 表头 自定义名称
	bill.badjustsuphead = {
		"title" : '单据明细',
		"initHeight" : 0.35,
		"name" : 'badjustsuphead',
		"type" : "formgrid",
		"resources" : OmdUrl.mall,
		"method" : "mss.commodity.badjustsup.get",
		"response" : "badjustsuphead",
		"properties" : {
			"id" : utils.createid('badjustsuphead'),
		},
		items: [{
				"label": "ph_key：",
				"name": "ph_key",
				"type": "TextBox",
				"visible": false,
			  }, {
				 "label": "单据编号：",
				 "name": "billno",
				 "type": "TextBox",
				 "readOnly": true,
				 "visible": true,
			  }, {
				 "label": "模块编号：",
				 "name": "billmoduleid",
				 "type": "TextBox",
				 "defaultValue": app.modulecode,
				 "visible": false,
			  }, {
				"label": "单据类型：",
				"name": "billtype",
				"type": "TextBox",
				"defaultValue": getBilltype(app.modulecode),
				"visible": false
			  }, {
				 "label" : "手工编号：",
				 "name" : "billsgno",
				 "type" : "TextBox",
				 "readOnly" : false,
				 "visible": false
			  }, {
				 "label": "单据状态：",
				 "name": "billstatus",
				 "type": "ComboBox",
				 dictkey: 'BILLSTATUS',
				 "readOnly": true,
				 "defaultValue": "N",
			  }, {
				 "label": "生效日期：",
				 "name": "effdate",
				 "type": "DatePicker",
				 "format" : "yyyy-MM-dd",
				 "required" : "true",
				 "enabled" : true,
				 "value" : mini.formatDate(new Date(), "yyyy-MM-dd"),
				 "defaultValue" : mini.formatDate(new Date(), "yyyy-MM-dd"),
				 "onValuechanged" : "page.onEffdateChange", 
			  }, {
				 "label" : "新合同号：",
				 "name" : "newcontno",
				 type : "fut_popselect",
				 selectkey : "supcontno",
				 textName : "newcontno",
				 beforefunc : "page.head_beforefunc",
				 itemchangedfunc : "page.head_itemchangedfunc",
				 "allowInput" : true,
				 "required" : true,
		    }, {
				 "label" : "新供应商：",
				 "name" : "newsupid",
				 "defaultValue" : "",
				 displayField : "newsbid_name",
				 type : "fut_popselect",
				 selectkey : "supcode",
				 textName : "newsbid_name",
				 "readOnly" : true,
		    }, {
				 "label" : "新经营方式：",
				 "name" : "newwmid",
				 "type" : "ComboBox",
			     data : wmid,
				 "readOnly" : true,
		    }, {
				 "label" : "原合同号：",
				 "name" : "contno",
				 type : "fut_popselect",
				 selectkey : "supcontno",
				 textName : "contno",
				 beforefunc : "page.head_beforefunc",
				 itemchangedfunc : "page.head_itemchangedfunc",
				 "allowInput" : true,
				 "required" : true,
		   }, {
				"label" : "原供应商：",
				"name" : "supid",
				"readOnly" : true,
				"defaultValue" : "",
				displayField : "sbid_name",
				type : "fut_popselect",
				selectkey : "supcode",
				textName : "sbid_name",
			}, {
				"label" : "原经营方式：",
				"name" : "wmid",
				"type" : "ComboBox",
				"readOnly" : true,
				data : wmid,
			}, {
				"label": "柜组：",
				"name": "mfid",
				"type": "fut_popselect",
				selectkey: "selfspcode",
				textName: "spid_name",
				allowInput: true,
				beforefunc : "page.head_beforefunc",
			}, {
				"label": "柜组编码：",
				"name": "spid_name",
				"type": "TextBox",
				 readOnly: true,
				 visible: false
			},{
				"text" : "是否转换库存：",
				"type" : "CheckBox",
				"name" : "iszkc",
				"trueValue" : "Y",
				"falseValue" : "N",
				"defaultValue" : 'Y', 
				"readOnly" : false,
				"enabled": true,
				"style" : "width:69%;"
				/*"style" : "display:block;float:none",*/
			}, {
				"label": "门店：",
				"name": "muid",
				"type": "fut_popselect",
				selectkey: "muid",
				textName: "muid_name",
				allowInput: true,
				beforefunc : "page.head_beforefunc",
				"visible": false,
			}, {
				"label": "录入人：",
				"type": "TextBox",
				"name": "inputer_name",
				"readOnly": "true",
			}, {
				"label": "审核人：",
				"type": "TextBox",
				"name": "auditor_name",
				"readOnly": "true",
				"style" : "display:block;float:none",
			}, {
				"label": "录入日期：",
				"type": "DatePicker",
				"name": "inputdate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
			}, {
				"label": "审核日期：",
				"type": "DatePicker",
				"name": "auditdate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"readOnly": "true",
			}, {
				"label": "录入人编码",
				"type": "TextBox",
				"name": "inputer",
				"visible": false,
			}, {
				"label": "最后修改日期：",
				"type": "DatePicker",
				"name": "lastmoddate",
				"format": "yyyy-MM-dd HH:mm:ss",
				"visible": false,
			}
		]
	};
	
	// 明细 自定义名称
	bill.badjustsupdet = {
		"title" : '商品信息',// tab页面标题
		"name" : 'badjustsupdet',// 名称 数据绑定根据此数据来匹配
		"type" : "gridbox",
		"properties" : {
			"id" : utils.createid('badjustsupdet'),
			"multiSelect" : "true",
			"allowCellEdit" : "true",
			"allowCellSelect" : "true",
			"editNextOnEnterKey" : "true",
			"editNextRowCell" : "true",
			"allowSortColumn" : "false",
			"allowCellValid" : true,
			"showPager" : false,
			"oncellbeginedit" : "OcmControl.checkboxEditor",
			"columns" : [ {
					type : "checkcolumn",
					headerAlign : "center",
					readOnly : true,
					width : 30,
				}, {
					type : "indexcolumn",
					header : "行号",
					headerAlign : "center",
				}, {
					field : "drowno",
					header : "行号",
					width : 80,
					allowSort : true,
					headerAlign : "center",
					visible : false
				},{
					field: "gbid",
					name: "gbid",
					header: "商品编码",
					/*headerAlign: "center",
					allowSort: true,
					required: true,
					editor: OcmControl.newControl('fut_popselectgrid'),
	                width: 120,
	                editorSet: {
	                selectkey: 'gbaseid',
	                multiSelect: true,
	                beforefunc:"page.det_beforefunc",
	                itemchangedfunc:"page.det_itemchangedfunc",
	                readOnly : true,
	                },*/
					width : 120,
					allowSort: true,
					readOnly : true,
					headerAlign : "center",
				},{
					field : "gbbarcode",
					name : "gbbarcode",
					header : "商品条码",
					editor: OcmControl.newControl('fut_popselectgrid'),
					width : 130,
					headerAlign : "center",
					required : true,
					editorSet: {
		                selectkey: 'selfbarcodein',
		                multiSelect: true,
		                beforefunc:"page.det_beforefunc",
		                itemchangedfunc:"page.det_itemchangedfunc",
					},
				},{
					field : "gbname",
					name: "gbname",
					header : "商品名称",
					width : 130,
					allowSort: true,
					readOnly : true,
					headerAlign : "center",
				},{
					field: "mfid",
					name: "mfid",
					header: "柜组",
					headerAlign: "center",
					allowSort: true,
					readOnly : true,
					editor: OcmControl.newControl('fut_popselectgrid'),
	                width: 160,
	                displayField: "spid_name",
	                editorSet: {
	                selectkey: 'spcode',
	                multiSelect: true,
	                },
				},{
					field: "ppcode",
					name: "ppcode",
					header: "品牌",
					headerAlign: "center",
					allowSort: true,
					readOnly : true,
					editor: OcmControl.newControl('fut_popselectgrid'),
	                width: 150,
	                displayField: "ppcode_name",
	                editorSet: {
	                selectkey: 'ppcode',
	                multiSelect: true,
	                },
				},{
					field: "catcode",
					name: "catcode",
					header: "商品类别",
					headerAlign: "center",
					allowSort: true,
					readOnly : true,
					editor: OcmControl.newControl('fut_popselectgrid'),
	                width: 140,
	                displayField: "catcode_name",
	                editorSet: {
	                selectkey: 'treeGbcatcode',
	                multiSelect: true,
	                },
				}, {
					field : "supid",
					displayField : "sbid_name",
					header : "原供应商",
					headerAlign : "center",
					readOnly : true,
					width : 160,
					editor : OcmControl.newControl('fut_popselectgrid'),
					editorSet: {
						selectkey:"supcode",
						textName :"sbid_name",
						}, 
					cdEdtCfg:{
						   compnentType:'fut_popselect',
						   selectkey:"supcode"  },
				},{
					field : "wmid",
					headerAlign : "center",
					header : "原经营方式",
					type : "comboboxcolumn",
					editor : OcmControl.newControl('ComboBox'),
					renderer : "OcmControl.dictRendererWithCode",
					dictkey : 'WMID',
					readOnly : true,
					width : 95,
				},{
					field : "newsupid",
					displayField : "newsbid_name",
					header : "新供应商",
					headerAlign : "center",
					readOnly : true,
					width : 160,
					editor : OcmControl.newControl('fut_popselectgrid'),
					editorSet: {
						selectkey:"supcode",
						textName :"newsbid_name",
						}, 
					cdEdtCfg:{
						compnentType:'fut_popselect',
						selectkey:"supcode" },
				},{
					field : "newwmid",
					headerAlign : "center",
					header : "新经营方式",
					type : "comboboxcolumn",
					editor : OcmControl.newControl('ComboBox'),
					renderer : "OcmControl.dictRendererWithCode",
					dictkey : 'WMID',
					readOnly : true,
					width : 95,
				}]
		}
	};

	var btn = Future.default.btn;
	// 按钮配置 - 固定名称
	bill.toolbarconfig = {
		id : utils.createid('systoolbar'),
		// items : Future.pub.Basebill.default_toolsbar
		items : [ btn.addData, btn.editData, btn.delData, btn.saveData,
			btn.separator, btn.auditData, btn.separator, btn.searchData ]
	}

	// 单据配置
	bill.billconfig = {
		billhead : bill.badjustsuphead, // 单据主表
		billdetail : [bill.badjustsupdet], // 单据明细表
		billquerylist : bill.badjustsuplist,// 查询列表
		dettabpages : [bill.badjustsupdet],// 要放入明细TAB列表的组件
		defaultmoduleid : app.modulecode,// 默认单据类型
	}

	// 创建标准单据模板
	utils.create_standardbill_config(bill);

})();
