/**
 * 特卖商品生效单 --- 界面定义
 */
(function() {
	// 要引用的包
	var utils = Future.ns('Future.utils');
	
	var col = Future.ns('default.col');
	// 命名空间
	var ns = Future.ns('specialsalegdeff.view');

	// 定义一个对象用来配置界面
	var bill = {};

	var moduleid = app.modulecode;
	
	var dictData = OcmControl.getDict("WMID,CMPMMID,GBSTATUS,PRICEACCURACY,GBJJFS,GBISYJ,GBTYPE,CMPHSFF,GMFSTATUS,GMFTAXTYPE","code,name,pro1,ddvalue")

	// 把定义对象放到命名空间下
	ns.bill = bill;
	// 表头 自定义名称
	bill.gbupdatehead = {
		"name" : 'gbupdatehead',
		"initHeight" : 0.3,
		"type" : "formgrid",
		"resources" : OmdUrl.mall,
		"method" : "mss.commodity.gbupdatehead.get",
		"response" : "gbupdatehead",
		"properties" : {
			"id" : utils.createid('gbupdatehead'),
		},
		items : [{
			"label": "ph_key：",
			"name": "ph_key",
			"type": "TextBox",
			"visible": false,
		}, {
			"label": "单据编号：",
			"name": "billno",
			"type": "TextBox",
			"readOnly": true,
			"visible": true,
		},{
			"label": "单据编号：",
			"name": "billsgno",
			"type": "TextBox",
			"readOnly": true,
			"visible": false,
		}, {
			"label": "模块编号：",
			"name": "billmoduleid",
			"type": "TextBox",
			"defaultValue": app.modulecode,
			"visible": false
		}, {
			"label": "单据类型：",
			"name": "billtype",
			"type": "TextBox",
			"defaultValue": getBilltype(app.modulecode),
			"visible": false
		}, {
			"label": "单据状态：",
			"name": "billstatus",
			"type": "ComboBox",
			dictkey: 'BILLSTATUS',
			"readOnly": true,
			"defaultValue": "N",
			"style" : "display:block;float:none"
		},{
			"label" : "门店：",
			"name" : "muid",
			"type" : "ButtonEdit",
			"required" : true,
			"defaultValue" : "",
			type : "fut_popselect",
			selectkey:"muid",
			textName :"muid_name",
			beforefunc:"page.head_beforefunc",
			itemchangedfunc:"page.head_itemchangedfunc_muid", 
		},{
			"label" : "商户：",
			"name" : "sbid",
			"required" : false,
			"defaultValue" : "",
			type : "fut_popselect",
			selectkey:"sbid",
			textName :"sbid_name",
			beforefunc:"page.head_beforefunc",
			itemchangedfunc:"page.head_itemchangedfunc_sbid", 
		},{
			"label" : "商铺：",
			"name" : "spid",
			"required" : false,
			"defaultValue" : "",
			type : "fut_popselect",
			selectkey : "spid",
			textName : "spid_name",
			beforefunc:"page.head_beforefunc",
			itemchangedfunc:"page.head_itemchangedfunc_spid",
			allowSort : true,
		},{
			"label" : "录入人：",
			"name" : "inputer_name",
			"type" : "TextBox",
			"defaultValue" : app.username,
			"readOnly" : true,
		}, {
			"label" : "录入人",
			"name" : "inputer",
			"type" : "TextBox",
			"readOnly" : true,
			"visible":false,
		},{
			"label" : "审核人：",
			"name" : "auditor_name",
			"type" : "TextBox",
			"readOnly" : true,
		},{
			"label" : "审核人姓名",
			"name" : "auditor",
			"type" : "TextBox",
			"readOnly" : true,
			"visible":false,
		},{
			"label" : "取消人：",
			"name" : "canceler_name",
			"type" : "TextBox",
			"readOnly" : true,
			"style" : "display:block;float:none",
		}, {
			"label" : "取消人姓名",
			"name" : "canceler",
			"type" : "TextBox",
			"readOnly" : true,
			"visible":false,
		},{
	        "label" : "录入日期：",
	        "type" : "DatePicker",
	        "name" : "inputdate",
	        "format" : "yyyy-MM-dd HH:mm:ss",
	        "defaultValue" : new Date(),
	        "readOnly" : "true",
	    },{
            "label": "审核日期：",
            "type": "DatePicker",
            "name": "auditdate",
            "format": "yyyy-MM-dd HH:mm:ss",
            "readOnly": "true",
	    },{
            "label": "取消日期：",
            "type": "DatePicker",
            "name": "canceldate",
            "format": "yyyy-MM-dd HH:mm:ss",
            "readOnly": "true",
            "style" : "display:block;float:none",
	    }
	]
	};

	// 明细 自定义名称
	bill.gbupdatedet = {
		"title" : '商品列表',// tab页面标题
		"name" : 'gbupdatedet',// 名称 数据绑定根据此数据来匹配
		"type" : "gridbox",
		"properties" : {
			"id" : utils.createid('gbupdatedet'),
			"multiSelect" : "true",
			"allowCellEdit" : "true",
			"allowCellSelect" : "true",
			"editNextOnEnterKey" : "true",
			"editNextRowCell" : "true",
			"allowSortColumn" : "false",
			"allowCellValid" : true,
			"showPager" : false,
			"oncellbeginedit" : "OcmControl.checkboxEditor",
			"columns" : [ {
				type : "checkcolumn",
				headerAlign : "center",
				readOnly : true,
				width : 30,
			}, {
				type : "indexcolumn",
				header : "行号",
				headerAlign : "center",
			},{
				field: "gbid",
				name: "gbid",
				header: "商品编码",
				headerAlign: "center",
				allowSort: true,
				required: true,
				editor: OcmControl.newControl('fut_popselectgrid'),
                width: "150px",
                editorSet: {
                selectkey: 'gbids',
                multiSelect: true,
                beforefunc:"page.head_beforefunc",
                itemchangedfunc:"page.head_itemchangedfunc_gbid",
                },
			},{
				field : "gbbarcode",
				header : "商品条码",
				headerAlign : "center",
				allowSort : true,
				readOnly : true,
				visible : false,
				width : "160",
			},{
				field : "gbcname",
				header : "商品名称",
				headerAlign : "center",
				allowSort : true,
				readOnly : true,
				width : "160",
			},{
				field : "muid",
				header : "门店",
				headerAlign : "center",
				editor : OcmControl.newControl('fut_popselectgrid'),
				displayField : "muid_name",
				cdEdtCfg : {
					compnentType : 'fut_popselect',
					selectkey : "muid"
				},
				allowSort : true,
				readOnly : true,
				width : "160",
			},{
				field : "muid_name",
				header : "门店名称",
				headerAlign : "center",
				allowSort : true,
				readOnly : true,
				visible : false,
				width : "160",
			},{
				field : "spid",
				header : "商铺",
				headerAlign : "center",
				editor : OcmControl.newControl('fut_popselectgrid'),
				displayField : "spid_name",
				cdEdtCfg : {
					compnentType : 'fut_popselect',
					selectkey : "spid"
				},
				allowSort : true,
				readOnly : true,
				width : "160",
			},{
				field : "spid_name",
				header : "商铺名称",
				headerAlign : "center",
				allowSort : true,
				readOnly : true,
				visible : false,
				width : "160",
			},{
				field : "sbid",
				header : "商户名称",
				headerAlign : "center",
				editor : OcmControl.newControl('fut_popselectgrid'),
				displayField : "sbid_name",
				cdEdtCfg : {
					compnentType : 'fut_popselect',
					selectkey : "sbid"
				},
				allowSort : true,
				readOnly : true,
				width : "160",
			},{
				field : "sbid_name",
				header : "商户名称",
				headerAlign : "center",
				allowSort : true,
				readOnly : true,
				visible : false,
				width : "160",
			},{
				field : "catcode",
				header : "商品类别",
				headerAlign : "center",
				displayField : "mid_name",
				allowSort : true,
				readOnly : true,
				width : "160",
			},{
				field : "mid_name",
				header : "商品类别名称",
				headerAlign : "center",
				allowSort : true,
				readOnly : true,
				visible : false,
				width : "160",
			},{
				field : "ppcode",
				header : "品牌",
				headerAlign : "center",
				displayField : "ppcode_name",
				allowSort : true,
				readOnly : true,
				width : "160",
			},{
				field : "ppcode_name",
				header : "品牌名称",
				headerAlign : "center",
				allowSort : true,
				readOnly : true,
				visible : false,
				width : "160",
			},{
				field : "gbisyj",
				headerAlign : "center",
				header : "是否定价",
				allowSort : true,
				readOnly : true,
				visible : false,
				width : "160",
			},{
				field : "oldgmpsj",
				header : "售价",
				headerAlign : "center",
				width : 120,
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet : {
					format : "c2",
				},
				numberFormat : "c2",
				defaultValue : "0",
				align : "right",
				readOnly : true
			
			},{
				field : "gmpsj",
				header : "新售价",
				headerAlign : "center",
				width : 120,
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet : {
					format : "c2",
				},
				numberFormat : "c2",
				defaultValue : "0",
				align : "right",
				readOnly : false
			
			},{
				field : "gbjjfs",
				headerAlign : "center",
				header : "计价方式",
				type : "comboboxcolumn",
				editor : OcmControl.newControl('ComboBox'),
				renderer : "OcmControl.dictRendererWithCode",
				dictkey : 'GBJJFS',
				value : "4",
				allowSort : true,
				readOnly : true,
				visible : false,
				width : "160",
			},{
				field : "oldgmpkl",
				header : "扣率",
				headerAlign : "center",
				editor : OcmControl.newControl('TextBox'),
				width : "120",
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{format: "p2",},
				numberFormat:"p2",
				defaultValue : "0",
				align : "right",
				readOnly : true
			
			},{
				field : "gmpkl",
				header : "新扣率",
				headerAlign : "center",
				editor : OcmControl.newControl('TextBox'),
				width : 120,
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{format: "p2",},
				numberFormat:"p2",
				defaultValue : "0",
				align : "right",
			
			},{
				field : "gmfjkfd",
				header : "降扣幅度",
				headerAlign : "center",
				width : 120,
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{format: "p2",},
				numberFormat:"p2",
				defaultValue : "0",
				align : "right",
				readOnly : true
			
			} ]
		}
	};

	// 明细 自定义名称
	bill.gbupdatetime = {
		"title" : '特卖时间段',// tab页面标题
		"name" : 'gbupdatetime',// 名称 数据绑定根据此数据来匹配
		"type" : "gridbox",
		"properties" : {
			"id" : utils.createid('gbupdatetime'),
			"multiSelect" : "true",
			"allowCellEdit" : "true",
			"allowCellSelect" : "true",
			"editNextOnEnterKey" : "true",
			"editNextRowCell" : "true",
			"allowSortColumn" : "false",
			"allowCellValid" : true,
			"showPager" : false,
			"oncellbeginedit" : "OcmControl.checkboxEditor",
			"columns" : [ {
				type : "checkcolumn",
				headerAlign : "center",
				readOnly : true,
				width : 30,
			}, {
				type : "indexcolumn",
				header : "行号",
				headerAlign : "center",
			}, {
				field : "sdate", // 免租期开始日期
				header : "开始日期",
				headerAlign : "center",
				align : "center",
				required : true,
				editor : OcmControl.newControl('DatePicker'),
				dataType : "date",
				dateFormat : "yyyy-MM-dd",
				width : 120,
			}, {
				field : "edate", // 免租期结束日期
				header : "结束日期",
				headerAlign : "center",
				align : "center",
				required : true,
				editor : OcmControl.newControl('DatePicker'),
				dataType : "date",
				dateFormat : "yyyy-MM-dd",
				width : 120,
			},{
				field : "sum",
				header : "周日",
				type : "checkboxcolumn",
				headerAlign : "center",
				trueValue : "Y",
				falseValue : "N",
				value:"Y",
				allowSort : true,
				readOnly : false,
				width : "120",
			},{
				field : "mon",
				header : "周一",
				type : "checkboxcolumn",
				headerAlign : "center",
				trueValue : "Y",
				falseValue : "N",
				value:"Y",
				allowSort : true,
				readOnly : false,
				width : "120",
			},{
				field : "tue",
				header : "周二",
				type : "checkboxcolumn",
				headerAlign : "center",
				trueValue : "Y",
				falseValue : "N",
				value:"Y",
				allowSort : true,
				readOnly : false,
				width : "120",
			},{
				field : "wed",
				header : "周三",
				type : "checkboxcolumn",
				headerAlign : "center",
				trueValue : "Y",
				falseValue : "N",
				value:"Y",
				allowSort : true,
				readOnly : false,
				width : "120",
			},{
				field : "thu",
				header : "周四",
				type : "checkboxcolumn",
				headerAlign : "center",
				trueValue : "Y",
				falseValue : "N",
				value:"Y",
				allowSort : true,
				readOnly : false,
				width : "120",
			},{
				field : "fri",
				header : "周五",
				type : "checkboxcolumn",
				headerAlign : "center",
				trueValue : "Y",
				falseValue : "N",
				value:"Y",
				allowSort : true,
				readOnly : false,
				width : "120",
			},{
				field : "sat",
				header : "周六",
				type : "checkboxcolumn",
				headerAlign : "center",
				trueValue : "Y",
				falseValue : "N",
				value:"Y",
				allowSort : true,
				readOnly : false,
				width : "120",
			} ]
		}
	};

	// 查询 自定义名称
	bill.gbupdateheadquerylist = {
		"title" : '单据列表',
		"name" : 'gbupdateheadquerylist',
		"type" : "gridbox",
		"resources" : OmdUrl.mall,
		"method" : "mss.commodity.gbupdatehead.search",
		"response" : "gbupdatehead",
		"canquery" : true,
		/* "manualLoad" : true, */
		"bindform" : "layouttabs", // 绑定切换的TabsBox.name
		"bindSearchParam" : [ "ph_key" ], // 明细页面查询条件字段
		"searchParam" : {
			"billtype" : getBilltype(app.modulecode),
			"order_field" : "billno",
			"order_direction" : "desc"
		},
		"properties" : {
			"id" : utils.createid('gbupdateheadquerylist'),
			"columns" : [
					{
						type : "indexcolumn",
						header : "行号",
						headerAlign : "center",
					}, {
						field : "billno",
						header : "单据编号",
						allowSort : true,
						headerAlign : "center",
						width : 140,
						enabledSearch : true,
						visible : true
					}, {
						field : "billstatus",
						header : "单据状态",
						allowSort : true,
						headerAlign : "center",
						renderer : "OcmControl.dictRendererWithCode",
						dictkey : 'BILLFLAG',
						width : 120,
						enabledSearch : true,
						visible : true
					}, {
						field : "muid",
						type : "TextBox",
						headerAlign : "center",
						header : "门店",
						editor : OcmControl.newControl('fut_popselectgrid'),
						displayField : "muid_name",
						cdEdtCfg : {
							compnentType : 'fut_popselect',
							selectkey : "muid"
						},
						visible : true,
						enabledSearch : true,
						width : 200,
					},{
						field : "spid",
						type : "TextBox",
						headerAlign : "center",
						header : "商铺",
						editor : OcmControl.newControl('fut_popselectgrid'),
						displayField : "spid_name",
						cdEdtCfg : {
							compnentType : 'fut_popselect',
							selectkey : "spid"
						},
						visible : true,
						enabledSearch : true,
						width : 200,
					},{
						field : "sbid",
						type : "TextBox",
						headerAlign : "center",
						header : "商户",
						editor : OcmControl.newControl('fut_popselectgrid'),
						displayField : "sbid_name",
						cdEdtCfg : {
							compnentType : 'fut_popselect',
							selectkey : "sbid"
						},
						visible : true,
						enabledSearch : true,
						width : 200,
					},{
						field : "inputer",
						header : "录入人",
						width : 160,
						allowSort : true,
						headerAlign : "center",	
						editor:OcmControl.newControl('fut_popselectgrid'),
						displayField : "inputer_name",
						cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
						visible : true,
						enabledSearch : true,
					},{
						field : "inputer_name",
						header : "录入人",
						width : 160,
						allowSort : true,
						headerAlign : "center",	
						visible : false,
						enabledSearch : false,
					}, {
						field : "inputdate",
						type : "date",
						dataType : "date",
						format : "yyyy-MM-dd",
						header : "录入日期",
						width : 160,
						allowSort : true,
						headerAlign : "center",
						align : "center",
						visible : true,
						enabledSearch : true,
					}, {
						field : "auditor",
						header : "审核人",
						width : 160,
						allowSort : true,
						headerAlign : "center",
						editor:OcmControl.newControl('fut_popselectgrid'),
						displayField : "auditor_name",
						cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
						visible : true,
						enabledSearch : true,
					}, {
						field : "auditor_name",
						header : "审核人",
						width : 160,
						allowSort : true,
						headerAlign : "center",
						visible : false,
						enabledSearch : false,
					}, {
						field : "auditdate",
						type : "date",
						format : "yyyy-MM-dd",
						header : "审核日期",
						width : 160,
						dataType : "date",
						allowSort : true,
						headerAlign : "center",
						align : "center",
						visible : true,
						enabledSearch : true,
					}, {
						field : "canceler",
						header : "取消人",
						width : 160,
						allowSort : true,
						headerAlign : "center",
						editor:OcmControl.newControl('fut_popselectgrid'),
						displayField : "canceler_name",
						cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
						visible : true,
						enabledSearch : true,
					}, {
						field : "canceler_name",
						header : "取消人",
						width : 160,
						allowSort : true,
						headerAlign : "center",
						visible : false,
						enabledSearch : false,
					}, {
						field : "canceldate",
						type : "date",
						format : "yyyy-MM-dd",
						header : "取消日期",
						width : 160,
						dataType : "date",
						allowSort : true,
						headerAlign : "center",
						align : "center",
						visible : true,
						enabledSearch : true,
					} ]
		}
	};

	var btn = Future.default.btn;
	// 按钮配置 - 固定名称
	// 按钮配置 - 固定名称
	bill.toolbarconfig = {
		id: utils.createid('systoolbar'),
		items: [btn.addData,btn.editData, btn.saveData, btn.delData,btn.separator,btn.auditData,btn.cancelData,btn.searchData]
	}

	var termination = [ bill.gbupdatedet,bill.gbupdatetime ];

	// 单据配置
	bill.billconfig = {
		billhead : bill.gbupdatehead, // 单据主表
		billdetail : termination, // 单据明细表
		billquerylist : bill.gbupdateheadquerylist,// 查询列表
		dettabpages : termination,// 要放入明细TAB列表的组件
		defaultmoduleid : app.modulecode,// 默认单据类型
	}

	// 创建标准单据模板
	utils.create_standardbill_config(bill);

})();
