﻿<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
    <title>商品选择列表</title>
    <script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
    <style>
    .mini-itemsbutton {
    	border: none;
    	background: none;
    	display: inline-block;
    	padding: 0;
    	height: 21px;
    	margin-bottom: 5px;
    	text-align: right;
    }
    .mini-itemsbutton .mini-button {
    	margin: 0 0 0 5px;
    }
    </style>
</head>
<body>  
   
   	<div class="ocm-formheader" config="formheader1"></div>
  
	<div class="mini-fit">
		<div class="ocm-gridbox" config="config1"></div>
	</div>
	
	<div style="padding:5px;text-align:center;">
		<a name="ok" class="mini-button" iconCls="icon-ok" style="margin-right:40px;" onclick="onOkClick">确定</a>
		<a name="cancel" class="mini-button" iconCls="icon-cancel" onclick="onCancelClick">取消</a>
	</div>

<script type="text/javascript">
// 自定义控件
  mini.ItemsButton = function() {
    mini.ItemsButton.superclass.constructor.call(this);
    this.init();
  };

  mini.extend(mini.ItemsButton, mini.ToolBar, {

    uiCls: 'mini-itemsbutton',

		config: {
			items: [[
			{
				"text": "查询",
				"type": "Button",
				"name": "searchData",
				"enabled": true,
				"style": "width:70px",
				"onclick": "onSearchDataClick",
			}, {
				"text": "清除",
				"type": "Button",
				"name": "clearData",
				"enabled": true,
				"style": "width:70px",
				"onclick": "onClearDataClick",
			}]]
		},


    init: function() {

      this.set({
        'name': 'toolbar',
        'buttonItems': this.config.items,
        'cls': 'mini-itemsbutton',
      });

    },

    setButtonItems: function(items) {
      if (!mini.isArray(items)) return;
      var separators = [];
      for (var x = 0; x < items.length; x++) {
        for (var i = 0; i < items[x].length; i++) {
          if (this.id.indexOf('_') > -1) {
            var prefix = (this.id).split('_')[0] || '';
            items[x][i]['name'] = prefix + '_' + items[x][i]['name'];
          }
          // 设置默认点击事件
          this['btn_' + items[x][i].name] = new mini.Button();
          this['btn_' + items[x][i].name].set(items[x][i]);
          this['btn_' + items[x][i].name].render(this.getEl());
        }

        if (x < items.length - 1 && items.length > 2) {
          separators[i] = new mini.Separator();
          separators[i].set({cls: 'separator toolbar_separator'});
          separators[i].removeCls('mini-separator');
          separators[i].render(this.getEl());
        }
      }
    },

  });

  mini.regClass(mini.ItemsButton, 'itemsbutton');



	var formheader1 = {
		"type" : "formgrid",
		"properties" : {
			"id" : "formheader1",
			"style" : "padding:5 0 0 0px",
		},
		items : [ {
			"label" : "商品编码：",
			"type" : "TextBox",
			"name" : "item_code",
			"enabled" : true,
			"style" : "width:33%;",
		}, {
			"label" : "商品名称：",
			"type" : "TextBox",
			"name" : "item_name",
			"enabled" : true,
			"style" : "width:33%;",
		}, {
			"label" : "商品条码：",
			"type" : "TextBox",
			"name" : "barcode",
			"enabled" : true,
			"style" : "width:33%;",
		}, {
			"label" : "商品品牌：",
			"type" : "ButtonEdit",
			"name" : "brand_code",
			"enabled" : true,
			"style" : "width:33%;",
			"displayField" : "brand_name",
			"onbuttonclick" : "onPpcodeClick",
			"onValuechanged" : "onPpcodeChange",
		}, {
			"label" : "商品类别：",
			"type" : "ButtonEdit",
			"name" : "cat_code",
			"enabled" : true,
			"style" : "width:33%;",
			"displayField" : "cat_name",
			"onbuttonclick" : "onGoodstypeClick",
			"onValuechanged" : "onGoodstypeChange",
		}, {
			"text" : "查询",
			"type" : "ItemsButton",
			"name" : "searchData",
			"enabled": true,
			"style" : "width:33%;text-align: right",
		}]
	};

	var config1 = {
		"type" : "gridbox",
		"resources" : OmdUrl.mdm,
		"method" : "ocm.mdm.goods.searchbyorg",
		"response" : "item_business",
		"manualLoad" : true,
		"searchParam" : {},
        "uniqueField": "item_code",
		"properties" : {
			"id" : "gridbox1",
			"onrowdblclick" : "onRowDblClick",
			"multiSelect" : true,
			"columns" : [ {
				type : "checkcolumn",
				headerAlign : "center",
			}, {
				type : "indexcolumn",
				header : "行号",
				headerAlign : "center",
			}, {
				field : "item_code",
				name : "code",
				header : "商品编码",
				allowSort : true,
				headerAlign : "center",
				width : 80,
			}, {
				field : "item_name",
				name : "name",
				header : "商品名称",
				allowSort : true,
				headerAlign : "center",
				width : 300,
			}, {
				field : "barcode",
				name : "barcode",
				header : "商品条码",
				allowSort : true,
				headerAlign : "center",
				width : 120,
			}, {
				field : "sale_price",
				name : "sale_price",
				header : "参考售价",
				allowSort : true,
				headerAlign : "center",
				width : 70,
				numberFormat : "#,0.00",
				vtype :"float",
				align: "right",
				renderer : "onPriceRenderer",
			}, {
				field : "brand_name",
				name : "brand_name",
				header : "商品品牌",
				allowSort : true,
				headerAlign : "center",
				width : 100,
				renderer : "onBrandRenderer",
			}, {
				field : "cat_name",
				name : "cat_name",
				header : "商品类别",
				allowSort : true,
				headerAlign : "center",
				width : 100,
				renderer : "onCatRenderer",
			}, {
				field : "spec",
				header : "规格",
				allowSort : true,
				headerAlign : "center",
				width : 80,
			}, {
				field : "unit",
				header : "计量单位",
				allowSort : true,
				headerAlign : "center",
				width : 80,
			} ]
		},
	};
	
	mini.parse();
	
	function onRowDblClick(e) {
		onOkClick();
    }
</script>
	<script src="item.js" type="text/javascript"></script>
</body>
</html>