// 几种状态字典风格
var statusForbidden = [{code: "Y", name: "正常"}, {code: "N", name: "禁用"}];
var statusYesNo = [{code: "Y", name: "是"}, {code: "N", name: "否"}];
var statusValid = [{code:"Y",name:"有效"},{code:"N",name:"无效"}];

//获取字典数据
function getDict(str, _fields) {
    var fields = _fields || "dcode,dname";
    var _dicData = {};
    if (str) {
        var searchParam = {
            fields: fields,
            dictype: str
        };
        itemLoader.doRequest(OmdUrl.mall, "mall.work.dict.getDictByGroupCode", searchParam, null, null, function (data) {
            _dicData = data;
        }, null, null, false);
    }
    if (!_dicData.YESORNO) {
        _dicData.YESORNO = [{code: "Y", name: "是"}, {code: "N", name: "否"}];
    }
    return _dicData;
};

function getCodeChargeDict(str) {
        var rtncode;
        var searchParam = {
            "ccdeftype": {"$in": str},
        };
        itemLoader.doRequest(OmdUrl.mallmdm,
            "mall.mdm.codecharge.search", searchParam, null,
            null, function (data) {
                rtncode = data.codecharge;
            }, null, null, false);
        return rtncode;
};

//获取glborule规则
function getGrobrule(ruleid) {
    var _data;
    var searchParam = {
        ruleid: ruleid
    }
    itemLoader.doRequest(OmdUrl.mall, "mall.common.globrule.getRuleDef", searchParam,
        null, null, function (data) {
            _data = data.globrule;
        }, null, null, false);
    return _data;
};

//获取多个参数的规则
function getGrobruleList(ruleidStr) {
    var _globData = {};
    var searchParam = {
        ruleid: ruleidStr
    }
    itemLoader.doRequest(OmdUrl.mall, "mall.common.globrule.getRuleList", searchParam,
        null, null, function (data) {
            _globData = data.globrule;
        }, null, null, false);
    return _globData;
};

function getRulemode(ruleid) {
    var rulemode = "";
    var globrule = getGrobrule(ruleid);
    if (globrule && globrule.rulemode) {
        rulemode = globrule.rulemode;
    }
    return rulemode;
};

//报表打印配置
function getReportConfig(billmoduleid) {
    var _data;
    var reportfile = "";
    var searchParam = {
        moduleid: billmoduleid
    }
    itemLoader.doRequest(OmdUrl.mallmdm, "mall.mdm.reportconfig.search", searchParam, null, null, function (data) {
        if (data && data.reportconfig.length > 0) {
            _data = data.reportconfig;
            reportfile = _data[0].reportfile;
        }
    }, null, null, false);
    return reportfile;
};

//判断字符长度
function getByteLen(val) {    //传入一个字符串
    var len = 0;
    for (var i = 0; i < val.length; i++) {
        if (val[i].match(/[^\x00-\xff]/ig) != null) //全角
            len += 2; //如果是全角，占用两个字节
        else
            len += 1; //半角占用一个字节
    }
    return len;
};

Future.Pub.DictSrv.setconfig({
    url: OmdUrl.mall,
    method: 'mall.work.dict.getDictByGroupCode',
    fields: 'dcode,dname'
});
Future.Pub.DictSrv.service.mss = {
    url: OmdUrl.mall,
    method: 'mall.work.dict.getDictByGroupCode',
    fields: 'dcode,dname'
};
Future.Pub.DictSrv.loadDatabase = function (str, _fields) {
    var fields = _fields || this.config.fields;
    var searchParam = {
        'fields': fields,
        'dictype': str
    };
    var _dicData = {};
    if (!str) {
        return _dicData;
    }
    itemLoader.doRequest(this.config.url, this.config.method,
        searchParam, null, null,
        function (data) {
            _dicData = data;
        }, null, null, false);
    return _dicData;
};
app.repaint.modelData = function (tablename, isflag) {
    var dictData = "";
    var searchParam = {};
    if (app.repaint.billmoduleid != undefined && app.repaint.billmoduleid != "") {
        searchParam.billmoduleid = app.repaint.billmoduleid;
    }
    if (tablename != undefined && tablename != "") {
        searchParam.tablename = tablename;
    }
    if (isflag != undefined && isflag != "") {
        searchParam.isflag = isflag;
    }
    itemLoader.doRequest(OmdUrl.mall, "mall.work.model.search",
        searchParam, null, null, function (data) {
            dictData = data.modelhead[0];
        }, null, null, false);

    if (dictData == undefined || dictData == "") {
        return "";
    }
    searchParam = {};
    searchParam.ph_key = dictData["ph_key"];
    itemLoader.doRequest(OmdUrl.mall, "mall.work.model.get",
        searchParam, null, null, function (data) {
            dictData = data.modelhead;
        }, null, null, false);
    return dictData;
};

//获取单据类型
function getBilltype(billmoduleid) {
    var billtype = "";
    var searchParam = {"modeid": billmoduleid};
    var method = "mall.work.billmain.search";
    itemLoader.doRequest(OmdUrl.mall, method, searchParam, null, null, function (data) {
        var data = data.billmain;
        if (data.length > 0) {
            billtype = data[0].billtype;
        }
    }, null, null, false);
    return billtype;
}

//根据单据类型获取单据模块号
function getBillmoduleid(billtype) {
    var billmoduleid = "";
    var searchParam = {"billtype": billtype, "order_field": "modeid"};
    var method = "mall.work.billmain.search";
    itemLoader.doRequest(OmdUrl.mall, method, searchParam, null, null, function (data) {
        var data = data.billmain;
        if (data.length > 0) {
            billmoduleid = data[0].modeid;
        }
    }, null, null, false);
    return billmoduleid;
}

//获取参数值
function getManaPara(muid, mpcode) {
    var _data;
    var vmpvalue = "";
    var searchParam = {
        "fields": "mpvalue",
        "mpcode": mpcode,
        "mpmkt": muid
    };
    itemLoader.doRequest(OmdUrl.mallmdm, "mall.mdm.manapara.search", searchParam, null, null, function (data) {
        _data = data.manapara;
        if (!_data || _data.length == 0) {
            var searchParam = {
                "fields": "mpvalue",
                "mpcode": mpcode,
                "mpmkt": "00"
            };
            itemLoader.doRequest(OmdUrl.mallmdm, "mall.mdm.manapara.search", searchParam, null, null, function (data) {
                _data = data.manapara;
                if (_data && _data.length > 0) {
                    vmpvalue = _data[0].mpvalue;
                }
            }, null, null, false);
        } else {
            vmpvalue = _data[0].mpvalue;
        }
    }, null, null, false);
    return vmpvalue;
};

//获取modulerelation表模块信息
function getModelmoduleid(billmoduleid) {
    var _data = {};
    var searchParam = {
        modeid: billmoduleid
    }
    itemLoader.doRequest(OmdUrl.mall, "mall.work.modulerelation.getModelRelation", searchParam, null, null, function (data) {
        if (data) {
            _data = data.modulerelation;
        }
    }, null, null, false);
    return _data;
};

function getDictMdmBySelectKey(selectkey, addAll, page_size) {
    var selectconfig = $.extend(true, {}, Future.Query.getConfig(selectkey));
    var dic = [];
    if (page_size) {
        selectconfig.searchParam.page_size = page_size;
    }
    itemLoader.doRequest(selectconfig.resources,
        selectconfig.method, selectconfig.searchParam, null,
        null, function (data) {
            dic = data[selectconfig.response];
            if (selectconfig.searchParam.addAll || addAll) {
                dic.push({[selectconfig.responseCode]: "ALL", [selectconfig.responseName]: "所有"});
            }
        }, null, null, false);
    return dic;
};

//获取经营主体,union 0门店
function getCompany() {
    var compTemp = [];
    var searchParam = {
        "fields": "coid, coname",
        order_field: "coid",
    };
    itemLoader.doRequest(OmdUrl.mallmdm, "mall.mdm.comp.search", searchParam, null, null, function (data) {
        if (data.company.length > 0) {
            var companyindex = {"code": "0", "name": "门店"};
            var company = data.company;
            compTemp.push(companyindex);
            for (var i = 0; i < company.length; i++) {
                companyindex = {
                    "code": company[i].coid,
                    "name": company[i].coname
                };
                compTemp.push(companyindex);
            }
        }
    }, null, null, false);
    return compTemp;
};

//获取账单日
function getSettleDay() {
    var zdaytemp = [];
    var searchParam = {
        "fields": "code, name",
        "code": {"<>": "0"},
        order_field: "orderno, code",
    };
    itemLoader.doRequest(OmdUrl.mallmdm, "mall.mdm.setbillday.search", searchParam, null, null, function (data) {
        if (data) {
            zdaytemp = data.setbillday;
        }
    }, null, null, false);
    return zdaytemp;
};

//获取年增长规则
function getAnnualGrowthRule() {
    var searchParam = {
        billstatus: 'Y',
        "order_field": "billno",
        "order_direction": "desc",
    };
    var _date = {};
    itemLoader.doRequest(OmdUrl.mall, "mall.work.chargeincrule.search", searchParam, null, null, function (data) {
        _date = data.chargeincrulehd;
    }, null, null, false);
    return _date;
};

//获取结算组
function getSetGroupDef() {
    var setgroupTemp = [];
    var searchParam = {
        "fields": "setgroupcode, sgdname",
    };
    itemLoader.doRequest(OmdUrl.mall, "mall.work.settlegroupdef.search", searchParam, null, null, function (data) {
        if (data.result == '0') {
        } else {
            var temp = data.settlegroupdef;
            for (var i = 0; i < temp.length; i++) {
                var row = {
                    code: temp[i].setgroupcode,
                    name: temp[i].sgdname
                };
                setgroupTemp.push(row);
            }
        }
    }, null, null, false);
    return setgroupTemp;
};

//获取账单类型
function getSettleBillDef() {
    var settleDefTemp = [];
    var searchParam = {
        "fields": "setbtypecode, sbdname",
        "sbdstatus" : "Y"
    };
    itemLoader.doRequest(OmdUrl.mallmdm, "mall.mdm.settlebilldef.search", searchParam, null, null, function (data) {
        if (data.result == '0') {
        } else {
            var temp = data.settlebilldef;
            for (var i = 0; i < temp.length; i++) {
                var row = {
                    code: temp[i].setbtypecode,
                    name: temp[i].sbdname
                };
                settleDefTemp.push(row);
            }
        }
    }, null, null, false);
    return settleDefTemp;
};

//获取费用提取方式 去除余款
function getCodeChargeDefTypeQy() {
    var chargeTemp = [];
    var searchParam = {
        "fields": "cdtcode, cdtcname",
        "cdtcode": {"<>": "7"},
        "cdtstatus" : "Y",
        order_field: "cdtcode",
    };
    itemLoader.doRequest(OmdUrl.mallmdm, "mall.mdm.codechargedeftype.search", searchParam, null, null, function (data) {
        if (data.codechargedeftype) {
            var charge = data.codechargedeftype;
            for (var i = 0; i < charge.length; i++) {
                var row = {
                    "code": charge[i].cdtcode,
                    "name": charge[i].cdtcname
                };
                chargeTemp.push(row);
            }
        }
    }, null, null, false);
    return chargeTemp;
};

//获取费用类型
function getCodeChargeType() {
    var chargeTemp = [];
    var searchParam = {
        "fields": "cctcode, cctcname",
        order_field: "cctcode",
    };
    itemLoader.doRequest(OmdUrl.mallmdm, "mall.mdm.codechargetype.search", searchParam, null, null, function (data) {
        if (data.codechargetype) {
            var charge = data.codechargetype;
            for (var i = 0; i < charge.length; i++) {
                var row = {
                    "code": charge[i].cctcode,
                    "name": charge[i].cctcname
                };
                chargeTemp.push(row);
            }
        }
    }, null, null, false);
    return chargeTemp;
};

//获取费用类型 ALL
function getAllCodeChargeType(){
    var allChargeTemp = [];
    var charge = getCodeChargeType();
    var all = {code:"ALL",name:"所有"};
    allChargeTemp.push(all);
    allChargeTemp.push(charge);
    return allChargeTemp;
}

//获取税务分类定义
function getTaxClass() {
    var taxTemp = [];
    var searchParam = {
        "fields": "taxcode,taxname",
        'taxflag': "Y",
        'taxstatus': "Y",
        'order_field': "taxcode",
        'order_direction': "asc"
    };
    itemLoader.doRequest(OmdUrl.mallmdm, "mall.mdm.taxclass.search", searchParam, null, null, function (data) {
        if (data.taxclass) {
            var tax = data.taxclass;
            for (var i = 0; i < tax.length; i++) {
                var row = {
                    "code": tax[i].taxcode,
                    "name": tax[i].taxname
                };
                taxTemp.push(row);
            }
        }
    }, null, null, false);
    return taxTemp;
};