/**
 * 公共查询接口配置
 */
//省份/城市
Future.Query.Config.coderegion = {
    winurl: "/mall-business-ui/pages/wizard/gridbox-view.jsp?key=coderegion",
    title: "省份/城市选择",
    resources: OmdUrl.mallmdm,
    method: "mall.mdm.region.search",
    responseCode: "crcode",
    responseName: "crcname",
    response: "coderegion",
    multiSelect: false,
    manualLoad: false,
    searchParam: {
        fields: "crcode, crcname, crclass, crpcode",
        order_field: "crcode",
    },
    columns: [{
        type: "checkcolumn",
        headerAlign: "center",
    }, {
        type: "indexcolumn",
        header: "行号",
        headerAlign: "center",
    }, {
        field: "crcode",
        name: "code",
        header: "编码",
        allowSort: true,
        headerAlign: "center",
    }, {
        field: "crcname",
        name: "name",
        header: "名称",
        allowSort: true,
        headerAlign: "center",
    }]
};

//组织机构树形(门店资料维护中的上级编码)
Future.Query.Config.treemdmorg = {
    winurl: "/mall-business-ui/pages/wizard/treebox-view.jsp?key=treemdmorg",
    title: "机构部门选择",
    resources: OmdUrl.mallmdm,
    method: "mall.mdm.org.search",
    responseCode: "mfid",
    responseName: "mfcname",
    responseId: "mfid",
    response: "manaorg",
    rootCode: "1",
    rootName: "总部",
    width: 0.35,
    // height : 0.6,
    manualLoad: false,
    rootAll: "1",
    rootAllname: "总部",
    searchParam: {
        fields: "mfid, mfcname, mfpid",
        order_field: "mfid",
        "$and": [{"$or": [{"mftypecode": "M"}, {"$and": [{"mftypecode": "1"}, {"muid": ""}]}]}],
        "mfid": {"<>": "1"},
    },
    editorSet: {
        idField: "mfid",
        parentField: "mfpid",
    }
};

//门店弹框
Future.Query.Config.muid = {
    winurl: "/mall-business-ui/pages/wizard/gridbox-view.jsp?key=muid",
    title: "门店代码选择",
    resources: OmdUrl.mallmdm,
    method: "mall.mdm.mkt.search",
    responseCode: "muid",
    responseName: "mucname",
    responseId: "muid",
    response: "manaunit",
    multiSelect: false,
    manualLoad: false,
    searchParam: {
        fields: "muid, mucname, crcname",
        order_field: "muid",
    },
    columns: [{
        type: "checkcolumn",
        headerAlign: "center",
    }, {
        type: "indexcolumn",
        header: "行号",
        headerAlign: "center",
    }, {
        field: "muid",
        header: "编码",
        allowSort: true,
        headerAlign: "center",
    }, {
        field: "mucname",
        header: "名称",
        allowSort: true,
        headerAlign: "center",
    }, {
        field: "crcname",
        header: "城市名",
        allowSort: true,
        headerAlign: "center",
        visible: false,
    }]
};

//组织机构
Future.Query.Config.mdmorg = {
    winurl: "/mall-business-ui/pages/wizard/gridbox-view.jsp?key=mdmorg",
    title: "组织机构",
    resources: OmdUrl.mallmdm,
    method: "mall.mdm.org.search",
    responseId: "mfid",
    responseCode: "mfid",
    responseName: "mfcname",
    response: "manaorg",
    multiSelect: false,
    manualLoad: false,
    searchParam: {
        fields: "mfid, mfcname, mfpid",
        order_field: "mfid",
    }
};

//商户弹框(门店商户)
Future.Query.Config.supmkt = {
    winurl: "/mall-business-ui/pages/wizard/gridbox-view.jsp?key=supmkt",
    title: "商户",
    // width: 0.65,
    resources: OmdUrl.mallmdm,
    method: "mall.mdm.sup.search",
    responseCode: "sbid",
    responseName: "sbcname",
    responseSbdz: "sbdz",
    responseId: "sbid",
    response: "supplierbase",
    multiSelect: false,
    manualLoad: false,
    searchParam: {
        order_field: "sbid",
        "sbstatus": {"<>": "N"},
    },
    columns: [{
        type: "checkcolumn",
        headerAlign: "center",
    }, {
        type: "indexcolumn",
        header: "行号",
        headerAlign: "center",
    }, {
        field: "sbid",
        header: "商户编码",
        allowSort: true,
        headerAlign: "center",
    }, {
        field: "sbcname",
        header: "商户中文名称",
        allowSort: true,
        headerAlign: "center",
    }, {
        field: "sbdz",
        header: "店招",
        allowSort: true,
        headerAlign: "center",
    }, {
        field: "sbstatus",
        header: "商户状态",
        allowSort: true,
        headerAlign: "center",
        visible : false,
    }]
};

//商铺弹框(租赁合同)
Future.Query.Config.zlcmfspid = {
    winurl: "/mall-business-ui/pages/wizard/gridbox-view.jsp?key=zlcmfspid",
    title: "商铺",
    resources: OmdUrl.mallmdm,
    method: "mall.mdm.shop.search",
    responseCode: "spid",
    responseName: "spcname",
    responseId: "spid",
    response: "shoplist",
    multiSelect: false,
    manualLoad: false,
    searchParam: {
        order_field: "spid",
    },
    columns: [{
        type: "checkcolumn",
        headerAlign: "center",
    }, {
        type: "indexcolumn",
        header: "行号",
        headerAlign: "center",
    }, {
        field: "spid",
        header: "商铺编码",
        allowSort: true,
        headerAlign: "center",
        width: 150
    }, {
        field: "spcname",
        header: "商铺名称",
        allowSort: true,
        headerAlign: "center",
    }, {
        field: "spbuildarea",
        header: "建筑面积",
        allowSort: true,
        headerAlign: "center",
        align: "right",
    }, {
        field: "splettarea",
        header: "套内面积",
        allowSort: true,
        headerAlign: "center",
        align: "right",
    }, {
        field: "muid",
        header: "门店",
        allowSort: true,
        headerAlign: "center",
        width: 150,
        visible : false,
    }, {
        field: "spstatus",
        header: "状态",
        allowSort: true,
        headerAlign: "center",
        visible : false,
    }, {
        field: "sptype",
        header: "商铺类型",
        allowSort: true,
        headerAlign: "center",
        visible : false,
    }, {
        field: "region",
        header: "上级编码",
        allowSort: true,
        headerAlign: "center",
        width: 200,
        visible : false,
    }]
};

// 合同弹框
Future.Query.Config.contno = {
    winurl: "/mall-business-ui/pages/contract/com/searchcontno-view.jsp?key=contno",
    title: "合同选择",
    resources: OmdUrl.mallmdm,
    // width: 0.5,
    method: "mall.mdm.contract.search",
    responseCode: "contno",
    responseName: "",
    responseContno: "contno",
    responseSbid: "sbid",
    responseMuid: "muid",
    response: "contmain",
    multiSelect: false,
    manualLoad: false,
    searchParam: {
        order_field: "contno",
    },
    columns: [{
        type: "checkcolumn",
        headerAlign: "center",
    }, {
        type: "indexcolumn",
        header: "行号",
        headerAlign: "center",
    }, {
        field: "contno",
        header: "合同号",
        allowSort: true,
        headerAlign: "center",
        // width: 80,
    }, {
        field: "muid",
        header: "门店",
        allowSort: true,
        headerAlign: "center",
        width: 120,
        visible :false,
    }, {
        field: "sbid",
        header: "商户",
        allowSort: true,
        headerAlign: "center",
        visible :false,
    }, {
        field: "wmid",
        header: "经营方式",
        allowSort: true,
        headerAlign: "center",
        visible: false,
        width: 80,
        visible :false,
    }, {
        field: "cmeffdate",
        header: "生效日期",
        allowSort: true,
        headerAlign: "center",
        dataType: "date",
        dateFormat: "yyyy-MM-dd",
    }, {
        field: "cmlapdate",
        header: "失效日期",
        allowSort: true,
        headerAlign: "center",
        // width: 100,
        dataType: "date",
        dateFormat: "yyyy-MM-dd",
    }]
};

//品牌
Future.Query.Config.ppcode = {
    winurl: "/mall-business-ui/pages/wizard/gridbox-view.jsp?key=ppcode",
    title: "品牌",
    resources: OmdUrl.mallmdm,
    method: "mall.mdm.brand.search",
    responseCode: "ppcode",
    responseName: "ppcname",
    response: "codebrand",
    multiSelect: false,
    manualLoad: false,
    searchParam: {
        order_field: "ppcode",
        "ppstatus": "Y",
        order_direction: "asc"
    },
    columns: [{
        type: "checkcolumn",
        headerAlign: "center",
    }, {
        type: "indexcolumn",
        header: "行号",
        headerAlign: "center",
    }, {
        field: "ppcode",
        header: "编码",
        allowSort: true,
        headerAlign: "center",
    }, {
        field: "ppcname",
        header: "名称",
        allowSort: true,
        headerAlign: "center",
    }]
};
// 品牌的经营种类
Future.Query.Config.brandcat = {
    winurl: "/mall-business-ui/pages/wizard/gridbox-view.jsp?key=brandcat",
    title: "品类",
    resources: OmdUrl.mallmdm,
    method: "mall.mdm.brand.get",
    responseCode: "mcid",
    responseName: "mcname",
    response: "codebrand",
    childrenResponse: "brandmanacat",
    responseId: "mcid",
    multiSelect: false,
    manualLoad: false,
    searchParam: {
        "fields": "ppcode,brandmanacat"
    },
    columns: [{
        type: "checkcolumn",
        headerAlign: "center",
    }, {
        type: "indexcolumn",
        header: "行号",
        headerAlign: "center",
    }, {
        field: "mcid",
        header: "编码",
        allowSort: true,
        headerAlign: "center",
    }, {
        field: "mcname",
        header: "名称",
        allowSort: true,
        headerAlign: "center",
    }]
};
// 经营种类
Future.Query.Config.cat = {
    winurl: "/mall-business-ui/pages/wizard/gridbox-view.jsp?key=cat",
    title: "品类",
    resources: OmdUrl.mallmdm,
    method: "mall.mdm.manacat.search",
    responseCode: "mcid",
    responseName: "mcname",
    response: "manacat",
    responseId: "mcid",
    multiSelect: false,
    manualLoad: false,
    searchParam: {
        "mcflag": "Y",
        "mcstatus": 'Y',
        order_field: "mcid",
    },
    columns: [{
        type: "checkcolumn",
        headerAlign: "center",
    }, {
        type: "indexcolumn",
        header: "行号",
        headerAlign: "center",
    }, {
        field: "mcid",
        header: "编码",
        allowSort: true,
        headerAlign: "center",
    }, {
        field: "mcname",
        header: "名称",
        allowSort: true,
        headerAlign: "center",
    }]
};

//合同费用项目
Future.Query.Config.contcccode = {
    winurl: "/mall-business-ui/pages/wizard/gridbox-view.jsp?key=contcccode",
    title: "费用项目",
    resources: OmdUrl.mallmdm,
    method: "mall.mdm.codecharge.search",
    responseCode: "cccode",
    responseName: "cccname",
    responseId: "cccode",
    response: "codecharge",
    multiSelect: false,
    manualLoad: false,
    searchParam: {
        order_field: "cccode",
    },
    columns: [{
        type: "checkcolumn",
        headerAlign: "center",
    }, {
        type: "indexcolumn",
        header: "行号",
        headerAlign: "center",
    }, {
        field: "cccode",
        header: "编码",
        allowSort: true,
        headerAlign: "center",
    }, {
        field: "cccname",
        header: "名称",
        allowSort: true,
        headerAlign: "center",
    }, {
        field: "ccdeftype",
        header: "费用提取方式",
        allowSort: true,
        headerAlign: "center",
        visible: false,
    }, {
        field: "ccdeftype_name",
        header: "费用提取方式",
        allowSort: true,
        headerAlign: "center",
    }]
};

//费用提取方式
Future.Query.Config.chargetype = {
    winurl: "/mall-business-ui/pages/wizard/gridbox-view.jsp?key=chargetype",
    title: "费用提取方式",
    resources: OmdUrl.mallmdm,
    method: "mall.mdm.codechargedeftype.search",
    responseCode: "cdtcode",
    responseName: "cdtcname",
    responseId: "cdtcode",
    response: "codechargedeftype",
    multiSelect: false,
    manualLoad: false,
    searchParam: {
        order_field: "cdtcode",
    },
    columns: [{
        type: "checkcolumn",
        headerAlign: "center",
    }, {
        type: "indexcolumn",
        header: "行号",
        headerAlign: "center",
    }, {
        field: "cdtcode",
        header: "编码",
        allowSort: true,
        headerAlign: "center",
    }, {
        field: "cdtcname",
        header: "名称",
        allowSort: true,
        headerAlign: "center",
    }]
};

//上级编码
Future.Query.Config.treeMmfidno = {
    winurl: "/mall-business-ui/pages/wizard/treebox_mmfid-view.jsp?key=treeMmfidno",
    title: "上级编码选择",
    resources: OmdUrl.mallmdm,
    method: "mall.mdm.mktmanaframe.search",
    responseId: "mmfid",
    responseCode: "mmfid",
    responseName: "mmfcname",
    response: "mktmanaframe",
    width: 0.3,
    height: 0.6,
    rootCode: "muid",
    rootName: "上级编码",
    manualLoad: false,
    searchParam: {
        fields: "mmfid, mmfcname, mmfpid, muid, mmclass, mmfflag",
        order_field: "mmfid",
    },
    editorSet: {
        idField: "mmfid",
        parentField: "mmfpid",
        showFolderCheckBox: false,
    }
};
//费用代码
Future.Query.Config.cccode = {
    winurl: "/mall-business-ui/pages/wizard/gridbox-view.jsp?key=cccode",
    title: "费用代码选择",
    resources: OmdUrl.mallmdm,
    method: "mall.mdm.codecharge.search",
    responseCode: "cccode",
    responseName: "cccname",
    responseId: "cccode",
    response: "codecharge",
    multiSelect: false,
    manualLoad: false,
    searchParam: {
        order_field: "cccode",
    },
    columns: [{
        type: "checkcolumn",
        headerAlign: "center",
    }, {
        type: "indexcolumn",
        header: "行号",
        headerAlign: "center",
    }, {
        field: "cccode",
        header: "编码",
        allowSort: true,
        headerAlign: "center",
    }, {
        field: "cccname",
        header: "名称",
        allowSort: true,
        headerAlign: "center",
    }]
};

//部门
Future.Query.Config.mana = {
    winurl: "/mall-business-ui/pages/wizard/gridbox-view.jsp?key=mana",
    title: "部门",
    resources: OmdUrl.mallmdm,
    method: "mall.mdm.mktmanaframe.search",
    responseCode: "mmfid",
    responseName: "mmfcname",
    responseId: "mmfid",
    response: "mktmanaframe",
    multiSelect: false,
    manualLoad: false,
    searchParam: {
        fields: "mmfid, mmfcname, muid",
        mmfflag: "Y",
        order_field: "mmfid",
    },
    columns: [{
        type: "checkcolumn",
        headerAlign: "center",
    }, {
        type: "indexcolumn",
        header: "行号",
        headerAlign: "center",
    }, {
        field: "mmfid",
        header: "编码",
        allowSort: true,
        headerAlign: "center",
    }, {
        field: "mmfcname",
        header: "名称",
        allowSort: true,
        headerAlign: "center",
    }]
};

//商品分类树形(租赁商品)
Future.Query.Config.treegbcatcode = {
    winurl: "/mall-business-ui/pages/wizard/treebox_selfcat-view.jsp?key=treegbcatcode",
    title: "商品类别选择",
    resources: OmdUrl.mallmdm,
    method: "mall.mdm.goodscat.search",
    responseCode: "catcode",
    responseName: "catcname",
    responseId: "catcode",
    response: "goodscat",
    rootCode: "0",
    width: 0.3,
    height: 0.6,
    rootName: "所有分类",
    manualLoad: false,
    searchParam: {
        order_field: "catcode",
        nsta: "2021",
    },
    editorSet: {
        idField: "catcode",
        parentField: "catpcode",
        showFolderCheckBox: false,
    }
};

//服务器组
Future.Query.Config.servergroup = {
    winurl: "/mall-business-ui/pages/wizard/gridbox-view.jsp?key=servergroup",
    title: "服务器组",
    resources: OmdUrl.mallmdm,
    method: "mall.mdm.sysservergroup.search",
    responseCode: "ssggroupid",
    responseName: "ssggroupname",
    response: "sys_servergroup",
    multiSelect: false,
    manualLoad: false,
    searchParam: {
        order_field: "ssggroupid",
    },
    columns: [{
        type: "checkcolumn",
        headerAlign: "center",
    }, {
        type: "indexcolumn",
        header: "行号",
        headerAlign: "center",
    }, {
        field: "ssggroupid",
        header: "分组编码",
        allowSort: true,
        headerAlign: "center",
    }, {
        field: "ssggroupname",
        header: "分组名称",
        allowSort: true,
        headerAlign: "center",
    }]
};

//新功能模块
Future.Query.Config.modeidnew = {
    winurl: "/mall-business-ui/pages/wizard/gridbox-view.jsp?key=modeidnew",
    title: "事物选择",
    resources: OmdUrl.mallmdm,
    method: "mall.mdm.billmain.search",
    responseCode: "modeid",
    responseName: "billname",
    response: "billmain",
    multiSelect: false,
    manualLoad: false,
    searchParam: {
        order_field: "modeid",
    }
};

//商户
Future.Query.Config.sbid = {
    winurl: "/mall-business-ui/pages/wizard/gridbox-view.jsp?key=sbid",
    title: "商户选择",
    resources: OmdUrl.mallmdm,
    method: "mall.mdm.sup.search",
    responseCode: "sbid",
    responseName: "sbcname",
    responseId: "sbid",
    response: "supplierbase",
    multiSelect: false,
    manualLoad: false,
    searchParam: {
        order_field: "sbid",
    },
    columns: [{
        type: "checkcolumn",
        headerAlign: "center",
    }, {
        type: "indexcolumn",
        header: "行号",
        headerAlign: "center",
    }, {
        field: "sbid",
        header: "编码",
        allowSort: true,
        headerAlign: "center",
    }, {
        field: "sbcname",
        header: "名称",
        allowSort: true,
        headerAlign: "center",
    }, {
        field: "sbfp",
        header: "发票抬头",
        allowSort: true,
        headerAlign: "center",
        visible: false,
    }, {
        field: "sbfpadd",
        header: "发票地址",
        allowSort: true,
        headerAlign: "center",
        visible: false,
    }, {
        field: "fplx",
        header: "发票类型",
        allowSort: true,
        headerAlign: "center",
        visible: false,
    }, {
        field : "sbdz",
        header : "店招",
        allowSort : true,
        headerAlign : "center",
    }, {
        field : "sbstatus",
        header : "商户状态",
        allowSort : true,
        headerAlign : "center",
        visible: false,
    }]
};

//商铺
Future.Query.Config.spid = {
    winurl: "/mall-business-ui/pages/wizard/gridbox-view.jsp?key=spid",
    title: "商铺",
    resources: OmdUrl.mallmdm,
    method: "mall.mdm.shop.search",
    responseId: "spid",
    responseCode: "spid",
    responseName: "spcname",/*不用[编码]+名称*/
    response: "shoplist",
    multiSelect: false,
    manualLoad: false,
    searchParam: {
        order_field: "spid",
        order_direction: "asc"
    },
    columns: [{
        type: "checkcolumn",
        headerAlign: "center",
    }, {
        type: "indexcolumn",
        header: "行号",
        headerAlign: "center",
    }, {
        field: "muid",
        header: "门店名称",
        allowSort: true,
        headerAlign: "center",
        width: 150,
        visible: false,
    }, {
        field: "spid",
        header: "商铺编码",
        allowSort: true,
        headerAlign: "center",
    }, {
        field: "spcname",
        header: "商铺名称",
        allowSort: true,
        headerAlign: "center",
    }, {
        field: "spstatus",
        header: "商铺状态",
        allowSort: true,
        headerAlign: "center",
        visible : false,
    }, {
        field: "sptype",
        header: "商铺类型",
        allowSort: true,
        headerAlign: "center",
        visible : false,
    }]
};
// 业主
Future.Query.Config.owner = {
    winurl: "/mall-business-ui/pages/wizard/gridbox-view.jsp?key=owner",
    title: "业主",
    resources: OmdUrl.mallmdm,
    method: "mall.mdm.ownerinfo.search",
    responseCode: "ownerid",
    responseName: "ownercname",
    responseId: "ownerid",
    response: "ownerinfo",
    multiSelect: false,
    manualLoad: false,
    searchParam: {
        order_field: "ownerid",
    },
    columns: [{
        type: "checkcolumn",
        headerAlign: "center",
    }, {
        type: "indexcolumn",
        header: "行号",
        headerAlign: "center",
    }, {
        field: "muid",
        header: "门店名称",
        allowSort: true,
        headerAlign: "center",
    }, {
        field: "ownerid",
        header: "编码",
        allowSort: true,
        headerAlign: "center",
    }, {
        field: "ownercname",
        header: "名称",
        allowSort: true,
        headerAlign: "center",
    }]
};

Future.Query.Config.bcontno = {
    winurl: "/mall-business-ui/pages/contract/com/searchcontno-view.jsp?key=bcontno",
    title: "合同选择",
    resources: OmdUrl.mall,
    // width : 0.7,
    method : "mall.work.bcont.search",
    responseCode: "contno",
    responseName: "",
    responseContno: "contno",
    responseSbcode: "sbid",
    responseMuid: "muid",
    response : "bcontmain",
    multiSelect: false,
    manualLoad: false,
    searchParam: {
        order_field:"contno",
    },
    columns : [ {
        type : "checkcolumn",
        headerAlign : "center",
    }, {
        type : "indexcolumn",
        header : "行号",
        headerAlign : "center",
    }, {
        field : "contno",
        header : "合同号",
        allowSort : true,
        headerAlign : "center",
        width:80,
    }, {
        field : "muid",
        header : "门店",
        allowSort : true,
        headerAlign : "center",
        width:120,
        visible : false,
    },{
        field : "muid_name",
        header : "门店",
        allowSort : true,
        headerAlign : "center",
        width:120,
        visible : true,
    }, {
        field : "sbid",
        header : "商户",
        allowSort : true,
        headerAlign : "center",
        visible : false,
    },{
        field : "sbid_name",
        header : "商户",
        allowSort : true,
        headerAlign : "center",
        visible : true,
    }, {
        field : "cmeffdate",
        header : "生效日期",
        allowSort : true,
        headerAlign : "center",
        dataType : "date",
        dateFormat : "yyyy-MM-dd",
    }, {
        field : "cmlapdate",
        header : "失效日期",
        allowSort : true,
        headerAlign : "center",
        width:100,
        dataType : "date",
        dateFormat : "yyyy-MM-dd",
    }]
};

// 租赁合同
Future.Query.Config.leasecontno = {
    winurl: "/mall-business-ui/pages/wizard/gridbox_shop-view.jsp?key=leasecontno",
    title: "合同选择",
    resources: OmdUrl.mallmdm,
    width: 0.7,
    method: "mall.mdm.contract.search",
    responseCode: "contno",
    responseName: "",
    responseContno: "contno",
    responseSbcode: "sbid",
    responseSpcode: "spid",
    responsePpcode: "ppcode",
    response: "contmain",
    multiSelect: false,
    manualLoad: false,
    searchParam: {
        order_field: "contno",
    },
    columns: [{
        type: "checkcolumn",
        headerAlign: "center",
    }, {
        type: "indexcolumn",
        header: "行号",
        headerAlign: "center",
    }, {
        field: "contno",
        header: "合同编号",
        allowSort: true,
        headerAlign: "center",
        width: 110,
    }, {
        field: "contstatus",
        header: "合同状态",
        allowSort: true,
        headerAlign: "center",
        width: 150,
        renderer: "OcmControl.dictRendererWithCode",
        dictkey: 'CONTSTATUS',
    }, {
        field: "wmid",
        header: "经营方式",
        allowSort: true,
        headerAlign: "center",
        width: 100,
        renderer: "OcmControl.dictRendererWithCode",
        dictkey: 'WMID',
    }, {
        field: "sbid_name",
        header: "商户",
        allowSort: true,
        headerAlign: "center",
        width: 180,
    }, {
        field: "ppcode_name",
        header: "品牌",
        allowSort: true,
        headerAlign: "center",
    }, {
        field: "cmeffdate",
        header: "生效日期",
        allowSort: true,
        headerAlign: "center",
        dataType: "date",
        dateFormat: "yyyy-MM-dd",
        //width:80,
    }, {
        field: "cmlapdate",
        header: "失效日期",
        allowSort: true,
        headerAlign: "center",
        dataType: "date",
        dateFormat: "yyyy-MM-dd",
        //width:80,
    }]
};

//费用明细
Future.Query.Config.supchargeconvert= {
    winurl: "/mall-business-ui/pages/wizard/gridbox-view.jsp?key=supchargeconvert",
    title: "合同费用明细选择",
    resources : OmdUrl.settle,
    method : "mall.settle.supchargelist.search",
    response : "supchargelist",
    multiSelect : true,
    manualLoad : false,
    searchParam : {
        order_field :"contno",
        order_direction:"asc"
    },
    columns : [ {
        type : "checkcolumn",
        headerAlign : "center",
    }, {
        type : "indexcolumn",
        header : "行号",
        headerAlign : "center",
    }, {
        field : "muid",
        header : "门店",
        allowSort : true,
        headerAlign : "center",
        width : 120,
        visible : false,
    }, {
        field : "muid_name",
        header : "门店",
        allowSort : true,
        headerAlign : "center",
        width : 120,
        visible : true,
    },{
        field : "sbid",
        header : "商户",
        allowSort : true,
        headerAlign : "center",
        width : 160,
        visible : false,
    }, {
        field : "sbid_name",
        header : "商户",
        allowSort : true,
        headerAlign : "center",
        width : 160,
        visible : true,
    },{
        field : "contno",
        header : "合同",
        allowSort : true,
        headerAlign : "center",
        width : 120,
    }, {
        field : "spid",
        header : "商铺",
        allowSort : true,
        headerAlign : "center",
        visible : false,
    }, {
        field : "spid_name",
        header : "商铺",
        allowSort : true,
        headerAlign : "center",
        width : 160,
    },{
        field : "cccode",
        header : "费用项目",
        allowSort : true,
        headerAlign : "center",
        visible : false,
    }, {
        field : "cccode_name",
        header : "费用项目",
        allowSort : true,
        headerAlign : "center",
        visible : true,
        width : 120,
    },{
        field : "feesdate",
        headerAlign : "center",
        header : "费用开始日期",
        allowSort : true,
        editor : OcmControl.newControl('DatePicker'),
        dataType : "date",
        dateFormat : "yyyy-MM-dd",
    }, {
        field : "feeedate",
        headerAlign : "center",
        header : "费用结束日期",
        allowSort : true,
        editor : OcmControl.newControl('DatePicker'),
        dataType : "date",
        dateFormat : "yyyy-MM-dd",
    },  {
        field : "ysamount",
        header : "应收金额",
        allowSort : true,
        headerAlign : "center",
        numberFormat : "#,0.00",
        vtype : "float",
        align : "right",
        readOnly : true,
        width : 80,
    }, {
        field : "recamount",
        header : "实收金额",
        allowSort : true,
        headerAlign : "center",
        numberFormat : "#,0.00",
        vtype : "float",
        align : "right",
        readOnly : true,
        width : 80,
    },{
        field : "recdkamount",
        header : "实收抵扣",
        allowSort : true,
        headerAlign : "center",
        numberFormat : "#,0.00",
        vtype : "float",
        align : "right",
        readOnly : true,
        visible : false,
        width : 80,
    }, {
        field : "preadjamount",
        header : "预调整金额",
        allowSort : true,
        headerAlign : "center",
        numberFormat : "#,0.00",
        vtype : "float",
        align : "right",
        readOnly : true,
        visible : false,
        width : 80,
    },{
        field : "adjamount",
        header : "后调整金额",
        allowSort : true,
        headerAlign : "center",
        numberFormat : "#,0.00",
        vtype : "float",
        align : "right",
        readOnly : true,
        visible : false,
        width : 80,
    },{
        field : "ysbalance",
        header : "应收余额",
        allowSort : true,
        headerAlign : "center",
        numberFormat : "#,0.00",
        vtype : "float",
        align : "right",
        readOnly : true,
        width : 80,
    },{
        field : "payamount",
        header : "应付金额",
        allowSort : true,
        headerAlign : "center",
        numberFormat : "#,0.00",
        vtype : "float",
        align : "right",
        readOnly : true,
        width : 80,
    },{
        field : "paidamount",
        header : "已付金额",
        allowSort : true,
        headerAlign : "center",
        numberFormat : "#,0.00",
        vtype : "float",
        align : "right",
        readOnly : true,
        width : 80,
    },{
        field : "paydkamount",
        header : "实付抵扣",
        allowSort : true,
        headerAlign : "center",
        numberFormat : "#,0.00",
        vtype : "float",
        align : "right",
        readOnly : true,
        visible : false,
        width : 80,
    },{
        field : "paybalance",
        header : "应付余额",
        allowSort : true,
        headerAlign : "center",
        numberFormat : "#,0.00",
        vtype : "float",
        align : "right",
        readOnly : true,
        width : 80,
    }, {
        field : "ytamount",
        header : "应退金额",
        allowSort : true,
        headerAlign : "center",
        numberFormat : "#,0.00",
        vtype : "float",
        align : "right",
        readOnly : true,
        width : 80,
    }, {
        field : "rtndkamount",
        header : "实退抵扣",
        allowSort : true,
        headerAlign : "center",
        numberFormat : "#,0.00",
        vtype : "float",
        align : "right",
        readOnly : true,
        visible : false,
        width : 80,
    },{
        field : "confiscateamt",
        header : "押金罚没",
        allowSort : true,
        headerAlign : "center",
        numberFormat : "#,0.00",
        vtype : "float",
        align : "right",
        visible :false,
        readOnly : true,
        width : 80,
    },{
        field : "rtnamount",
        header : "已退金额",
        allowSort : true,
        headerAlign : "center",
        numberFormat : "#,0.00",
        vtype : "float",
        align : "right",
        readOnly : true,
        width : 80,
    }, {
        field : "ytbalance",
        header : "应退余额",
        allowSort : true,
        headerAlign : "center",
        numberFormat : "#,0.00",
        vtype : "float",
        align : "right",
        readOnly : true,
    } ]
};

//业种
Future.Query.Config.yzid= {
    winurl: "/mall-business-ui/pages/wizard/gridbox-view.jsp?key=yzid",
    title: "业种",
    resources: OmdUrl.mallmdm,
    method: "mall.mdm.manacat.search",
    responseCode : "mcid",
    responseName : "mcname",
    responseId: "mcid",
    response : "manacat",
    multiSelect : false,
    manualLoad : false,
    searchParam : {
        mcflag:"Y",
        order_field :"mcid",
        order_direction:"asc"
    },
    columns : [ {
        type : "checkcolumn",
        headerAlign : "center",
    }, {
        type : "indexcolumn",
        header : "行号",
        headerAlign : "center",
    }, {
        field : "mcid",
        header : "编码",
        allowSort : true,
        headerAlign : "center",
    }, {
        field : "mcname",
        header : "名称",
        allowSort : true,
        headerAlign : "center",
    } ]
};

//商铺弹框(写字楼单元)
Future.Query.Config.unitspid = {
    winurl: "/mall-business-ui/pages/wizard/gridbox-view.jsp?key=unitspid",
    title: "单元",
    resources: OmdUrl.mallmdm,
    method: "mall.mdm.shop.search",
    responseCode: "spid",
    responseName: "spcname",
    responseId: "spid",
    response: "shoplist",
    multiSelect: false,
    manualLoad: false,
    searchParam: {
        order_field: "spid",
    },
    columns: [{
        type: "checkcolumn",
        headerAlign: "center",
    }, {
        type: "indexcolumn",
        header: "行号",
        headerAlign: "center",
    }, {
        field: "spid",
        header: "单元编码",
        allowSort: true,
        headerAlign: "center",
        width: 150
    }, {
        field: "spcname",
        header: "单元名称",
        allowSort: true,
        headerAlign: "center",
    }, {
        field: "spbuildarea",
        header: "建筑面积",
        allowSort: true,
        headerAlign: "center",
        align: "right",
    }, {
        field: "splettarea",
        header: "套内面积",
        allowSort: true,
        headerAlign: "center",
        align: "right",
    }, {
        field: "muid",
        header: "门店",
        allowSort: true,
        headerAlign: "center",
        width: 150,
        visible : false
    }, {
        field: "spstatus",
        header: "状态",
        allowSort: true,
        headerAlign: "center",
        visible: false,
    }]
};

//电子签章
Future.Query.Config.signatures = {
    winurl: "/mall-business-ui/pages/wizard/gridbox-view.jsp?key=signatures",
    title: "电子签章选择",
    resources : OmdUrl.mall,
    method : "mall.work.signatures.search",
    responseCode : "signcode",
    responseName : "signname",
    responseId: "signcode",
    response : "report",
    multiSelect : false,
    manualLoad : false,
    searchParam : {
        order_field:"signcode",
    },
    columns : [ {
        type : "checkcolumn",
        headerAlign : "center",
    }, {
        type : "indexcolumn",
        header : "行号",
        headerAlign : "center",
    }, {
        field : "signcode",
        header : "电子签章编码",
        allowSort : true,
        headerAlign : "center",
    }, {
        field : "signname",
        header : "电子签章描述",
        allowSort : true,
        headerAlign : "center",
    }]
};

Future.Query.Config.checkkeywords = {
    winurl: "/mall-business-ui/pages/wizard/gridbox-view.jsp?key=checkkeywords",
    title: "品牌资料库选择",
    resources : OmdUrl.mall,
    method : "mall.work.investbrandbase.search",
    response : "investbrandbase",
    checkValue:true,
    multiSelect : false,
    manualLoad : false,
    searchParam : {
        order_field:"brandcode",
    },
    columns : [ {
        type : "checkcolumn",
        headerAlign : "center",
    }, {
        type : "indexcolumn",
        header : "行号",
        headerAlign : "center",
        visible : false,
    }, {
        field : "brandcode",
        header : "编号",
        allowSort : true,
        headerAlign : "center",
        width:60,
    }, {
        field : "brandnamechn",
        header : "名称",
        allowSort : true,
        headerAlign : "center",
        width:100,
    }, {
        field : "fomalcode",
        header : "正式编码",
        allowSort : true,
        headerAlign : "center",
        width:100,
    }, {
        field : "keywords",
        header : "检索关键字",
        allowSort : true,
        headerAlign : "center",
        width:100,
    }  ]
};