﻿
<%@ page language="java" contentType="text/html; charset=utf-8"
	pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
<title>门店选择树</title>
<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
<script src="treebox.js" type="text/javascript"></script>
</head>
<body>
	<div style="padding: 5px; text-align: center;">
		<label>编码/名称：</label> <input id="skey" class="mini-textbox"
			style="width: 150px;" onenter="onSKeyEnter" /> <a
			class="mini-button" style="width: 60px;" onclick="search()">查询</a>
	</div>
	<div class="mini-fit">
		<div class="mini-tabs" id="tabs"></div>
	</div>
	<div style="padding: 5px; text-align: center;">
		<a name="ok" class="mini-button" iconCls="icon-ok"
			style="margin-right: 40px;" onclick="onOkClick">确定</a> <a
			name="cancel" class="mini-button" iconCls="icon-cancel"
			onclick="onCancelClick">取消</a>
	</div>

	<script type="text/javascript">
		mini.parse();

		var key = getUrlParam("key");
		var saleregion="";

		var config = {
			searchParam:{},
			org : {
				title : "门店",
				tabItems : [ {
					"title" : "选择门店",
					"name" : "org"
				}, 
				/* {
					"title" : "门店组",
					"name" : "orggroup"
				},  */
				{
					"title" : "门店导入",
					"name" : "orgimport"
				} ]
			},
			cat : {
				title : "品类",
				tabItems : [ {
					"title" : "品类",
					"name" : "org"
				} ]
			},
			cut : {
				title : "会员",
				tabItems : [ {
					"title" : "会员",
					"name" : "org"
				} ]
			}
		};

		var tabs = mini.get("tabs");

		tabs.set({
			height : "100%",
			tabs : config[key].tabItems
		});

		//门店树(tab1)
		var tree = new mini.Tree();
		tree.set({
			idField : "code",
			textField : "codename",
			//parentField : "parent_id",
			showCheckBox : "true",
			expandOnLoad:1
		});

		//门店组树(tab2)
		var treegroup = new UserControl.TreeBox();
		treegroup.set({
			idField : "oid",
			textField : "codename",
			nodesField : "orgs",
			parentField : "parent_id",
			showCheckBox : "true",
			expandOnLoad:0,
			imgPath : "/ocp-ui-res/js/lib/miniui/miniui/themes/icons/"
		});
		
		// 门店输入
		var outlookbar = new mini.OutlookBar();
		outlookbar.setWidth("100%");
		outlookbar.setHeight("100%");
		var topGroup = {
			title: "门店输入框",
			name: "inputgroup",
			body: "<div style=\"height:100%;\"><textarea id=\"mkttxtinput\" class=\"mini-textarea\" style=\"width:100%;height:85%;\" emptyText=\"粘贴门店到这里\"></textarea><br/><br/><div style=\"text-align:center;\"><a class=\"mini-button\" onclick=\"loadtxtmkt()\" >解析</a></div>",
		};
		var bottomGroup = {
			title: "门店列表",
			name: "gridgroup",
			body: "<div class=\"mini-fit\" ><div id=\"mktinputgrid\" " +
				"class=\"mini-datagrid\" " +
				"style=\"width:100%;height:100%;\" " +
				"showPager=\"false\" " +
	       		"idField=\"code\" multiSelect=\"false\" >" +
	       		"<div property=\"columns\">" +
	       		"<div field=\"indexcolumn\" field=\"indexcolumn\" headerAlign=\"center\" >行号</div>" +
	       		"<div field=\"code\" headerAlign=\"center\" >门店编码</div>" +
	       		"<div field=\"name\" headerAlign=\"center\" >门店名称</div>" +
	       		"</div></div></div>",
		};
		outlookbar.addGroup(topGroup);
		outlookbar.addGroup(bottomGroup);
		outlookbar.setAutoCollapse(true);
		outlookbar.setActiveIndex(0);

		//渲染方法，树控件加入到tabs页面中
		tree.render(tabs.getTabBodyEl("org"));
		treegroup.render(tabs.getTabBodyEl("orggroup"));
		outlookbar.render(tabs.getTabBodyEl("orgimport"));

		
		var param = {};

		var showall = false;//显示所有返回的就门店，包括all
		
		var billmoduleid = "";

		//初始传入方法
		function SetData(data) {
			if (data.multiSelect == true || data.multiSelect == false) {
				param.multiSelect = data.multiSelect;
			}
			
			for (var par in data.searchParam) {
				if(par=="saleregion"){
					config.searchParam.saleregion = data.searchParam[par];
				}
				
			}
			if(data.billmoduleid == "6005103" || data.billmoduleid == "6005102"){
				config.searchParam = data.searchParam;
				billmoduleid = data.billmoduleid;
			}
			getTreeData();
			if (data.showall == true) {
				showall = true;
			}
			//勾选已选择的节点
			var checkid = data.checkid;
			if (checkid == "%") {
				tree.checkAllNodes();
			}

			setCheckNodes(checkid);
		}
		
		//获取树数据
		function getTreeData() {
          
			var token = getUrlParam("token");

			if (key == "org") {

				//门店
				var svr = "master.work.common.getMktDict";
				
				var orgpara ={};
				if(billmoduleid != "6005103" && billmoduleid != "6005102"){
					if(config.searchParam.saleregion!=null&&config.searchParam.saleregion!=""){
						orgpara={
								order_field : "code",
								fields : "code,name,oid,parent_id,lastflag,saleregion",
								page_no : 1,
								page_size : 9999,
								saleregion:config.searchParam.saleregion,
							}
					}else{
						orgpara={
								order_field : "code",
								fields : "code,name,oid,parent_id,lastflag,saleregion",
								page_no : 1,
								page_size : 9999
							}
					}	
				}else{
					orgpara ={
							order_field : "code",
							fields : "code,name,oid,parent_id,lastflag,saleregion",
							page_no : 1,
							page_size : 9999,
							code:config.searchParam.$and.code,
							saleregion:config.searchParam.saleregion,	
							/* lastflag:config.searchParam.$and.lastflag, */
					}
				}

				
				itemLoader.doRequest(OmdUrl.master, svr, orgpara, null, null, function(data) {
					var source = data.organization;
					for (var i = 0; i < source.length; i++) {
						source[i].codename = "[" + source[i].code + "]"
								+ source[i].name;
					}
					if(billmoduleid != "6005103" && billmoduleid != "6005102"){
						source.push({
							oid : "0",
							codename : "[%]所有门店"
						});						
					}
					tree.loadList(source, "oid", "parent_id");
				}, null, null, false);
				/*
				var orggrouppara ={};
				if(config.searchParam.saleregion!=null&&config.searchParam.saleregion!=""){
					orggrouppara={
							order_field : "group_code",
							fields : "ogid,group_code,group_name,parent_id,orgs",
							page_no : 1,
							page_size : 9999,
							saleregion:config.searchParam.saleregion
						}
				}else{
					orggrouppara={
							order_field : "group_code",
							fields : "ogid,group_code,group_name,parent_id,orgs",
							page_no : 1,
							page_size : 9999
						}
				}
				//门店组
				var method = "ocm.mdm.org.group";
				if (token && token != "")
					method = "ocm.mdm.org.group";
				itemLoader.doRequest(OmdUrl.mdm, method, orggrouppara, null, null, function(data) {
					var source = data.organization_group;

					var treelist = [];

					//门店组树
					for (var i = 0; i < source.length; i++) {
						var row = {
							"oid" : source[i].group_code,
							"code" : source[i].group_code,
							"name" : source[i].group_name,
							"codename" : "[" + source[i].group_code + "]"
									+ source[i].group_name,
							"parent_id" : "0",
							"img" : "addfolder.gif"
						};
						treelist.push(row);

						//门店组下的门店树
						var orgs = source[i].orgs;
						if(orgs!=null){
							for (var j = 0; j < orgs.length; j++) {
								var org = {
									"oid" : source[i].group_code + "-"
											+ orgs[j].org_code,
									"code" : orgs[j].org_code,
									"name" : orgs[j].org_name,
									"codename" : "[" + orgs[j].org_code + "]"
											+ orgs[j].org_name,
									"pcode" : source[i].group_code,
									"pname" : source[i].group_name,
									"parent_id" : source[i].group_code
								};
								treelist.push(org);
							}
						}
						
					}

					treelist.push({
						oid : "0",
						codename : "[%]所有门店组",
						img : "addfolder.gif"
					});
					treegroup.loadList(treelist, "oid", "parent_id");
					//treegroup.expandNode(treegroup.getNode("0"));
					
					//treegroup.expandAll();
				}, null, null, false);*/
			} else if (key == "cut") {
				var svr = "omp.work.custtype.search";

				itemLoader.doRequest(OmdUrl.omp, svr, {
					fields : "code,name,cid,parent_id",
					"order_field" : "code",
					"order_direction":"asc",
					page_no : 1,
					page_size : 9999
				}, null, null, function(data) {
					var _data=data.custtype;
					var source=[];
					source.push({
						code : "ALL",
						name:"所有人",
						parent_id:"0",
						codename : "[ALL]所有人"
					});
					source.push({
						code : "HALL",
						name:"所有会员",
						parent_id:"0",
						codename : "[HALL]所有会员"
					});
					source.push({
						code : "NALL",
						name:"所有非会员",
						parent_id:"0",
						codename : "[NALL]所有非会员"
					});
					source.push({
						code : "T",
						name:"会员类型",
						parent_id:"0",
						codename : "[T]会员类型"
					});
					for(var i=0;i<_data.length;i++){
						source.push(_data[i]);
					};
					//source.push(data.custtype)
					//var source = data.category;
					for (var i = 0; i < source.length; i++) {
						source[i].codename = "[" + source[i].code + "]"
								+ source[i].name;
					}

					tree.loadList(source, "code", "parent_id");
					//tree.expandAll();
				}, null, null, false);
			}
			else if(key == "cat"){
				var svr = "ocm.mdm.manacat.search";

				itemLoader.doRequest(OmdUrl.mdm, svr, {
					fields : "code,name,cid,parent_id",
					"order_field" : "code",
					page_no : 1,
					page_size : 9999
				}, null, null, function(data) {
					//var source = data.custtype;
					var source = data.category;
					for (var i = 0; i < source.length; i++) {
						source[i].codename = "[" + source[i].code + "]"
								+ source[i].name;
					}
					source.push({
						code : "0",
						codename : "[%]所有品类"
					});
					tree.loadList(source, "code", "parent_id");
					//tree.expandAll();
				}, null, null, false);
			}
		}

		//确定事件
		function onOkClick(e) {
			var data = [];
            var flag=true;
			
			if(mini.get("mktinputgrid")){
				var _grid = mini.get("mktinputgrid");
				if(_grid){
					rows = _grid.getData();
					if(rows.length > 0) {
						flag=false;
						gridrows: for (var i = 0; i < rows.length; i++) {
							var flag =false;
							for (var j = 0; j < data.length; j++) {
								if (data[j].code == rows[i].code) {
									continue gridrows;
								}
							}
								data.push(rows[i]);	
							
						}
					}	
				}
				
			}
			
            if(flag){
            	var rows = tree.getCheckedNodes(false);
    			if (rows.length > 0) {
    				data = rows;
    			}

    			rows = treegroup.getCheckedNodes(false);
    			if (rows.length > 0) {
    				//判断是否分组门店是否已选的第一个tab门店中
    				treegrouprows: for (var i = 0; i < rows.length; i++) {
    					for (var j = 0; j < data.length; j++) {
    						if (data[j].code == rows[i].code) {
    							continue treegrouprows;
    						}
    					}

    					if (rows[i].parent_id != "0") {
    						data.push(rows[i]);
    					}
    				}
    			}	
            }
			
			
			if (data.length == 0) {
				mini.alert("请选择" + config[key].title);
				return;
			}

			if (param.multiSelect == false && data.length > 1) {
				mini.alert("只能选择一个" + config[key].title);
				return;
			}

			if (key == "org") {

				//判断选择所有门店ALL，是否返回所有记录数
				//var rootNode = tree.getNode(0);
				//if(showall == false){
				// if(rootNode && tree.isCheckedNode(rootNode)){
				// data = [{code:"%",name:"所有门店"}];
				// }
				//}
			}

			window.CloseOwnerWindow(data);
		}

		//取消按钮
		function onCancelClick(e) {
			window.CloseOwnerWindow("close");
		}

		//勾选树
		function setCheckNodes(checkid) {
			if (checkid) {
				var idstr = checkid.split(",");
				var nodes = [];

				//门店树勾选
				for (var i = 0; i < idstr.length; i++) {
					var node = tree.getNode(idstr[i]);
					nodes.push(node);
				}
				tree.checkNodes(nodes);
				nodes = [];
				//门店树勾选
				for (var i = 0; i < idstr.length; i++) {
					var node = treegroup.getNode(idstr[i]);
					nodes.push(node);
				}
				treegroup.checkNodes(nodes);
			}
		}

		function search() {
			var skey = mini.get("skey").getValue();
			var thistree;
			if (tabs.activeIndex == 0) {
				thistree = tree;
			} else {
				thistree = treegroup;
			}
			if (skey == "") {
				thistree.clearFilter();
			} else {
				skey = skey.toLowerCase();
				thistree
						.filter(function(node) {
							var text = node.codename ? node.codename
									.toLowerCase() : "";
							var pcode = node.pcode ? node.pcode.toLowerCase()
									: "";
							var pname = node.pname ? node.pname.toLowerCase()
									: "";
							if (text.indexOf(skey) != -1
									|| pcode.indexOf(skey) != -1
									|| pname.indexOf(skey) != -1) {
								return true;
							}
						});
			}
		}
		function onSKeyEnter(e) {
			search();
		}
		
		function loadtxtmkt() {
			var mkttxtinput = mini.get("mkttxtinput");
			var mktstr = mkttxtinput.getValue();
			var mktstrary;
			if(mktstr.indexOf(",") != -1 && mktstr.indexOf("\n") != -1) {
				mini.alert("无法解析，你确认粘贴的门店信息正确");
				return;
			}
			mktstrary = mktstr.split(",");
			if(mktstrary.length <= 1) {
				mktstrary = mktstr.split("\n");
			}
			var saleregion=null;
			
			if(config.searchParam.saleregion){
			if(config.searchParam.saleregion!=null&&config.searchParam.saleregion!=""){
				saleregion=config.searchParam.saleregion;
			}
			}
						
			if(mktstrary.length > 0) {
				var svr = "master.work.common.getMktDict";
				var orgpara ={};
				if(saleregion!=null&&saleregion!=""){
					orgpara={
							order_field : "code",
							fields : "code,name,oid,parent_id,saleregion",
							"$and":{"code":{"$in":mktstrary},
							       "saleregion" : saleregion,
							       "lastflag":"Y"},
							page_no : 1,
							page_size : 9999
						}
				}else{
					orgpara={
							order_field : "code",
							fields : "code,name,oid,parent_id,saleregion",
							"$and":{"code":{"$in":mktstrary},
							       "lastflag":"Y"},
							page_no : 1,
							page_size : 9999
						}
				}
				
				itemLoader.doRequest(OmdUrl.master, svr, orgpara, null, null, function(data) {
					var source = data.organization;
					var rows = [];
					$.each(source, function(inx, src) {
						var row = {
							indexcolumn:inx+1,
							code: src.code,
							name: src.name,
							lastflag:"Y"
						}
						rows.push(row);
					});
					var errmkt=[];
					for(var i=0;i<mktstrary.length;i++){
						var flag=false;
						for(var j=0;j<rows.length;j++){
							if(mktstrary[i]==rows[j].code){
								flag=true;
								break;
							}
						}
						if(!flag){
							errmkt.push(mktstrary[i]);
						}
					}
					if(errmkt!=null&&errmkt.length!=0){
						mini.alert("门店编码【"+errmkt+"】不存在");
					}
					var _grid = mini.get("mktinputgrid");
					_grid.clearRows();
					_grid.addRows(rows, 0);
					outlookbar.setActiveIndex(1);
				}, null, null, false);
			}
		}
	</script>
</body>
</html>