if (!window.UserControl) window.UserControl = {};

UserControl.TreeBox = function () {

    UserControl.TreeBox.superclass.constructor.call(this);

    //this.initComponents();
    //this.bindEvents();

}

mini.extend(UserControl.TreeBox, mini.Tree, {
    
    uiCls: 'uc-treebox',

    initComponents: function () {
        var toolbar = '<div style="padding:0px;">'
            + '<input id="name" class="mini-textbox" style="width:100%" borderStyle="border:0px;" emptyText="请输入查询关键字"/>'
        + '</div>';
        var footer = '<div style="padding:5px;text-align:center;">'
            + '<a name="ok" class="mini-button" iconCls="icon-ok" style="margin-right:20px;">确定</a>'
            + ' <a name="cancel" class="mini-button" iconCls="icon-cancel" >取消</a>'
        + '</div>';

        this.set({
            resultAsTree: false,
            showToolbar: false,
            toolbar: toolbar,
            showFooter: true,
            footer: footer,
            onbeforeload: this.pullData,
        });
        
        var that = this;
        if (that.config.properties) {
          for (var _p in that.config.properties) {
            var a = "set"+_p.replace(/\b(\w)/g, function($0,$1){return $1.toUpperCase();});;
            that[a](that.config.properties[_p]);
          };
        };
        
        this.load();
    },
    bindEvents: function () {
    	
        this.nameText = mini.get('name', this);

        this.okBtn = mini.getbyName('ok', this);
        this.cancelBtn = mini.getbyName('cancel', this);

        var that = this;

        this.nameText.on('enter', function (e) {
        	var treekey = that.nameText.getValue();
            if (treekey == "") {
            	that.clearFilter();
            } else {
            	treekey = treekey.toLowerCase();                
            	that.filter(function (node) {
                    var text = node.name ? node.name.toLowerCase() : "";
                    if (text.indexOf(treekey) != -1) {
                        return true;
                    }
                });
            }
        });
        
        this.okBtn.on('click', function (e) {
            that.fire("okclick");
        });
        this.cancelBtn.on('click', function (e) {
        	window.CloseOwnerWindow("close");
            that.fire("cancelclick");
        });
    },

    pullData: function(e) {
        e.cancel = true;
        var that = this;
        var source = [];
        if (that.config.resources) {
          var searchParam = {
          };
          alert(that.config.searchParam);
          if (that.config.searchParam) {
            for (var _s in that.config.searchParam) {
              searchParam[_s] = that.config.searchParam[_s];
            };
          };
          itemLoader.doRequest(that.config.resources, that.config.method, searchParam, null, null, function(data) {
            source = data[that.config.response];
            for ( var i = 0; i < source.length; i++) {
            	source[i].codename = "["+source[i].code+"]"+source[i].name;
            }
            source.push({oid:"0",codename:"[%]所有门店"}); 
            that.loadList(source,"oid","parent_id");
            that.expandAll();
          }, null, null, false);
        }
      },
    
    setConfig: function(conf) {
        var _conf = window[conf] || conf;
        if (_conf && typeof(_conf) === "object") {
          this.config = _conf;
        };
        this.initComponents();
        this.bindEvents();
      },
    
    getAttrs: function (el) {
        var attrs = UserControl.TreeBox.superclass.getAttrs.call(this, el);
        mini._ParseString(el, attrs,
            ["config","onokclick", "oncancelclick"]
        );
        return attrs;
    },
    
    setCheckNodes: function(checkid){
    	if(checkid){
			var idstr = checkid.split(",");
 			var nodes = [];
   			for(var i = 0;i < idstr.length;i++){
   				var node = treebox1.getNode(idstr[i]);
   				nodes.push(node);
   			}
   			treebox1.checkNodes(nodes);
		}
    }
      
});

mini.regClass(UserControl.TreeBox, "uc-treebox");