var billmoduleid = "";
var moduleInfo = "";
var dictData = "";
var reportconfig = "";
var gbidRulemode = "0";
var contnoRulemode = "0";

//合同当前有效期计算开始日期cmeffdate
var expirysdatename = getManaPara("00", "EXPIRYSDATE");

//根据billtype单据的类型 申请 I  修改 U  查询 M  撤场 4
//'200801-1合同申请单','200802-44合同变更单','200803-CS5合同查询','200808-7商户撤场单','100426-187商铺撤场申请单'
//'L10305-1写字楼合同申请单','L10304-44写字楼合同变更单'，''L10306-CS5写字楼合同查询'，'L10308-7写字楼撤场单'
function isModel() {
    var code = "";
    if (billtype == '1' || billtype == 'C1') {
        code = 'I';
    } else if (billtype == '44' || billtype == '45') {
        code = 'U';
    } else if (billtype == 'CS5' || billtype == 'CS4') {
        code = 'M';
    } else if (billtype == '7') {
        code = '4';
    }
    return code;
};

function isWmid() {
    var code = "";
    if (moduleInfo != "") {
        code = moduleInfo.wmid;
    }
    return code;
}

//取得系统字典
function getDictData() {
    dictData = getDict("SYSTEM_BILLSTATUS,CONTRACT_BDMODE,CONTRACT_SETFLAG,CONTRACT_SQMODE,CONTRACT_BDQX,BRAND_PPGRADE,CONTRACT_CONTSTATUS,SHOP_CCAREA,CONTRACT_SYFS,CONTRACT_WMID,CHARGE_PAYMODE,SYSTEM_BILLSOURCE,CONTRACT_CCREASON,CONTRACT_CONTTYPE,CONTRACT_SETMODE,CONTRACT_CETYPE,CONTRACT_CYCUNIT,FINANCE_VATRATE,GOODS_XFTAXRATE,CONTRACT_CYCSQTYPE,CONTRACT_DRAWSALES,CONTRACT_OFCTYPE,CONTRACT_CONTSTYLE,GOODS_GMFSTATUS,CONTRACT_ZNJMODE", "dcode,dname,pro1,ddvalue");
    return dictData;
};

/***************************添加自定义字典******************************/
function AddDictData(dictData) {
    dictData.ANNUALGROWTHRULE = getAnnualGrowthRule();
    dictData.COMPANY = getCompany();
    dictData.SETGROUPCODE = getSetGroupDef();
    dictData.SETTLEDAY = getSettleDay();
    dictData.WMID = [{code: "5", name: "租赁"}];
    dictData.modflag = [{code: "N", name: "初始"}, {code: "M", name: "修改"}, {code: "I", name: "新增"}, { code: "D", name: "删除"}];
};
/***********************明细tab页中的商铺展示*******************************/
function spnameList(_data) {
    var list = [];
    for (var int = 0; int < _data.length; int++) {
        var bcont = _data[int];
        var num = int + 1;
        if (bcont.spid != undefined && bcont.spid.toLowerCase() == "all") {
            bcont.spid_name = "ALL";
        }
        if (bcont.browno == undefined || bcont.browno == "" || bcont.browno != num) {
            bcont.browno = num;
        }
        if (isModel() == CONSTANT_UPDATA) {
            if (bcont.modflag != "D") {
                list.push(bcont);
            } else {
                _data.splice(int, 1);
                int--;
            }
        } else {
            list.push(bcont);
        }
    }
    return list;
};

/********************************单据表头事件检查****************************************/
//判断商户与门店是否有关系：参数1：sbid 商户id, 参数2：mktoid 门店, 结果： true: 有 ，fals 没有
function isSbMk(sbid, muid) {
    var flag = false;
    var searchParam = {"sbid": sbid,
                        "supmkt:muid": muid};
    itemLoader.doRequest(OmdUrl.mallmdm, "mall.mdm.sup.search", searchParam, null, null, function (data) {
        if (data && data.length > 0) {
            flag = true;
        }
    }, null, null, false);
    return flag;
};

function getSbidPhkey(sbid) {
    var ph_key = "";
    var searchParam = {"sbid": sbid};
    itemLoader.doRequest(OmdUrl.mall, "mall.work.sup.search", searchParam, null, null, function (data) {
        var temp = data.supplierbase;
        ph_key = temp[0].ph_key;
    }, null, null, false);
    return ph_key;
};

//合同值变更事件检查
//1.检查合同存在未审核的结算单
function check(contno) {
    var isflag = false;
    var postdata = {};
    postdata.contno = contno;
    postdata.billstatus = "M";
    itemLoader.doRequest(OmdUrl.settle, "mall.settle.supsettlehead.search", postdata, null, null, function (data) {
        var _data = data.supsettlehead;
        if (_data.length > 0) {
            jsbillno = _data.billno;
            isflag = true;
        }
    }, null, null, false);
    return isflag;
};

//2.检查合同是否存在已审核的撤场单
function check2(contno) {
    var isflag = false;
    var postdata = {};
    postdata.contno = contno;
    postdata.billstatus = "Y";
    postdata.billmoduleid = mini.getbyName("billmoduleid").getValue();
    itemLoader.doRequest(OmdUrl.mall, "mall.work.bcont.search", postdata, null, null, function (data) {
            if (data.bcontmain.length > 0) {
                isflag = true;
            }
        }, null, null, false);
    return isflag;
};

//2.检查合同是否存在未审核的变更单
function check3(contno) {
    var isflag = false;
    var postdata = {};
    postdata.contno = contno;
    postdata.billstatus = "N";
    itemLoader.doRequest(OmdUrl.mall, "mall.work.bcont.search", postdata, null, null, function (data) {
            if (data.bcontmain.length > 0) {
                isflag = true;
            }
        }, null, null, false);
    return isflag;
};

// 根据设置方式
function setDetailsTabs(wmid) {
    var tabs = mini.get("tabs2");
    tabs.updateTab(tabs.tabs[1], {visible: true});
    tabs.updateTab(tabs.tabs[8], {visible: true});
    tabs.updateTab(tabs.tabs[2], {visible: false});
    tabs.activeTab(tabs.tabs[1]);
    tabs.activeTab(tabs.tabs[8]);
};

//获取此店铺号的合同信息
function getDph(dph) {
    var temp = "";
    var searchParam = {"dph": dph, "billtype": "1"};
    itemLoader.doRequest(OmdUrl.mall, "mall.work.bcont.search", searchParam, null, null, function (data) {
        temp = data.bcontmain;
    }, null, null, false);
    return temp;
};

//判断明细是否有数据   结果：false:有数据/ture:没有数据
function isDetail(flag) {
    if (flag != "1") {
        if (bcontmanaframe != undefined) {
            if (bcontmanaframe.getData().length > 0) {
                return false;
            }
        }
    }
    if (bcontbd != undefined) {
        if (bcontbd.getData().length > 0) {
            return false;
        }
    }
    if (bcontcycfee != undefined) {
        if (bcontcycfee.getData().length > 0) {
            return false;
        }
    }
    if (flag != "1") {
        if (bcontdeposit != undefined) {
            if (bcontdeposit.getData().length > 0) {
                return false;
            }
        }
    }
    if (bcontcharge != undefined) {
        if (bcontcharge.getData().length > 0) {
            return false;
        }
    }
    if (flag != "1") {
        if (bcontoverduefine != undefined) {
            if (bcontoverduefine.getData().length > 0) {
                return false;
            }
        }
    }
    if (bcontgoods != undefined) {
        if (bcontgoods.getData().length > 0) {
            return false;
        }
    }
    if (flag != "1") {
    }
    return true;
};

function isBdmode(muid) {
    var bdtemp = null;
    var bdtemp = getManaPara(muid, "BDMODE");
    if (bdtemp) {
        return bdtemp;
    } else {
        return;
    }
};

//检查合同生效日期不能小于商铺生效日期
function checkSpstartdate(spstartdate) {
    var tempdata = [];
    var flag = true;
    var form = details1.form;
    var spiddata2 = bcontmanaframe.getData();
    var muid = form.getField("muid").getValue();
    var strspid = "";
    for (var i = 0; i < spiddata2.length; i++) {
        strspid = strspid + spiddata2[i].spid + ',';
    }
    if (strspid == "") {
        return true;
    } else {
        strspid = strspid.substring(0, strspid.length - 1);
    }
    var searchParam = {};
    searchParam.muid = muid;
    var list = strspid.split(",");
    searchParam.spid = list;
    itemLoader.doRequest(OmdUrl.mallmdm, "mall.mdm.shop.searchZlCmfSpid", searchParam, null, null, function (data) {
        tempdata = data;
    }, null, null, false);
    if (tempdata.length > 0) {
        for (var i = 0; i < tempdata.length; i++) {
            if (spstartdate < tempdata[i].spstartdate) {
                mini.alert("合同生效日期不能小于商铺[" + tempdata[i].spid + "]生效日期[" + tempdata[i].spstartdate + "]");
                flag = false;
                break;
            }
        }
    }
    return flag;
};

//修改合同开始日期
function setbcontmanaframeDate(row) {
    var data = bcontmanaframe.getData();
    for (var i = 0; i < data.length; i++) {
        bcontmanaframe.updateRow(data[i], row);
    }
};

//撤场日期check   撤场日期撤场日期不能小于合同的最后结算日期
function checkContnoCcdate(contno, edate) {
    var para = {};
    para.flag = false;
    var searchParam = {
        "contno": contno
    };
    itemLoader.doRequest(OmdUrl.settle, "mall.settle.supsettlehead.searchContMaxJsdate", searchParam, null, null, function (data) {
        if (data) {
            if (data.maxthisdate != '1') {
                if (edate < data.maxthisdate) {
                    para.flag = true;
                    para.maxthisdate = data.maxthisdate;
                }
            }
        }
    }, null, null, false);
    return para;
};
/****************************日期比较******************************************/
// 合同生效日期与失效日期进行比较//求出所有明细的最小开始日期，与最大结束日期
function getAllMinMaxDate(wmid) {
    var list = [];
    if (bcontbd != undefined && bcontbd.getData().length > 0) {
        var para = getMinMaxDate(bcontbd, "cbsdate", "cbedate");
        para.sname = CONSTANT_GRID2_NAME;
        para.ename = CONSTANT_GRID2_NAME;
        list.push(para);
    }
    if (bcontcycfee != undefined && bcontcycfee.getData().length > 0) {
        var para = getMinMaxDate(bcontcycfee, "cbsdate", "cbedate");
        para.sname = CONSTANT_GRID3_NAME;
        para.ename = CONSTANT_GRID3_NAME;
        list.push(para);
    }
    if (bcontcharge != undefined && bcontcharge.getData().length > 0) {
        var para = getMinMaxDate(bcontcharge, "ccsdate", "ccedate");
        para.sname = CONSTANT_GRID5_NAME;
        para.ename = CONSTANT_GRID5_NAME;
        list.push(para);
    }
    if (bcontgoodskl != undefined && bcontgoodskl.getData().length > 0) {
        var para = getMinMaxDate(bcontgoodskl, "sdate", "edate");
        para.sname = CONSTANT_GRID9_NAME;
        para.ename = CONSTANT_GRID9_NAME;
        list.push(para);
    }
    var para = "";
    for (var i = 0; i < list.length; i++) {
        if (i == 0) {
            para = list[i];
        } else {
            if (para.sdate >= list[i].sdate) {
                para.sdate = list[i].sdate;
                para.sname = list[i].sname;
                para.snum = list[i].snum;
            }
            if (para.edate <= list[i].edate) {
                para.edate = list[i].edate;
                para.ename = list[i].ename;
                para.enum = list[i].enum;
            }
        }
    }
    return para;
};

/*  求取grid 最小开始日期与最大结束时间
 *  参数1： grid 明细控件对象  参数2： sname 开始日期字段名称  参数3： ename 结束日期字段名称
 *  结果： para.sdate 最小开始日期 para.edate 最大开始日期   para.snum  最小日期行数 para.enum  最大日期行数
 **/
function getMinMaxDate(grid, sname, ename) {
    var para = {};
    para.sdate = "";
    para.edate = "";
    para.snum = "";
    para.enum = "";
    var data = grid.getData();
    for (var i = 0; i < data.length; i++) {
        var tsdate;
        var tedate;
        if (data[i][sname] != undefined && data[i][sname] != "") {
            tsdate = data[i][sname].substring(0, 10);
        }
        if (data[i][ename] != undefined && data[i][ename] != "") {
            tedate = data[i][ename].substring(0, 10);
        }
        if (i == 0) {
            para.sdate = tsdate;
            para.edate = tedate;
            para.snum = i + 1;
            para.enum = i + 1;
        } else {
            if (tsdate && para.sdate >= tsdate) {
                para.sdate = tsdate;
                para.snum = i + 1;
            }
            if (tedate && para.edate <= tedate) {
                para.edate = tedate;
                para.enum = i + 1;
            }
        }
    }
    return para;
};

//方法：求两个时间之间的月数  参数1： data1  开始日期 (形式："yyyymmdd")  参数2： data2  结束日期 (形式："yyyymmdd")
//结果：len 月数  默认格式为"20030303",根据自己需要改格式和方法
function getMonthNumber(date1, date2) {
    var year1 = date1.substr(0, 4);
    var year2 = date2.substr(0, 4);
    var month1 = date1.substr(4, 2);
    var month2 = date2.substr(4, 2);
    var len = (year2 - year1) * 12 + (month2 - month1);
    var day = date2.substr(6, 2) - date1.substr(6, 2);
    if (day > 0) {
        len += 1;
    }
    return len;
};

/*  求取grid 最后一行的开始结束日期
 *  参数1： grid 明细控件对象 参数2： sname 开始日期字段名称 参数3： ename 结束日期字段名称
 *  结果： para.sdate 最小开始日期  para.edate 最大开始日期
 **/
function getRowMaxDate(grid, sname, ename) {
    var para = {};
    para.sdate = "";
    para.edate = "";
    var data = grid.getData();
    var j = data.length - 1;
    var tsdate = data[j][sname].substring(0, 10);
    var tedate = data[j][ename].substring(0, 10);
    para.sdate = tsdate;
    para.edate = tedate;
    return para;
};

/********************************单据明细事件检查*****************************/
//浮点型相加
function accAdd(arg1, arg2) {
    var r1, r2, m;
    try {
        r1 = arg1.toString().split(".")[1].length;
    } catch (e) {
        r1 = 0;
    }
    try {
        r2 = arg2.toString().split(".")[1].length;
    } catch (e) {
        r2 = 0;
    }
    m = Math.pow(10, Math.max(r1, r2));
    return (arg1 * m + arg2 * m) / m;
};

//检查当前结算方式是属于结算还是清算
function checkisqs(setmode) {
    var v_isqs;
    var searchParam = {
        "smid": setmode,
    };
    itemLoader.doRequest(OmdUrl.settle, "mall.settle.setmodedef.search", searchParam, null, null, function (data) {
        if (data) {
            var _data = data.setmodedef;
            v_isqs = _data[0].isqs;
        } else {
            v_isqs = "X";
        }
    }, null, null, false);
    return v_isqs;
};

//保存时检查合同号是否存在，存在返回true
function checkContno(contno, billno) {
    var temp = false;
    var searchParam = {
        "contno": contno
    };
    if (billno) {
        searchParam.billno = {"<>": billno};
    }
    itemLoader.doRequest(OmdUrl.mall, "mall.work.bcont.search", searchParam, null, null, function (data) {
        if (data.bcontmain && data.bcontmain.length > 0) {
            temp = true;
        }
    }, null, null, false);
    return temp;
};

//新增商品編码
function getGbid() {
    var _data = {};
    itemLoader.doRequest(OmdUrl.mall, "mall.work.goods.getAutoGbid", {}, null, null, function (data) {
        _data = data.gbid;
    }, null, null, false);
    return _data;
};

function fcheckGbid(gbid){
    var flag = false;
    var searchParam = {
        "gbid" : gbid,
    };
    itemLoader.doRequest(OmdUrl.mall,"mall.work.goods.checkGbid",searchParam,null,null,function(data) {
        var _data = data.flag;
        if(_data == "Y"){
            flag = true;
        }
    }, null, null, false);
    return flag;
};

//检查商铺是否已使用
function isSpidUse(spid) {
    if (bcontbd) {
        var bcontbddata = bcontbd.getData();
        for (var i = 0; i < bcontbddata.length; i++) {
            if (spid && (bcontbddata[i].spid == spid || bcontbddata[i].spid.toLowerCase() == "all")) {
                var rowNum = i + 1;
                mini.alert("商铺已被" + CONSTANT_GRID2_NAME + "第" + rowNum + "行明细的商铺[" + bcontbddata[i].spid_name + "]所引用不能修改或删除，请检查 ");
                return false;
            }
        }
    }
    if (bcontcycfee) {
        var bcontcycfeedata = bcontcycfee.getData();
        for (var i = 0; i < bcontcycfeedata.length; i++) {
            if (spid && (bcontcycfeedata[i].spid == spid || bcontcycfeedata[i].spid.toLowerCase() == "all")) {
                var rowNum = i + 1;
                mini.alert("商铺已被[" + CONSTANT_GRID3_NAME + "]第" + rowNum + "行明细的商铺[" + bcontcycfeedata[i].spid_name + "]所引用不能修改或删除，请检查 ");
                return false;
            }
        }
    }
    if (bcontcharge) {
        var bcontchargedata = bcontcharge.getData();
        for (var i = 0; i < bcontchargedata.length; i++) {
            if (spid && (bcontchargedata[i].spid == spid || bcontchargedata[i].spid.toLowerCase() == "all")) {
                var rowNum = i + 1;
                mini.alert("商铺已被[" + CONSTANT_GRID5_NAME + "]第" + rowNum + "行明细的商铺[" + bcontchargedata[i].spid_name + "]所引用不能修改或删除，请检查 ");
                return false;
            }
        }
    }
    if (bcontgoods) {
        var bcontgoodsdata = bcontgoods.getData();
        for (var i = 0; i < bcontgoodsdata.length; i++) {
            if (spid && (bcontgoodsdata[i].spid == spid || bcontgoodsdata[i].spid.toLowerCase() == "all")) {
                var rowNum = i + 1;
                mini.alert("商铺已被[" + CONSTANT_GRID7_NAME + "]第" + rowNum + "行明细的商铺[" + bcontgoodsdata[i].spid_name + "]所引用不能修改或删除，请检查 ");
                return false;
            }
        }
    }
    return true;
};

//变更单删除商品时检查商品是否已存在
function checkcontgoodsflag(contno, gbid) {
    var flag = false;
    var searchParam = {
        "contno": contno,
        "gbid": gbid
    };
    itemLoader.doRequest(OmdUrl.mall, "mall.work.contevent.checkContGoodsFlag", searchParam, null, null, function (data) {
        if (data.ret && data.ret == "Y") {
            flag = true;
        }
        ;
    }, null, null, false);
    return flag;
};

//删除商品时更新明细状态
function setModflag(rows, grid) {
    if (rows.length > 0) {
        for (var i = 0; i < rows.length; i++) {
            var row = rows[i];
            var newrow = {};
            if (row.modflag == "I") {
                grid.removeRow(row);
            } else {
                newrow.modflag = "D";
                grid.updateRow(row, newrow);
            }
            grid.removeRow(row);
        }
    }
};

//检查商铺有效期与合同有效期是否交叉
function checkSpidDataCross(data) {
    var form = details1.form;
    var contno = form.getField("contno").getValue();
    for (var i = 0; i < data.length; i++) {
        if (data[i].flag != 'D') {
            var temp = checkEffSpCont(data[i], contno);
            if (temp && temp != "") {
                mini.alert("商铺[" + data[i].spid_name + "]的有效日期与合同[" + temp + "]的商铺有效日期存在交叉，请重新输入商铺");
                return false;
            }
        }
    }
    return true;
};

//检查出商铺的有效合同
function checkEffSpCont(row, contno) {
    var temp = "";
    var searchParam = {
        "spid": row.spid,
        "muid": row.muid,
        "sdate": row.sdate.substring(0, 10),
        "edate": row.edate.substring(0, 10)
    };
    if (contno != undefined && contno != "") {
        searchParam.contno = contno;
    }
    itemLoader.doRequest(OmdUrl.mall, "mall.work.contevent.searchEffSpCont", searchParam, null, null, function (data) {
        if (data && data.contno) {
            temp = data.contno;
        }
    }, null, null, false);
    return temp;
};

//价格
function Monthprice(spid, ccarea, cycunit, rentprice) {
    var para = {};
    para.data = "0";
    var area = getArea(spid);
    var spbuildarea = Number(area.spbuildarea);//建筑面积
    if (ccarea == "B") {
        area = Number(area.spbuildarea);//建筑面积
    } else if (ccarea == "R") {
        area = Number(area.splettarea); //套内面积
    }
    if (cycunit == "3") {
        para.data = rentprice * 30.5;
    } else if (cycunit == "1") {
        para.data = rentprice * area * 30.5;
    } else if (cycunit == "4" || cycunit == "8" || cycunit == "12") {
        para.data = rentprice;
    } else if (cycunit == "2" || cycunit == "9" || cycunit == "13") {
        para.data = rentprice * area;
    } else if (cycunit == "10") {
        para.data = rentprice / 12;
    } else {
        para.data = "0";
    }
    return para;
};

//获取面积
function getArea(code) {
    var para = {};
    para.spbuildarea = "0"; //建筑面积
    para.splettarea = "0"; //套内面积
    var data = bcontmanaframe.getData();
    if (code.toLowerCase() == "all") {
        for (var i = 0; i < data.length; i++) {
            para.spbuildarea = accAdd(para.spbuildarea, data[i].spbuildarea);
            para.splettarea = accAdd(para.splettarea, data[i].splettarea);
        }
    } else {
        for (var i = 0; i < data.length; i++) {
            if (data[i].spid == code) {
                para.spbuildarea = data[i].spbuildarea;
                para.splettarea = data[i].splettarea;
                break;
            }
        }
    }
    return para;
};

//超额销售检查
function checkCbsum(field, record, value) {
    var cbsum1 = 0;
    var cbsum2 = 0;
    var cbsum3 = 0;
    var cbsum4 = 0;
    var cbsum5 = 0;
    var cbsum6 = 0;
    if (record.cbsum1 != undefined && record.cbsum1 != "") {
        cbsum1 = Number(record.cbsum1);
    }
    if (record.cbsum2 != undefined && record.cbsum2 != "") {
        cbsum2 = Number(record.cbsum2);
    }
    if (record.cbsum3 != undefined && record.cbsum3 != "") {
        cbsum3 = Number(record.cbsum3);
    }
    if (record.cbsum4 != undefined && record.cbsum4 != "") {
        cbsum4 = Number(record.cbsum4);
    }
    if (record.cbsum5 != undefined && record.cbsum5 != "") {
        cbsum5 = Number(record.cbsum5);
    }
    if (record.cbsum6 != undefined && record.cbsum6 != "") {
        cbsum6 = Number(record.cbsum6);
    }
    if (Number(value) == 0) {
        return true;
    }
    var arr2 = [cbsum1, cbsum2, cbsum3, cbsum4, cbsum5, cbsum6];
    var resulttemp2 = {};
    if (field == "cbsum2") {
        arr2[1] = Number(value);
        resulttemp2 = cdsumisins(arr2, arr2.length);
        if (resulttemp2.flag == false) {
            mini.alert("超额销售" + (resulttemp2.max + 1) + "必须大于超额销售" + (resulttemp2.min + 1) + "，请检查！");
            return;
        }
    } else if (field == "cbsum3") {
        arr2[2] = Number(value);
        resulttemp2 = cdsumisins(arr2, arr2.length);
        if (resulttemp2.flag == false) {
            mini.alert("超额销售" + (resulttemp2.max + 1) + "必须大于超额销售" + (resulttemp2.min + 1) + "，请检查！");
            return;
        }
    } else if (field == "cbsum4") {
        arr2[3] = Number(value);
        resulttemp2 = cdsumisins(arr2, arr2.length);
        if (resulttemp2.flag == false) {
            mini.alert("超额销售" + (resulttemp2.max + 1) + "必须大于超额销售" + (resulttemp2.min + 1) + "，请检查！");
            return;
        }
    } else if (field == "cbsum5") {
        arr2[4] = Number(value);
        resulttemp2 = cdsumisins(arr2, arr2.length);
        if (resulttemp2.flag == false) {
            mini.alert("超额销售" + (resulttemp2.max + 1) + "必须大于超额销售" + (resulttemp2.min + 1) + "，请检查！");
            return;
        }
    } else if (field == "cbsum6") {
        arr2[5] = Number(value);
        resulttemp2 = cdsumisins(arr2, arr2.length);
        if (resulttemp2.flag == false) {
            mini.alert("超额销售" + (resulttemp2.max + 1) + "必须大于超额销售" + (resulttemp2.min + 1) + "，请检查！");
            return;
        }
    }
    return true;
};

//判断超额销售是否逐级递增
function cdsumisins(arr, len) {
    if (len <= 1) {
        return {flag: true};
    } else {
        for (var i = len; i > 0; i--) {
            if (arr[i - 1] != 0) {
                return recursion(arr, i);
            }
        }
        return {flag: true};
    }
};

function recursion(arr, len) {
    if (len <= 1) {
        return {flag: true};
    } else {
        if ((arr[len - 1] > arr[len - 2]) && (recursion(arr, len - 1)).flag) {
            return {flag: true};
        } else if (arr[len - 1] <= arr[len - 2]) {
            return {
                flag: false,
                min: len - 2,
                max: len - 1
            }
        } else {
            return recursion(arr, len - 1);
        }
    }
};

//检查租金价格
function checkRentprice(field, record, value) {
    var rentprice1 = 0;
    var rentprice2 = 0;
    var rentprice3 = 0;
    var rentprice4 = 0;
    var rentprice5 = 0;
    var rentprice6 = 0;
    if (record.rentprice1 != undefined && record.rentprice1 != "") {
        rentprice1 = Number(record.rentprice1);
    }
    if (record.rentprice2 != undefined && record.rentprice2 != "") {
        rentprice2 = Number(record.rentprice2);
    }
    if (record.rentprice3 != undefined && record.rentprice3 != "") {
        rentprice3 = Number(record.rentprice3);
    }
    if (record.rentprice4 != undefined && record.rentprice4 != "") {
        rentprice4 = Number(record.rentprice4);
    }
    if (record.rentprice5 != undefined && record.rentprice5 != "") {
        rentprice5 = Number(record.rentprice5);
    }
    if (record.rentprice6 != undefined && record.rentprice6 != "") {
        rentprice6 = Number(record.rentprice6);
    }
    if (Number(value) == 0) {
        return true;
    }
    if (field == "rentprice2") {
        if (value <= rentprice1) {
            mini.alert("租金价格2必须大于租金价格1");
            return false;
        }
    } else if (field == "rentprice3") {
        if (value <= rentprice1) {
            mini.alert("租金价格3必须大于租金价格1");
            return false;
        }
        if (value <= rentprice2) {
            mini.alert("租金价格3必须大于租金价格2");
            return false;
        }
    } else if (field == "rentprice4") {
        if (value <= rentprice1) {
            mini.alert("租金价格4必须大于租金价格1");
            return false;
        }
        if (value <= rentprice2) {
            mini.alert("租金价格4必须大于租金价格2");
            return false;
        }
        if (value <= rentprice3) {
            mini.alert("租金价格4必须大于租金价格3");
            return false;
        }
    } else if (field == "rentprice5") {
        if (value <= rentprice1) {
            mini.alert("租金价格5必须大于租金价格1");
            return false;
        }
        if (value <= rentprice2) {
            mini.alert("租金价格5必须大于租金价格2");
            return false;
        }
        if (value <= rentprice3) {
            mini.alert("租金价格5必须大于租金价格3");
            return false;
        }
        if (value <= rentprice4) {
            mini.alert("租金价格5必须大于租金价格4");
            return false;
        }
    } else if (field == "rentprice6") {
        if (value <= rentprice1) {
            mini.alert("租金价格6必须大于租金价格1");
            return false;
        }
        if (value <= rentprice2) {
            mini.alert("租金价格6必须大于租金价格2");
            return false;
        }
        if (value <= rentprice3) {
            mini.alert("租金价格6必须大于租金价格3");
            return false;
        }
        if (value <= rentprice4) {
            mini.alert("租金价格6必须大于租金价格4");
            return false;
        }
        if (value <= rentprice5) {
            mini.alert("租金价格6必须大于租金价格5");
            return false;
        }
    }
    return true;
};

//检查商品是否存在
function checkGbid(gbid, contno) {
    var flag = false;
    var searchParam = {
        "gbid": gbid,
    };
    itemLoader.doRequest(OmdUrl.mallmdm, "mall.mdm.goodsbase.search", searchParam, null, null, function (data) {
        if (data && data.zlgbid.num > 0) {
            flag = true;
        }
    }, null, null, false);
    return flag;
};

//保存时检查明细是否录入
function cellCheck(grid, name) {
    if (grid) {
        var columns = grid.columns;
        var obj = grid.getData();
        if (obj.length == 0) {
            return true;
        }
        for (var i = 0; i < columns.length; i++) {
            if (columns[i].required && columns[i].field && columns[i].visible != false) {
                for (var j = 0; j < obj.length; j++) {
                    var rownum = j + 1;
                    if (!obj[j][columns[i].field] && parseFloat(obj[j][columns[i].field]) != 0) {
                        mini.alert(name + "第" + rownum + "行明细的[" + columns[i].header + "]没有录入，请检查");
                        return false;
                    }
                }
            }
        }
        return true;
    } else {
        return true;
    }
};

//保存时检查商品例外明细是否录入
function goodsklCellCheck(grid, name) {
    if (grid) {
        var columns = grid.columns;
        var obj = grid.getData();
        if (obj.length == 0) {
            return true;
        }
        for (var i = 0; i < columns.length; i++) {
            if (columns[i].required && columns[i].field && columns[i].visible != false) {
                for (var j = 0; j < obj.length; j++) {
                    var rownum = getGoodsklRowNum(obj[j]);
                    if (!obj[j][columns[i].field] && parseFloat(obj[j][columns[i].field]) != 0) {
                        mini.alert("商品编号[" + obj[j].gbid + "]" + name + "第" + rownum + "行明细的[" + columns[i].header + "]没有录入，请检查");
                        return false;
                    }
                }
            }
        }
        return true;
    } else {
        return true;
    }
};

//保存时检查日期是否正确
function saveCheck() {
    var form = details1.form;
    var sdate = mini.formatDate(form.getField("cmeffdate").getValue(), "yyyy-MM-dd");
    var edate = mini.formatDate(form.getField("cmlapdate").getValue(), "yyyy-MM-dd");
    var data1 = mini.formatDate(form.getField("cmeffdate").getValue(), "yyyyMMdd");
    var data2 = mini.formatDate(form.getField("cmlapdate").getValue(), "yyyyMMdd");
    var ccdate = mini.formatDate(form.getField("ccdate").getValue(), "yyyy-MM-dd");
    if (data1 && data2 && data1 > data2) {
        mini.alert("合同失效日期不能小于合同生效日期");
        return false;
    } else if (ccdate > edate) {
        mini.alert("撤场日期不能大于合同失效日期");
        return false;
    } else {
        var para = getAllMinMaxDate(isWmid());
        if (para.sdate != undefined && para.sdate != "" && sdate > para.sdate) {
            mini.alert("合同生效日期 不能大于" + para.sname + "的第" + para.snum + "行的开始日期(" + para.sdate + ")");
            return false;
        }
        if (para.edate != undefined && para.edate != "" && edate < para.edate) {
            mini.alert("合同失效日期 不能小于" + para.ename + "的第" + para.enum + "行的结束日期(" + para.edate + ")");
            return false;
        }
    }
    return true;
};

//检查日期是否在商铺有效期内
function checkSpidData(grid, sname, ename, tablename) {
    var data = bcontmanaframe.getData();
    var data2 = grid.getData();
    for (var i = 0; i < data.length; i++) {
        for (var j = 0; j < data2.length; j++) {
            if (data[i].spid.toLowerCase() == "all" || data2[j].spid.toLowerCase() == "all" || data[i].spid == data2[j].spid) {
                var rownum2 = j + 1;
                var sdate = data[i].sdate.substring(0, 10);
                var tempsdate = data2[j][sname].substring(0, 10);
                if (tempsdate < sdate) {
                    mini.alert("明细" + tablename + "第" + rownum2 + "行的时间不在" + CONSTANT_GRID1_NAME + "的商铺[" + data[i].spid_name + "]的有效时间内，请检查 ");
                    return false;
                }
                var edate = data[i].edate.substring(0, 10);
                var tempedate = data2[j][ename].substring(0, 10);
                if (tempedate > edate) {
                    mini.alert("明细" + tablename + "第" + rownum2 + "行的时间不在" + CONSTANT_GRID1_NAME + "的商铺[" + data[i].spid_name + "]的有效时间内，请检查 ");
                    return false;
                }
            }
        }
    }
    return true;
};

function getSetModeCode(setmodecode){
    var setModeData = dictData.SETMODE;
    var pro1 = "";
    var setModeStr = [];
    if(setModeData != null && setModeData.length > 0){
        for (var i = 0; i < setModeData.length; i++) {
            if (setModeData[i].code == setmodecode){
                pro1 = setModeData[i].pro1;
                break;
            }
        }
        for (var i = 0; i < setModeData.length; i++) {
            if (setModeData[i].pro1 == pro1){
                setModeStr.push(setModeData[i].code);
            }
        }
    }
    return setModeStr;
}

//明细数据检查
function checkdetaildata(grid, sname, ename, svalue, evalue, row) {
    var data = grid.getData();
    for (var i = 0; i < data.length; i++) {
        if (grid == bcontbd) {
            if (row.setmode != undefined && row.setmode != "") {
                var setmode = getSetModeCode(row.setmode);
                for (var x = 0; x < setmode.length; x++) {
                    if (setmode[x].dcode == data[i].setmode) {
                        if (row._id != data[i]._id && row.spid && data[i].spid) {
                            if (row.spid.toLowerCase() == "all" || data[i].spid.toLowerCase() == "all" || row.spid == data[i].spid) {
                                if (svalue != "") {
                                    if (svalue >= data[i][sname] && svalue <= data[i][ename]) {
                                        var rownum = i + 1;
                                        mini.alert("开始日期与第" + rownum + "行的时间存在交叉，请重新输入开始日期 ");
                                        return false;
                                    }
                                }
                                ;
                                if (evalue != "") {
                                    if (evalue >= data[i][sname] && evalue <= data[i][ename]) {
                                        var rownum = i + 1;
                                        mini.alert("结束日期与第" + rownum + "行的时间存在交叉，请重新输入结束日期 ");
                                        return false;
                                    }
                                }
                            }
                        }
                    }
                }
            } else {
                if (row._id != data[i]._id && row.spid && data[i].spid) {
                    if (row.spid.toLowerCase() == "all" || data[i].spid.toLowerCase() == "all" || row.spid == data[i].spid) {
                        if (svalue != "") {
                            if (svalue >= data[i][sname] && svalue <= data[i][ename]) {
                                var rownum = i + 1;
                                mini.alert("开始日期与第" + rownum + "行的时间存在交叉，请重新输入开始日期 ");
                                return false;
                            }
                        }
                        ;
                        if (evalue != "") {
                            if (evalue >= data[i][sname] && evalue <= data[i][ename]) {
                                var rownum = i + 1;
                                mini.alert("结束日期与第" + rownum + "行的时间存在交叉，请重新输入结束日期 ");
                                return false;
                            }
                        }
                    }
                }
            }
            ;
        } else if (grid == bcontgoodskl) {
            if (row._id != data[i]._id && row.gbid && data[i].gbid) {
                if (row.gbid.toLowerCase() == "all" || data[i].gbid.toLowerCase() == "all" || row.gbid == data[i].gbid) {
                    if (svalue != "") {
                        if (svalue >= data[i][sname] && svalue <= data[i][ename]) {
                            var rownum = i + 1;
                            mini.alert("开始日期与第" + rownum + "行的时间存在交叉，请重新输入开始日期 ");
                            return false;
                        }
                    }
                    ;
                    if (evalue != "") {
                        if (evalue >= data[i][sname] && evalue <= data[i][ename]) {
                            var rownum = i + 1;
                            mini.alert("结束日期与第" + rownum + "行的时间存在交叉，请重新输入结束日期 ");
                            return false;
                        }
                    }
                    ;
                }
            }
        } else {
            if (row._id != data[i]._id && row.spid && data[i].spid) {
                if ((row.spid.toLowerCase() == "all" || data[i].spid.toLowerCase() == "all" || row.spid == data[i].spid) && row.cccode == data[i].cccode) {
                    if (svalue != "") {
                        if (svalue >= data[i][sname] && svalue <= data[i][ename]) {
                            var rownum = i + 1;
                            mini.alert("开始日期与第" + rownum + "行的时间存在交叉，请重新输入开始日期 ");
                            return false;
                        }
                    }
                    if (evalue != "") {
                        if (evalue >= data[i][sname] && evalue <= data[i][ename]) {
                            var rownum = i + 1;
                            mini.alert("结束日期与第" + rownum + "行的时间存在交叉，请重新输入结束日期 ");
                            return false;
                        }
                    }
                }
            }
        }
    }
    return true;
};

function checkdetaildata2(grid, sname, ename, tablename) {
    var data = grid.getData();
    var data2 = grid.getData();
    for (var i = 0; i < data.length; i++) {
        svalue = data[i][sname];
        evalue = data[i][ename];
        if (svalue && svalue.length > 10) {
            svalue = svalue.substring(0, 10);
        }
        if (evalue && evalue.length > 10) {
            evalue = evalue.substring(0, 10);
        }
        var rownum = i + 1;
        if (svalue > evalue) {
            mini.alert("明细[" + tablename + "]的第" + rownum + "行结束日期不能小于开始日期，请检查");
            return false;
        }
        for (var j = i + 1; j < data2.length; j++) {
            if (grid == bcontbd) {
                if (data[i].setmode != undefined && data[i].setmode != "") {
                    var setmode = getSetModeCode(data[i].setmode);
                    for (var x = 0; x < setmode.length; x++) {
                        if (setmode[x].dcode == data[j].setmode) {
                            if (data[i].spid.toLowerCase() == "all" || data[j].spid.toLowerCase() == "all" || data[i].spid == data[j].spid) {
                                var rownum2 = j + 1;
                                if (!checkCommonData(svalue, evalue, data[j][sname], data[j][ename], rownum, rownum2, tablename)) {
                                    return false;
                                }
                            }
                            break;
                        }
                    }
                } else {
                    if (data[i].spid.toLowerCase() == "all" || data[j].spid.toLowerCase() == "all" || data[i].spid == data[j].spid) {
                        var rownum2 = j + 1;

                        if (!checkCommonData(svalue, evalue, data[j][sname], data[j][ename], rownum, rownum2, tablename)) {
                            return false;
                        }
                    }
                }
            } else if (grid == bcontgoodskl) {
                if (data[i].gbid == data[j].gbid || data[i].gbid.toLowerCase() == "all" || data[j].gbid.toLowerCase() == "all") {
                    var tempRowNum = getGoodsklRowNum(data[i]);
                    var tempRowNum2 = getGoodsklRowNum(data[j]);
                    tablename = "商品编号[" + data[i].gbid + "]" + tablename;
                    if (!checkCommonData(svalue, evalue, data[j][sname], data[j][ename], tempRowNum, tempRowNum2, tablename)) {
                        return false;
                    }
                }
            } else {
                if ((data[i].spid.toLowerCase() == "all" || data[j].spid.toLowerCase() == "all" || data[i].spid == data[j].spid) && data[i].cccode == data[j].cccode) {
                    var rownum2 = j + 1;
                    if (!checkCommonData(svalue, evalue, data[j][sname], data[j][ename], rownum, rownum2, tablename)) {
                        return false;
                    }
                }
            }
        }
    }
    return true;
};

//判断是否断档
function checkdetaildata3(grid, sname, ename, tablename) {
    var datamanaframe = bcontmanaframe.getData();
    var data = grid.getData();
    for (var j = 0; j < datamanaframe.length; j++) {
        var arr = [];
        for (var i = 0; i < data.length; i++) {
            var isqs = checkisqs(data[i].setmode);
            if (datamanaframe[j].spid.toLowerCase() == "all") {
                if (data[i].spid.toLowerCase() == "all" && (isqs == "Y" || isqs == "X")) {
                    svalue = data[i][sname];
                    evalue = data[i][ename];
                    var newrow = {
                        sdate: svalue,
                        edate: evalue,
                        rownum: i + 1
                    };
                    arr.push(newrow);
                }
            } else {
                if ((data[i].spid.toLowerCase() == "all" || data[i].spid == datamanaframe[j].spid) && (isqs == "Y" || isqs == "X")) {
                    svalue = data[i][sname];
                    evalue = data[i][ename];
                    var newrow = {
                        sdate: svalue,
                        edate: evalue,
                        rownum: i + 1
                    };
                    arr.push(newrow);
                }
            }
        }
        var sortarrbyproperty = arr.sort(comparebyproperty(sname));
        var lengthtemp = sortarrbyproperty.length;
        for (var i = 0; i < lengthtemp - 1; i++) {
            var times = mini.parseDate(sortarrbyproperty[i + 1]['sdate']) - mini.parseDate(sortarrbyproperty[i]['edate']);
            if (times > 86400000 || times <= 0) {   //时间差大于一天
                mini.alert("明细[" + tablename + "]的" + sortarrbyproperty[i]['rownum'] + "行和" + sortarrbyproperty[i + 1]['rownum'] + "行日期有断档");
                return;
            }
        }
        var arr1 = [];
        for (var i = 0; i < data.length; i++) {
            var isqs = checkisqs(data[i].setmode);
            if (datamanaframe[j].spid.toLowerCase() == "all") {
                if (data[i].spid.toLowerCase() == "all" && (isqs == "N" || isqs == "X")) {
                    svalue = data[i][sname];
                    evalue = data[i][ename];
                    var newrow = {
                        sdate: svalue,
                        edate: evalue,
                        rownum: i + 1
                    };
                    arr1.push(newrow);
                }
            } else {
                if ((data[i].spid.toLowerCase() == "all" || data[i].spid == datamanaframe[j].spid) && (isqs == "N" || isqs == "X")) {
                    svalue = data[i][sname];
                    evalue = data[i][ename];
                    var newrow = {
                        sdate: svalue,
                        edate: evalue,
                        rownum: i + 1
                    };
                    arr1.push(newrow);
                }
            }
        }
        var sortarrbyproperty1 = arr1.sort(comparebyproperty(sname));
        var lengthtemp1 = sortarrbyproperty1.length;
        for (var i = 0; i < lengthtemp1 - 1; i++) {
            var times1 = mini.parseDate(sortarrbyproperty1[i + 1]['sdate']) - mini.parseDate(sortarrbyproperty1[i]['edate']);
            if (times1 > 86400000 || times1 <= 0) {   //时间差大于一天
                mini.alert("明细[" + tablename + "]的" + sortarrbyproperty1[i]['rownum'] + "行和" + sortarrbyproperty1[i + 1]['rownum'] + "行日期有断档");
                return;
            }
        }
    }
    return true;
};

function checkCommonData(svalue, evalue, tsvalue, tevalue, rownum, trownum, tablename) {
    if (svalue && svalue.length > 10) {
        svalue = svalue.substring(0, 10);
    }
    if (evalue && evalue.length > 10) {
        evalue = evalue.substring(0, 10);
    }
    if (tsvalue && tsvalue.length > 10) {
        tsvalue = tsvalue.substring(0, 10);
    }
    if (tevalue && tevalue.length > 10) {
        tevalue = tevalue.substring(0, 10);
    }
    if (svalue >= tsvalue && svalue <= tevalue) {
        mini.alert("明细" + tablename + "第" + rownum + "行与第" + trownum + "行的时间存在交叉，请检查 ");
        return false;
    }
    if (evalue >= tsvalue && evalue <= tevalue) {
        mini.alert("明细" + tablename + "第" + rownum + "行与第" + trownum + "行的时间存在交叉，请检查 ");
        return false;
    }
    if (tsvalue >= svalue && tsvalue <= evalue) {
        mini.alert("明细" + tablename + "第" + rownum + "行与第" + trownum + "行的时间存在交叉，请检查 ");
        return false;
    }
    if (tevalue >= svalue && tevalue <= evalue) {
        mini.alert("明细" + tablename + "第" + rownum + "行与第" + trownum + "行的时间存在交叉，请检查 ");
        return false;
    }
    return true;
};

function getGoodsklRowNum(obj) {
    var data = bcontgoodskl.findRows(function (row) {
        if (row.gbid == obj.gbid) return true;
    });
    var rowNum = 0;
    for (var i = 0; i < data.length; i++) {
        if (data[i]._id == obj._id) {
            rowNum = i + 1;
            break;
        }
    }
    return rowNum;
};

//指定排序的比较函数
function comparebyproperty(property) {
    return function (obj1, obj2) {
        var value1 = obj1[property];
        var value2 = obj2[property];
        return value1 - value2;  //升序
    }
};

//删除明细行时检查费用是否使用
function checkfeeflag(ph_key) {
    var flag = false;
    var searchParam = {
        "ph_key": ph_key
    };
    itemLoader.doRequest(OmdUrl.mall, "mall.work.contevent.checkFeeFlag", searchParam, null, null, function (data) {
        if (data.ret && data.ret == "Y") {
            flag = true;
        }
    }, null, null, false);
    return flag;
};

//删除单据前处理刷新租金管理费数据 未改造
function delDataSplit(billno) {
    var searchParam = {
        "billno": billno
    };
    itemLoader.doRequest(OmdUrl.mall, "mall.work.bcont.delDataSplit", searchParam, null, null, function (data) {
        if (data.flag != null && data.flag == "1") {
        } else {
        }
    }, null, null, false);
};

//保存时检查收取日期
function checksqdata(rows) {
    var rownum = 0;
    for (var i = 0; i < rows.length; i++) {
        rownum = i + 1;
        if (rows[i].sqmode == "3") {
            if (!rows[i].sqdate) {
                mini.alert(CONSTANT_GRID5_NAME + "第" + rownum + "行的收取日期没有输入，请检查");
                return false;
            }
        }
    }
    return true;
};

//保存后生成租金管理费数据  待处理
function refreshData(billno) {
    var searchParam = {
        "billno": billno
    };
    itemLoader.doRequest(OmdUrl.mall, "mall.work.bcont.refreshData", searchParam, null, null, function (data) {
        if (data.flag != null && data.flag == "1") {
        } else {
        }
    }, null, null, false);
};