selectwindow = function (config) {
    selectwindow.superclass.constructor.call(this);
    this.set(config);
    this.initControls();
    this.initEvents();
};
mini.extend(selectwindow, mini.Window, {
    url: "",
    keyField: "key",
    title: "选择",
    gridconfig: {},
    defaulecond: {},
    width: 800,
    height: 600,
    bodyStyle: "padding:0;",
    allowResize: true,
    showModal: true,
    showToolbar: true,
    showFooter: true,
    initControls: function () {
        var toolbarEl = this.getToolbarEl();
        var footerEl = this.getFooterEl();
        var bodyEl = this.getBodyEl();
        var thisEl = this.getEl();
        var toolbarHtml = '<div style="width:100%;">'
            + ' <div class="mini-toolbar" style="border-bottom:0;padding:2px;">'
            + '     <table style="width:100%;" cellspacing="0px;">'
            + '       <tr style="width: 100%">'
            + '           <td style="width: 100%" >'
            + '               <a name="searchBtn" class="mini-button" iconCls="icon-search" ">查询</a>'
            + '               <a name="cleanBtn" class="mini-button" iconCls="icon-reload" ">清空</a>'
            + '               <a  name="addBtn" class="mini-button" iconCls="icon-add" ">增加</a>'
            + '               <a  name="delBtn"  class="mini-button" iconCls="icon-remove" ">删除</a>'
           if (!this.singleSelect) {
        	   toolbarHtml = toolbarHtml + '<div name ="radiobuttonlist" class="mini-radiobuttonlist" repeatItems="1" repeatLayout="table" repeatDirection="vertical"'
        		  + ' textField="text" valueField="id"'
        		  + ' </div>';
       
           }
        	toolbarHtml = toolbarHtml + '           </td>'
            + '           <td style="white-space:nowrap;">'
            + '               <a  name="okBtn" class="mini-button" iconCls="icon-add" ">确定</a>'
            + '               <a  name="cancelBtn"  class="mini-button" iconCls="icon-remove" ">取消</a>'
            + '            </td>'
            + '       </tr>'
            + '   </table>'
            + ' </div>'
            + '</div>';
        //var toolbarEl = $(toolbarHtml);
        jQuery(toolbarEl).append(toolbarHtml);
        mini.parse(this.el);
        if (!this.singleSelect) {
        	 var rbldata = [
        	                { id: 1, text: '全选' },
        	                { id: 2, text: '全不选'},
        	                { id: 3, text: '反选'},
        	            ];
        	 mini.getbyName("radiobuttonlist", this).setData(rbldata);
        	 this._selectBtn = mini.getbyName("radiobuttonlist", this);
        }
       
        this._okBtn = mini.getbyName("okBtn", this);
        this._cancelBtn = mini.getbyName("cancelBtn", this);
        this._searchBtn = mini.getbyName("searchBtn", this);
        this._cleanBtn = mini.getbyName("cleanBtn", this);
        this._addBtn = mini.getbyName("addBtn", this);
        this._delBtn = mini.getbyName("delBtn", this);

        this.grid = new OcmControl.GridBox();
        this.grid.setConfig(this.gridconfig);
        this.grid.render(bodyEl);

        this.cond = new selectcondgrid();
        this.cond.setcolumnsConfig(this.grid.columns);
        this.cond.render(toolbarEl);
    },
    initEvents: function () {
        this._searchBtn.on("click", function (e) {
            var _conditions = [];
            // 处理查询条件
            var c = this.cond.getData();
            var _columns = this.cond._conf;
            for (var i = 0; i < c.length; i++) {
                if (
                    c[i].conditions_field != undefined &&
                    c[i].conditions_calculator != undefined &&
                    c[i].conditions_value != undefined &&
                    c[i].conditions_value != '') {
                    var re = /^\[(.*)\](.*)/;
                    var v = c[i].conditions_value;
                    if (re.test(v)) {
                        v = v.replace(re, '$1');
                    }
                    var dt;
                    for (var j = 0; j < _columns.length; j++) {
                        if (_columns[j].field === c[i].conditions_field) {
                            dt = _columns[j].dataType;
                            break;
                        };
                    };
                    if (_conditions.length == 0) {
                        _conditions
                            .push({
                                field: c[i].conditions_field,
                                calculator: c[i].conditions_calculator,
                                value: v,
                                datatype: dt
                            })
                    } else {
                        _conditions
                            .push({
                                relation: c[i].conditions_relationship,
                                field: c[i].conditions_field,
                                calculator: c[i].conditions_calculator,
                                value: v,
                                datatype: dt
                            })
                    }
                }
            }
            var searchParam = {};
            // var _origSearchParam = this.grid.config.searchParam;
            // if (_origSearchParam) {
            //     for (var prop in _origSearchParam) {
            //         if (_origSearchParam.hasOwnProperty(prop)) {
            //             searchParam[prop] = _origSearchParam[prop];
            //         }
            //     }
            // };
            // if (this.grid.config.initSearchParam) {
            //     var initSearchParam = JSON.parse(this.grid.config.initSearchParam);
            //     for (var prop3 in initSearchParam) {
            //         searchParam[prop3] = initSearchParam[prop3];
            //     }
            // }
            var AddDate = function (dt, days) {
                d = new Date(dt);
                d = +d + 1000 * 60 * 60 * 24 * days;
                d = new Date(d);
                return d.getFullYear() + "-" + (d.getMonth() + 1) + "-" + d.getDate();
            };
            var genRelation = function (data, index, flag) {
                var _flag = flag || 0;
                if (index < 0)
                    return;
                var _obj = {};
                _obj[data[index].field] = {};
                if (data[index].calculator === "LIKE") {
                    data[index].value = "%" + data[index].value + "%";
                }
                if (data[index].calculator == "==" && data[index].datatype == "date") {
                    _obj[data[index].field][">="] = data[index].value;
                    _obj[data[index].field]["<"] = AddDate(data[index].value, 1);
                } else if (data[index].calculator == "<=" && data[index].datatype == "date"){
                    _obj[data[index].field]["<"] = AddDate(data[index].value, 1);
                } else if (data[index].calculator == ">" && data[index].datatype == "date"){
                    _obj[data[index].field][">="] = AddDate(data[index].value, 1);
                } else {
                    _obj[data[index].field][data[index].calculator] = data[index].value;
                }
                if (data[index].relation || data[index].relation == '0') {
                    var att = (data[index].relation == '0' ? "$and" : data[index].relation );
                    if (!searchParam[att]) {
                        searchParam[att] = [];
                    }
                    searchParam[att].push(_obj);
                    _flag = genRelation(data, index - 1, _flag + 1);
                } else {
                    var att = (data[index + 1].relation == '0' ? "$and" : data[index + 1].relation );
                    searchParam[att].push(_obj);
                }
                return (_flag == 0 ? 1 : _flag);
            };
            for (var y = _conditions.length; y > 0; y--) {
                if (_conditions[y - 1].calculator === "LIKE") {
                    _conditions[y - 1].value = "%" +  _conditions[y - 1].value + "%";
                }
                if (!searchParam[_conditions[y - 1].field] &&
                    !(_conditions[y - 1].relation) && _conditions[y - 1].relation != '0') {
                    if (_conditions[y - 1].calculator == "==" && _conditions[y - 1].datatype == "date") {
                        searchParam[_conditions[y - 1].field] = {};
                        searchParam[_conditions[y - 1].field][">="] = _conditions[y - 1].value;
                        searchParam[_conditions[y - 1].field]["<"] = AddDate(
                            _conditions[y - 1].value, 1);
                    } else if (_conditions[y - 1].calculator == "<=" && _conditions[y - 1].datatype == "date") {
                        searchParam[_conditions[y - 1].field] = {};
                        searchParam[_conditions[y - 1].field]["<"] = AddDate( _conditions[y - 1].value, 1);
                    }else if (_conditions[y - 1].calculator == ">" && _conditions[y - 1].datatype == "date") {
                        searchParam[_conditions[y - 1].field] = {};
                        searchParam[_conditions[y - 1].field][">="] = AddDate( _conditions[y - 1].value, 1);
                    }else {
                        if (_conditions[y - 1].field == "inputer" || _conditions[y - 1].field == "auditor" || _conditions[y - 1].field == "canceler") {
                            var field_name = _conditions[y - 1].field + "_name";
                            if (_conditions[y - 1].calculator == "==") {
                                searchParam["$or"] = {};
                                var param = {};
                                param[_conditions[y - 1].field] = {};
                                param[field_name] = {};
                                param[_conditions[y - 1].field][_conditions[y - 1].calculator] = _conditions[y - 1].value;
                                param[field_name]["LIKE"] = "[%]" + _conditions[y - 1].value;
                                searchParam["$or"] = param;
                            } else if (_conditions[y - 1].calculator === "LIKE") {
                                searchParam[field_name] = {};
                                searchParam[field_name][_conditions[y - 1].calculator] = _conditions[y - 1].value;
                            }
                        } else {
                            searchParam[_conditions[y - 1].field] = {};
                            searchParam[_conditions[y - 1].field][_conditions[y - 1].calculator] = _conditions[y - 1].value;
                        }
                    }
                } else {
                    if (searchParam[_conditions[y - 1].field]) {
                        if (!searchParam["$and"]) {
                            searchParam["$and"] = []
                        }
                        var tempParam={};
                        tempParam[_conditions[y - 1].field] = searchParam[_conditions[y - 1].field]
                        tempParam[_conditions[y - 1].field][_conditions[y - 1].calculator] = _conditions[y - 1].value;
                        searchParam["$and"].push(tempParam);
                        delete searchParam[_conditions[y - 1].field];
                    }
                }
                if (_conditions[y - 1].relation || _conditions[y - 1].relation == '0') {
                    var _x = genRelation(_conditions, y - 1);
                    y = y - _x;
                }
            };
            searchParam['page_no'] = "1"; // 回到第一页
            var searchParambak = {};
            if (this.grid.config.initSearchParam) {
                var initSearchParam = JSON.parse(this.grid.config.initSearchParam);
                for (var prop3 in initSearchParam) {
                    searchParambak[prop3] = initSearchParam[prop3];
                }
            }
            // var searchParambak = this.grid.config.searchParam;
            searchParam = $.extend({}, searchParambak, this.defaultcond || {}, searchParam);
            this.grid.getResources(searchParam);
        }, this);

        this._addBtn.on("click", function (e) {
            this.cond.add();

        }, this);

        this._delBtn.on("click", function (e) {
            this.cond.del();
        }, this);

        this._cleanBtn.on("click", function (e) {
            this.cond.celear();
        }, this);
        if (!this.singleSelect) {
        	 this._selectBtn.on("valuechanged", function (e) {
             	if (e.value == "1") {
             		 this.grid.selectAll(true);
             	} else if (e.value == "2") {
             		this.grid.deselectAll (true);
             	} else if (e.value == "3") {
             		var rows = this.grid.getSelecteds();
             		this.grid.selectAll(true);
             		this.grid.deselects  (rows);
             	}
             }, this);
        }
        this._okBtn.on("click", function (e) {
            var ret = true;
            var row = this.getData();
            if (row.length <= 0) {
                mini.alert('请选择');
                return;
            }
            this.hide();
            this._Callback(row);
        }, this);
        this._cancelBtn.on("click", function (e) {
            var ret = true;
            this.hide();
        }, this);
        this.on("beforebuttonclick", function (e) {
            if (e.name == "close") {
                e.cancel = true;
                this.hide();
            }
        }, this);
        if (this.singleSelect){
        	 this.grid.on('rowdblclick', function (e) {
                 var ret = true;
                 var row = [];
                 row.push(e.record)
                 this.hide();
                 this._Callback(row);
             }, this);
        }
       
    },
    setCallback: function (callback) {
        this._Callback = callback;
    },
    setData: function (data, callback) {
        this._Callback = callback;
        //this.grid.selects(data);
    },
    getData: function () {
        var rows = this.grid.getSelecteds();
        return rows;
    },
    setDefaultCond: function (cond) {
        this.defaultcond = cond;
    },
    cleandata: function () {
        this.cond.celear();
        this.grid.clearRows();
    }
});
mini.regClass(selectwindow, "selectwindow");
