/**
 * 页面定义
 */
(function () {
	// 要引用的包
	var utils = Future.ns('Future.utils');
	var validate = Future.ns('Future.validate');
	var col = Future.ns('default.col');
	   
	// 活动命名空间
	var ns = Future.ns('attendance.view');

	// 定义一个对象用来配置界面
	var attendance = {};

	// 把定义对象放到命名空间下
	ns.attendance = attendance;

	// 查询列表
	attendance.attendancelist = {
		"type": "gridbox",
		"resources": OmdUrl.mss,
		name:"attendancelist",
		"method": "mss.work.attendance.search",
		"response": "attendanceconfig",
		"searchParam": {
			"order_field": "muid",
		},
		"properties": {
			"id": utils.createid('attendancelist'),
			"allowCellEdit" : "true",
			"allowCellSelect" : "true",
			"editNextOnEnterKey" : "true",
			"editNextRowCell" : "true",
			"allowSortColumn" : "false",
			"allowCellValid" : true,
			"oncellbeginedit" : "OcmControl.checkboxEditor",
			"columns": [{
				type: "indexcolumn",
				headerAlign: "center",
				header: "行号",
				readOnly : true,
				width: 50,
			}, {
				field: "ph_key",
				type: "TextBox",
				headerAlign: "center",
				header: "单据编号",
				visible:false,
			},{
				field: "muid",
				displayField : "muid_name",
				headerAlign: "center",
				header: "门店",
				editor:OcmControl.newControl('fut_popselectgrid'),
				editorSet: {
					selectkey:"muid",
					textName :"muid_name",
					// beforefunc:"head_beforefunc_muid_detail",
					itemchangedfunc:"page.head_itemchanged_muid_detail"
					}, 
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"muid"},
				required : true,
				width: 150,
			}, {
				field: "city",
				type: "TextBox",
				headerAlign: "center",
				header: "城市",
				readOnly : true,
				width: 80,
			},{
				field: "placelng",
				type: "TextBox",
				headerAlign: "center",
				header: "考勤地点经度",
				readOnly : true,
				visible : false,
				enabledSearch : false,
				value : "0",
			}, {
				field: "placelat",
				type: "TextBox",
				headerAlign: "center",
				header: "考勤地点纬度",
				readOnly : true,
				visible : false,
				enabledSearch : false,
				value : "0",
			},{
				field: "placename",
				type: "TextBox",
				headerAlign: "center",
				header: "考勤地点中文名",
				editor : OcmControl.newControl('ButtonEdit'),
				editorSet : {
					onbuttonclick : "page.saveMapData",
					allowInput : false
				},
				required : true,
				width: 250,
				
			},{
				field: "range",
				type: "TextBox",
				headerAlign: "center",
				header: "考勤范围",
				editor : OcmControl.newControl('NumButtonEdit'),
				editorSet:{
					format: "n0",
				},
				numberFormat : "n0",
				enabledSearch : false,
				required : true,
			}]
		}
	};
    var  toolsbaritems = $.extend(true, [], Future.pub.BaseSingleGrid.default_toolsbar);
    
   /* var  saveMapData = {
    		'text' : '定位',
    		'iconCls' : 'icon-search',
    		'name' : 'saveMapData',
    		 ibediting: 'Y',
    	     tabindex: '1',
    	     status: 'E'
    	} ;
    toolsbaritems.push(saveMapData);*/
	// 按钮配置 - 固定名称
	attendance.toolbarconfig = {
		id: utils.createid('systoolbar'),
		items:toolsbaritems
	};
	
	
    

	// 单据配置
	attendance.billconfig = {
		control: attendance.attendancelist, // 单据主表
	};
	// 创建标准单据配置
	utils.create_standardgrid_config(attendance);

})()
