/**
 * 页面定义
 */
(function () {
	// 要引用的包
	var utils = Future.ns('Future.utils');
	var validate = Future.ns('Future.validate');
	var col = Future.ns('default.col');
	// 活动命名空间
	var ns = Future.ns('balanceregister.view');

	// 定义一个对象用来配置界面
	var bill = {};
	var moduleid = app.modulecode;
	var billtype=getBilltype(moduleid);
	// 把定义对象放到命名空间下
	ns.bill = bill;
	// 查询列表
	bill.searchlist = {
		"type": "gridbox",
		"resources": OmdUrl.mss,
		"method": "mss.base.balanceregister.search",
		"response": "balanceregister",
		"bindform": "layouttabs",
		"bindSearchParam": ["ph_key"], // 明细页面查询条件字段
		"searchParam": {
			"billtype" : billtype,
			"order_field": "billno",
			"order_direction": "desc",
		},
		"properties": {
			"id": utils.createid('searchlist'),
			"columns": [{
				type: "indexcolumn",
				headerAlign: "center",
				header: "行号",
				width: 60,
			},{
				field: "billno",
				type:"TextBox",
				headerAlign:"center",
				header:"单据编号",
				width: "150",
			},{
				field: "billstatus",
				type:"TextBox",
				headerAlign:"center",
				header:"单据状态",
				renderer: "OcmControl.dictRendererWithCode",
				dictkey : 'BILLFLAG',
			},{
				field: "muid",
				displayField : "muid_name",
				type:"TextBox",
				headerAlign:"center",
				header:"门店",
				width: "200",
				cdEdtCfg : {
					compnentType : 'fut_popselect',
					selectkey : "muid",
					textName : "muid_name",
				}
			},{
				field: "sbid",
				displayField : "sbid_name",
				type:"TextBox",
				headerAlign:"center",
				header:"商户",
				width: "250",
				cdEdtCfg : {
					compnentType : 'fut_popselect',
					selectkey : "sbid",
					textName : "sbid_name",
				}
			},{
				field: "contno",
				displayField : "contno",
				type:"TextBox",
				headerAlign:"center",
				header:"合同编号",
				width: "150",
				cdEdtCfg : {
					compnentType : 'fut_popselect',
					selectkey : "contno",
					textName : "contno",
				}
			},{
				field: "ykcode",
				displayField : "ykcode_name",
				type:"TextBox",
				headerAlign:"center",
				header:"余款账号",
				width: "150",
				cdEdtCfg : {
					compnentType : 'fut_popselect',
					selectkey : "cccode_all",
					textName : "ykcode_name",
					searchParam:{wherestr: "ccdeftype = 7"},
				}
			},{
				field : "bccrje",
				headerAlign : "center",
				header : "本次存款",
				numberFormat : "c2",
				align: "right",
				enabledSearch : false,
				width:148,
			},{
				field : "wsyje",
				headerAlign : "center",
				header : "当前余款",
				numberFormat : "c2",
				align: "right",
				enabledSearch : false,
				width:148,
			},{
				field : "inputer_name",
				header : "录入人",
				width : 150,
				allowSort : true,
				headerAlign : "center",	
				enabledSearch : false,
			},{
				field : "inputer",
				header : "录入人",
				width : 100,
				allowSort : true,
				headerAlign : "center",	
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "inputer_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
				visible:false,
				enabledSearch : true,
			}, {
				field : "inputdate",
				type : "date",
				dataType : "date",
				format : "yyyy-MM-dd",
				header : "录入日期",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "auditor",
				header : "审核人",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "auditor_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
				visible:false,
				enabledSearch : true,
			}, {
				field : "auditor_name",
				header : "审核人",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				enabledSearch : false,
			}, {
				field : "auditdate",
				type : "date",
				format : "yyyy-MM-dd",
				header : "审核日期",
				width : 150,
				dataType : "date",
				allowSort : true,
				headerAlign : "center",
				align : "center",
			}, {
				field : "canceler",
				header : "取消人",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				editor:OcmControl.newControl('fut_popselectgrid'),
				displayField : "canceler_name",
				cdEdtCfg:{compnentType:'fut_popselect',selectkey:"user"},
				visible:false,
				enabledSearch : true,
			}, {
				field : "canceler_name",
				header : "取消人",
				width : 150,
				allowSort : true,
				headerAlign : "center",
				enabledSearch : false,
			}]
		}
	};
	
	// 单据主表
	bill.balanceregister = {
		"type": "formgrid",
		"resources": OmdUrl.mss,
		"name": 'balanceregister',
		"method": "mss.base.balanceregister.get",
		"response": "balanceregister",
		"properties": {
			"id": utils.createid('balanceregister')
		},
		items:[{
			"label" : "ph_key：",
			"name" : "ph_key",
			"type" : "TextBox",
			"visible":false,
		},{
			"label" : "单据编号：",
			"type" : "TextBox",
			"name" : "billno",
			"readOnly" : "true",
		}, {
			"label": "模块编号：",
			"name": "billmoduleid",
			"type": "TextBox",
			"defaultValue": moduleid,
			"visible": false
		}, {
			"label": "单据类型：",
			"name": "billtype",
			"type": "TextBox",
			"defaultValue": billtype,
			"visible": false
		},{
			"label" : "单据状态：",
			"name" : "billstatus",
			"type" : "ComboBox",
			"defaultValue":"N",
			dictkey : 'BILLFLAG',
			"readOnly": true,
		}, {
			"label": "单据类型：",
			"name": "billtype",
			"type": "ComboBox",
			"defaultValue": billtype,
			dictkey: 'BILLTYPE',
			"visible": false,
		}, {
			"label" : "门店：",
			displayField : "muid_name",
			"name" : "muid",
			"defaultValue" : "",
			"type": "ButtonEdit",
			"required" : "true",
			type : "fut_popselect",//类型
			selectkey:"muid",//弹框类型
			textName :"muid_name", //文本显示字段
			beforefunc:"page.head_beforefunc",
			itemchangedfunc:"page.head_itemchanged_muid",
		},{
			"label" : "商户：",
			"name" : "sbid",
			displayField : "sbid_name",
			"type": "ButtonEdit",
			"required" : "true",
			type : "fut_popselect",//类型
			selectkey:"sbid",//弹框类型
			textName :"sbid_name", //文本显示字段
			beforefunc:"page.head_beforefunc",
			itemchangedfunc:"page.head_itemchanged_sbid",
		},{
			"label" : "合同：",
			"name" : "contno",
			displayField : "contno",
			"type": "ButtonEdit",
			"required" : "true",
			type : "fut_popselect",//类型
			selectkey:"contno",//弹框类型
			textName :"contno", //文本显示字段
			beforefunc:"page.head_beforefunc",
			itemchangedfunc:"page.head_itemchanged_contno",
		},{
			"label" : "余款账号：",
			"name" : "ykcode",
			displayField : "ykcode_name",
			"type": "ButtonEdit",
			"required" : "true",
			type : "fut_popselect",//类型
			selectkey:"cccode_all",//弹框类型
			textName :"ykcode_name", //文本显示字段
			beforefunc:"page.head_beforefunc",
			itemchangedfunc:"page.head_itemchanged_ykcode",
		 },{
			"label" : "本次存款：",
			"name" : "bccrje",
			"type" : "NumButtonEdit",
			"format" : "c2",
			"defaultValue":0,
			/*"style" : "display:block;float:none"*/
		},{
			"label" : "当前余款：",
			"name" : "wsyje",
			"type" : "NumButtonEdit",
			"format" : "c2",
			"defaultValue":0,
			"readOnly" : "true",
			"style" : "display:block;float:none"
		},{
			"label" : "备注：",
			"name" : "memo",
			"type" : "TextBox",
			"style": "width:60%;display:block;float:none",
		},{
			"label" : "录入人编码",
			"type" : "TextBox",
			"name" : "inputer",
			"visible" : false,
		},{
			"label" : "录入人：",
			"type" : "TextBox",
			"name" : "inputer_name",
			"readOnly" : "true",
		},{
			"label" : "审核人编码",
			"type" : "TextBox",
			"name" : "auditor",
			"visible" : false,
		},{
			"label" : "审核人：",
			"type" : "TextBox",
			"name" : "auditor_name",
			"readOnly" : "true",
		 },{
			"label" : "取消人编码",
			"type" : "TextBox",
			"name" : "canceler",
			"visible" : false,
		},{
			"label" : "取消人：",
			"type" : "TextBox",
			"name" : "canceler_name",
			"readOnly" : "true", 
			"style": "display:block;float:none",
		},{
			"label" : "录入日期：",
			"type" : "DatePicker",
			"name" : "inputdate",
			"format" : "yyyy-MM-dd HH:mm:ss",
			"readOnly" : "true",
		},{
			"label" : "审核日期：",
			"type" : "DatePicker",
			"name" : "auditdate",
			"format" : "yyyy-MM-dd HH:mm:ss",
			"readOnly" : "true",
		 },{
			"label" : "取消日期：",
			"type" : "DatePicker",
			"name" : "canceldate",
			"format" : "yyyy-MM-dd HH:mm:ss",
			"readOnly" : "true",
			}
		]
	}
	
	var btn = Future.default.btn;
	
	// 按钮配置 - 固定名称
	bill.toolbarconfig = {
		id: utils.createid('systoolbar'),
		items: [btn.addData, btn.delData, btn.editData, btn.saveData,
			btn.separator,btn.auditData,btn.cancelData, btn.searchData,
			{'text': '打印','iconCls': 'icon-print','name': 'printData',
		     billstatus: 'Y',ibediting: 'N',tabindex: '1'
		}
		]
	}
	
	// 单据配置
	bill.billconfig = {
		billhead: bill.balanceregister, // 单据主表
		billquerylist: bill.searchlist, // 查询列表
		defaultmoduleid: app.modulecode, // 默认单据类型
	}
	// 创建标准单据模板
	utils.create_standardbill_config(bill);

})()
