<%@ page language="java" contentType="text/html; charset=utf-8"
	pageEncoding="utf-8"%>
<!DOCTYPE html/>
<html>
<head>
<title>商场银行信息编辑字典</title>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
	<div class="ocm-layout" config="cardLayout" borderStyle="border:0px;"
		style="width: 100%; height: 100%;"></div>
	<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
	<script type="text/javascript">
		var billmoduleid = "100905";
		var toolbar1 = {
			rule : { // 按钮可用规则 Y:已审核, N:录入, C:已取消
				'billstatus' : {
					'Y' : [ 'addData', 'cancelData', 'searchData' ],
					'N' : [ 'addData', 'editData', 'delData','searchData' ],
					'C' : [ 'addData', 'searchData']
				}
			},
			status : { // 按钮同斥规则 N:新增后, V:查看, E:编辑后, S:保存后, A:审核后, C:取消后, D:删除后(默认)
				'N' : [ 'addData', 'saveData', 'searchData' ],
				'V' : [ 'addData', 'editData', 'delData','searchData' ],
				'E' : [ 'addData', 'saveData', 'delData', 'searchData' ],
				'S' : [ 'addData', 'editData', 'delData','searchData' ],
				'C' : [ 'addData', 'searchData'],
				'D' : [ 'addData', 'searchData' ],
			},
			items : [ [ {
				"text" : "新增",
				"iconCls" : "icon-add",
				"name" : "addData",
			}, {
				"text" : "删除",
				"iconCls" : "icon-remove",
				"name" : "delData",
			}, {
				"text" : "修改",
				"iconCls" : "icon-edit",
				"name" : "editData",
			}, {
				"text" : "保存",
				"iconCls" : "icon-save",
				"name" : "saveData",
			},{
				"text" : "查询",
				"iconCls" : "icon-search",
				"name" : "searchData",
			} ] ]
		};

		var formheader1 = {
			"type" : "formgrid",
			"properties" : {
				"id" : "formheader1",
			},
			items : [  {
				"label" : "ph_key：",
				"name" : "ph_key",
				"type" : "TextBox",
				"visible":false,
			},{
				"label" : "编码：",
				"type" : "TextBox",
				"name" : "bank",
				"required": true,
			},{
				"label" : "门店：",
				"type" : "ButtonEdit",
				"name" : "mktid",
				"required" : "true",
				"onbuttonclick" : "onMktidClick",
				"onValuechanged" : "onMktidChange",
			},{
				"label" : "银行名称：",
				"type" : "TextBox",
				"name" : "bank_name",
				"required": true,
			}, {
				"label" : "银行账号：",
				"type" : "TextBox",
				"name" : "accntno",
				"required": true,
			},{
				"label" : "门店名称：",
				"name" : "mktid_name",
				"type" : "TextBox",
				"visible":false,
			},{
				"label" : "账务科目代码：",
				"type" : "TextBox",
				"name" : "pzkm",
				"required": true,
			},{
				"label" : "备注1：",
				"type" : "TextBox",
				"name" : "memo1",
			},{
				"label" : "备注2：",
				"type" : "TextBox",
				"name" : "memo2",
			}]
		};

		
		//单据列表
		var gridbox2 = {
			"type" : "gridbox",
			"resources":OmdUrl.mall,
			"method":"mss.base.bankinfo.search",
			"response" : "bankinfo",
			//"manualLoad" : true,
			"bindform" : "tabs1", // 绑定切换的TabsBox.name
			"bindSearchParam" : [ "ph_key" ], // 明细页面查询条件字段
			"searchParam" : {
				"order_field" : "mktid,bank",
				"order_direction" : "desc", //降序排列
				"fields" : "ph_key,mktid_name,bank,bank_name,pzkm,memo1,memo2,accntno",
			},
			"properties" : {
				"id" : "gridbox2",
				"columns" : [ {
					type:"indexcolumn",
					headerAlign:"center",
					header:"行号",
					readOnly: true,
					width:"5%",
				},{
					field: "bank",
					name : "bank",
					type:"TextBox",
					headerAlign:"center",
					header:"编码",
					width:"12%",
				},{
					field: "mktid_name",
					name : "mktid_name",
					type:"TextBox",
					headerAlign:"center",
					header:"门店",
					width:"12%",
				},{
					field: "bank_name",
					name : "bank_name",
					type:"TextBox",
					headerAlign:"center",
					align:"left",
					header:"银行名称",
					width:"40%",
				},{
					field: "accntno",
					name : "accntno",
					type:"TextBox",
					headerAlign:"center",
					align:"left",
					header:"银行账号",
					width:"40%",
				},{
					field: "pzkm",
					name : "pzkm",
					type:"TextBox",
					headerAlign:"center",
					header:"账务科目代码",
					width:"12%",
				},{
					field: "memo1",
					name : "memo1",
					type:"TextBox",
					headerAlign:"center",
					header:"备注1",
				},{
					field: "memo2",
					name : "memo2",
					type:"TextBox",
					headerAlign:"center",
					header:"备注2",
				},{
					field: "ph_key",
					name : "ph_key",
					type:"TextBox",
					headerAlign:"center",
					header:"物理主键",
					visible:false,
				},]
			},
		};
	

		var details = {
			"type" : "formgrid",
			"resources":OmdUrl.mall,
			"method":"mss.base.bankinfo.get",
			"response" : "bankinfo",
			"properties" : {
				"id" : "details",
			},
			"items" : formheader1.items,
		};

		var tabs1 = {
			properties : {
				"id" : "tabs1"
			},
			items : [ {
				"title" : "单据列表",
				"name" : "list",
				"control" : gridbox2,
			}, {
				"title" : "单据明细",
				"name" : "details",
				"control" : details,
			} ]
		};

		var cardLayout = {
			properties : {
				"id" : "cardLayout",
				"name" : "cardLayout",
			},
			"toolbar" : toolbar1,
			"tabs" : tabs1,
		};

		mini.parse();
	</script>
	<script src="bank.js" type="text/javascript"></script>
	<style type="text/css">
body {
	margin: 0;
	padding: 0;
}

#selectrule {
	height: 30px;
}

.left {
	float: left;
	width: 43%;
	height: 100%;
}

.right {
	float: right;
	width: 51%;
	height: 100%;
}

.buttonlist {
	margin-left: 43.5%;
	height: 100%;
}

.Content {
	height: 85%;
	/* min-width: 700px;
		_width: expression((   document.documentElement.clientWidth || 
			 document.body.clientWidth)>700?"700px":"" ); */
}

#left_a {
	float: left;
	width: 40%;
	margin-left: 0px
}

#right_a {
	float: right;
	margin-right: 60px;
	width: 50%;
}
</style>

</body>
</html>
