<%@ page language="java" contentType="text/html; charset=utf-8"
         pageEncoding="utf-8" %>
<!DOCTYPE html />
<html>
<head>
    <title>余款设置单</title>
    <meta http-equiv="content-type" content="text/html; charset=UTF-8"/>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">
<!-- 引用基类 -->
<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
<script src="/mall-business-ui/pages/common/method.js" type="text/javascript"></script>
<script src="/mall-business-ui/pages/common/queryconfig.js" type="text/javascript"></script>

<div id="Layout_toolbar" class="ocm-systoolbar" config="toolbar" style="hight: 10%,float:right"></div>

<div class="mini-fit">

    <div id="layout1" class="mini-layout" style="width: 100%; height: 100%;" borderStyle="border:solid 1px #aaa;">

        <div title="账单列表" showProxyText="false" region="west" width="400" expanded="true" showSplitIcon="false">
            <div class="ocm-gridbox" config="billsetlist"></div>
        </div>


        <div title="账单明细" region="center" showHeader="true" showCollapseButton="false">
            <div class="ocm-gridbox" config="settlebilldefdetail"></div>
        </div>
    </div>
</div>
</body>


<script type="text/javascript">
    var dictData = getDict("CCTYPE");
    dictData.billstatus = [{code: "Y", name: "启用"}, {code: "N", name: "不启用"}];
    dictData.cccode = getDictMdmBySelectKey("cccode", true);

    var toolbar = {
        rule: {},
        status: {
            'N': ['editData'],
            'E': ['saveData', 'addData', 'delData', 'addListData', 'delListData'],
        },
        items: [[{
            'text': '修改',
            'iconCls': 'icon-edit',
            'name': 'editData',
            "onclick": "editData",
        }, {
            'text': '保存',
            'iconCls': 'icon-save',
            'name': 'saveData',
            "onclick": "saveData",
        }], [{
            'text': '新增账单',
            'iconCls': 'icon-addnew',
            'name': 'addListData',
            "onclick": "addListRowData",
        }, {
            'text': '删除账单',
            'iconCls': 'icon-remove',
            'name': 'delListData',
            'onclick': 'delListRowData'
        }], [{
            'text': '新增明细',
            'iconCls': 'icon-addnew',
            'name': 'addData',
            "onclick": "addRowData",
        }, {
            'text': '删除明细',
            'iconCls': 'icon-remove',
            'name': 'delData',
            'onclick': 'delRowData'
        }]]
    };

    var billsetlist = {
        "type": "gridbox",
        "resources": OmdUrl.mall,
        "method": "mall.work.settlebilldef.search",
        "response": "settlebilldef",
        "bindSearchParam": ["ph_key"], // 明细页面查询条件字段
        "searchParam": {
            'order_field': "setbtypecode",
            'order_direction': "asc"
        },
        "properties": {
            "id": "billsetlist",
            "multiSelect": true,
            "allowCellEdit": true,
            "allowCellSelect": true,
            "editNextOnEnterKey": true,
            "editNextRowCell": true,
            "allowSortColumn": false,
            "showColumnsMenu": true,
            "showSummaryRow": true,
            "oncellbeginedit": "OcmControl.checkboxEditor",
            "oncellendedit": 'OcmControl.datetimeFormate',
            "allowRowSelect": true,
            "showPager": false,
            "columns": [{
                type: "indexcolumn",
                header: "行号",
                headerAlign: "center",
                readOnly: true,
            }, {
                field: "setbtypecode",
                headerAlign: "center",
                header: "账单编号",
                width: 50,
                allowSort: true,
                editor: OcmControl.newControl('TextBox'),
                editorSet: {onValuechanged: "onBtypecodeChanged"},
            }, {
                field: "sbdname",
                headerAlign: "center",
                header: "账单名称",
            }, {
                field: "sbdename",
                headerAlign: "center",
                header: "账单英文名称",
                visible: false,
            }, {
                field: "sbdstatus",
                header: "状态",
                type: "comboboxcolumn",
                editor: OcmControl.newControl('ComboBox'),
                headerAlign: "center",
                textField: "name",
                valueField: "code",
                renderer: "OcmControl.dictRendererWithCode",
                data: dictData.billstatus,
            }, {
                field: "ph_key",
                header: "ph_key",
                visible: false,
            }],
        },
    };

    var settlebilldefdetail = {
        "type": "gridbox",
        "resources": OmdUrl.mall,
        "method": "mall.work.settlebilldefdetail.search",
        "response": "settlebilldefdetail",
        "bindSearchParam": ["ph_key"], // 明细页面查询条件字段
        "manualLoad": true,
        "searchParam": {'order_field': "sbdditemorder"},
        //"searchParam" :{'field':"ph_key,ccname,cccode,cctype,sbdditemorder"},
        "properties": {
            "id": "settlebilldefdetail",
            "multiSelect": true,
            "allowCellEdit": true,
            "allowSortColumn": true,
            "allowCellSelect": true,
            "editNextOnEnterKey": true,
            "showReloadButton": false,
            "editNextRowCell": true,
            "allowSortColumn": false,
            "oncellbeginedit": "OcmControl.checkboxEditor",
            "columns": [{
                type: "indexcolumn",
                header: "行号",
                headerAlign: "center",
                readOnly: true,
            }, {
                field: "setbtypecode",
                headerAlign: "center",
                header: "账单编号",
                width: 50,
                visible: false,
            }, {
                field: "cctype",
                header: "账单类型",
                type: "comboboxcolumn",
                editor: OcmControl.newControl('ComboBox'),
                headerAlign: "center",
                width: 140,
                textField: "name",
                valueField: "code",
                renderer: "OcmControl.dictRendererWithCode",
                onValuechanged: "onCctypeChanged",
                data: dictData.CCTYPE,

            }, {
                field: "cccode",
                header: "费用项目",
                displayField: "ccname",
                editor: OcmControl.newControl('fut_popselectgrid'),
                editorSet: {
                    selectkey: "cccode",
                    textName: "ccname",
                    beforefunc: "head_beforefunc",
                },
                cdEdtCfg: {
                    compnentType: 'fut_popselect', selectkey: "cccode",
                },
                textField: "cccname",
                valueField: "cccode",
                renderer: "OcmControl.dictRendererWithCode",
                data: dictData.cccode,
                headerAlign: "center",
                width: 140,
            }, {
                field: "sbdditemorder",
                header: "账单项目显示排序",
                headerAlign: "center",
                width: 140,
            }]
        },
    };


</script>
<script src="billset.js" type="text/javascript"></script>

</html>