/**
 * 公共查询接口配置
 */

//商铺/广告位合并/拆分 配置
// 表头

// 商铺合并表头
Future.Query.Config.tablebshopchghead = [ {
		"label" : "ph_key：",
		"type" : "TextBox",
		"name" : "ph_key",
		"readOnly" : "true",
		"visible" : false,
	}, {
		"label" : "单据编号：",
		"name" : "billno",
		"type" : "TextBox",
		"required" : "true",
		"readOnly" : true,
		"visible" : true,
		"style" : "width:30%",
	},{
		"label" : "手工编号：",
		"type" : "TextBox",
		"name" : "billsgno",
		"style" : "width:30%",
	},{
		"label" : "模块编号：",
		"name" : "billmoduleid",
		"type" : "TextBox",
		"required" : "true",
		"readOnly" : true,
		"visible" : false,
		"defaultValue" : "100501"
	}, {
		"label" : "单据状态：",
		"name" : "billstatus",
		"type" : "ComboBox",
		dictkey : 'BILLFLAG',
		"defaultValue" : "N",
		"readOnly" : true,
		"visible" : true,
		
	}, {
		"label" : "门店：",
		"name" : "muid",
		type : "fut_popselect",
		selectkey : "muid",
		textName : "muid_name",
		"required" : "true",
		beforefunc : "head_check_detail",
		
		"allowInput" : true,
		"style" : "width:30%",
	}, {
		"label" : "门店名称：",
		"name" : "muid_name",
		"type" : "TextBox",
		"required" : "true",
		"defaultValue" : "",
		visible : false,
	},
	{
		"label" : "上级编码：",
		"name" : "mmfid",
		"required" : "true",
		"type" : "ButtonEdit",
		displayField : "mmfcname",
		allowSort : true,
		type : "fut_popselect",
		selectkey:"mmfidno",
		textName :"mmfcname", 
		beforefunc:"head_beforefunc_mmfid",
		//itemchangedfunc:"head_itemchanged_mmfidno", 
	},{
		"label" : "单据生效日期：",
		"name" : "effdate",
		"type" : "DatePicker",
		"format" : "yyyy-MM-dd",
		"required" : "true",
		"defaultValue" : new Date(),
		"style" : "display:block;float:none",
	},{
		"label" : "商铺编码：",
		"type" : "TextBox",
		"name" : "spcode",
		"required" : "true",
		visible : false,
	},{
		"label" : "新商铺编码：",
		"type" : "TextBox",
		"name" : "newspcode",
		"onValuechanged":"onSpcodeChanged",
		"required" : "true",
		"visible" : "true",
	},{
		"label" : "新商铺名称：",
		"type" : "TextBox",
		"name" : "newspname",
		"visible" : "true",
	},{
		"label" : "业主：",
		"type" : "ButtonEdit",
		"name" : "ownerid",
		displayField : "ownercname",
		type : "fut_popselect",
		selectkey : "owner",
		textName : "ownercname",
		responseName : "ownerid",
		beforefunc : "page.head_beforefunc_owner",
		
		//itemchangedfunc : "head_itemchanged_owner",
		//"visible" : false,
	},{
		"label" : "商铺类型：",
		"name" : "sptype", 
		"type" : "ComboBox",
		"required" : "true",
		"onclick" : "head_check_details",
		"onValuechanged":"onSptypeChanged",
		//dictkey : 'SPMODE',
	},{
		"label" : "商铺属性：",
		"name" : "spmode",
		"type" : "ComboBox",
		"required" : "true",
		"style" : "display:block;float:none",
		//dictkey : 'SPTYPE',
	},{
		"label" : "新建筑面积：",
		"type" : "TextBox",
		"name" : "newspbuildarea",
		"required" : "true",
		"onValuechanged":"getPoolrate",
		visible : true,
	},{
		"label" : "新套内面积：",
		"name" : "newsplettarea",
		"type" : "TextBox",
		"onValuechanged":"getPoolrate",
		"required" : "true",
	},{
		"label" : "公摊率：",
		"name" : "poolrate",
		"required" : "true",
		"type" : "Spinner",
		"format":"p2",
	    //"increment" : "0.01",
	    "minValue" : "0",
	    "maxValue" : "999999", 
	    "defaultValue" : "0",
	    "inputStyle" :"text-align:right;",
		"readOnly":true
	},{
		"label" : "规划业种：",
		"name" : "mid",
		"type" : "ButtonEdit",
		displayField : "mname",
		type : "fut_popselect",
		selectkey : "yzid",
		textName : "mname",
		responseName : "code",
		visible:false,
	},{
		"label" : "规划业态：",
		"type" : "ButtonEdit",
		"name" : "yt",
		displayField : "ytname",
		type : "fut_popselect",
		selectkey : "ytid",
		textName : "ytname",
		responseName : "code",
		visible:false,
	},{
		"label" : "目标品牌：",
		"type" : "ButtonEdit",
		"name" : "ppcode",
		displayField : "ppname",
		type : "fut_popselect",
		selectkey : "ppcode",
		textName : "ppname",
		itemchangedfunc : "head_itemchanged_ppcodes",
		beforefunc:"head_beforefunc_mffids",
		visible:false,
	},/*{
		"label" : "日目标租金：",
		"name" : "dayrent",
		"type" : "TextBox",
		visible:false,
	},{
		"label" : "月目标租金：",
		"name" : "monrent",
		"type" : "TextBox",
		visible:false,
	},{
		"label" : "月目标管理费：",
		"name" : "monmanafee",
		"type" : "TextBox",
		visible:false,
	},*/{
		"label" : "方位：",
		"name" : "position",
		"type" : "ComboBox",
		"visible":false,
		//dictkey : 'POSITION',
	},{
		"label" : "广告位类型：",
		"name" : "spggtype",
		"type" : "ComboBox",
		"readOnly" : true,
		//dictkey : 'SPGGTYPE',
	},{
		"label" : "广告介质：",
		"name" : "media",
		"type" : "ComboBox",
		"readOnly" : true,
		//dictkey : 'MEDIA',
	},{
		"label" : "尺寸cm²：",
		"type" : "TextBox",
		"name" : "size_",
		"style" : "display:block;float:none",
		"readOnly" : true,
		
	},{
		"label" : "面价：",
		"name" : "faceprice",
		"type" : "TextBox",
		"visible":true,
		"onValuechanged":"numberCheck",
		//dictkey : 'POSITION',
	},{
		"label" : "底价：",
		"name" : "lowprice",
		"type" : "TextBox",
		"visible":true,
		//dictkey : 'POSITION',
		"onValuechanged":"numberCheck",
		"style" : "display:block;float:none",
	},{
		"label" : "录入人：",
		"name" : "inputer_name",
		"type" : "TextBox",
		"readOnly" : true,
		"visible" : true,
		"defaultValue" : app.username
	}, {
		"label" : "录入人编码：",
		"type" : "TextBox",
		"name" : "inputer",
		"visible" : false,
		"defaultValue" : app.usercode
	}, {
		"label" : "审核人：",
		"name" : "auditor_name",
		"type" : "TextBox",
		"readOnly" : true,
		"visible" : true,
		"style" : "display:block;float:none",
	},{
		"label" : "录入日期：",
		"name" : "inputdate",
		"type" : "DatePicker",
		"readOnly" : true,
		"format" : "yyyy-MM-dd HH:mm:ss",
		"visible" : true,
		"defaultValue" : new Date(),
		
	},
	/*
	 * { "type" : "Separator", "style" : "clear: both;display: inline-block;width:
	 * 90%;margin: 0.2em 0 0.6em;" },
	 */{
		"label" : "审核日期：",
		"name" : "auditdate",
		"type" : "DatePicker",
		"readOnly" : true,
		"format" : "yyyy-MM-dd HH:mm:ss",
		"visible" : true
	} ];

//商铺合并列表
Future.Query.Config.tablebshopchgheadlist = [ {
		type : "indexcolumn",
		header : "行号",
		headerAlign : "center",
	}, {
		field : "billno",
		header : "单据编号",
		allowSort : true,
		headerAlign : "center",
		width : 160,
		visible : true
	}, /*{
		field : "billmoduleid",
		headerAlign : "center",
	    header : "单据类型",
	    headerAlign : "center",
	    width : 100,
	    editor : OcmControl.newControl('ComboBox'), 
	    type : "comboboxcolumn", //样式属性必须加
	    textField : "name",
	    valueField : "code",
	    renderer : "OcmControl.dictRendererWithCode",
	    visible:false,
	},*/{
		field : "billsgno",
	    header : "手工编号",
	    allowSort : true,
	    headerAlign : "center",
	    width : 160,
	},{
		field : "billstatus",
		header : "单据状态",
		allowSort : true,
		headerAlign : "center",
		renderer : "OcmControl.dictRendererWithCode",
		dictkey : 'BILLFLAG',
		width : 100,
		visible : true
	}, {
		field : "muid",
		header : "门店",
		displayField : "muname",
		headerAlign : "center",
		cdEdtCfg : {
			compnentType : 'fut_popselect',
			selectkey : "muid",
			textName : "mucname",
			responseName : "muid"
		},
		
		
		width : 100,
		visible : false,
		enabledSearch : true,
		allowSort : true,
	}, {
		field : "muid_name",
		header : "门店名称",
		width : 140,
		allowSort : true,
		enabledSearch : false,
		visible : true,
	},{
		field : "mmfid",
	    header : "上级编码",
		headerAlign : "center",
		displayField : "mmfcname",
		editor:OcmControl.newControl('fut_popselectgrid'),
		editorSet: {
			selectkey:"mmfidno",
			textName :"mmfcname",
			responseName : "mmfid",
			
			}, 	
		cdEdtCfg : {
			compnentType : 'fut_popselect',selectkey : "mmfidno",
			beforefunc:"head_beforefunc_search",
		},
		width : 140,	
		enabledSearch : true,
		visible:true,
	},{
		field : "mmfcname",
		name : "mmfcname",
		type : "TextBox",
		headerAlign : "center",
		header : "上级编码名称",
		required : true,
		visible : false,
		enabledSearch : false,
	}, {
		field : "spcode",
	    header : "商铺编码",
	    required : true,
	    allowSort : true,
	    headerAlign : "center",
	    visible:false,
	    enabledSearch : false,
	    enabled:false,
	    width : 160,
	}, {
		field : "newspcode",
	    header : "新商铺编码",
	    required : true,
	    allowSort : true,
	    headerAlign : "center",
	    visible:true,
	    width : 160,
	},{
		field : "spmode",
	    header : "商铺属性",
	    allowSort : true,
	    headerAlign : "center",
	    width : 100,
	    editor : OcmControl.newControl('ComboBox'), 
	    type : "comboboxcolumn", //样式属性必须加
	    textField : "name",
	    valueField : "code",
	    renderer : "OcmControl.dictRendererWithCode",
	},{
		field : "sptype",
	    header : "商铺类型",
	    allowSort : true,
	    headerAlign : "center",
	    width : 100,
	    editor : OcmControl.newControl('ComboBox'), 
	    type : "comboboxcolumn", //样式属性必须加
	    textField : "name",
	    valueField : "code",
	    renderer : "OcmControl.dictRendererWithCode",
	}, {
		field : "ownerid",
	    header : "业主",
	    
	    allowSort : true,
	    headerAlign : "center",
	    displayField : "ownercname",
	    cdEdtCfg : {
	        compnentType : 'fut_popselect',
	        selectkey : "ytid",
	        responseName : "code"
	   },
	   readOnly : true,
	   width : 140,
	} ,{
		field : "newspbuildarea",
	    header : "新建筑面积",
	    allowSort : true,
	    headerAlign : "center",
	    align: "right",
	    visible:true,
	    width : 100,
	},{
		field : "newsplettarea",
	    header : "新套内面积",
	    allowSort : true,
	    visible:true,
	    align: "right",
	    headerAlign : "center",
	    width : 100,
	},{
		field : "effdate",
	    header : "生效日期",
		dateFormat : "yyyy-MM-dd",
		dataType : "date",
		allowSort : true,
	    allowSort : true,
	    headerAlign : "center",
	    width : 140,
	},{
		field : "mid",
	    header : "规划业种",
	    allowSort : true,
	    visible:false,
	    headerAlign : "center",
	    enabledSearch : false,
	    width : 100,
	},{
		field : "mname",
	    header : "规划业种",
	    visible:false,
	    allowSort : true,
	    headerAlign : "center",
	    enabledSearch : false,
	    width : 100,
	},{
		field : "yt",
	    header : "规划业态",
	    displayField : "ytname",
	    allowSort : true,
	    headerAlign : "center",
	    cdEdtCfg : {
			compnentType : 'fut_popselect',
			selectkey : "ytid",
			responseName : "code"
		},
		readOnly : true,
		visible:false,
		enabledSearch : false,
		width : 100,
	   
	},{
		
		field : "ppcode",
		header : "品牌",
		headerAlign : "center",
		displayField : "ppname",
		cdEdtCfg : {
			compnentType : 'fut_popselect',
			selectkey : "ppcode",
			responseName : "code"
		},
		readOnly : true,
		enabledSearch : false,
		width : 100,
		visible:false,
		
	},{
		field : "dayrent",
	    header : "日目标租金",
	    allowSort : true,
	    headerAlign : "center",
	    headerAlign : "center",
	    width : 100,
	    numberFormat : "#,0.00",
	    align: "right",
	    enabledSearch : false,
	    visible:false,
	},{
		field : "monrent",
	    header : "月目标租金",
	    headerAlign : "center",
	    headerAlign : "center",
	    allowSort : true,
	    width : 100,
	    numberFormat : "#,0.00",
	    align: "right",
	    enabledSearch : false,
	    visible:false,
	},{
		field : "monmanafee",
	    header : "月目标管理费",
	    allowSort : true,
	    headerAlign : "center",
	    width : 100,
	    numberFormat : "#,0.00",
	    align: "right",
	    enabledSearch : false,
	    visible:false,
	    
	}, {
		field : "spggtype",
	    header : "广告位类型",
	    allowSort : true,
	    headerAlign : "center",
	    width : 100,
	    editor : OcmControl.newControl('ComboBox'), 
	    type : "comboboxcolumn", //样式属性必须加
	    textField : "name",
	    valueField : "code",
	    renderer : "OcmControl.dictRendererWithCode",
	}, {
		field : "media",
	    header : "广告介质",
	    allowSort : true,
	    headerAlign : "center",
	    width : 100,
	    editor : OcmControl.newControl('ComboBox'), 
	    type : "comboboxcolumn", //样式属性必须加
	    textField : "name",
	    valueField : "code",
	    renderer : "OcmControl.dictRendererWithCode",
	}, {
		field : "position",
	    header : "方位",
	    allowSort : true,
	    headerAlign : "center",
	    width : 100,
	    editor : OcmControl.newControl('ComboBox'), 
	    type : "comboboxcolumn", //样式属性必须加
	    textField : "name",
	    valueField : "code",
	    renderer : "OcmControl.dictRendererWithCode",
	    visible:false,
	    enabledSearch : false,
	},{
		field : "poolrate",
		name : "poolrate",
		headerAlign : "center",
		header : "公摊率",
		allowSort : false,
		visible : true,
		readOnly:true,
		vtype : "double",
		numberFormat : "p2",
		width : 100,
		readOnly : true,
		editor : OcmControl.newControl('Spinner'),
		editorSet : {
			"minValue" : "0",
			"maxValue" : "100000000000",
			"defaultValue" : "0",
		} ,
		enabledSearch : false,
	},{
		field : "inputer",
		header : "录入人",
		width : 100,
		visible:false,
		headerAlign : "center",
		enabledSearch : true,
		
	},{
		field : "inputer_name",
		header : "录入人",
		width : 100,
		allowSort : true,
		headerAlign : "center",
		enabledSearch : false,
	}, {
		field : "inputdate",
		dataType : "date",
		type : "date",
		format : "yyyy-MM-dd",
		header : "录入日期",
		width : 140,
		allowSort : true,
		headerAlign : "center",
		align : "center",
	}, {
		field : "auditor",
		header : "审核人",
		width : 100,
		visible:false,
		allowSort : true,
		headerAlign : "center",
		enabledSearch : true,
	}, {
		field : "auditor_name",
		header : "审核人",
		width : 100,
		allowSort : true,
		headerAlign : "center",
		enabledSearch : false,
	}, {
		field : "auditdate",
		type : "date",
		format : "yyyy-MM-dd",
		header : "审核日期",
		width : 140,
		dataType : "date",
		allowSort : true,
		headerAlign : "center",
		align : "center",
	}, {
		field : "size_",
	    header : "尺寸cm²",
	    allowSort : true,
	    headerAlign : "center",
	    width : 100,
	    visible:false,
	    
	}];

// 商铺合并明细
Future.Query.Config.tablebshopchgdet = [ {
		type : "checkcolumn",
		headerAlign : "center",
		readOnly : true,
		width : 30,
	}, {
		type : "indexcolumn",
		header : "行号",
		headerAlign : "center",
	}, {
		field : "browno",
		name : "browno",
		headerAlign : "center",
		header : "行号",
		allowSort : false,
		width : 120,
		visible : false
	}, {
		field : "spcode",
		header : "商铺编码",
		//visible:false,
		displayField : "spcname",
		editor:OcmControl.newControl('fut_popselectgrid'),
	    editorSet: {
	         selectkey:"spid",
	         textName :"spcname",
	         beforefunc:"detail_beforefunc_spcode",
	         itemchangedfunc:"detail_itemchanged_spcode"
	         },
	    cdEdtCfg:{compnentType:'fut_popselect',selectkey:"spid",},
	    headerAlign : "center",
		allowSort : false,
		required : true,
		width : 140,
		
	}, {
		field : "spid",
		headerAlign : "center",
		header : "铺位号",
		allowSort : false,
		width : 120,
		visible : false
	},{
		field : "spcname",
		headerAlign : "center",
		header : "商铺中文名称",
		allowSort : false,
		width : 120,
		visible : false
	}, {
	    field : "muid",
	    header : "门店",
	    headerAlign : "center",
	     readOnly:true,
	    visible : false,
	    width : 140,
	 },{
	    field : "muid_name",
	    header : "门店",
	    visible : true,
	    headerAlign : "center",
	    width : 140,
	    readOnly:true,
	 },{
			field : "mmfid",
			header : "上级编码",
			headerAlign : "center",
			width : 140,	
			readOnly:true,
			visible:false,
		}, {
			field : "mmfid_name",
			header : "上级编码",
			headerAlign : "center",
			width : 140,	
			readOnly:true,
			visible:true,
		},{
		field : "ownerid",
		headerAlign : "center",
		header : "业主",
		width : 140,	
		visible : false,
	},{
		field : "spstartdate",
		name : "spstartdate",
		headerAlign : "center",
		header : "生效日期",
		readOnly:true,
		vtype : "required:true",
		required : true,
		align : "center",
		editor : OcmControl.newControl('DatePicker'),
		dataType : "date",
		dateFormat : "yyyy-MM-dd",
		/*editorSet:{format:"yyyy-MM-dd",onValuechanged : "spstartdate"},*/
	}, {
		field : "sptype",
		header : "商铺类型",
		headerAlign : "center",
		type : "comboboxcolumn",
	  	valueField : "code",
	  	textField : "name",
	  	editor : OcmControl.newControl('ComboBox'),
	  	renderer: "OcmControl.dictRendererWithCode",
	  	align : "center",
	  	width : 120,
	  	readOnly:true,
	}, {
		field : "spmode",
		headerAlign : "center",
		header : "商铺属性",
		type : "comboboxcolumn",
	  	valueField : "code",
	  	textField : "name",
	  	editor : OcmControl.newControl('ComboBox'),
	  	renderer: "OcmControl.dictRendererWithCode",
	  	align : "center",
		width : 120,
		readOnly:true,
	},  {
		field : "spbuildarea",
		name : "spbuildarea",
		headerAlign : "center",
		header : "建筑面积",
		allowSort : false,
		required : true,
		readOnly:true,
		vtype : "required:true,double",
		numberFormat : "#,##0.00",
		width : 100,
		editor : OcmControl.newControl('Spinner'),
		editorSet : {
			"minValue" : "0",
			"maxValue" : "100000000000",
			"defaultValue" : "0",
		}
	
	}, {
		field : "poolrate",
		name : "poolrate",
		headerAlign : "center",
		header : "公摊率",
		allowSort : false,
		visible : true,
		readOnly:true,
		vtype : "double",
		numberFormat : "p2",
		width : 100,
		readOnly : true,
		editor : OcmControl.newControl('Spinner'),
		editorSet : {
			"minValue" : "0",
			"maxValue" : "100000000000",
			"defaultValue" : "0",
		}
	}, {
		field : "splettarea",
		name : "splettarea",
		headerAlign : "center",
		header : "套内面积",
		allowSort : false,
		required : true,
		readOnly:true,
		vtype : "required:true,double",
		numberFormat : "#,##0.00",
		width : 100,
		editor : OcmControl.newControl('Spinner'),
		editorSet : {
			"minValue" : "0",
			"maxValue" : "100000000000",
			"defaultValue" : "0",
		}
	}, {
		"header" : "面价",
		"name" : "faceprice",
		field : "faceprice",
		vtype : "required:true,double",
		required : true,
		readOnly:true,
		numberFormat : "#,##0.00",
		width : 100,
		editor : OcmControl.newControl('Spinner'),
		editorSet : {
			"minValue" : "0",
			"maxValue" : "100000000000",
			"defaultValue" : "0.00",
		}
	}, {
		"header" : "底价",
		"name" : "lowprice",
		field : "lowprice",
		vtype : "required:true,double",
		required : true,
		readOnly:true,
		numberFormat : "#,##0.00",
		width : 100,
		editor : OcmControl.newControl('Spinner'),
		editorSet : {
			"minValue" : "0",
			"maxValue" : "100000000000",
			"defaultValue" : "0.00",
		}
	} ,{
		field : "mid",
	    header : "规划业种",
		width : 140,
		displayField : "mname",
		editor:OcmControl.newControl('fut_popselectgrid'),
	    editorSet: {
	         selectkey:"yzid",
	         textName :"mname",
	         //beforefunc:"head_beforefunc_tags_detail",
	         //itemchangedfunc:"head_itemchanged_tags_detail"
	         },
	    cdEdtCfg:{compnentType:'fut_popselect',selectkey:"yzid"},
		allowSort : true,
		readOnly:true,
		enabledSearch : false,
		visible : false,
	},{
		field : "yt",
	    header : "规划业态",
	    
	    /*displayField : "ytname",
		editor:OcmControl.newControl('fut_popselectgrid'),
	    editorSet: {
	         selectkey:"ytid",
	         textName :"ytname",
	         //beforefunc:"head_beforefunc_tags_detail",
	         //itemchangedfunc:"head_itemchanged_tags_detail"
	         },
	    cdEdtCfg:{compnentType:'fut_popselect',selectkey:"ytid"},*/
	    
		width : 140,
		readOnly:true,
		allowSort : true,
		enabledSearch : false,
		visible : false
	},{
		 field : "ppcode",
	     header : "目标品牌",
	     required : true,
	     readOnly:true,
	     headerAlign : "center",
	     /*displayField : "ppname",
	 	 editor:OcmControl.newControl('fut_popselectgrid'),
	     editorSet: {
	          selectkey:"ppcode",
	          textName :"ppname",
	          //beforefunc:"head_beforefunc_tags_detail",
	          //itemchangedfunc:"head_itemchanged_tags_detail"
	          },
	     cdEdtCfg:{compnentType:'fut_popselect',selectkey:"ppcode"},*/
	     width : 140,
	     visible:false,
	
	},{
		field : "dayrent",
	    header : "日目标租金",
	    readOnly:true,
		allowSort : true,
		enabledSearch : false,
		visible : false,
		vtype : "required:true,double",
		numberFormat : "#,##0.00",
		editor : OcmControl.newControl('Spinner'),
		editorSet : {
			"minValue" : "0",
			"maxValue" : "100000000000",
			"defaultValue" : "0",
		}
	},{
		field : "monrent",
	    header : "月目标租金",
	    readOnly:true,
		allowSort : true,
		enabledSearch : false,
		visible:false,
		vtype : "required:true,double",
		numberFormat : "#,##0.00",
		editor : OcmControl.newControl('Spinner'),
		editorSet : {
			"minValue" : "0",
			"maxValue" : "100000000000",
			"defaultValue" : "0",
		}
	},{
		field : "monmanafee",
	    header : "月目标管理费",
	    readOnly:true,
		enabledSearch : false,
		visible : false,
		vtype : "required:true,double",
		numberFormat : "#,##0.00",
		editor : OcmControl.newControl('Spinner'),
		editorSet : {
			"minValue" : "0",
			"maxValue" : "100000000000",
			"defaultValue" : "0",
		}
	},{
		field : "spggtype",
	    header : "广告位类型",
	    headerAlign : "center",
		width : 140,
		align : "center",
		type : "comboboxcolumn",
	    valueField : "code",
	    textField : "name",
	    editor : OcmControl.newControl('ComboBox'),
	    renderer: "OcmControl.dictRendererWithCode",
	    readOnly:true,
	
	},{
		field : "media",
	    header : "广告介质",
	    headerAlign : "center",
		width : 140,
		align : "center",
		type : "comboboxcolumn",
	    valueField : "code",
	    textField : "name",
	    editor : OcmControl.newControl('ComboBox'),
	    renderer: "OcmControl.dictRendererWithCode",
	    readOnly:true,
	},{
		field : "size_",
	    header : "尺寸cm²",
	    readOnly:true,
		allowSort : true,
		enabledSearch : false,
		visible : true,
		vtype : "required:true,double",
		numberFormat : "#,##0.00",
		editor : OcmControl.newControl('Spinner'),
		editorSet : {
			"minValue" : "0",
			"maxValue" : "100000000000",
			"defaultValue" : "0.00",
		}
	},];





// ===================
function setComboxDatas(dictData, Items,billmoduleid) {
	for ( var i = 0; i < Items.length; i++) {
		/* formgrid */
		
		if (Items[i].name != undefined) {
			if (Items[i].name == "billmoduleid") {
				Items[i].data = dictData.BILLMODULEID;
				if (billmoduleid != undefined) {
					Items[i].defaultValue = billmoduleid;
				}
			} else if (Items[i].name == "billstatus") {
				if (isSearch(billmoduleid)) {
					 Items[i].data = dictData.CONTSTATUS;
				 } else {
					 Items[i].data = dictData.BILLFLAG;
				 }
			} else if (Items[i].name == "billtype") {
				Items[i].data = dictData.BILLTYPE;
			} else if (Items[i].name == "conttype") {
				Items[i].data = dictData.CONTTYPE;
			} else if (Items[i].name == "ccreason") {
				Items[i].data = dictData.CCREASON;
			} else if (Items[i].name == "setgroupcode") {
				Items[i].data = dictData.SETGROUPCODE;
			} else if (Items[i].name == "setmode") {
				Items[i].data = dictData.SETMODE;
			} else if (Items[i].name == "setflag") {
				Items[i].data = dictData.setflag;
			} else if (Items[i].name == "paycode") {
				Items[i].data = dictData.PAYMODE;
			} else if (Items[i].name == "settleday") {
				Items[i].data = dictData.SETTLEDAY;
			} else if (Items[i].name == "wmid") {
				Items[i].data = dictData.WMID;
			} else if (Items[i].name == "syfs") {
				Items[i].data = dictData.SYFS;
			} else if (Items[i].name == "cycsqtype") {
				Items[i].data = dictData.CYCSQTYPE;
			} else if (Items[i].name == "cetype") {
				Items[i].data = dictData.CETYPE;
			} else if (Items[i].name == "jkqx") {
				Items[i].data = dictData.SETTLEDAY;
			} else if (Items[i].name == "bdmode") {
				Items[i].data = dictData.bdmode;
			} else if (Items[i].name == "media") {// bshopchg
				Items[i].data = dictData.MEDIA;
			} else if (Items[i].name == "position") {
				Items[i].data = dictData.POSITION;
			} else if (Items[i].name == "spggtype") {
				Items[i].data = dictData.SPGGTYPE;
			} else if (Items[i].name == "spggtype") {
				Items[i].data = dictData.SPGGTYPE;
			} else if (Items[i].name == "sptype") {
				Items[i].data = dictData.SPTYPE;
			} else if (Items[i].name == "spmode") {
				Items[i].data = dictData.SPMODE;
			}
		}
		
		
		if (Items[i].field != undefined) {
			if (Items[i].field == "billmoduleid") {
				 Items[i].data = dictData.BILLMODULEID;
			} else if (Items[i].field == "billstatus") {
				 if (isSearch(billmoduleid)) {
					 Items[i].data = dictData.CONTSTATUS;
				 } else {
					 Items[i].data = dictData.BILLFLAG;
				 }
				
			}  else if (Items[i].field == "wmid") {
				Items[i].data = dictData.WMID;
			} else if (Items[i].field == "ccarea") {
				Items[i].data = dictData.CCAREA;
			} else if (Items[i].field == "setmode") {
				Items[i].data = dictData.SETMODE;
			} else if (Items[i].field == "cetype") {
				Items[i].data = dictData.CETYPE;
			} else if (Items[i].field == "cycunit") {
				Items[i].data = dictData.CYCUNIT;
			}  else if (Items[i].field == "sqmode") {
				Items[i].data = dictData.sqmode;
			}  else if (Items[i].field == "xxtax") {
				Items[i].data = dictData.XXTAXRATE;
			}  else if (Items[i].field == "xftax") {
				Items[i].data = dictData.XXTAXRATE;
			}  else if (Items[i].field == "custtype") {
				Items[i].data = dictData.CUSTTYPE;
			} else if (Items[i].field == "cycsqtype") {
				Items[i].data = dictData.CYCSQTYPE;
			} else if (Items[i].field == "media") {// bshopchg
				Items[i].data = dictData.MEDIA;
			} else if (Items[i].field == "position") {
				Items[i].data = dictData.POSITION;
			} else if (Items[i].field == "spggtype") {
				Items[i].data = dictData.SPGGTYPE;
			} else if (Items[i].field == "sptype") {
				Items[i].data = dictData.SPTYPE;
			} else if (Items[i].field == "spmode") {
				Items[i].data = dictData.SPMODE;
			}  
		}
	}
}



function getTableSort(Items,flag) {
	var strsort = "";
	for ( var i = 0; i < Items.length; i++) {
		if (flag == "1") {
			if (Items[i].id != undefined) {
				strsort = strsort + Items[i].id + ",";
			} else if (Items[i].name != undefined) {
				strsort = strsort + Items[i].name + ",";
			}
		}
		
		if (flag == "0" || flag == "2") {
			if (Items[i].field != undefined) {
				strsort = strsort + Items[i].field + ",";
			} 
		}
		
		if (flag == "3") {
			if (Items[i].name != undefined) {
				strsort = strsort + Items[i].name + ",";
			} 
		}
	}
	return strsort.substring(0, strsort.length - 1);
}

function getTableRow(key, Items,flag) {
	var row = {};
	for ( var i = 0; i < Items.length; i++) {
		if (key == Items[i].id || key == Items[i].name || key == Items[i].field ) {
			if (flag == "1") {
				if (Items[i].label != undefined && Items[i].label != "") {
					row.label = Items[i].label;
				} 
				
				if (Items[i].text != undefined && Items[i].text != "") {
					row.label = Items[i].text;
				} 
				

				if (Items[i].readOnly != undefined) {
					row.readonlyflag = Items[i].readOnly ? 1 : 0;
				} else {
					row.readonlyflag = 0;
				}

				if (Items[i].style != undefined && Items[i].style != "") {
					row.style = Items[i].style;
				} else {
					row.style = "";
				}

				if (Items[i].required != undefined) {
					row.requiredflag = Items[i].required ? 1 : 0;
				} else {
					row.requiredflag = 0;
				}

				if (Items[i].visible != undefined) {
					row.visibleflag = Items[i].visible ? 0: 1;
				} else {
					row.visibleflag = 0;
				}

				if (Items[i].defaultValue != undefined
						&& Items[i].defaultValue != "") {
					row.defaultvalue = Items[i].defaultValue;
				} else {
					row.defaultvalue = "";
				}

			} 
		
			if (flag == "0" || flag == "2") {
				 if (Items[i].header != undefined && Items[i].header != "") {
					  row.label = Items[i].header;
				  }
				  
				  if (Items[i].width != undefined && Items[i].width != "") {
					  row.style =  Items[i].width;
				  } else {
						row.style = "";
				  }
				  
				  if (Items[i].visible != undefined) {
					  row.visibleflag =  Items[i].visible?0:1;
				  }  else {
						row.visibleflag = 0;
				  }
				
				  if (flag == "2") {
					  if (Items[i].readOnly != undefined) {
						  row.readonlyflag =  Items[i].readOnly?1:0;
					  } else {
						  row.readonlyflag = 0;
					  }
					  if (Items[i].required != undefined) {
						  row.requiredflag =  Items[i].required?1:0;
					  } else {
						  row.requiredflag = 0;
					  }
					  
					  if (Items[i].value != undefined && Items[i].value != "") {
						  row.defaultvalue =  Items[i].value;
					  } else {
						  row.defaultvalue = "";
					  }
				  }
			}
			
			
			if (flag == "3") {
				  if (Items[i].title != undefined && Items[i].title != "") {
					  row.label = Items[i].title;
				  }

				  if (Items[i].visible != undefined) {
					  row.visibleflag = Items[i].visible? 0:1;
				  } else {
					  row.visibleflag = 0;
				  }
			}
			

			break;
		}

	}
	return row;
}




function setTabControl (Items) {
	for (var i=0;i<Items.length;i++) {
		if (Items[i].name == "bcontmanaframe") {
			Items[i].control = bcontmanaframe;
		} else if (Items[i].name == "bcontbd") {
			Items[i].control = bcontbd;
		} else if (Items[i].name == "bcontcycfee") {
			Items[i].control = bcontcycfee;
		} else if (Items[i].name == "bcontdeposit") {
			Items[i].control = bcontdeposit;
		} else if (Items[i].name == "bcontcharge") {
			Items[i].control = bcontcharge;
		} else if (Items[i].name == "bcontoverduefine") {
			Items[i].control = bcontoverduefine;
		} else if (Items[i].name == "bcontgoods") {
			Items[i].control = curhtml;
		} else if (Items[i].name == "bcontvipzkfd") {
			Items[i].control = bcontvipzkfd;
		} 
	}
}

function getDetilComboxData(sort) {
	var list = sort.split(",");
	var templist = [];
	for ( var i = 0; i < list.length; i++) {
		var para = {};
		para.code = list[i];
		para.name = list[i];
		templist.push(para);
	}
	return templist;
}

/**
 * 取得系统界面数据 
 * 
 * 
 * 
 **/
function getModelData(billmoduleid,tablename,isflag) {
	 var dictData = "";
	   var searchParam = {};
	   if (billmoduleid != undefined && billmoduleid != "") {
		   searchParam.billmoduleid = billmoduleid;
	   } 
	   if (tablename != undefined && tablename != "") {
		   searchParam.tablename = tablename;
	   }  
	   if (isflag != undefined && isflag != "") {
		   searchParam.isflag = isflag;
	   }
	  itemLoader.doRequest(OmdUrl.master, "mss.base.model.search",
						 searchParam, null, null, function(data) {
					 dictData = data.modelhead[0];
		}, null, null, false);
	  
	   if (dictData == undefined || dictData == "") {
		   return "";
	   }
	  searchParam={};
	  searchParam.ph_key =  dictData["ph_key"];
	  itemLoader.doRequest(OmdUrl.master, "mss.base.model.get",
				 searchParam, null, null, function(data) {
			 dictData = data.modelhead;
	  }, null, null, false);
	  return dictData;
}


function sortfield (list,items,flag) {
	 var reItems = [];
	 for (var i=0;i<list.length; i++) {
		 for (var j=0; j<items.length; j++ ) {
			 if (flag == "0" || flag == "2") {
				 
				 if (items[j].field != undefined && items[j].field == list[i]) {
					 reItems.push(items[j]);
					 break;
				 } else {
					 if (i == 0 && j==0) {
						 reItems.push(items[j]);
					 }
				 }
				
			 } else if (flag == "1") {
				 if ((items[j].name != undefined && items[j].name == list[i]) || (items[j].name == undefined && items[j].id == list[i])) {
					 reItems.push(items[j]);
					 break;
				 }
			 } else if (flag == "3") {
				 if (items[j].name != undefined && items[j].name == list[i]) {
					 reItems.push(items[j]);
					 break;
				 }
			 } 
		 }
	 }
	 
	 return reItems;
	 
 }


function init(modelhead,items) {

	  var modeldetail = modelhead["modeldetail"];
	  
	  // 排序处理
	  var sortstr = modelhead["sorttext"];
	  if (sortstr != undefined && sortstr != "") {
		 var list = sortstr.split (",");
		 items = sortfield(list,items,modelhead["isflag"]);
	  }
	  
	  for (var i=0;i<modeldetail.length;i++) {
		  for (var j=0;j<items.length;j++) {
			  // 处理单据列表
			  if (modelhead["isflag"] == "0" || modelhead["isflag"] == "2") {	
				  if (items[j].field != undefined && items[j].field == modeldetail[i].field) {
					  if (modeldetail[i].label != undefined && modeldetail[i].label != "") {
						  items[j].header = modeldetail[i].label;
					  }
					  
					  if (modeldetail[i].style != undefined && modeldetail[i].style != "") {
						  items[j].width = modeldetail[i].style;
					  }
					  
					  if (modeldetail[i].visibleflag != undefined && modeldetail[i].visibleflag != "") {
						  items[j].visible = modeldetail[i].visibleflag == "1"? false:true;
						  if (!items[j].visible) {
							  items[j].enabledSearch =false;
						  }
					  }  
					  
					  if (modelhead["isflag"] == "2") {
						  if (modeldetail[i].readonlyflag != undefined && modeldetail[i].readonlyflag != "") {
							  items[j].readOnly = modeldetail[i].readonlyflag == "1"? true:false;
						  }
						  if (modeldetail[i].requiredflag != undefined && modeldetail[i].requiredflag != "") {
							  items[j].required = modeldetail[i].requiredflag == "1"? true:false;
						  } 
						  if (modeldetail[i].defaultvalue != undefined && modeldetail[i].defaultvalue != "") {
							  items[j].value = modeldetail[i].defaultvalue;
						  }
					  }
					  
				  }
				  
			  //处理单据头  
			  } else if (modelhead["isflag"] == "1") {
				  if ( (items[j].name != undefined && items[j].name == modeldetail[i].field) || (items[j].name == undefined && items[j].id == modeldetail[i].field)) {
					  if (modeldetail[i].label != undefined && modeldetail[i].label != "") {
						  items[j].label = modeldetail[i].label;
						  
					  }
					  
					  if (modeldetail[i].readonlyflag != undefined && modeldetail[i].readonlyflag != "") {
						  items[j].readOnly = modeldetail[i].readonlyflag == "1"? true:false;
					  }
					  
					  if (modeldetail[i].style != undefined && modeldetail[i].style != "") {
						  var list = modeldetail[i].style.split("/");
						  var style ="";
						  if (list.length == 1) {
							  style = list[0];
						  } else {
							  for (var x=0; x< list.length;x++) {
								  style = style + list[x]+";";
							  }
						  }
						 
						  items[j].style = style;
					  }
					  
					  if (modeldetail[i].visibleflag != undefined && modeldetail[i].visibleflag != "") {
						  items[j].visible = modeldetail[i].visibleflag == "1"? false:true;
					  }
					  
					  if (modeldetail[i].requiredflag != undefined && modeldetail[i].requiredflag != "") {
						  items[j].required = modeldetail[i].requiredflag == "1"? true:false;
					  }
					  
					  if (modeldetail[i].defaultvalue != undefined && modeldetail[i].defaultvalue != "") {
						  items[j].defaultValue = modeldetail[i].defaultvalue;
					  }
				  }
				  // 处理多个明细
			  } else if (modelhead["isflag"] == "3") {
				  if (items[j].name != undefined && items[j].name == modeldetail[i].field) {
					  if (modeldetail[i].label != undefined && modeldetail[i].label != "") {
						  items[j].title = modeldetail[i].label;
					  }

					  if (modeldetail[i].visibleflag != undefined && modeldetail[i].visibleflag != "") {
						  items[j].visible = modeldetail[i].visibleflag == "1"? false:true;
					  }
				  }
			  }
		  }
	  }

	 

	  return items;
}

function initCommon(billmoduleid,tablename,items,flag) {
	  var modelhead = getModelData(billmoduleid,tablename,flag); 
	  if (modelhead == undefined || modelhead == "" ) {
		  return ""; 
	  }
	  var reItems =init(modelhead,items);
	  return  reItems;
}


function initHead (billmoduleid,tablename,items) {
	var reItems = initCommon(billmoduleid,tablename,items,"1");
	return  reItems;
}

function initGrid (billmoduleid,tablename,items) {
	var reItems = initCommon(billmoduleid,tablename,items,"0");
	return  reItems;
}

function initDetail (billmoduleid,tablename,items) {
	var reItems = initCommon(billmoduleid,tablename,items,"2");
	return  reItems;
}

function initTab (billmoduleid,tablename,items) {
	var reItems = initCommon(billmoduleid,tablename,items,"3");
	return  reItems;
}

function isSearch(temp) {
	var flag = false;
	var billtype = getBilltype(temp)
	if (temp == "400909" || billtype == "CS5" ||billtype == "CS4") {
		flag = true;
	}
	return flag;
}

