/**
 * 页面定义
 */
(function () {
	// 要引用的包
	var utils = Future.ns('Future.utils');
	var validate = Future.ns('Future.validate');
	var col = Future.ns('default.col');
	// 活动命名空间
	var ns = Future.ns('bsupinvoicehd.view');

	// 定义一个对象用来配置界面
	var bill = {};
	// 把定义对象放到命名空间下
	ns.bill = bill;
	// 查询列表
	bill.invoicelist = {
		"type": "gridbox",
		"resources": OmdUrl.mss,
		"method": "mss.base.supinvoicehd.search",
		"response": "supinvoicehd",
		"bindform": "layouttabs",
		"bindSearchParam": ["ph_key"], // 明细页面查询条件字段
		"searchParam": {
			"billmoduleid" : app.modulecode,
			"order_field": "inputdate",
			"order_direction": "desc",
		},
		"properties": {
			"id": utils.createid('invoicelist'),
			"columns": [{
				type: "indexcolumn",
				headerAlign: "center",
				header: "行号",
				width: 60,
			},{
				field: "billno",
				type:"TextBox",
				headerAlign:"center",
				header:"单据编号",
				width: "150",
			},{
				field: "billsgno",
				type:"TextBox",
				headerAlign:"center",
				header:"手工单号",
				width: "150",
			},{
				field: "billsource",
				type:"TextBox",
				headerAlign:"center",
				header:"数据来源",
				renderer: "OcmControl.dictRendererWithCode",
				dictkey : 'BILLSOURCE',
				visible : false,
			},{
				field: "billstatus",
				type:"TextBox",
				headerAlign:"center",
				header:"单据状态",
				renderer: "OcmControl.dictRendererWithCode",
				dictkey : 'BILLFLAG',
			},{
				field: "sihsupid",
				displayField : "sihsupid_name",
				type:"TextBox",
				headerAlign:"center",
				header:"供应商",
				width: "250",
				cdEdtCfg : {
					compnentType : 'fut_popselect',
					selectkey : "sbid",
					textName : "sihsupid_name",
				},
			},{
				field: "sihmarket",
				displayField : "sihmarket_name",
				type:"TextBox",
				headerAlign:"center",
				header:"门店",
				width: "250",
				cdEdtCfg : {
					compnentType : 'fut_popselect',
					selectkey : "muid",
					textName : "sihmarket_name",
				},
			},{
				field: "sihcode",
				type:"TextBox",
				headerAlign:"center",
				header:"发票代码",
				width: "250",
			},{
				field: "sihid",
				type:"TextBox",
				headerAlign:"center",
				header:"发票号码",
				width: "250",
			},{
				field: "invoicetype",
				type:"TextBox",
				headerAlign:"center",
				header:"发票类型",
				renderer: "OcmControl.dictRendererWithCode",
				dictkey : 'INVOICETYPE',
			},{
				field: "sbfp",
				type:"TextBox",
				headerAlign:"center",
				header:"发票抬头",
				width: "250",
				enabledSearch : false,
				visible : false,
			},{
				field: "sbfpadd",
				type:"TextBox",
				headerAlign:"center",
				header:"发票地址",
				width: "250",
				enabledSearch : false,
				visible : false,
			},{
				field : "sihbhsje",
				headerAlign : "center",
				header : "不含税金额",
				numberFormat : "c2",
				align: "right",
				enabledSearch : false,
				width:148,
			},{
				field : "sihhsje",
				headerAlign : "center",
				header : "含税金额",
				numberFormat : "c2",
				align: "right",
				value : "0",
				enabledSearch : false,
				width:148,
			},{
				field : "sihse",
				headerAlign : "center",
				header : "税额",
				numberFormat : "c2",
				align: "right",
				enabledSearch : false,
				width:148,
			}, {
				field : "inputer",
				header : "录入人",
				headerAlign : "center",
				readOnly : true,
				enabledSearch : true,
				visible:false,
				width : 100,
			},{
				field : "inputer_name",
				header : "录入人",
				headerAlign : "center",
				readOnly : true,
				enabledSearch : false,
				width : 100,
			},{
				field : "inputdate",
				dataType : "date",
				dateFormat : "yyyy-MM-dd HH:mm:ss", 
				header : "录入日期",
				width : 160,
				headerAlign : "center",
			}, {
				field : "auditor",
				header : "审核人",
				width : 100,
				headerAlign : "center",
				enabledSearch : true,
				visible:false,
			}, {
				field : "auditor_name",
				header : "审核人",
				width : 100,
				headerAlign : "center",
				enabledSearch : false,
			}, {
				field : "auditdate",
				dataType : "date",
				dateFormat : "yyyy-MM-dd HH:mm:ss",
				header : "审核日期",
				headerAlign : "center",
				width : 160,
			}, {
				field : "canceler",
				header : "取消人",
				width : 100,
				headerAlign : "center",
				enabledSearch : true,
				visible:false,
			},{
				field : "canceler_name",
				header : "取消人",
				width : 100,
				headerAlign : "center",
				enabledSearch : false,
			}, {
				field : "canceldate",
				dataType : "date",
				dateFormat : "yyyy-MM-dd HH:mm:ss",
				header : "取消日期",
				headerAlign : "center",
				width : 160,
			}]
		}
	};
	
	// 单据主表
	bill.supinvoicehd = {
		"type": "formgrid",
		"resources": OmdUrl.mss,
		"name": 'supinvoicehd',
		"method": "mss.base.supinvoicehd.get",
		"response": "supinvoicehd",
		"properties": {
			"id": utils.createid('supinvoicehd')
		},
		items:[{
			"label" : "ph_key：",
			"name" : "ph_key",
			"type" : "TextBox",
			"visible":false,
		},{
			"label" : "单据编号：",
			"type" : "TextBox",
			"name" : "billno",
			"readOnly" : "true",
			"style" : "width:22.5%;",
		},{
			"label" : "手工单号：",
			"name" : "billsgno",
			"type" : "TextBox",
			"style" : "width:22.5%;"
		},{
			"label" : "数据来源：",
			"type" : "ComboBox",
			"name" : "billsource",
			dictkey : 'BILLSOURCE',
			"defaultValue" : "02",
			"visible":false,
		},{
			"label" : "单据类型：",
			"name" : "billmoduleid",
			"type" : "ComboBox",
			"defaultValue": app.modulecode,
			dictkey : 'BILLMODULEID',
			"readOnly": true,
			"style" : "width:22.5%;"
		},{
			"label" : "单据状态：",
			"name" : "billstatus",
			"type" : "ComboBox",
			"defaultValue":"N",
			dictkey : 'BILLFLAG',
			"readOnly": true,
			"style" : "width:22.5%;"
		}, {
			"label" : "门店：",
			displayField : "sihmarket_name",
			"name" : "sihmarket",
			"defaultValue" : "",
			"type": "ButtonEdit",
			"required" : "true",
			type : "fut_popselect",//类型
			selectkey:"muid",//弹框类型
			textName :"sihmarket_name", //文本显示字段
			beforefunc:"page.head_beforefunc",
			itemchangedfunc:"page.head_itemchanged_muid",
			"style" : "width:22.5%;"
		},{
			"label" : "商户：",
			"name" : "sihsupid",
			displayField : "sihsupid_name",
			"type": "ButtonEdit",
			"required" : "true",
			type : "fut_popselect",//类型
			selectkey:"sbid",//弹框类型
			textName :"sihsupid_name", //文本显示字段
			beforefunc:"page.head_beforefunc",
			itemchangedfunc:"page.head_itemchanged_sbid",
			"style" : "width:22.5%;"
		},{
			"label" : "发票类型：",
			 "name" : "invoicetype",
			 "type" : "ComboBox", 
			dictkey : 'INVOICETYPE',
			"required" : "true",
			"defaultValue" : "2",
			"style" : "width:22.5%;"
		},{
		    "label" : "开票日期：",
		    "type" : "DatePicker",
		    "name" : "sihkpdate",
		    "format" : "yyyy-MM-dd",
		    "required" : "true",
		    "value" : mini.formatDate(new Date(),"yyyy-MM-dd"),
		    "defaultValue" : mini.formatDate(new Date(),"yyyy-MM-dd"),
			"style" : "width:22.5%;"
		},{
			"label" : "发票代码：",
			"name" : "sihcode",
			"type" : "TextBox",
			"required" : "true",
		    "style" : "width:22.5%",
		},{
			"label" : "发票号码：",
			"name" : "sihid",
			"type" : "TextBox",
			"required" : "true",
			onValuechanged:"page.onSihidChange",
		    "style" : "width:22.5%"
		}, {
			"label": "账单编号：",
			"name": "jsbillno",
			"type": "ButtonEdit",
			textName: "jsbillno",
			allowInput: true,
			"required": "true",
			onbuttonclick : "page.setbillnoClick",
			"style" : "width:22.5%;display:block;float:none"
		 },{
			"label" : "不含税金额：",
			"name" : "sihbhsje",
			"type" : "NumButtonEdit",
			"format" : "c2",
			"defaultValue":0,
			"readOnly": true,
			"style" : "width:22.5%"
		},{
			"label" : "含税金额：",
			"name" : "sihhsje",
			"type" : "NumButtonEdit",
			"format" : "c2",
			"defaultValue":0,
			"readOnly": true,
			"style" : "width:22.5%"
		},{
			"label" : "税额：",
			"name" : "sihse",
			"type" : "NumButtonEdit",
			"format" : "c2",
			"defaultValue":0,
			"readOnly": true,
			"style" : "width:22.5%;display:block;float:none"
		},{
			"label" : "发票抬头：",
			"type" : "TextBox",
			"name" : "sbfp",
			"readOnly": true,
			"style" : "width:22.5%"
		}, {
			"label" : "发票地址：",
			"type" : "TextBox",
			"name" : "sbfpadd",
			"readOnly": true,
			"style" : "width:67.5%; display:block;float:none",
		},{
			"label" : "备注：",
			"name" : "sihmemo",
			"type" : "TextBox",
			"style": "width:90%;display:block;float:none",
		},{
			"label" : "录入人编码",
			"type" : "TextBox",
			"name" : "inputer",
			"visible" : false,
		},{
			"label" : "录入人：",
			"type" : "TextBox",
			"name" : "inputer_name",
			"readOnly" : "true",
			"style" : "width:22.5%"
		},{
			"label" : "审核人编码",
			"type" : "TextBox",
			"name" : "auditor",
			"visible" : false,
		},{
			"label" : "审核人：",
			"type" : "TextBox",
			"name" : "auditor_name",
			"readOnly" : "true",
			"style" : "width:22.5%"
		 },{
			"label" : "取消人编码",
			"type" : "TextBox",
			"name" : "canceler",
			"visible" : false,
		},{
			"label" : "取消人：",
			"type" : "TextBox",
			"name" : "canceler_name",
			"readOnly" : "true", 
			"style": "width:22.5%;display:block;float:none",
		},{
			"label" : "录入日期：",
			"type" : "DatePicker",
			"name" : "inputdate",
			"format" : "yyyy-MM-dd HH:mm:ss",
			"readOnly" : "true",
			"style" : "width:22.5%"
		},{
			"label" : "审核日期：",
			"type" : "DatePicker",
			"name" : "auditdate",
			"format" : "yyyy-MM-dd HH:mm:ss",
			"readOnly" : "true",
			"style" : "width:22.5%"
		 },{
			"label" : "取消日期：",
			"type" : "DatePicker",
			"name" : "canceldate",
			"format" : "yyyy-MM-dd HH:mm:ss",
			"readOnly" : "true",
			"style" : "width:22.5%"
			}
		]
	}
	// 单据明细
	bill.supinvoicedet= {
			title: '单据明细',
			"type": "gridbox",
			name: 'supinvoicedet',
			"properties": {
				"id": utils.createid('supinvoicedet'),
				"multiSelect" : true,
				"allowCellEdit" : true,
				"allowCellSelect" : true,
				"editNextOnEnterKey" : true,
				"editNextRowCell" : true,
				"allowSortColumn" : false,
				"showColumnsMenu":true,
				"oncellbeginedit" : "OcmControl.checkboxEditor",
				"oncellendedit" : 'OcmControl.datetimeFormate',
				"columns": [{
					type: "checkcolumn",
					name: "checkcolumn",
					headerAlign: "center",
					readOnly: true,
				}, {
					field: "rowno",
					headerAlign: "center",
					align: "center",
					header: "行号",
					type: "indexcolumn",
					readOnly: true,
					width: "60px",
				},{	
					field: "seq",
					type :"TextBox",
					header:"行号",
					visible:false,
				},{	
					field: "kpkm",
					type :"TextBox",
					header:"开票科目",
					headerAlign:"center",
					renderer: "OcmControl.dictRendererWithCode",
					dictkey : 'FYKPTYPE',
					readOnly: true,
				},{
					field : "tax",
					header : "税率",
					headerAlign : "center",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{
						format: "p2",
					},
					numberFormat : "p2",
					align: "right",
					readOnly: true,
				},{
					field : "bhsje",
					headerAlign : "center",
					header : "不含税金额",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{
						format: "c2",
					},
					numberFormat : "c2",
					align: "right",
					readOnly: true,
				},{
					field : "hsje",
					headerAlign : "center",
					header : "含税金额",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{
						format: "c2",
					},
					numberFormat : "c2",
					align: "right",
					readOnly: true,
				},{
					field : "se",
					headerAlign : "center",
					header : "税额",
					editor : OcmControl.newControl('NumButtonEdit'),
					editorSet:{
						format: "c2",
					},
					numberFormat : "c2",
					align: "right",
					value : "0",
					readOnly: true,
				},{
					field: "memo",
					type:"TextBox",
					headerAlign:"center",
					header:"备注",
				}]
			},
		};
	
	
	var btn = Future.default.btn;
	
	// 按钮配置 - 固定名称
	bill.toolbarconfig = {
		id: utils.createid('systoolbar'),
		items: [btn.addData, btn.delData, btn.editData, btn.saveData,
			btn.separator,btn.auditData,btn.cancelData, btn.searchData
		]
	}
	
	// 单据配置
	bill.billconfig = {
		billhead: bill.supinvoicehd, // 单据主表
		billdetail: [bill.supinvoicedet], // 单据明细表
		billquerylist: bill.invoicelist, // 查询列表
		dettabpages: [bill.supinvoicedet], // 要放入明细TAB列表的组件
		defaultmoduleid: app.modulecode, // 默认单据类型
	}
	// 创建标准单据模板
	utils.create_standardbill_config(bill);

})()
