var tabs1 = mini.get("tabs1");         // 获取tabs1
var code = mini.getbyName("code");// 门店
var details = mini.get("details"); // 明细
var cardLayout = mini.get("cardLayout");

// tab页面切换的时候，需要绑定自定义控件的数据集
if (tabs1) {
	tabs1.on('activechanged', function(e) {
		if (e.tab.name == "details") {
			setBillData();
		}
		
	});
}


// 数据回填
function setBillData(){
    var _details = mini.get("details");
    var _datas = {};
    if (_details) 
    {
        _datas = _details.config.data;
    }
	 if (_datas && jQuery.isEmptyObject(_datas) == false){ 
		 mini.getbyName("code").set({"readOnly":true, "enabled":false});
		
	}
	 
	
}



//新增按钮后事件
OcmControl.toolbarFn.addDataAfter = function()
{
	mini.getbyName("code").set({"readOnly":false, "enabled":true});
	//mini.getbyName("code").setReadOnly(false);
};

// 保存按钮后事件
OcmControl.toolbarFn.saveDataAfter = function()
{
    setBillData();
};

// 审核按钮后事件
OcmControl.toolbarFn.auditDataAfter = function()
{
    setBillData();
};

//删除按钮
OcmControl.toolbarFn.delDataBefore = function() {
	var code =  mini.getbyName("code").getValue();
	if (code != "" && code != undefined)  {
		if (!selectBusiness(code)) {
			mini.alert("设置凭证模型["+code+"]已被引用，不能删除");	
			return;
		}
	}
	return {};
};
//保存按钮前事件
OcmControl.toolbarFn.saveDataBefore = function() {
	var form = details.form;
	var code = form.getField("code").getValue();
	if (code == "" || code == undefined) {
		var temp = selectCode();
		if (temp == "") {
			return;
		} 
		var obj = {};
		obj.code = temp;
		return obj;
	} else {
		if (!checkdata(code))  {
			mini.alert("代码[" + code + "]已存在， 请重新输入");
			mini.getbyName("code").setValue("");
			return;
		}
		
	}
	
	return true;
};


//获取code
var selectCode = function() {
	var total = "";
	var searchParam = {
			"queryid" : "select_cwzzparacode",
	};
	itemLoader.doRequest(OmdUrl.mall,
			"mss.work.report.query", searchParam, null,
			null, function(data) {
		total = data.report[0].code;
			}, null, null, false);
	return total;
};

var selectBusiness = function(code) {
	var total;
	var searchParam = {
			"queryid" : "select_business",
			"code" :code,
	};
	itemLoader.doRequest(OmdUrl.mall,
			"mss.work.report.query", searchParam, null,
			null, function(data) {
		total = data.report[0].total;
			}, null, null, false);
	if (total > 0) {
		return false;
	} else {
		return true;
	}
};

function onCodeChange (e) {
	
	var text = e.value;
	if (text != "") {
		if (!checkdata(text)) {
			mini.alert("代码[" + text + "]已存在， 请重新输入");
			mini.getbyName("code").setValue("");
			return;
		}
	}
}

function checkdata(text) {
	var ph_key =  mini.getbyName("ph_key").getValue();
	var searchParam = {
			"code" :text,
	};
	if (ph_key != "") {
		searchParam.ph_key = {"<>":ph_key};
	}
	itemLoader.doRequest(OmdUrl.mall,
			"mss.base.cwzzpara.search", searchParam, null,
			null, function(data) {
		total = data.cwzzpara;
			}, null, null, false);
	if (total.length > 0) {
		return false;
	} else {
		return true;
	}
}