(function () {
    if (!window.Future) {
        window.Future = {};
    }
    if (!window.Future.commondict) {
        window.Future.commondict = {};
    }
    Future.commondict.commondictobj = function () {
        this.supper = Future.commondict.commondictobj.superclass;
        this.supper.constructor.call(this);
        
        this.btnitems = [ [ {
			'text' : '修改',
			'iconCls' : 'icon-edit',
			'name' : 'editData'
		}, {
			'text' : '保存',
			'iconCls' : 'icon-save',
			'name' : 'saveData'
		}, {
			'text' : '日志',
			'iconCls' : 'icon-print',
			'name' : 'viewLogs'
		} ] ];// 当前按钮数组
        
        this.btnstatusconfig = { // 只有一个状态
			'E' : [ 'saveData', 'viewLogs' ],
			'V' : [ 'editData', 'viewLogs' ]
		};// 按钮状态配置
    };
    mini.extend(Future.commondict.commondictobj, Future.Pub.Billbase, {
    	initBase: function() {
    		this.initEvents();
    		this.initToolbar();
			this.setmodified(true);
			this.setbtnsta("V");
			this['flag'] = 'U';
			
			this.dw_querylist.load();
    	},
    	initEvents: function() {
    		var _this = this;
    		// 设置Grid双击事件
    		this.dw_querylist.set({
        	    onbeforeload: function(e) {
        	    	_this.doquery(e);
        	    }
        	});
    	}
    });
    
    Future.commondict.commondictobj.prototype.doeditData = function() {
    	this.dw_querylist.setEnabled(true);
		this.setbtnsta("E");
    };

    Future.commondict.commondictobj.prototype.dosaveData = function() {
    	var _this = this;
    	// 是否修改
    	if(!this.dw_querylist.isChanged()) {
    		_this.dw_querylist.setEnabled(false);
    		_this.setbtnsta("V");
    		return;
    	}
    	// 验证
    	this.dw_querylist.validate();
    	if(!this.dw_querylist.isValid()) {
    		return;
    	}
    	var postData = {};
    	postData[this.dw_querylist.config.response] = this.dw_querylist.getChanges();
    	this.setGridData(postData[this.dw_querylist.config.response]);
//    	$.each(postData[this.dw_querylist.config.response], function(inx, obj) {
//    		obj["flag"] = "U";
//    	});
    	var inx = this.dw_querylist.config.method.lastIndexOf(".");
    	var method = this.dw_querylist.config.method.substring(0, inx) + ".save";
    	itemLoader.doRequest(this.dw_querylist.config.resources, method, postData, null, null,
	        function(data) {
    		_this.setbtnsta("V");
			_this.dw_querylist.reload();
			_this.dw_querylist.setEnabled(false);
            mini.alert('保存成功');
        },
        null, null, false);
    };
    
    Future.commondict.commondictobj.prototype.doaddRowData = function() {
        var _obj = {};
        _obj['flag'] = 'I';
        for (var i = 0; i < this.dw_querylist.config.properties.columns.length; i++) {
            var _k = this.dw_querylist.config.properties.columns[i];
            if (_k.required) {
                _obj[_k['field']] = '';
            }
            if (_k.value) {
                _obj[_k['field']] = _k.value;
            }
        }
        this.dw_querylist.addRow(_obj);
        this.doeditData();
    };
    
    Future.commondict.commondictobj.prototype.doremoveRowData = function() {
    	var _this = this;
    	mini.confirm("是否删除明细？", "提示", function (action) {
            if (action == "ok") {
            	var row = _this.dw_querylist.getSelected();
            	if(!row) {
            		mini.alert("请选择一条数据");
            		return;
            	}
            	row["flag"] = "D";
            	_this.dw_querylist.removeRow(row, false);
            }
        });
    };
    
    Future.commondict.commondictobj.prototype.doviewLogs = function() {
    	var _this = this;
		var _url = "/mall-business-ui/pages/common/operationlog-view.jsp";
		if (app.token && app.token != "")
		{
			_url = _url + "?token="+ app.token;
		}
		if (app.srvkey && app.srvkey != "")
		{
			_url = _url + "?srvkey="+ app.srvkey;
		}
    	mini.open({
    		url : encodeURI(_url),
    		title : "日志查看",
    		width :  $(window).width() * 0.8,
    		height : $(window).height() * 0.8,
    		onload : function() {
    			var iframe = this.getIFrameEl();
    			iframe.contentWindow.load(_this.billmoduleid);
    		},
    		ondestroy : function(data) {
    			
    		}
    	});
    };
    
})();

