<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<!DOCTYPE html />
<html>
<head>
    <title>商品选择列表</title>
    <script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
    <style>
    .mini-itemsbutton {
    	border: none;
    	background: none;
    	display: inline-block;
    	padding: 0;
    	height: 21px;
    	margin-bottom: 5px;
    	text-align: right;
    }
    .mini-itemsbutton .mini-button {
    	margin: 0 0 0 5px;
    }
    </style>
</head>
<body>  
   
   	<div class="ocm-formheader" config="formheader1"></div>
  
	<div class="mini-fit">
		<div class="ocm-gridbox" config="config1"></div>
	</div>
	
	<div style="padding:5px;text-align:center;">
		<a name="ok" class="mini-button" iconCls="icon-ok" style="margin-right:40px;" onclick="onOkClick">确定</a>
		<a name="cancel" class="mini-button" iconCls="icon-cancel" onclick="onCancelClick">取消</a>
	</div>

<script type="text/javascript">
// 自定义控件
  mini.ItemsButton = function() {
    mini.ItemsButton.superclass.constructor.call(this);
    this.init();
  };

  mini.extend(mini.ItemsButton, mini.ToolBar, {

    uiCls: 'mini-itemsbutton',

		config: {
			items: [[
			{
				"text": "查询",
				"type": "Button",
				"name": "searchData",
				"enabled": true,
				"style": "width:70px",
				"onclick": "onSearchDataClick",
			}, {
				"text": "清除",
				"type": "Button",
				"name": "clearData",
				"enabled": true,
				"style": "width:70px",
				"onclick": "onClearDataClick",
			}]]
		},


    init: function() {

      this.set({
        'name': 'toolbar',
        'buttonItems': this.config.items,
        'cls': 'mini-itemsbutton',
      });

    },

    setButtonItems: function(items) {
      if (!mini.isArray(items)) return;
      var separators = [];
      for (var x = 0; x < items.length; x++) {
        for (var i = 0; i < items[x].length; i++) {
          if (this.id.indexOf('_') > -1) {
            var prefix = (this.id).split('_')[0] || '';
            items[x][i]['name'] = prefix + '_' + items[x][i]['name'];
          }
          // 设置默认点击事件
          this['btn_' + items[x][i].name] = new mini.Button();
          this['btn_' + items[x][i].name].set(items[x][i]);
          this['btn_' + items[x][i].name].render(this.getEl());
        }

        if (x < items.length - 1 && items.length > 2) {
          separators[i] = new mini.Separator();
          separators[i].set({cls: 'separator toolbar_separator'});
          separators[i].removeCls('mini-separator');
          separators[i].render(this.getEl());
        }
      }
    },

  });

  mini.regClass(mini.ItemsButton, 'itemsbutton');



	var formheader1 = {
		"type" : "formgrid",
		"properties" : {
			"id" : "formheader1",
			"style" : "padding:5 0 0 0px",
		},
		items : [ {
			"label" : "商品编码：",
			"type" : "TextBox",
			"name" : "gbid",
			"enabled" : true,
			"style" : "width:50%;",
		}, {
			"label" : "商品名称：",
			"type" : "TextBox",
			"name" : "gbcname",
			"enabled" : true,
			"style" : "width:50%;",
		}, {
			"label" : "商品条码：",
			"type" : "TextBox",
			"name" : "gbbarcode",
			"enabled" : true,
			"style" : "width:50%;",
		}, {
			"text" : "查询",
			"type" : "ItemsButton",
			"name" : "searchData",
			"enabled": true,
			"style" : "width:50%;text-align: right",
		}]
	};

	var config1 = {
		"type" : "gridbox",
		"resources" : OmdUrl.mdm,
		"method" : "ocm.mdm.goodsbase.search",
		"response" : "goodsbase",
		"manualLoad" : true,
		"searchParam" : {},
        "uniqueField": "gbid",
		"properties" : {
			"id" : "gridbox1",
			"onrowdblclick" : "onRowDblClick",
			"multiSelect" : true,
			"columns" : [ {
				type : "checkcolumn",
				headerAlign : "center",
			}, {
				type : "indexcolumn",
				header : "行号",
				headerAlign : "center",
				width : 60,
			}, {
				field : "gbbarcode",
				name : "gbbarcode",
				header : "商品条码",
				allowSort : true,
				headerAlign : "center",
				width : 80,
			}, {
				field : "gbcname",
				name : "gbcname",
				header : "商品名称",
				allowSort : true,
				headerAlign : "center",
				width : 200,
			},{
				field : "gbename",
				name : "gbename",
				header : "柜组",
				allowSort : true,
				headerAlign : "center",
				width : 200,
			}, {
				field : "gbspec",
				name : "gbspec",
				header : "规格",
				allowSort : true,
				headerAlign : "center",
				width : 120,
				visible:false,
			},  {
				field : "gbcatname",
				name : "gbcatname",
				header : "商品类别",
				allowSort : true,
				headerAlign : "center",
				width : 200,
			},{
				field : "gbcatcode",
				name : "gbcatcode",
				header : "商品类别",
				allowSort : true,
				headerAlign : "center",
				width : 70,
				visible:false,
			}, {
				field : "gbppname",
				name : "gbppname",
				header : "品牌",
				allowSort : true,
				headerAlign : "center",
				width : 200,
				//renderer : "onBrandRenderer",
			}, {
				field : "gbppcode",
				name : "gbppcode",
				header : "品牌",
				allowSort : true,
				headerAlign : "center",
				width : 100,
				visible:false,
				//renderer : "onBrandRenderer",
			}, {
				field : "gbunit",
				name : "gbunit",
				header : "单位",
				allowSort : true,
				headerAlign : "center",
				width : 100,
				//renderer : "onCatRenderer",
			}, {
				field : "spec",
				header : "规格",
				allowSort : true,
				headerAlign : "center",
				width : 80,
				visible:false,
			}, {
				field : "gbkl",
				header : "原扣率",
				allowSort : true,
				headerAlign : "center",
				width : 80,
			} ]
		},
	};
	
	mini.parse();
	
	
	function onRowDblClick(e) {
		onOkClick();
    }
	
	
	
	
</script>
	<script src="goodsbase.js" type="text/javascript"></script>
</body>
</html>