var tabs = mini.get("tabs");

var details = mini.get("details");

var formheader1 = mini.get("formheader1");

var form = new mini.Form("#formheader1");

// 改变按钮的状态
var _toolbar = mini.get("Layout_toolbar");
// 定义一个长度
var len;
var flag = "";
_toolbar.changedStatus("S");
//获取编码规则
var globrule = getGrobrule("goodscat");

// 新增后 toolbar状态栏
function initData() {
    _toolbar.changedStatus("N");
};

// 保存后
function changeData() {
    _toolbar.changedStatus("S");
}

// 修改后
function edData() {
    _toolbar.changedStatus("E");
}

// 删除后
function delDataAfter() {
    _toolbar.changedStatus("D");
}

getTreeData();

function getTreeData() {
    var svr = "mall.work.goodscat.search";
    itemLoader.doRequest(OmdUrl.mall, svr, {
        page_no: 1,
        page_size: 9999,
        "order_field": "catcode",
        "order_direction": "asc",
    }, null, null, function (data) {
        var source = data.goodscat;
        len = source.length;
        for (var i = 0; i < source.length; i++) {
            source[i].codename = "[" + source[i].catcode + "]"
                + source[i].catcname;
        }
        source.push({
            catcode: "0",
            catclass: "0",
            catcname: "所有分类",
            codename: "所有分类"
        });
        tabs.loadList(source, "catcode", "catpcode");
        tabs.expandAll();
    }, null, null, false);
}

// 数据回填
tabs.on("nodeclick", function initData(e) {
    _toolbar.changedStatus("N");
    // 切换节点控制表单是否可编辑
    var items = formheader1.config.items;
    for (var i = 0; i < items.length; i++) {
        mini.getbyName(items[i].name).setEnabled(false);
    }
    var node = tabs.getSelectedNode();// 获取选中的节点

    var form = new mini.Form("#formheader1");
    form.setData(node);

});

// 新增子项(先将表头清空，再将表头上的chaparentid的值设成节点的chaid的值)
function addChildData() {
    var node = tabs.getSelectedNode();// 获取选中的节点
    var catclass = parseInt(node.catclass) + 1;
    var maxclass = parseInt(globrule.rulemaxcls);
    if (maxclass != 3) {
        mini.alert("商品分类为3层结构，请检查编码规则");
        return;
    }
    if (catclass > maxclass) {
        mini.alert("当前层级大于系统设置最大层级，不能增加子级，请重新选择");
        return;
    }
    if (catclass > 3) {
        mini.alert("3级以上不能新增下级节点,请重新选择");
        return;
    }
    initData();                               // 改变toolbar状态
    var items = formheader1.config.items;
    for (var i = 0; i < items.length; i++) {
        mini.getbyName(items[i].name).setEnabled(true);
    }
    form.reset();
    form.getField("catstatus").setValue("Y");
    // form.getField("catcode").setValue(catcode);
    form.getField("catpcode").setValue(node.catcode);
    form.getField("catclass").setValue(catclass);
    form.getField("catflag").setValue((catclass == maxclass ? "Y" : "N"));
    form.getField("catpcode").setEnabled(false);
    form.getField("catclass").setEnabled(false);
    form.getField("catflag").setEnabled(false);
    flag = "I";
    if (globrule.rulemode == "1") {
        mini.getbyName("catcode").setEnabled(false);
    } else {
        mini.getbyName("catcode").setEnabled(true);
    }
}

// 新增本项
function addSelfData() {
    var node = tabs.getSelectedNode();// 获取选中的节点
    var catclass = parseInt(node.catclass);
    if (catclass == '0') {
        mini.alert("不能新增此项本级");
        return;
    }
    var maxclass = parseInt(globrule.rulemaxcls);
    if (maxclass != 3) {
        mini.alert("商品分类为3层结构，请检查编码规则");
        return;
    }
    initData();                              // 改变toolbar状态
    // 改变表头的是否可编辑状态
    var items = formheader1.config.items;
    for (var i = 0; i < items.length; i++) {
        mini.getbyName(items[i].name).setEnabled(true);
    }
    form.reset();
    form.getField("catstatus").setValue("Y");
   // form.getField("catcode").setValue(catcode);
    form.getField("catpcode").setValue(node.catpcode);
    form.getField("catclass").setValue(node.catclass);
    form.getField("catflag").setValue((catclass == maxclass ? "Y" : "N"));
    form.getField("catpcode").setEnabled(false);
    form.getField("catclass").setEnabled(false);
    form.getField("catflag").setEnabled(false);
    flag = "I";
    if (globrule.rulemode == "1") {
        mini.getbyName("catcode").setEnabled(false);
    } else {
        mini.getbyName("catcode").setEnabled(true);
    }

}


// 表头不能修改
function canNotEdit() {
    var items = formheader1.config.items;
    for (var i = 0; i < items.length; i++) {
        mini.getbyName(items[i].name).setEnabled(false);
    }
}

// 表头能修改
function canEdit() {
    var items = formheader1.config.items;
    for (var i = 0; i < items.length; i++) {
        mini.getbyName(items[i].name).setEnabled(true);
    }
}


// 查询是否有子项
function isChild(catcode) {
    var searchParam = {
        catpcode: catcode,
    };
    var _dicData = {};
    itemLoader.doRequest(OmdUrl.mall, "mall.work.goodscat.search",
        searchParam, null, null, function (data) {
            _dicData = data.goodscat;
        }, null, null, false);
    return _dicData;
}


// 删除
function delData() {
    var _date = getFormValue();
    var childDate = isChild(_date[0].catcode);
    if (childDate.length > 0) {
        mini.alert("还有子项，不能进行删除操作");
        return;
    }
    var searchParam = {}
    var isuse;
    var gbcatcode = _date[0].catcode;
    var isyy = checkgoodsbase(gbcatcode);
    if (isyy == false) {
        mini.alert("商品分类：[" + gbcatcode + "] 被引用，不允许删除!")
        return;
    }
    ;


    _date[0].flag = "D";
    _date[0].ph_key = form.getField("ph_key").getValue();
    itemLoader.doRequest(OmdUrl.mall, "mall.work.goodscat.delete", _date[0], null, null, function (data) {
        mini.alert("删除成功!");
        canNotEdit();          // 保存成功之后让表头不可编辑
        getTreeData();         // 刷新树
        delDataAfter()           // 更改toolbar的状态
        form.reset();
        tabs.selectNode(_date[0].chaparentid);
    }, null, null, false);
}

// 获取表单上的值
function getFormValue() {
    var node = tabs.getSelectedNode();// 获取选中的节点
    var form = new mini.Form("#formheader1");

    var addDatas = [];
    addDatas.push(form.getData());

    return addDatas;
}


// 修改
function editData() {
    var node = tabs.getSelectedNode();// 获取选中的节点
    if (node.catclass == '0') {
        mini.alert("所有分类节点不允许修正，请重新选择");
        return;
    }
    canEdit();  // 表头是否可编辑
    // 修改的时候编号是不能修改的
    mini.getbyName("catcode").setEnabled(false);
    mini.getbyName("catclass").setEnabled(false);
    mini.getbyName("catflag").setEnabled(false);
    mini.getbyName("catpcode").setEnabled(false);
    edData();   // toolbar状态改变
    flag = "U";
}

// 保存
function saveData() {
    //var temp = details.form.getData();
    var _date = getFormValue();
    _date[0].flag = flag;
    _date[0].ph_key = form.getField("ph_key").getValue();
   var ph_key = form.getField("ph_key").getValue();
    if (!mini.getbyName("catcname").getValue()) {
        mini.alert("请输入中文名称");
        return;
    }

    if (!mini.getbyName("catstatus").getValue()) {
        mini.alert("请选择状态");
        return;
    }
    if(globrule.rulemode =="0"){//自动编码模式
        if (!mini.getbyName("catcode").getValue()) {
            mini.alert("请输入编码");
            return;
        }
        if(GetLength(mini.getbyName("catcode").getValue())> 10) {
            mini.alert("编码长度超过10码，请检查！")
            return ;
        }
    }

    //层级不允许超过3级,跟分析报表展示有关
    if (_date[0].catclass > 3) {
        mini.alert("层级不允许超过3级，请检查!");
        return;
    }
    // 判断名称是否重复
    if (flag == "I") {
        var param = {};
        //param.catcode = _date[0].catcode;
        param.catcname = _date[0].catcname;
        var returnflag = false;
        itemLoader.doRequest(OmdUrl.mall, "mall.work.goodscat.search", param, null, null, function (data) {
            if (data.goodscat.length > 0) {
                //mini.alert("编码 " + _date[0].catcode + " 已存在！");
                mini.alert("名称 " + _date[0].catcname + " 已存在！");
                returnflag = true;
            }
        }, null, null, false);

        if (returnflag) {
            return;
        }
    }

    itemLoader.doRequest(OmdUrl.mall, "mall.work.goodscat.save", _date, null, null, function (data) {
        if (flag == "I") {
            var ph_key = data[0].ph_key;
            var searchParam = {
                "ph_key" : ph_key
            };
            itemLoader.doRequest(OmdUrl.mall, "mall.work.goodscat.get",searchParam, null, null, function(data) {
                if (data) {
                    var catcode = data.goodscat.catcode;
                };
                form.getField("catcode").setValue(catcode);
            },null,null,false);
            mini.alert("保存成功!");
        } else if (flag == "U") {
            mini.alert("修改成功!");
        }
        var ph_key = data[0].ph_key;
        canNotEdit();          // 保存成功之后让表头不可编辑
        getTreeData();         // 刷新树
        changeData()           // 更改toolbar的状态
        tabs.selectNode(_date[0].chaid);
    }, null, null, false);
};

function setSelecdName(temp, tempfalg) {
    var data = tabs.getList();
    for (var i = 0; i < data.length; i++) {
        if (data[i].catcname == temp) {
            if (tempfalg) {
                tabs.selectNode(data[i]);
                return;
            } else {
                if (flag == "I" || flag == "U") {
                    return false;
                }
            }
        }
    }

    if (!tempfalg) {
        return true;
    }
}

function checkgoodsbase(value) {
    var flag = true;
    var searchParam = {}
    searchParam.gbcatcode = value;
    itemLoader.doRequest(OmdUrl.mallmdm, "mall.mdm.goodsbase.search",
        searchParam, null, null, function (data) {
            if (data.goodsbase != undefined && data.goodsbase.length > 0) {
                flag = false;
            }
            ;
        }, null, null, false);
    return flag;
}
function GetLength(str) {
    return str.replace(/[\u0391-\uFFE5]/g, "aa").length;  //先把中文替换成两个字节的英文，在计算长度
}
function setSelecdNode(temp, tempfalg) {
    var data = tabs.getList();
    for (var i = 0; i < data.length; i++) {
        if (data[i].catcode == temp) {
            if (tempfalg) {
                tabs.selectNode(data[i]);
                return;
            } else {
                if (flag == "I") {
                    return false;
                }
            }
        }
    }

    if (!tempfalg) {
        return true;
    }
}