var tabs = mini.get("tabs");
var details = mini.get("details");
var flag = "";
// 改变按钮的状态
var _toolbar = mini.get("config_toolbar");
var mfdata = getGrobrule("org");

var mftype;

if (_toolbar) {
    _toolbar.changedStatus("S");
    if (_toolbar["btn_config_editPayData"]) {
        _toolbar["btn_config_editPayData"].on("click", editData);
    }

    if (_toolbar["btn_config_savePayData"]) {
        _toolbar["btn_config_savePayData"].on("click", saveData);
    }

    if (_toolbar["btn_config_addChildData"]) {
        _toolbar["btn_config_addChildData"].on("click", addChildData);
    }

    if (_toolbar["btn_config_addSelfData"]) {
        _toolbar["btn_config_addSelfData"].on("click", addSelfData);
    }

    if (_toolbar["btn_config_delPayData"]) {
        _toolbar["btn_config_delPayData"].on("click", delPayData);
    }
    setStatus(false);
    getTreeData();
}

// 数据回填
tabs.on("nodeclick", function initData(e) {
    var node = tabs.getSelectedNode();// 获取选中的节点
    if (node.mfid != "0") {
        setBillData(node);
    } else {
        details.form.clear();
        setStatus(false);
        _toolbar.changedStatus("S");
    }
});

function setBillData(node) {
    var _details = mini.get("details");
    var _datas = {};
    _details.getResources({
        mfid: node.mfid,
        ph_key: node.ph_key,
    });
    _datas = _details.config.data;
    if (_datas["mfpid"] == '0') {
        mini.getbyName("mfpid").setValue(_datas["mfpid"]);
        mini.getbyName("mfpid").setText("[" + _datas["mfpid"] + "]组织机构");
    } else {
        var mf = getmfpid(_datas["mfpid"]);
        mini.getbyName("mfpid").setValue(_datas["mfpid"]);
        mini.getbyName("mfpid").setText(
            "[" + mf[0].mfid + "]" + mf[0].mfcname);
    }
    if (_datas && _datas != {}) {
        _toolbar.changedStatus("S");
    }
    mftype = _datas["mftypecode"];
}

function getTreeData() {
    var searchParam = {
        "order_field": "mfid",
        "nsta": '2021',
        "page_size": 9999
    };
    itemLoader.doRequest(OmdUrl.mall, "mall.work.manaorg.search", searchParam, null, null, function (data) {
        var source = data.manaorg;
        len = source.length;
        for (var i = 0; i < source.length; i++) {
            source[i].codename = "[" + source[i].mfid + "]"
                + source[i].mfcname;
        }
        source.push({
            mfid: "0",
            mfcname: "组织机构",
            codename: "组织机构",
            mfflag: "N",
            mfclass: 0,
            mfstatus: "Y",
        });
        tabs.loadList(source, "mfid", "mfpid");
        tabs.expandAll();
    }, null, null, false);
}

function editData() {
    var node = tabs.getSelectedNode();// 获取选中的节点
    if (node.mfid == "0") {
        mini.alert("组织机构节点不允许修改，请重新选择");
        return;
    }
    if (node.mftypecode == "M") {
        mini.alert("组织机构类型为门店不允许修改，如需要修改请到门店资料维护中修改");
        return;
    }
    flag = "U";
    _toolbar.changedStatus("E");
    setStatus(true);
    mini.getbyName("mfid").setEnabled(false);
}

function getForm() {
    var data = {};
    data.mfid = mini.getbyName("mfid").getValue() ? mini.getbyName("mfid")
        .getValue() : "";
    data.mfcname = mini.getbyName("mfcname").getValue() ? mini.getbyName(
        "mfcname").getValue() : "";
    data.mfename = mini.getbyName("mfename").getValue() ? mini.getbyName(
        "mfename").getValue() : "";
    data.mfpid = mini.getbyName("mfpid").getValue() ? mini.getbyName("mfpid")
        .getValue() : "";
    data.mfclass = mini.getbyName("mfclass").getValue() ? mini.getbyName(
        "mfclass").getValue() : "";
    data.mfflag = mini.getbyName("mfflag").getValue() ? mini
        .getbyName("mfflag").getValue() : "";
    data.muid = mini.getbyName("muid").getValue() ? mini.getbyName("muid")
        .getValue() : "";
    data.mfstatus = mini.getbyName("mfstatus").getValue() ? mini.getbyName(
        "mfstatus").getValue() : "";
    data.mftypecode = mini.getbyName("mftypecode").getValue() ? mini.getbyName(
        "mftypecode").getValue() : "";
    data.person1 = mini.getbyName("person1").getValue() ? mini.getbyName(
        "person1").getValue() : "";
    data.hscode = mini.getbyName("hscode").getValue() ? mini
        .getbyName("hscode").getValue() : "";
    return data;
}

function setStatus(flag) {
    var items = details.config.items;
    for (var i = 0; i < items.length; i++) {
        mini.getbyName(items[i].name).setEnabled(flag);
    }
    mini.getbyName("mfstatus").setEnabled(false);
    mini.getbyName("mfflag").setEnabled(false);
    mini.getbyName("mfclass").setEnabled(false);
    mini.getbyName("mfpid").setEnabled(false);
    mini.getbyName("muid").setEnabled(false);
}

function setNode(node) {

    details.form.clear();
    var mfclass = Number(node.mfclass);
    var mftypecode;
    // node.temp=1表示新增子级，node.temp=2新增本级
    if (node.temp == "1") {
        mini.getbyName("mfpid").setValue(node.mfid);
        mini.getbyName("mfpid").setText("[" + node.mfid + "]" + node.mfcname);
        mfclass = mfclass + 1;
        mini.getbyName("mfclass").setValue(mfclass);
        if (mfdata.rulemode == "1") {
            // var mfid = getRuleCode(node.mfid, mfclass);
            // mini.getbyName("mfid").setValue(mfid);
        }
        if (node.mftypecode && node.mftypecode != 'M') {
            mftypecode = node.mftypecode;
        } else {
            mftypecode = '2';
        }
        // 机构类型，默认等于上级机构类型
        mini.getbyName("mftypecode").setValue(mftypecode);
    } else if (node.temp == "2") {
        var code = getmfid(node.mfpid);
        mini.getbyName("mfpid").setValue(node.mfpid);
        if (node.mfpid == "0") {
            mini.getbyName("mfpid").setText('[' + 0 + ']' + '组织机构');
        } else {
            mini.getbyName("mfpid").setText(
                '[' + code[0].mfid + ']' + code[0].mfcname);
        }

        mini.getbyName("mfclass").setValue(mfclass);
        if (mfdata.rulemode == "1") {
            if (code.length > 0) {
                // var mfid = getRuleCode(code[0].mfid, mfclass);
                // mini.getbyName("mfid").setValue(mfid);
            }
        }
        // 机构类型，默认等于本级机构类型
        if (node.mftypecode == 'M') {
            mftypecode = '2';
        } else {
            mftypecode = node.mftypecode;
        }

        mini.getbyName("mftypecode").setValue(mftypecode);
    }
    if (mfdata.rulemaxcls == mfclass) {
        mini.getbyName("mfflag").setValue("Y");
    } else {
        mini.getbyName("mfflag").setValue("N");
    }
    mini.getbyName("muid").setValue(node.muid);
    mini.getbyName("muid").setText(node.muid);
    mini.getbyName("mfstatus").setValue("Y");
    flag = "I";
}

// function getRuleCode(code, mfclass) {
// 	var source = "";
// 	/*itemLoader.doRequest(OmdUrl.mall, "mss.base.codebrand.getBrandCode", {*/
// 	itemLoader.doRequest(OmdUrl.mall, "mall.work.globrule.getAutoCode", {
// 		ruleid : "01",
// 		ruletype : code,
// 		rolecls : mfclass,
// 	}, null, null, function(data) {
// 		/*source = data.brandcode;*/
// 		source = data.autocode;
// 	}, null, null, false);
// 	return source;
// }

function addSelfData() {
    var node = tabs.getSelectedNode();// 获取选中的节点
    node.temp = "2";
    if (node.mfid == 0) {
        mini.alert("组织机构不能直接增加本项，请重新选择!");
        _toolbar.changedStatus("S");
        setStatus(false);
        return;
    }
	if (node.mftypecode == "M") {
		mini.alert("门店不能直接增加本项，请重新选择!");
		_toolbar.changedStatus("S");
		setStatus(false);
		return;
	}
    //by rj20180726 如果是1集结点是不能新增本项的，因为上一级节点是0顶级，查不到数据
    // if(node.mfclass =="1"){
    // 	mini.alert("此节点不能新增本项，请重新选择!");
    // 	return;
    // }
    setNode(node);
    _toolbar.changedStatus("E");
    setStatus(true);
    if (mfdata.rulemode == "1") {
        mini.getbyName("mfid").setEnabled(false);
    } else {
        mini.getbyName("mfid").setEnabled(true);
    }
}

function addChildData() {
    var node = tabs.getSelectedNode();// 获取选中的节点
    node.temp = "1";
    // 1次级不能增加子级或末级不能增加子级
    if (node.mfflag == "Y") {
        mini.alert("末级不能增加子项，请重新选择!");
        _toolbar.changedStatus("S");
        setStatus(false);
        return;
    }
    if (node.mfid == '0') {
        node.mfid = '0';
        node.mfcname = '组织机构';
    }
    setNode(node);
    _toolbar.changedStatus("E");
    setStatus(true);
    if (mfdata.rulemode == "1") {
        mini.getbyName("mfid").setEnabled(false);
    } else {
        mini.getbyName("mfid").setEnabled(true);
    }
}

function setSelecdNode(mfpid, temp, tempfalg) {
    var data = tabs.getList();
    for (var i = 0; i < data.length; i++) {
        if (data[i].mfpid == mfpid) {
            if (data[i].mfid == temp || data[i].mfcname == temp) {
                if (tempfalg) {
                    tabs.selectNode(data[i]);
                    return;
                } else {
                    if (flag == "I") {
                        return false;
                    }
                }
            }
        }
    }
    if (!tempfalg) {
        return true;
    }
}

// 查询是否有子项
function isChild(mfid) {
    var searchParam = {
        mfpid: mfid,
    };
    var _dicData = {};
    itemLoader.doRequest(OmdUrl.mall, "mall.work.manaorg.search", searchParam,
        null, null, function (data) {
            _dicData = data.manaorg;
        }, null, null, false);
    return _dicData;
}

function getmfpid(mfpid) {
    var searchParam = {
        mfid: mfpid,
    };
    var _dicData = {};
    itemLoader.doRequest(OmdUrl.mall, "mall.work.manaorg.search", searchParam,
        null, null, function (data) {
            _dicData = data.manaorg;
        }, null, null, false);
    return _dicData;
}

function onMftypecodeChanged(e) {
	var oldvalue = e.sender.oldValue;
    if (e.value == "M") {
        mini.alert("不能新增门店类型");
        mini.getbyName("mftypecode").setValue(oldvalue);
        return;
    }

    var node = tabs.getSelectedNode();
    //node.temp为空时，修改数据库已保存的节点
    if (!node.temp) {
        var parent = tabs.getParentNode(node);
        // 判断本级节点的机构类型是否和上级节点匹配
        if (parent.mftypecode) {
            if (parent.mftypecode != '1' && parent.mftypecode != 'M'
                && parent.mftypecode != e.value) {
                mini.alert("本级组织机构类型和上级机构类型不一致");
                mini.getbyName("mftypecode").setValue(oldvalue);
                return;
            }
        }
		if (parent.mftypecode == "M" && e.value == "1") {
			mini.alert("不能修改机构类型为[1]");
			mini.getbyName("mftypecode").setValue(oldvalue);
			return;
		}
        var childs = tabs.getChildNodes(node);
        // 判断本级节点的机构类型是否和下级节点匹配
        if (e.value != '1') {
            for (var i = 0; i < childs.length; i++) {
                if (e.value != childs[i].mftypecode) {
                    mini.alert("本级组织机构类型和下级机构类型不一致");
                    mini.getbyName("mftypecode").setValue(oldvalue);
                    return;
                }
            }
        }
    } else if (node.temp == '1') {
        //新增子级
        if (node.mftypecode) {
            if (node.mftypecode != '1' && node.mftypecode != 'M'
                && node.mftypecode != e.value) {
                mini.alert("本级组织机构类型和上级机构类型不一致");
                mini.getbyName("mftypecode").setValue(oldvalue);
                return;
            }
			if (node.mftypecode == "M" && e.value == "1") {
				mini.alert("不能新增机构类型为[1]的子项");
				mini.getbyName("mftypecode").setValue(oldvalue);
				return;
			}
        }
    } else if (node.temp == '2') {
        //新增本级
        var parent = tabs.getParentNode(node);
        if (parent.mftypecode) {
            if (parent.mftypecode != '1' && parent.mftypecode != 'M'
                && parent.mftypecode != e.value) {
                mini.alert("本级组织机构类型和上级机构类型不一致");
                mini.getbyName("mftypecode").setValue(oldvalue);
                return;
            }
            if (parent.mftypecode == "M" && e.value == "1") {
				mini.alert("不能新增机构类型为[1]");
				mini.getbyName("mftypecode").setValue(oldvalue);
				return;
			}
        }

    }

    mftype = e.value;

}

function saveData() {
    var temp = getForm();
    var mfid;
    // if (temp.mfid == "") {
    // 	mini.alert("请输入编码");
    // 	return;
    // }
    if (temp.mfcname == "") {
        mini.alert("请输入中文名称");
        return;
    }
    if (temp.mftypecode == "") {
        mini.alert("请先选择机构类型！");
        return;
    }
    if (!setSelecdNode(temp.mfpid, temp.mfcname, false)) {
        mini.alert("已经存在节点[" + temp.mfcname + "] ，请重新输入中文名");
        return;
    }
    if (!setSelecdNode(temp.mfpid, temp.mfid, false)) {
        mini.alert("已经存在节点[" + temp.mfid + "] ，请重新输入编码");
        return;
    }
    if (flag != "I") {
        temp.ph_key = mini.getbyName("ph_key").getValue() ? mini.getbyName(
            "ph_key").getValue() : "";
    }
    temp.flag = flag;
    itemLoader.doRequest(OmdUrl.mall, "mall.work.manaorg.save", temp, null,
        null, function (data) {
            if (flag == "U") {
                mini.alert("修改成功!");
            } else if (flag == "I") {
                var node = tabs.getSelectedNode();// 获取选中的节点
                if (node.mfid != "0") {
                    var childDate = isChild(node.mfid);
                    if (childDate.length > 0) {
                        node.mfflag = "N";
                        node.flag = "U";
                        node.ph_key = node.ph_key;
                        itemLoader.doRequest(OmdUrl.mall,
                            "mall.work.manaorg.save", node, null, null,
                            function (data) {
                            }, null, null, false);
                    }
                }
                mini.alert("保存成功!");
            }
            temp.ph_key = data[0].ph_key;
            _toolbar.changedStatus("S");
            setStatus(false);
            setBillData(temp);
            flag = "";
            getTreeData();
            setSelecdNode(temp.mfpid, temp.mfid, true);
            var node2 = tabs.getSelectedNode();
            if (node2) {
                tabs.expandPath(node2);
                tabs.expandNode(node2);
            }
        }, null, null, false);
};

function delPayData() {
    var _date = getForm();
    var childDate = isChild(_date.mfid);
    if (childDate.length > 0) {
        mini.alert("还有子项，不能进行删除操作");
        return;
    }

    _date.flag = "D";
    _date.ph_key = mini.getbyName("ph_key").getValue() ? mini.getbyName(
        "ph_key").getValue() : "";
    itemLoader.doRequest(OmdUrl.mall, "mall.work.manaorg.delete", _date, null,
        null, function (data) {
            mini.alert("删除成功!");
            details.form.clear();
            _toolbar.changedStatus("S");
            flag = "";
            setStatus(false);
            getTreeData();
        }, null, null, false);
}

function getTmdd() {
    var utctime;
    var searchParam = {
        "queryid": "select_UNIX_TIMESTAMP"
    };
    var method = "mss.work.report.query";
    itemLoader.doRequest(OmdUrl.mall, method, searchParam, null, null,
        function (data) {
            var data = data.report;
            utctime = data[0].utctime;
        }, null, null, false);
    return utctime;
}

function getmfid(mfpid) {
    var searchParam = {
        mfid: mfpid,
    };
    var _dicData = {};
    itemLoader.doRequest(OmdUrl.mall, "mall.work.manaorg.search", searchParam,
        null, null, function (data) {
            _dicData = data.manaorg;
        }, null, null, false);
    return _dicData;
}
