<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8" %>
<!DOCTYPE html />
<html>
<head>
    <title>付款方式管理</title>
    <meta http-equiv="content-type" content="text/html; charset=UTF-8"/>
</head>
<body style="_height: 100%; _margin: 0px; _padding: 0px;">

<div id="config_toolbar" class="ocm-systoolbar" config="toolbar1"
></div>
<div class="ocm-layout" config="config1" borderStyle="border:0px;"
     style="width: 100%; height: 100%;"></div>
<script src="/ocp-ui-res/js/boot-omp.js" type="text/javascript"></script>
<script src="/mall-business-ui/pages/common/method.js" type="text/javascript"></script>

<script id="pagehtmlsource" type="text/miniui-template">
    <div class="mini-fit">
        <div id="layout1" class="mini-layout"
             style="width: 100%; height: 100%;"
             borderStyle="border:solid 1px #aaa;">
            <div title="付款方式" showProxyText="false" region="west" width="200"
                 expanded="true" showSplitIcon="false">
                <div class="mini-tree" id="tabs" textField="codename" idField="pmcode" parentField="pmpcode"></div>
            </div>
            <div title="明细" region="center" showHeader="true" showCollapseButton="false">
                <div class="ocm-formheader" config="details" style="padding-top: 5px; "></div>
            </div>
        </div>
    </div>
</script>


<script type="text/javascript">
    //字典数据初始化
    var dicData = getDict("PAYTYPE,PMMODE,SSWRFS,PMBACKTYPE,PMLX,PAYCHANNEL", "dcode,dname,pro1,ddvalue");
    dicData.status = [{code: "Y", name: "正常"}, {code: "N", name: "禁用"}];
    dicData.status2 = [{code: "Y", name: "是"}, {code: "N", name: "否"}];
    dicData.rtncode = getCodeChargeDict("11"); //返款费用代码
    dicData.itemcode = getCodeChargeDict("12"); //返款费用代码

    var toolbar1 = {
        status: { // 按钮同斥规则 N:新增后, V:查看, E:编辑后, S:保存后, A:审核后, C:取消后, D:删除后(默认)
            'E': ['savePayData'],
            'S': ['editPayData', 'addChildData', 'addSelfData', 'delPayData'],
        },
        items: [[{
            'text': '新增子项',
            'iconCls': 'icon-add',
            'name': 'addChildData',
        }, {
            'text': '新增本项',
            'iconCls': 'icon-add',
            'name': 'addSelfData',
        }, {
            'text': '修改',
            'iconCls': 'icon-edit',
            'name': 'editPayData'
        }, {
            'text': '删除',
            'iconCls': 'icon-remove',
            'name': 'delPayData'
        }, {
            'text': '保存',
            'iconCls': 'icon-save',
            'name': 'savePayData'
        }]]
    };


    // 页面布局配置
    var formheader1 = {
        "type": "formgrid",
        "properties": {
            "id": "formheader1",
        },
        items: [{
            "label": "编码：",
            "type": "TextBox",
            "name": "pmcode",
            "required": true,
            "style": "width:30%;",
            "onValuechanged": "onPmcodeChange",
        }, {
            "label": "中文名称：",
            "type": "TextBox",
            "name": "pmcname",
            "required": true,
            "style": "width:30%;",
        }, {
            "label": "状态：",
            "type": "ComboBox",
            "name": "pmstatus",
            "required": true,
            "data": dicData.status,
            "style": "width:30%;",
            "renderer": "OcmControl.dictRendererWithCode",
        }, {
            "label": "付款方式类别：",
            "type": "ComboBox",
            "name": "pmtype",
            "required": true,
            "data": dicData.PAYTYPE,
            "renderer": "OcmControl.dictRendererWithCode",
        }, {
            "label": "上级编码：",
            "name": "pmpcode",
            "type": "TextBox",
            "style": "width:30%;",
        }, {
            "label": "付款级次：",
            "type": "TextBox",
            "name": "pmclass",
            "style": "width:30%;",
        }, {
            "label": "付款模式：",
            "type": "ComboBox",
            "name": "pmmode",
            "required": true,
            "data": dicData.PMMODE,
            "style": "width:30%;",
            "renderer": "OcmControl.dictRendererWithCode",
        }, {
            "label": "付款汇率：",
            "type": "TextBox",
            "name": "pmhl",
            "required": true,
            "vtype": "float",
            "numberFormat": "#.00",
            "align": "right",
            "style": "width:30%;",
            "defaultValue": "1",
        }, {
            "label": "付款用途：",
            "type": "ComboBox",
            "name": "pmlx",
            "data": dicData.PMLX,
            "showNullItem": "true",
            "style": "width:30%;",

        }, {
            "label": "费用代码：",
            "type": "ComboBox",
            "name": "itemcode",
            "data": dicData.itemcode,
            "textField" : "cccname",
            "valueField" : "cccode",
            "style": "width:30%;",
            "renderer": "OcmControl.dictRendererWithCode",
            "showNullItem": "true",
            "nullItemText": "",
        }, {
            "label": "手续费费率：",
            "name": "pmxykfl",
            "type": "NumButtonEdit",
            "format": "p4",
            "defaultValue": 0,
            "style": "width:30%;",
            "prange": true,
        }, {
            "label": "单笔封项：",
            "type": "NumButtonEdit",
            "name": "singmaxje",
            "format": "c4",
            "prange": true,
            "max": 99999999.9999,
            "onValuechanged": "onPmjeChange",
        }, {
            "label": "返款类型：",
            "type": "ComboBox",
            "name": "pmbacktype",
            "data": dicData.PMBACKTYPE,
            "style": "width:30%;",
            "renderer": "OcmControl.dictRendererWithCode",
            "showNullItem": "true",
            "nullItemText": "",
        }, {
            "label": "返款费用代码：",
            "type": "ComboBox",
            "name": "rtncode",
            "textField" : "cccname",
            "valueField" : "cccode",
            "data": dicData.rtncode,
            "style": "width:30%;",
            "renderer": "OcmControl.dictRendererWithCode",
            "showNullItem": "true",
            "nullItemText": "",
        }, {
            "label": "付款对象：",
            "type": "ComboBox",
            "name": "paychannel",
            "data": dicData.PAYCHANNEL,
            "style": "width:30%;",
            "required": true,
            "renderer": "OcmControl.dictRendererWithCode",
            "showNullItem": "true",
            "nullItemText": "",
            "defaultValue": "00",
        }, {
            "label": "销售费率：",
            "type": "TextBox",
            "name": "setfl",
            "vtype": "float",
            "numberFormat": "#.00",
            "align": "right",
            "style": "width:30%;",
            "visible": false,
        }, {
            "label": "最小付款金额：",
            "type": "NumButtonEdit",
            "format": "c2",
            "prange": true,
            "max": 9999999999.99,
            "name": "pmminje",
            "style": "width:30%;",
            "onValuechanged": "onPmjeChange",
        }, {
            "label": "最大付款金额：",
            "type": "NumButtonEdit",
            "name": "pmmaxje",
            "format": "c2",
            "prange": true,
            "max": 9999999999.99,
            "onValuechanged": "onPmjeChange",
        }, {
            "text": "是否末级：",
            "type": "CheckBox",
            "name": "pmflag",
            "required": "true",
            "trueValue": "Y",
            "falseValue": "N",
            "defaultValue": "Y",
            "style": "width:20%;",
        }, {
            "label": "舍入方式：",
            "type": "ComboBox",
            "name": "sswrfs",
            "data": dicData.SSWRFS,
            "style": "width:30%;",
            "renderer": "OcmControl.dictRendererWithCode",
        }, {
            "label": "舍入精度：",
            "type": "TextBox",
            "name": "sswrjd",
            "vtype": "float",
            "align": "right",
        }, {
            "text": "是否找零：",
            "type": "CheckBox",
            "name": "pmiszl",
            "required": "true",
            "trueValue": "Y",
            "falseValue": "N",
            "defaultValue": "Y",
            "style": "width:20%;",
        }, {
            "text": "是否计算收入：",
            "type": "CheckBox",
            "name": "pmisjssr",
            "required": "true",
            "trueValue": "Y",
            "falseValue": "N",
            "defaultValue": "Y",
        }, {
            "label": "供应商承担比例：",
            "name": "pmsupzkfd",
            "type": "NumButtonEdit",
            "format": "p2",
            "defaultValue": 0,
            "style": "width:30%;",
            "align": "right",
        }, {
            "text": "是否损溢：",
            "type": "CheckBox",
            "name": "pmisyy",
            "required": "true",
            "trueValue": "Y",
            "falseValue": "N",
            "defaultValue": "Y",
            "style": "width:20%;",
        }, {
            "label": "企业代码：",
            "type": "TextBox",
            "name": "ent_id",
            "deafaultVaue": "0",
            "visible": false,
        }, {
            "label": "物理主键：",
            "type": "TextBox",
            "name": "ph_key",
            "visible": false,
        }]
    };
    //自定义面板,门店和渠道
    var curhtmlsource = {
        "type": "html",
        "properties": {
            "id": "curhtmlsource",
        },
        "contents": $("#pagehtmlsource").text(),
    };

    var tabs2 = {
        properties: {
            "id": "tabs2",
        },
        items: [{
            "name": "curbilldata",
            "control": curhtmlsource,
            "showHeader": false,
        }]
    };

    var details = {
        "type": "formgrid",
        "resources": OmdUrl.mall,
        "method": "mall.work.pay.get",
        "response": "paymode",
        "properties": {
            "id": "details",
        },
        "items": formheader1.items,
    };
    var config1 = {
        properties: {
            "id": "config1",
            "name": "config1",
        },
        toolbar: "",
        tabs: tabs2,
    };
    mini.parse();
</script>
<script src="paymode.js" type="text/javascript"></script>
</body>
</html>